// ************************************************************************* //
//  File: SubsetGUIPluginInfo.C
// ************************************************************************* //

#include <SubsetPluginInfo.h>
#include <SubsetAttributes.h>
#include <QvisSubsetPlotWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Subset_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Subset plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 16:40:04 PST 2003
//
// ****************************************************************************
extern "C" GUIPlotPluginInfo* GetGUIInfo()
{
    return new SubsetGUIPluginInfo;
}

// ****************************************************************************
//  Method: SubsetGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 16:40:04 PST 2003
//
// ****************************************************************************

const char *
SubsetGUIPluginInfo::GetMenuName() const
{
    return "Subset";
}


// ****************************************************************************
// Method: SubsetGUIPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 16:40:04 PST 2003
//
// Modifications:
//   
// ****************************************************************************

int
SubsetGUIPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SUBSET;
}

// ****************************************************************************
//  Method: SubsetGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 16:40:04 PST 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
SubsetGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisSubsetPlotWindow(type, (SubsetAttributes *)attr,
        "Subset plot attributes", "Subset plot", notepad);
}

// ****************************************************************************
//  Method: SubsetGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Thu Mar 13 16:40:04 PST 2003
//
// ****************************************************************************

#include <Subset.xpm>
const char **
SubsetGUIPluginInfo::XPMIconData() const
{
    return Subset_xpm;
}
