#include <SubsetAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for SubsetAttributes::Subset_Type
//

static const char *Subset_Type_strings[] = {
"Domain", "Group", "Material", 
"Unknown"};

std::string
SubsetAttributes::Subset_Type_ToString(SubsetAttributes::Subset_Type t)
{
    int index = int(t);
    if(index < 0 || index >= 4) index = 0;
    return Subset_Type_strings[index];
}

std::string
SubsetAttributes::Subset_Type_ToString(int t)
{
    int index = (t < 0 || t >= 4) ? 0 : t;
    return Subset_Type_strings[index];
}

bool
SubsetAttributes::Subset_Type_FromString(const std::string &s, SubsetAttributes::Subset_Type &val)
{
    val = SubsetAttributes::Domain;
    for(int i = 0; i < 4; ++i)
    {
        if(s == Subset_Type_strings[i])
        {
            val = (Subset_Type)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for SubsetAttributes::ColoringMethod
//

static const char *ColoringMethod_strings[] = {
"ColorBySingleColor", "ColorByMultipleColors", "ColorByColorTable"
};

std::string
SubsetAttributes::ColoringMethod_ToString(SubsetAttributes::ColoringMethod t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return ColoringMethod_strings[index];
}

std::string
SubsetAttributes::ColoringMethod_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return ColoringMethod_strings[index];
}

bool
SubsetAttributes::ColoringMethod_FromString(const std::string &s, SubsetAttributes::ColoringMethod &val)
{
    val = SubsetAttributes::ColorBySingleColor;
    for(int i = 0; i < 3; ++i)
    {
        if(s == ColoringMethod_strings[i])
        {
            val = (ColoringMethod)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for SubsetAttributes::PointType
//

static const char *PointType_strings[] = {
"Box", "Axis", "Icosahedron", 
"Point"};

std::string
SubsetAttributes::PointType_ToString(SubsetAttributes::PointType t)
{
    int index = int(t);
    if(index < 0 || index >= 4) index = 0;
    return PointType_strings[index];
}

std::string
SubsetAttributes::PointType_ToString(int t)
{
    int index = (t < 0 || t >= 4) ? 0 : t;
    return PointType_strings[index];
}

bool
SubsetAttributes::PointType_FromString(const std::string &s, SubsetAttributes::PointType &val)
{
    val = SubsetAttributes::Box;
    for(int i = 0; i < 4; ++i)
    {
        if(s == PointType_strings[i])
        {
            val = (PointType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: SubsetAttributes::SubsetAttributes
//
// Purpose: 
//   Constructor for the SubsetAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Nov 12 11:43:38 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

SubsetAttributes::SubsetAttributes() : AttributeSubject("isbbiiaas*idbbidibs"),
    colorTableName("Default"), singleColor()
{
    colorType = ColorByMultipleColors;
    filledFlag = true;
    legendFlag = true;
    lineStyle = 0;
    lineWidth = 0;
    subsetType = Unknown;
    opacity = 1;
    wireframe = false;
    drawInternal = false;
    smoothingLevel = 0;
    pointSize = 0.05;
    pointType = Box;
    pointSizeVarEnabled = false;
    pointSizeVar = "default";
}

// ****************************************************************************
// Method: SubsetAttributes::SubsetAttributes
//
// Purpose: 
//   Copy constructor for the SubsetAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Nov 12 11:43:38 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

SubsetAttributes::SubsetAttributes(const SubsetAttributes &obj) : AttributeSubject("isbbiiaas*idbbidibs")
{
    colorType = obj.colorType;
    colorTableName = obj.colorTableName;
    filledFlag = obj.filledFlag;
    legendFlag = obj.legendFlag;
    lineStyle = obj.lineStyle;
    lineWidth = obj.lineWidth;
    singleColor = obj.singleColor;
    multiColor = obj.multiColor;
    subsetNames = obj.subsetNames;
    subsetType = obj.subsetType;
    opacity = obj.opacity;
    wireframe = obj.wireframe;
    drawInternal = obj.drawInternal;
    smoothingLevel = obj.smoothingLevel;
    pointSize = obj.pointSize;
    pointType = obj.pointType;
    pointSizeVarEnabled = obj.pointSizeVarEnabled;
    pointSizeVar = obj.pointSizeVar;

    SelectAll();
}

// ****************************************************************************
// Method: SubsetAttributes::~SubsetAttributes
//
// Purpose: 
//   Destructor for the SubsetAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Nov 12 11:43:38 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

SubsetAttributes::~SubsetAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: SubsetAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the SubsetAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Nov 12 11:43:38 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

SubsetAttributes& 
SubsetAttributes::operator = (const SubsetAttributes &obj)
{
    if (this == &obj) return *this;
    colorType = obj.colorType;
    colorTableName = obj.colorTableName;
    filledFlag = obj.filledFlag;
    legendFlag = obj.legendFlag;
    lineStyle = obj.lineStyle;
    lineWidth = obj.lineWidth;
    singleColor = obj.singleColor;
    multiColor = obj.multiColor;
    subsetNames = obj.subsetNames;
    subsetType = obj.subsetType;
    opacity = obj.opacity;
    wireframe = obj.wireframe;
    drawInternal = obj.drawInternal;
    smoothingLevel = obj.smoothingLevel;
    pointSize = obj.pointSize;
    pointType = obj.pointType;
    pointSizeVarEnabled = obj.pointSizeVarEnabled;
    pointSizeVar = obj.pointSizeVar;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: SubsetAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the SubsetAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Nov 12 11:43:38 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
SubsetAttributes::operator == (const SubsetAttributes &obj) const
{
    // Create the return value
    return ((colorType == obj.colorType) &&
            (colorTableName == obj.colorTableName) &&
            (filledFlag == obj.filledFlag) &&
            (legendFlag == obj.legendFlag) &&
            (lineStyle == obj.lineStyle) &&
            (lineWidth == obj.lineWidth) &&
            (singleColor == obj.singleColor) &&
            (multiColor == obj.multiColor) &&
            (subsetNames == obj.subsetNames) &&
            (subsetType == obj.subsetType) &&
            (opacity == obj.opacity) &&
            (wireframe == obj.wireframe) &&
            (drawInternal == obj.drawInternal) &&
            (smoothingLevel == obj.smoothingLevel) &&
            (pointSize == obj.pointSize) &&
            (pointType == obj.pointType) &&
            (pointSizeVarEnabled == obj.pointSizeVarEnabled) &&
            (pointSizeVar == obj.pointSizeVar));
}

// ****************************************************************************
// Method: SubsetAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the SubsetAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Nov 12 11:43:38 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
SubsetAttributes::operator != (const SubsetAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SubsetAttributes::TypeName
//
// Purpose: 
//   Type name method for the SubsetAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Nov 12 11:43:38 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
SubsetAttributes::TypeName() const
{
    return "SubsetAttributes";
}

// ****************************************************************************
// Method: SubsetAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the SubsetAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Nov 12 11:43:38 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
SubsetAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SubsetAttributes *tmp = (const SubsetAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SubsetAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the SubsetAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Nov 12 11:43:38 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SubsetAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SubsetAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: SubsetAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the SubsetAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Nov 12 11:43:38 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SubsetAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SubsetAttributes(*this);
    else
        retval = new SubsetAttributes;

    return retval;
}

// ****************************************************************************
// Method: SubsetAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Nov 12 11:43:38 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
SubsetAttributes::SelectAll()
{
    Select(0, (void *)&colorType);
    Select(1, (void *)&colorTableName);
    Select(2, (void *)&filledFlag);
    Select(3, (void *)&legendFlag);
    Select(4, (void *)&lineStyle);
    Select(5, (void *)&lineWidth);
    Select(6, (void *)&singleColor);
    Select(7, (void *)&multiColor);
    Select(8, (void *)&subsetNames);
    Select(9, (void *)&subsetType);
    Select(10, (void *)&opacity);
    Select(11, (void *)&wireframe);
    Select(12, (void *)&drawInternal);
    Select(13, (void *)&smoothingLevel);
    Select(14, (void *)&pointSize);
    Select(15, (void *)&pointType);
    Select(16, (void *)&pointSizeVarEnabled);
    Select(17, (void *)&pointSizeVar);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SubsetAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Nov 12 11:43:38 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
SubsetAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    SubsetAttributes defaultObject;
    bool addToParent = false;
    // Create a node for SubsetAttributes.
    DataNode *node = new DataNode("SubsetAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("colorType", ColoringMethod_ToString(colorType)));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("colorTableName", colorTableName));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("filledFlag", filledFlag));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("legendFlag", legendFlag));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineStyle", lineStyle));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineWidth", lineWidth));
    }

        DataNode *singleColorNode = new DataNode("singleColor");
        if(singleColor.CreateNode(singleColorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(singleColorNode);
        }
        else
            delete singleColorNode;
    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        DataNode *multiColorNode = new DataNode("multiColor");
        if(multiColor.CreateNode(multiColorNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(multiColorNode);
        }
        else
            delete multiColorNode;
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("subsetNames", subsetNames));
    }

    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("subsetType", Subset_Type_ToString(subsetType)));
    }

    if(completeSave || !FieldsEqual(10, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("opacity", opacity));
    }

    if(completeSave || !FieldsEqual(11, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("wireframe", wireframe));
    }

    if(completeSave || !FieldsEqual(12, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("drawInternal", drawInternal));
    }

    if(completeSave || !FieldsEqual(13, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("smoothingLevel", smoothingLevel));
    }

    if(completeSave || !FieldsEqual(14, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("pointSize", pointSize));
    }

    if(completeSave || !FieldsEqual(15, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("pointType", PointType_ToString(pointType)));
    }

    if(completeSave || !FieldsEqual(16, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("pointSizeVarEnabled", pointSizeVarEnabled));
    }

    if(completeSave || !FieldsEqual(17, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("pointSizeVar", pointSizeVar));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: SubsetAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Nov 12 11:43:38 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
SubsetAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("SubsetAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("colorType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetColorType(ColoringMethod(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            ColoringMethod value;
            if(ColoringMethod_FromString(node->AsString(), value))
                SetColorType(value);
        }
    }
    if((node = searchNode->GetNode("colorTableName")) != 0)
        SetColorTableName(node->AsString());
    if((node = searchNode->GetNode("filledFlag")) != 0)
        SetFilledFlag(node->AsBool());
    if((node = searchNode->GetNode("legendFlag")) != 0)
        SetLegendFlag(node->AsBool());
    if((node = searchNode->GetNode("lineStyle")) != 0)
        SetLineStyle(node->AsInt());
    if((node = searchNode->GetNode("lineWidth")) != 0)
        SetLineWidth(node->AsInt());
    if((node = searchNode->GetNode("singleColor")) != 0)
        singleColor.SetFromNode(node);
    if((node = searchNode->GetNode("multiColor")) != 0)
        multiColor.SetFromNode(node);
    if((node = searchNode->GetNode("subsetNames")) != 0)
        SetSubsetNames(node->AsStringVector());
    if((node = searchNode->GetNode("subsetType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 4)
                SetSubsetType(Subset_Type(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Subset_Type value;
            if(Subset_Type_FromString(node->AsString(), value))
                SetSubsetType(value);
        }
    }
    if((node = searchNode->GetNode("opacity")) != 0)
        SetOpacity(node->AsDouble());
    if((node = searchNode->GetNode("wireframe")) != 0)
        SetWireframe(node->AsBool());
    if((node = searchNode->GetNode("drawInternal")) != 0)
        SetDrawInternal(node->AsBool());
    if((node = searchNode->GetNode("smoothingLevel")) != 0)
        SetSmoothingLevel(node->AsInt());
    if((node = searchNode->GetNode("pointSize")) != 0)
        SetPointSize(node->AsDouble());
    if((node = searchNode->GetNode("pointType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 4)
                SetPointType(PointType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            PointType value;
            if(PointType_FromString(node->AsString(), value))
                SetPointType(value);
        }
    }
    if((node = searchNode->GetNode("pointSizeVarEnabled")) != 0)
        SetPointSizeVarEnabled(node->AsBool());
    if((node = searchNode->GetNode("pointSizeVar")) != 0)
        SetPointSizeVar(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SubsetAttributes::SetColorType(SubsetAttributes::ColoringMethod colorType_)
{
    colorType = colorType_;
    Select(0, (void *)&colorType);
}

void
SubsetAttributes::SetColorTableName(const std::string &colorTableName_)
{
    colorTableName = colorTableName_;
    Select(1, (void *)&colorTableName);
}

void
SubsetAttributes::SetFilledFlag(bool filledFlag_)
{
    filledFlag = filledFlag_;
    Select(2, (void *)&filledFlag);
}

void
SubsetAttributes::SetLegendFlag(bool legendFlag_)
{
    legendFlag = legendFlag_;
    Select(3, (void *)&legendFlag);
}

void
SubsetAttributes::SetLineStyle(int lineStyle_)
{
    lineStyle = lineStyle_;
    Select(4, (void *)&lineStyle);
}

void
SubsetAttributes::SetLineWidth(int lineWidth_)
{
    lineWidth = lineWidth_;
    Select(5, (void *)&lineWidth);
}

void
SubsetAttributes::SetSingleColor(const ColorAttribute &singleColor_)
{
    singleColor = singleColor_;
    Select(6, (void *)&singleColor);
}

void
SubsetAttributes::SetMultiColor(const ColorAttributeList &multiColor_)
{
    multiColor = multiColor_;
    Select(7, (void *)&multiColor);
}

void
SubsetAttributes::SetSubsetNames(const stringVector &subsetNames_)
{
    subsetNames = subsetNames_;
    Select(8, (void *)&subsetNames);
}

void
SubsetAttributes::SetSubsetType(SubsetAttributes::Subset_Type subsetType_)
{
    subsetType = subsetType_;
    Select(9, (void *)&subsetType);
}

void
SubsetAttributes::SetOpacity(double opacity_)
{
    opacity = opacity_;
    Select(10, (void *)&opacity);
}

void
SubsetAttributes::SetWireframe(bool wireframe_)
{
    wireframe = wireframe_;
    Select(11, (void *)&wireframe);
}

void
SubsetAttributes::SetDrawInternal(bool drawInternal_)
{
    drawInternal = drawInternal_;
    Select(12, (void *)&drawInternal);
}

void
SubsetAttributes::SetSmoothingLevel(int smoothingLevel_)
{
    smoothingLevel = smoothingLevel_;
    Select(13, (void *)&smoothingLevel);
}

void
SubsetAttributes::SetPointSize(double pointSize_)
{
    pointSize = pointSize_;
    Select(14, (void *)&pointSize);
}

void
SubsetAttributes::SetPointType(SubsetAttributes::PointType pointType_)
{
    pointType = pointType_;
    Select(15, (void *)&pointType);
}

void
SubsetAttributes::SetPointSizeVarEnabled(bool pointSizeVarEnabled_)
{
    pointSizeVarEnabled = pointSizeVarEnabled_;
    Select(16, (void *)&pointSizeVarEnabled);
}

void
SubsetAttributes::SetPointSizeVar(const std::string &pointSizeVar_)
{
    pointSizeVar = pointSizeVar_;
    Select(17, (void *)&pointSizeVar);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

SubsetAttributes::ColoringMethod
SubsetAttributes::GetColorType() const
{
    return ColoringMethod(colorType);
}

const std::string &
SubsetAttributes::GetColorTableName() const
{
    return colorTableName;
}

std::string &
SubsetAttributes::GetColorTableName()
{
    return colorTableName;
}

bool
SubsetAttributes::GetFilledFlag() const
{
    return filledFlag;
}

bool
SubsetAttributes::GetLegendFlag() const
{
    return legendFlag;
}

int
SubsetAttributes::GetLineStyle() const
{
    return lineStyle;
}

int
SubsetAttributes::GetLineWidth() const
{
    return lineWidth;
}

const ColorAttribute &
SubsetAttributes::GetSingleColor() const
{
    return singleColor;
}

ColorAttribute &
SubsetAttributes::GetSingleColor()
{
    return singleColor;
}

const ColorAttributeList &
SubsetAttributes::GetMultiColor() const
{
    return multiColor;
}

ColorAttributeList &
SubsetAttributes::GetMultiColor()
{
    return multiColor;
}

const stringVector &
SubsetAttributes::GetSubsetNames() const
{
    return subsetNames;
}

stringVector &
SubsetAttributes::GetSubsetNames()
{
    return subsetNames;
}

SubsetAttributes::Subset_Type
SubsetAttributes::GetSubsetType() const
{
    return Subset_Type(subsetType);
}

double
SubsetAttributes::GetOpacity() const
{
    return opacity;
}

bool
SubsetAttributes::GetWireframe() const
{
    return wireframe;
}

bool
SubsetAttributes::GetDrawInternal() const
{
    return drawInternal;
}

int
SubsetAttributes::GetSmoothingLevel() const
{
    return smoothingLevel;
}

double
SubsetAttributes::GetPointSize() const
{
    return pointSize;
}

SubsetAttributes::PointType
SubsetAttributes::GetPointType() const
{
    return PointType(pointType);
}

bool
SubsetAttributes::GetPointSizeVarEnabled() const
{
    return pointSizeVarEnabled;
}

const std::string &
SubsetAttributes::GetPointSizeVar() const
{
    return pointSizeVar;
}

std::string &
SubsetAttributes::GetPointSizeVar()
{
    return pointSizeVar;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
SubsetAttributes::SelectColorTableName()
{
    Select(1, (void *)&colorTableName);
}

void
SubsetAttributes::SelectSingleColor()
{
    Select(6, (void *)&singleColor);
}

void
SubsetAttributes::SelectMultiColor()
{
    Select(7, (void *)&multiColor);
}

void
SubsetAttributes::SelectSubsetNames()
{
    Select(8, (void *)&subsetNames);
}

void
SubsetAttributes::SelectPointSizeVar()
{
    Select(17, (void *)&pointSizeVar);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SubsetAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Nov 12 11:43:38 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
SubsetAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "colorType";
        case 1:  return "Color table";
        case 2:  return "filledFlag";
        case 3:  return "legendFlag";
        case 4:  return "lineStyle";
        case 5:  return "lineWidth";
        case 6:  return "singleColor";
        case 7:  return "multiColor";
        case 8:  return "subsetNames";
        case 9:  return "subsetType";
        case 10:  return "opacity";
        case 11:  return "wireframe";
        case 12:  return "drawInternal";
        case 13:  return "Smoothing level";
        case 14:  return "Point size";
        case 15:  return "Point Type";
        case 16:  return "Point size by var enabled";
        case 17:  return "Point size by var";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SubsetAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Nov 12 11:43:38 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
SubsetAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_enum;
        case 1:  return FieldType_colortable;
        case 2:  return FieldType_bool;
        case 3:  return FieldType_bool;
        case 4:  return FieldType_linestyle;
        case 5:  return FieldType_linewidth;
        case 6:  return FieldType_color;
        case 7:  return FieldType_att;
        case 8:  return FieldType_stringVector;
        case 9:  return FieldType_enum;
        case 10:  return FieldType_opacity;
        case 11:  return FieldType_bool;
        case 12:  return FieldType_bool;
        case 13:  return FieldType_int;
        case 14:  return FieldType_double;
        case 15:  return FieldType_enum;
        case 16:  return FieldType_bool;
        case 17:  return FieldType_variablename;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SubsetAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Nov 12 11:43:38 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
SubsetAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "enum";
        case 1:  return "colortable";
        case 2:  return "bool";
        case 3:  return "bool";
        case 4:  return "linestyle";
        case 5:  return "linewidth";
        case 6:  return "color";
        case 7:  return "att";
        case 8:  return "stringVector";
        case 9:  return "enum";
        case 10:  return "opacity";
        case 11:  return "bool";
        case 12:  return "bool";
        case 13:  return "int";
        case 14:  return "double";
        case 15:  return "enum";
        case 16:  return "bool";
        case 17:  return "variablename";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SubsetAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Nov 12 11:43:38 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
SubsetAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const SubsetAttributes &obj = *((const SubsetAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (colorType == obj.colorType);
        }
        break;
    case 1:
        {  // new scope
        retval = (colorTableName == obj.colorTableName);
        }
        break;
    case 2:
        {  // new scope
        retval = (filledFlag == obj.filledFlag);
        }
        break;
    case 3:
        {  // new scope
        retval = (legendFlag == obj.legendFlag);
        }
        break;
    case 4:
        {  // new scope
        retval = (lineStyle == obj.lineStyle);
        }
        break;
    case 5:
        {  // new scope
        retval = (lineWidth == obj.lineWidth);
        }
        break;
    case 6:
        {  // new scope
        retval = (singleColor == obj.singleColor);
        }
        break;
    case 7:
        {  // new scope
        retval = (multiColor == obj.multiColor);
        }
        break;
    case 8:
        {  // new scope
        retval = (subsetNames == obj.subsetNames);
        }
        break;
    case 9:
        {  // new scope
        retval = (subsetType == obj.subsetType);
        }
        break;
    case 10:
        {  // new scope
        retval = (opacity == obj.opacity);
        }
        break;
    case 11:
        {  // new scope
        retval = (wireframe == obj.wireframe);
        }
        break;
    case 12:
        {  // new scope
        retval = (drawInternal == obj.drawInternal);
        }
        break;
    case 13:
        {  // new scope
        retval = (smoothingLevel == obj.smoothingLevel);
        }
        break;
    case 14:
        {  // new scope
        retval = (pointSize == obj.pointSize);
        }
        break;
    case 15:
        {  // new scope
        retval = (pointType == obj.pointType);
        }
        break;
    case 16:
        {  // new scope
        retval = (pointSizeVarEnabled == obj.pointSizeVarEnabled);
        }
        break;
    case 17:
        {  // new scope
        retval = (pointSizeVar == obj.pointSizeVar);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Modifications:
//    Jeremy Meredith, Mon Dec  9 16:30:54 PST 2002
//    Added smoothing level.
//
//    Kathleen Bonnell, Fri Nov 12 11:42:36 PST 2004 
//    Added needSecondaryVar. 
//
// ****************************************************************************
bool
SubsetAttributes::ChangesRequireRecalculation(const SubsetAttributes &obj)
{
    bool needSecondaryVar = obj.pointSizeVarEnabled &&
                            pointSizeVar != obj.pointSizeVar &&
                            obj.pointSizeVar != "default" && 
                            obj.pointSizeVar != "" &&
                            obj.pointSizeVar != "\0"; 

    return ((filledFlag != obj.filledFlag) ||
            (subsetType != obj.subsetType) || 
            (subsetNames != obj.subsetNames) ||
            (wireframe != obj.wireframe) ||
            (drawInternal != obj.drawInternal) ||
            (smoothingLevel != obj.smoothingLevel) ||
            needSecondaryVar);
}

bool
SubsetAttributes::VarChangeRequiresReset()
{ 
    return true;
}

