#include <PySubsetAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PySubsetAttributes
//
// Purpose: 
//   This class contains the plot attributes for the subset boundary plot.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Nov 12 11:46:16 PDT 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a SubsetAttributes.
//
struct SubsetAttributesObject
{
    PyObject_HEAD
    SubsetAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewSubsetAttributes();

static PyObject *
SubsetAttributes_Notify(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubsetAttributes_SetColorType(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the colorType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetColorType(SubsetAttributes::ColoringMethod(ival));
    else
    {
        fprintf(stderr, "An invalid colorType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "ColorBySingleColor, ColorByMultipleColors, ColorByColorTable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubsetAttributes_GetColorType(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColorType()));
    return retval;
}

static PyObject *
SubsetAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubsetAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

static PyObject *
SubsetAttributes_SetFilledFlag(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the filledFlag in the object.
    obj->data->SetFilledFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubsetAttributes_GetFilledFlag(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFilledFlag()?1L:0L);
    return retval;
}

static PyObject *
SubsetAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubsetAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

static PyObject *
SubsetAttributes_SetLineStyle(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineStyle in the object.
    obj->data->SetLineStyle(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubsetAttributes_GetLineStyle(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineStyle()));
    return retval;
}

static PyObject *
SubsetAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubsetAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

static PyObject *
SubsetAttributes_SetSingleColor(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the singleColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetSingleColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubsetAttributes_GetSingleColor(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the singleColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *singleColor = obj->data->GetSingleColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(singleColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(singleColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(singleColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(singleColor[3])));
    return retval;
}

static PyObject *
SubsetAttributes_SetMultiColor(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;

    // NOT IMPLEMENTED!!!
    // name=multiColor, type=att

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubsetAttributes_GetMultiColor(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;
    // NOT IMPLEMENTED!!!
    // name=multiColor, type=att
    PyObject *retval = NULL;
    return retval;
}

static PyObject *
SubsetAttributes_SetSubsetNames(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;

    stringVector  &vec = obj->data->GetSubsetNames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the subsetNames in the object as modified.
    obj->data->SelectSubsetNames();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubsetAttributes_GetSubsetNames(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the subsetNames.
    const stringVector &subsetNames = obj->data->GetSubsetNames();
    PyObject *retval = PyTuple_New(subsetNames.size());
    for(int i = 0; i < subsetNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(subsetNames[i].c_str()));
    return retval;
}

static PyObject *
SubsetAttributes_SetSubsetType(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the subsetType in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetSubsetType(SubsetAttributes::Subset_Type(ival));
    else
    {
        fprintf(stderr, "An invalid subsetType value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "Domain, Group, Material, Unknown.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubsetAttributes_GetSubsetType(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSubsetType()));
    return retval;
}

static PyObject *
SubsetAttributes_SetOpacity(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the opacity in the object.
    obj->data->SetOpacity(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubsetAttributes_GetOpacity(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOpacity());
    return retval;
}

static PyObject *
SubsetAttributes_SetWireframe(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the wireframe in the object.
    obj->data->SetWireframe(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubsetAttributes_GetWireframe(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetWireframe()?1L:0L);
    return retval;
}

static PyObject *
SubsetAttributes_SetDrawInternal(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the drawInternal in the object.
    obj->data->SetDrawInternal(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubsetAttributes_GetDrawInternal(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDrawInternal()?1L:0L);
    return retval;
}

static PyObject *
SubsetAttributes_SetSmoothingLevel(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the smoothingLevel in the object.
    obj->data->SetSmoothingLevel(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubsetAttributes_GetSmoothingLevel(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSmoothingLevel()));
    return retval;
}

static PyObject *
SubsetAttributes_SetPointSize(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pointSize in the object.
    obj->data->SetPointSize(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubsetAttributes_GetPointSize(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPointSize());
    return retval;
}

static PyObject *
SubsetAttributes_SetPointType(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointType in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetPointType(SubsetAttributes::PointType(ival));
    else
    {
        fprintf(stderr, "An invalid pointType value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "Box, Axis, Icosahedron, Point.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubsetAttributes_GetPointType(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointType()));
    return retval;
}

static PyObject *
SubsetAttributes_SetPointSizeVarEnabled(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointSizeVarEnabled in the object.
    obj->data->SetPointSizeVarEnabled(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubsetAttributes_GetPointSizeVarEnabled(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPointSizeVarEnabled()?1L:0L);
    return retval;
}

static PyObject *
SubsetAttributes_SetPointSizeVar(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the pointSizeVar in the object.
    obj->data->SetPointSizeVar(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
SubsetAttributes_GetPointSizeVar(PyObject *self, PyObject *args)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetPointSizeVar().c_str());
    return retval;
}



static struct PyMethodDef SubsetAttributes_methods[] = {
    {"Notify", SubsetAttributes_Notify, METH_VARARGS},
    {"SetColorType", SubsetAttributes_SetColorType, METH_VARARGS},
    {"GetColorType", SubsetAttributes_GetColorType, METH_VARARGS},
    {"SetColorTableName", SubsetAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", SubsetAttributes_GetColorTableName, METH_VARARGS},
    {"SetFilledFlag", SubsetAttributes_SetFilledFlag, METH_VARARGS},
    {"GetFilledFlag", SubsetAttributes_GetFilledFlag, METH_VARARGS},
    {"SetLegendFlag", SubsetAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", SubsetAttributes_GetLegendFlag, METH_VARARGS},
    {"SetLineStyle", SubsetAttributes_SetLineStyle, METH_VARARGS},
    {"GetLineStyle", SubsetAttributes_GetLineStyle, METH_VARARGS},
    {"SetLineWidth", SubsetAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", SubsetAttributes_GetLineWidth, METH_VARARGS},
    {"SetSingleColor", SubsetAttributes_SetSingleColor, METH_VARARGS},
    {"GetSingleColor", SubsetAttributes_GetSingleColor, METH_VARARGS},
    {"SetMultiColor", SubsetAttributes_SetMultiColor, METH_VARARGS},
    {"GetMultiColor", SubsetAttributes_GetMultiColor, METH_VARARGS},
    {"SetSubsetNames", SubsetAttributes_SetSubsetNames, METH_VARARGS},
    {"GetSubsetNames", SubsetAttributes_GetSubsetNames, METH_VARARGS},
    {"SetSubsetType", SubsetAttributes_SetSubsetType, METH_VARARGS},
    {"GetSubsetType", SubsetAttributes_GetSubsetType, METH_VARARGS},
    {"SetOpacity", SubsetAttributes_SetOpacity, METH_VARARGS},
    {"GetOpacity", SubsetAttributes_GetOpacity, METH_VARARGS},
    {"SetWireframe", SubsetAttributes_SetWireframe, METH_VARARGS},
    {"GetWireframe", SubsetAttributes_GetWireframe, METH_VARARGS},
    {"SetDrawInternal", SubsetAttributes_SetDrawInternal, METH_VARARGS},
    {"GetDrawInternal", SubsetAttributes_GetDrawInternal, METH_VARARGS},
    {"SetSmoothingLevel", SubsetAttributes_SetSmoothingLevel, METH_VARARGS},
    {"GetSmoothingLevel", SubsetAttributes_GetSmoothingLevel, METH_VARARGS},
    {"SetPointSize", SubsetAttributes_SetPointSize, METH_VARARGS},
    {"GetPointSize", SubsetAttributes_GetPointSize, METH_VARARGS},
    {"SetPointType", SubsetAttributes_SetPointType, METH_VARARGS},
    {"GetPointType", SubsetAttributes_GetPointType, METH_VARARGS},
    {"SetPointSizeVarEnabled", SubsetAttributes_SetPointSizeVarEnabled, METH_VARARGS},
    {"GetPointSizeVarEnabled", SubsetAttributes_GetPointSizeVarEnabled, METH_VARARGS},
    {"SetPointSizeVar", SubsetAttributes_SetPointSizeVar, METH_VARARGS},
    {"GetPointSizeVar", SubsetAttributes_GetPointSizeVar, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
SubsetAttributes_dealloc(PyObject *v)
{
   SubsetAttributesObject *obj = (SubsetAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
SubsetAttributes_compare(PyObject *v, PyObject *w)
{
    SubsetAttributes *a = ((SubsetAttributesObject *)v)->data;
    SubsetAttributes *b = ((SubsetAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
SubsetAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "colorType") == 0)
        return SubsetAttributes_GetColorType(self, NULL);
    if(strcmp(name, "ColorBySingleColor") == 0)
        return PyInt_FromLong(long(SubsetAttributes::ColorBySingleColor));
    else if(strcmp(name, "ColorByMultipleColors") == 0)
        return PyInt_FromLong(long(SubsetAttributes::ColorByMultipleColors));
    else if(strcmp(name, "ColorByColorTable") == 0)
        return PyInt_FromLong(long(SubsetAttributes::ColorByColorTable));

    if(strcmp(name, "colorTableName") == 0)
        return SubsetAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "filledFlag") == 0)
        return SubsetAttributes_GetFilledFlag(self, NULL);
    if(strcmp(name, "legendFlag") == 0)
        return SubsetAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "lineStyle") == 0)
        return SubsetAttributes_GetLineStyle(self, NULL);
    if(strcmp(name, "lineWidth") == 0)
        return SubsetAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "singleColor") == 0)
        return SubsetAttributes_GetSingleColor(self, NULL);
    if(strcmp(name, "subsetNames") == 0)
        return SubsetAttributes_GetSubsetNames(self, NULL);
    if(strcmp(name, "subsetType") == 0)
        return SubsetAttributes_GetSubsetType(self, NULL);
    if(strcmp(name, "Domain") == 0)
        return PyInt_FromLong(long(SubsetAttributes::Domain));
    else if(strcmp(name, "Group") == 0)
        return PyInt_FromLong(long(SubsetAttributes::Group));
    else if(strcmp(name, "Material") == 0)
        return PyInt_FromLong(long(SubsetAttributes::Material));
    else if(strcmp(name, "Unknown") == 0)
        return PyInt_FromLong(long(SubsetAttributes::Unknown));

    if(strcmp(name, "opacity") == 0)
        return SubsetAttributes_GetOpacity(self, NULL);
    if(strcmp(name, "wireframe") == 0)
        return SubsetAttributes_GetWireframe(self, NULL);
    if(strcmp(name, "drawInternal") == 0)
        return SubsetAttributes_GetDrawInternal(self, NULL);
    if(strcmp(name, "smoothingLevel") == 0)
        return SubsetAttributes_GetSmoothingLevel(self, NULL);
    if(strcmp(name, "pointSize") == 0)
        return SubsetAttributes_GetPointSize(self, NULL);
    if(strcmp(name, "pointType") == 0)
        return SubsetAttributes_GetPointType(self, NULL);
    if(strcmp(name, "Box") == 0)
        return PyInt_FromLong(long(SubsetAttributes::Box));
    else if(strcmp(name, "Axis") == 0)
        return PyInt_FromLong(long(SubsetAttributes::Axis));
    else if(strcmp(name, "Icosahedron") == 0)
        return PyInt_FromLong(long(SubsetAttributes::Icosahedron));
    else if(strcmp(name, "Point") == 0)
        return PyInt_FromLong(long(SubsetAttributes::Point));

    if(strcmp(name, "pointSizeVarEnabled") == 0)
        return SubsetAttributes_GetPointSizeVarEnabled(self, NULL);
    if(strcmp(name, "pointSizeVar") == 0)
        return SubsetAttributes_GetPointSizeVar(self, NULL);

    return Py_FindMethod(SubsetAttributes_methods, self, name);
}

static int
SubsetAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "colorType") == 0)
        retval = (SubsetAttributes_SetColorType(self, tuple) != NULL);
    else if(strcmp(name, "colorTableName") == 0)
        retval = (SubsetAttributes_SetColorTableName(self, tuple) != NULL);
    else if(strcmp(name, "filledFlag") == 0)
        retval = (SubsetAttributes_SetFilledFlag(self, tuple) != NULL);
    else if(strcmp(name, "legendFlag") == 0)
        retval = (SubsetAttributes_SetLegendFlag(self, tuple) != NULL);
    else if(strcmp(name, "lineStyle") == 0)
        retval = (SubsetAttributes_SetLineStyle(self, tuple) != NULL);
    else if(strcmp(name, "lineWidth") == 0)
        retval = (SubsetAttributes_SetLineWidth(self, tuple) != NULL);
    else if(strcmp(name, "singleColor") == 0)
        retval = (SubsetAttributes_SetSingleColor(self, tuple) != NULL);
    else if(strcmp(name, "subsetNames") == 0)
        retval = (SubsetAttributes_SetSubsetNames(self, tuple) != NULL);
    else if(strcmp(name, "subsetType") == 0)
        retval = (SubsetAttributes_SetSubsetType(self, tuple) != NULL);
    else if(strcmp(name, "opacity") == 0)
        retval = (SubsetAttributes_SetOpacity(self, tuple) != NULL);
    else if(strcmp(name, "wireframe") == 0)
        retval = (SubsetAttributes_SetWireframe(self, tuple) != NULL);
    else if(strcmp(name, "drawInternal") == 0)
        retval = (SubsetAttributes_SetDrawInternal(self, tuple) != NULL);
    else if(strcmp(name, "smoothingLevel") == 0)
        retval = (SubsetAttributes_SetSmoothingLevel(self, tuple) != NULL);
    else if(strcmp(name, "pointSize") == 0)
        retval = (SubsetAttributes_SetPointSize(self, tuple) != NULL);
    else if(strcmp(name, "pointType") == 0)
        retval = (SubsetAttributes_SetPointType(self, tuple) != NULL);
    else if(strcmp(name, "pointSizeVarEnabled") == 0)
        retval = (SubsetAttributes_SetPointSizeVarEnabled(self, tuple) != NULL);
    else if(strcmp(name, "pointSizeVar") == 0)
        retval = (SubsetAttributes_SetPointSizeVar(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
SubsetAttributes_print(PyObject *v, FILE *fp, int flags)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)v;

    const char *colorType_names = "ColorBySingleColor, ColorByMultipleColors, ColorByColorTable";
    if(obj->data->GetColorType() == SubsetAttributes::ColorBySingleColor)
        fprintf(fp, "colorType = ColorBySingleColor  # %s\n", colorType_names);
    else if(obj->data->GetColorType() == SubsetAttributes::ColorByMultipleColors)
        fprintf(fp, "colorType = ColorByMultipleColors  # %s\n", colorType_names);
    else
        fprintf(fp, "colorType = ColorByColorTable  # %s\n", colorType_names);

    fprintf(fp, "colorTableName = %s\n", obj->data->GetColorTableName().c_str());
    if(obj->data->GetFilledFlag())
        fprintf(fp, "filledFlag = 1\n");
    else
        fprintf(fp, "filledFlag = 0\n");
    if(obj->data->GetLegendFlag())
        fprintf(fp, "legendFlag = 1\n");
    else
        fprintf(fp, "legendFlag = 0\n");
    fprintf(fp, "lineStyle = %d\n", obj->data->GetLineStyle());
    fprintf(fp, "lineWidth = %d\n", obj->data->GetLineWidth());
    const unsigned char *singleColor = obj->data->GetSingleColor().GetColor();
    fprintf(fp, "singleColor = (%d, %d, %d, %d)\n", int(singleColor[0]), int(singleColor[1]), int(singleColor[2]), int(singleColor[3]));
    //multiColor
    {   const stringVector &subsetNames = obj->data->GetSubsetNames();
        fprintf(fp, "subsetNames = (");
        for(int i = 0; i < subsetNames.size(); ++i)
        {
            fprintf(fp, "\"%s\"", subsetNames[i].c_str());
            if(i < subsetNames.size() - 1)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    const char *subsetType_names = "Domain, Group, Material, Unknown";
    if(obj->data->GetSubsetType() == SubsetAttributes::Domain)
        fprintf(fp, "subsetType = Domain  # %s\n", subsetType_names);
    else if(obj->data->GetSubsetType() == SubsetAttributes::Group)
        fprintf(fp, "subsetType = Group  # %s\n", subsetType_names);
    else if(obj->data->GetSubsetType() == SubsetAttributes::Material)
        fprintf(fp, "subsetType = Material  # %s\n", subsetType_names);
    else
        fprintf(fp, "subsetType = Unknown  # %s\n", subsetType_names);

    fprintf(fp, "opacity = %g\n", obj->data->GetOpacity());
    if(obj->data->GetWireframe())
        fprintf(fp, "wireframe = 1\n");
    else
        fprintf(fp, "wireframe = 0\n");
    if(obj->data->GetDrawInternal())
        fprintf(fp, "drawInternal = 1\n");
    else
        fprintf(fp, "drawInternal = 0\n");
    fprintf(fp, "smoothingLevel = %d\n", obj->data->GetSmoothingLevel());
    fprintf(fp, "pointSize = %g\n", obj->data->GetPointSize());
    const char *pointType_names = "Box, Axis, Icosahedron, Point";
    if(obj->data->GetPointType() == SubsetAttributes::Box)
        fprintf(fp, "pointType = Box  # %s\n", pointType_names);
    else if(obj->data->GetPointType() == SubsetAttributes::Axis)
        fprintf(fp, "pointType = Axis  # %s\n", pointType_names);
    else if(obj->data->GetPointType() == SubsetAttributes::Icosahedron)
        fprintf(fp, "pointType = Icosahedron  # %s\n", pointType_names);
    else
        fprintf(fp, "pointType = Point  # %s\n", pointType_names);

    if(obj->data->GetPointSizeVarEnabled())
        fprintf(fp, "pointSizeVarEnabled = 1\n");
    else
        fprintf(fp, "pointSizeVarEnabled = 0\n");
    fprintf(fp, "pointSizeVar = \"%s\"\n", obj->data->GetPointSizeVar().c_str());

    return 0;
}

#include <snprintf.h>
PyObject *
PySubsetAttributes_StringRepresentation(const SubsetAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    const char *colorType_names = "ColorBySingleColor, ColorByMultipleColors, ColorByColorTable";
    if(atts->GetColorType() == SubsetAttributes::ColorBySingleColor)
        {
             SNPRINTF(tmpStr, 1000, "colorType = ColorBySingleColor  # %s\n", colorType_names);
             str += tmpStr;
        }
    else if(atts->GetColorType() == SubsetAttributes::ColorByMultipleColors)
        {
             SNPRINTF(tmpStr, 1000, "colorType = ColorByMultipleColors  # %s\n", colorType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "colorType = ColorByColorTable  # %s\n", colorType_names);
             str += tmpStr;
        }

   SNPRINTF(tmpStr, 1000, "colorTableName = %s\n", atts->GetColorTableName().c_str());
   str += tmpStr;
    if(atts->GetFilledFlag())
        SNPRINTF(tmpStr, 1000, "filledFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "filledFlag = 0\n");
    str += tmpStr;
    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "legendFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "legendFlag = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "lineStyle = %d\n", atts->GetLineStyle());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "lineWidth = %d\n", atts->GetLineWidth());
    str += tmpStr;
    const unsigned char *singleColor = atts->GetSingleColor().GetColor();
    SNPRINTF(tmpStr, 1000, "singleColor = (%d, %d, %d, %d)\n", int(singleColor[0]), int(singleColor[1]), int(singleColor[2]), int(singleColor[3]));
    str += tmpStr;
#if 0
    { // new scope
         PyObject *s = PyColorAttributeList_StringRepresentation(atts->GetMultiColor());
         str += "multiColor = {"
         if(obj != 0) str += PyString_AS_STRING(s);
         str += "}"
    }
#endif
    {   const stringVector &subsetNames = atts->GetSubsetNames();
        SNPRINTF(tmpStr, 1000, "subsetNames = (");
        str += tmpStr;
        for(int i = 0; i < subsetNames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", subsetNames[i].c_str());
            str += tmpStr;
            if(i < subsetNames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *subsetType_names = "Domain, Group, Material, Unknown";
    if(atts->GetSubsetType() == SubsetAttributes::Domain)
        {
             SNPRINTF(tmpStr, 1000, "subsetType = Domain  # %s\n", subsetType_names);
             str += tmpStr;
        }
    else if(atts->GetSubsetType() == SubsetAttributes::Group)
        {
             SNPRINTF(tmpStr, 1000, "subsetType = Group  # %s\n", subsetType_names);
             str += tmpStr;
        }
    else if(atts->GetSubsetType() == SubsetAttributes::Material)
        {
             SNPRINTF(tmpStr, 1000, "subsetType = Material  # %s\n", subsetType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "subsetType = Unknown  # %s\n", subsetType_names);
             str += tmpStr;
        }

    SNPRINTF(tmpStr, 1000, "opacity = %g\n", atts->GetOpacity());
    str += tmpStr;
    if(atts->GetWireframe())
        SNPRINTF(tmpStr, 1000, "wireframe = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "wireframe = 0\n");
    str += tmpStr;
    if(atts->GetDrawInternal())
        SNPRINTF(tmpStr, 1000, "drawInternal = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "drawInternal = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "smoothingLevel = %d\n", atts->GetSmoothingLevel());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "pointSize = %g\n", atts->GetPointSize());
    str += tmpStr;
    const char *pointType_names = "Box, Axis, Icosahedron, Point";
    if(atts->GetPointType() == SubsetAttributes::Box)
        {
             SNPRINTF(tmpStr, 1000, "pointType = Box  # %s\n", pointType_names);
             str += tmpStr;
        }
    else if(atts->GetPointType() == SubsetAttributes::Axis)
        {
             SNPRINTF(tmpStr, 1000, "pointType = Axis  # %s\n", pointType_names);
             str += tmpStr;
        }
    else if(atts->GetPointType() == SubsetAttributes::Icosahedron)
        {
             SNPRINTF(tmpStr, 1000, "pointType = Icosahedron  # %s\n", pointType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "pointType = Point  # %s\n", pointType_names);
             str += tmpStr;
        }

    if(atts->GetPointSizeVarEnabled())
        SNPRINTF(tmpStr, 1000, "pointSizeVarEnabled = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "pointSizeVarEnabled = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "pointSizeVar = \"%s\"\n", atts->GetPointSizeVar().c_str());
    str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
SubsetAttributes_str(PyObject *v)
{
    SubsetAttributesObject *obj = (SubsetAttributesObject *)v;
    return PySubsetAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *SubsetAttributes_Purpose = "This class contains the plot attributes for the subset boundary plot.";

//
// The type description structure
//
static PyTypeObject SubsetAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "SubsetAttributes",                    // tp_name
    sizeof(SubsetAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)SubsetAttributes_dealloc,  // tp_dealloc
    (printfunc)SubsetAttributes_print,     // tp_print
    (getattrfunc)SubsetAttributes_getattr, // tp_getattr
    (setattrfunc)SubsetAttributes_setattr, // tp_setattr
    (cmpfunc)SubsetAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)SubsetAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    SubsetAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static SubsetAttributes *defaultAtts = 0;

static PyObject *
NewSubsetAttributes()
{
    SubsetAttributesObject *newObject;
    newObject = PyObject_NEW(SubsetAttributesObject, &SubsetAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new SubsetAttributes(*defaultAtts);
    else
        newObject->data = new SubsetAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapSubsetAttributes(const SubsetAttributes *attr)
{
    SubsetAttributesObject *newObject;
    newObject = PyObject_NEW(SubsetAttributesObject, &SubsetAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (SubsetAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
SubsetAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewSubsetAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef SubsetAttributesMethods[] = {
    {"SubsetAttributes", SubsetAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *SubsetAttributesObserver = 0;
static bool SubsetAttributesEnableLogging = true;

static void
PySubsetAttributes_WriteLog(Subject *subj, void *data)
{
    SubsetAttributes *atts = (SubsetAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!SubsetAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# SubsetAttributes_WriteLog()\n");
}

void
PySubsetAttributes_StartUp(SubsetAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PySubsetAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(SubsetAttributesObserver == 0)
    {
        SubsetAttributesObserver = new ObserverToCallback(subj,
            PySubsetAttributes_WriteLog, (void *)logFile);
    }

    SubsetAttributesEnableLogging = true;
}

void
PySubsetAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete SubsetAttributesObserver;
    SubsetAttributesObserver = 0;
}

PyMethodDef *
PySubsetAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return SubsetAttributesMethods;
}

bool
PySubsetAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &SubsetAttributesType);
}

SubsetAttributes *
PySubsetAttributes_FromPyObject(PyObject *obj)
{
    SubsetAttributesObject *obj2 = (SubsetAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PySubsetAttributes_NewPyObject()
{
    return NewSubsetAttributes();
}

PyObject *
PySubsetAttributes_WrapPyObject(const SubsetAttributes *attr)
{
    return WrapSubsetAttributes(attr);
}

void
PySubsetAttributes_SetLogging(bool val)
{
    SubsetAttributesEnableLogging = val;
}

// ****************************************************************************
//  Modifications:
//    Kathleen Bonnell, Mon Dec  2 18:06:04 PST 2002
//    Make defaultAtts point to the passed atts directly.
//
// ****************************************************************************
void
PySubsetAttributes_SetDefaults(const SubsetAttributes *atts)
{
    defaultAtts = const_cast<SubsetAttributes*>(atts);
}
