// ************************************************************************* //
//  File: StreamlineViewerPluginInfo.C
// ************************************************************************* //

#include <StreamlinePluginInfo.h>
#include <avtStreamlinePlot.h>

#if defined(__APPLE__)
#define GetViewerInfo Streamline_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Streamline plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:48 PST 2004
//
// ****************************************************************************
extern "C" ViewerPlotPluginInfo* GetViewerInfo()
{
    StreamlineViewerPluginInfo::InitializeGlobalObjects();
    return new StreamlineViewerPluginInfo;
}

//
// Storage for static data elements.
//
StreamlineAttributes *StreamlineViewerPluginInfo::clientAtts = NULL;
StreamlineAttributes *StreamlineViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  StreamlineViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:48 PST 2004
//
// ****************************************************************************
void
StreamlineViewerPluginInfo::InitializeGlobalObjects()
{
    StreamlineViewerPluginInfo::clientAtts  = new StreamlineAttributes;
    StreamlineViewerPluginInfo::defaultAtts = new StreamlineAttributes;
}

// ****************************************************************************
//  Method: StreamlineViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:48 PST 2004
//
// ****************************************************************************

AttributeSubject *
StreamlineViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: StreamlineViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:48 PST 2004
//
// ****************************************************************************

AttributeSubject *
StreamlineViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: StreamlineViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:48 PST 2004
//
// ****************************************************************************

void
StreamlineViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(StreamlineAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: StreamlineViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:48 PST 2004
//
// ****************************************************************************

void
StreamlineViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(StreamlineAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: StreamlineViewerPluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:48 PST 2004
//
// ****************************************************************************

avtPlot *
StreamlineViewerPluginInfo::AllocAvtPlot()
{
    return new avtStreamlinePlot;
}

// ****************************************************************************
//  Method: StreamlineViewerPluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:48 PST 2004
//
// ****************************************************************************

void
StreamlineViewerPluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtDatabaseMetaData *, const char *)
{
    *(StreamlineAttributes*)atts = *defaultAtts;
}

// ****************************************************************************
// Method: StreamlineViewerPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:48 PST 2004
//
// Modifications:
//   
// ****************************************************************************

int
StreamlineViewerPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_VECTOR;
}


// ****************************************************************************
//  Method: StreamlineViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:48 PST 2004
//
// ****************************************************************************

#include <Streamline.xpm>
const char **
StreamlineViewerPluginInfo::XPMIconData() const
{
    return Streamline_xpm;
}
