// ************************************************************************* //
//                        StreamlineScriptingPluginInfo.C
// ************************************************************************* //
#include <StreamlinePluginInfo.h>
#include <PyStreamlineAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Streamline_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Streamline plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Oct 4 15:22:56 PST 2002
//
// ****************************************************************************
extern "C" ScriptingPlotPluginInfo* GetScriptingInfo()
{
    return new StreamlineScriptingPluginInfo;
}

// ****************************************************************************
// Method: StreamlineScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Oct 4 15:22:56 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
StreamlineScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyStreamlineAttributes_StartUp((StreamlineAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: StreamlineScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Oct 4 15:22:56 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void *
StreamlineScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyStreamlineAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: StreamlineScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Streamline plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Oct 4 15:22:56 PST 2002
//
// Modifications:
//   
// ****************************************************************************

bool
StreamlineScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyStreamlineAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: StreamlineScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Oct 4 15:22:56 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
StreamlineScriptingPluginInfo::SetLogging(bool val)
{
    PyStreamlineAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: StreamlineScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Oct 4 15:22:56 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
StreamlineScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyStreamlineAttributes_SetDefaults((const StreamlineAttributes *)atts);
}
