// ************************************************************************* //
//  File: StreamlineGUIPluginInfo.C
// ************************************************************************* //

#include <StreamlinePluginInfo.h>
#include <StreamlineAttributes.h>
#include <QvisStreamlinePlotWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Streamline_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Streamline plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 11:13:00 PDT 2003
//
// ****************************************************************************
extern "C" GUIPlotPluginInfo* GetGUIInfo()
{
    return new StreamlineGUIPluginInfo;
}

// ****************************************************************************
//  Method: StreamlineGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 11:13:00 PDT 2003
//
// ****************************************************************************

const char *
StreamlineGUIPluginInfo::GetMenuName() const
{
    return "Streamline";
}


// ****************************************************************************
// Method: StreamlineGUIPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 11:13:00 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

int
StreamlineGUIPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_VECTOR;
}

// ****************************************************************************
//  Method: StreamlineGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 11:13:00 PDT 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
StreamlineGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisStreamlinePlotWindow(type, (StreamlineAttributes *)attr,
        "Streamline plot attributes", "Streamline plot", notepad);
}

// ****************************************************************************
//  Method: StreamlineGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 11:13:00 PDT 2003
//
// ****************************************************************************

#include <Streamline.xpm>
const char **
StreamlineGUIPluginInfo::XPMIconData() const
{
    return Streamline_xpm;
}
