package llnl.visit.plots;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;
import llnl.visit.ColorAttribute;

// ****************************************************************************
// Class: StreamlineAttributes
//
// Purpose:
//    Attributes for the Streamline plot
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Wed Dec 22 14:35:15 PST 2004
//
// Modifications:
//   
// ****************************************************************************

public class StreamlineAttributes extends AttributeSubject implements Plugin
{
    // Enum values
    public final static int SOURCETYPE_SPECIFIEDPOINT = 0;
    public final static int SOURCETYPE_SPECIFIEDLINE = 1;
    public final static int SOURCETYPE_SPECIFIEDPLANE = 2;
    public final static int SOURCETYPE_SPECIFIEDSPHERE = 3;
    public final static int SOURCETYPE_SPECIFIEDBOX = 4;

    public final static int COLORINGMETHOD_SOLID = 0;
    public final static int COLORINGMETHOD_COLORBYSPEED = 1;
    public final static int COLORINGMETHOD_COLORBYVORTICITY = 2;

    public final static int DISPLAYMETHOD_LINES = 0;
    public final static int DISPLAYMETHOD_TUBES = 1;
    public final static int DISPLAYMETHOD_RIBBONS = 2;


    public StreamlineAttributes()
    {
        super(23);

        sourceType = SOURCETYPE_SPECIFIEDPOINT;
        stepLength = 1;
        maxTime = 10;
        pointSource = new double[3];
        pointSource[0] = 0;
        pointSource[1] = 0;
        pointSource[2] = 0;
        lineStart = new double[3];
        lineStart[0] = 0;
        lineStart[1] = 0;
        lineStart[2] = 0;
        lineEnd = new double[3];
        lineEnd[0] = 1;
        lineEnd[1] = 0;
        lineEnd[2] = 0;
        planeOrigin = new double[3];
        planeOrigin[0] = 0;
        planeOrigin[1] = 0;
        planeOrigin[2] = 0;
        planeNormal = new double[3];
        planeNormal[0] = 0;
        planeNormal[1] = 0;
        planeNormal[2] = 1;
        planeUpAxis = new double[3];
        planeUpAxis[0] = 0;
        planeUpAxis[1] = 1;
        planeUpAxis[2] = 0;
        planeRadius = 1;
        sphereOrigin = new double[3];
        sphereOrigin[0] = 0;
        sphereOrigin[1] = 0;
        sphereOrigin[2] = 0;
        sphereRadius = 1;
        boxExtents = new double[6];
        boxExtents[0] = 0;
        boxExtents[1] = 1;
        boxExtents[2] = 0;
        boxExtents[3] = 1;
        boxExtents[4] = 0;
        boxExtents[5] = 1;
        pointDensity = 2;
        displayMethod = DISPLAYMETHOD_LINES;
        showStart = true;
        radius = 0.125;
        lineWidth = 2;
        coloringMethod = COLORINGMETHOD_COLORBYSPEED;
        colorTableName = new String("Default");
        singleColor = new ColorAttribute(0, 0, 0);
        legendFlag = true;
        lightingFlag = true;
    }

    public StreamlineAttributes(StreamlineAttributes obj)
    {
        super(23);

        int i;

        sourceType = obj.sourceType;
        stepLength = obj.stepLength;
        maxTime = obj.maxTime;
        pointSource = new double[3];
        pointSource[0] = obj.pointSource[0];
        pointSource[1] = obj.pointSource[1];
        pointSource[2] = obj.pointSource[2];

        lineStart = new double[3];
        lineStart[0] = obj.lineStart[0];
        lineStart[1] = obj.lineStart[1];
        lineStart[2] = obj.lineStart[2];

        lineEnd = new double[3];
        lineEnd[0] = obj.lineEnd[0];
        lineEnd[1] = obj.lineEnd[1];
        lineEnd[2] = obj.lineEnd[2];

        planeOrigin = new double[3];
        planeOrigin[0] = obj.planeOrigin[0];
        planeOrigin[1] = obj.planeOrigin[1];
        planeOrigin[2] = obj.planeOrigin[2];

        planeNormal = new double[3];
        planeNormal[0] = obj.planeNormal[0];
        planeNormal[1] = obj.planeNormal[1];
        planeNormal[2] = obj.planeNormal[2];

        planeUpAxis = new double[3];
        planeUpAxis[0] = obj.planeUpAxis[0];
        planeUpAxis[1] = obj.planeUpAxis[1];
        planeUpAxis[2] = obj.planeUpAxis[2];

        planeRadius = obj.planeRadius;
        sphereOrigin = new double[3];
        sphereOrigin[0] = obj.sphereOrigin[0];
        sphereOrigin[1] = obj.sphereOrigin[1];
        sphereOrigin[2] = obj.sphereOrigin[2];

        sphereRadius = obj.sphereRadius;
        boxExtents = new double[6];
        for(i = 0; i < obj.boxExtents.length; ++i)
            boxExtents[i] = obj.boxExtents[i];

        pointDensity = obj.pointDensity;
        displayMethod = obj.displayMethod;
        showStart = obj.showStart;
        radius = obj.radius;
        lineWidth = obj.lineWidth;
        coloringMethod = obj.coloringMethod;
        colorTableName = new String(obj.colorTableName);
        singleColor = new ColorAttribute(obj.singleColor);
        legendFlag = obj.legendFlag;
        lightingFlag = obj.lightingFlag;

        SelectAll();
    }

    public boolean equals(StreamlineAttributes obj)
    {
        int i;

        // Compare the pointSource arrays.
        boolean pointSource_equal = true;
        for(i = 0; i < 3 && pointSource_equal; ++i)
            pointSource_equal = (pointSource[i] == obj.pointSource[i]);

        // Compare the lineStart arrays.
        boolean lineStart_equal = true;
        for(i = 0; i < 3 && lineStart_equal; ++i)
            lineStart_equal = (lineStart[i] == obj.lineStart[i]);

        // Compare the lineEnd arrays.
        boolean lineEnd_equal = true;
        for(i = 0; i < 3 && lineEnd_equal; ++i)
            lineEnd_equal = (lineEnd[i] == obj.lineEnd[i]);

        // Compare the planeOrigin arrays.
        boolean planeOrigin_equal = true;
        for(i = 0; i < 3 && planeOrigin_equal; ++i)
            planeOrigin_equal = (planeOrigin[i] == obj.planeOrigin[i]);

        // Compare the planeNormal arrays.
        boolean planeNormal_equal = true;
        for(i = 0; i < 3 && planeNormal_equal; ++i)
            planeNormal_equal = (planeNormal[i] == obj.planeNormal[i]);

        // Compare the planeUpAxis arrays.
        boolean planeUpAxis_equal = true;
        for(i = 0; i < 3 && planeUpAxis_equal; ++i)
            planeUpAxis_equal = (planeUpAxis[i] == obj.planeUpAxis[i]);

        // Compare the sphereOrigin arrays.
        boolean sphereOrigin_equal = true;
        for(i = 0; i < 3 && sphereOrigin_equal; ++i)
            sphereOrigin_equal = (sphereOrigin[i] == obj.sphereOrigin[i]);

        // Compare the boxExtents arrays.
        boolean boxExtents_equal = true;
        for(i = 0; i < 6 && boxExtents_equal; ++i)
            boxExtents_equal = (boxExtents[i] == obj.boxExtents[i]);

        // Create the return value
        return ((sourceType == obj.sourceType) &&
                (stepLength == obj.stepLength) &&
                (maxTime == obj.maxTime) &&
                pointSource_equal &&
                lineStart_equal &&
                lineEnd_equal &&
                planeOrigin_equal &&
                planeNormal_equal &&
                planeUpAxis_equal &&
                (planeRadius == obj.planeRadius) &&
                sphereOrigin_equal &&
                (sphereRadius == obj.sphereRadius) &&
                boxExtents_equal &&
                (pointDensity == obj.pointDensity) &&
                (displayMethod == obj.displayMethod) &&
                (showStart == obj.showStart) &&
                (radius == obj.radius) &&
                (lineWidth == obj.lineWidth) &&
                (coloringMethod == obj.coloringMethod) &&
                (colorTableName == obj.colorTableName) &&
                (singleColor == obj.singleColor) &&
                (legendFlag == obj.legendFlag) &&
                (lightingFlag == obj.lightingFlag));
    }

    public String GetName() { return "Streamline"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetSourceType(int sourceType_)
    {
        sourceType = sourceType_;
        Select(0);
    }

    public void SetStepLength(double stepLength_)
    {
        stepLength = stepLength_;
        Select(1);
    }

    public void SetMaxTime(double maxTime_)
    {
        maxTime = maxTime_;
        Select(2);
    }

    public void SetPointSource(double[] pointSource_)
    {
        pointSource[0] = pointSource_[0];
        pointSource[1] = pointSource_[1];
        pointSource[2] = pointSource_[2];
        Select(3);
    }

    public void SetPointSource(double e0, double e1, double e2)
    {
        pointSource[0] = e0;
        pointSource[1] = e1;
        pointSource[2] = e2;
        Select(3);
    }

    public void SetLineStart(double[] lineStart_)
    {
        lineStart[0] = lineStart_[0];
        lineStart[1] = lineStart_[1];
        lineStart[2] = lineStart_[2];
        Select(4);
    }

    public void SetLineStart(double e0, double e1, double e2)
    {
        lineStart[0] = e0;
        lineStart[1] = e1;
        lineStart[2] = e2;
        Select(4);
    }

    public void SetLineEnd(double[] lineEnd_)
    {
        lineEnd[0] = lineEnd_[0];
        lineEnd[1] = lineEnd_[1];
        lineEnd[2] = lineEnd_[2];
        Select(5);
    }

    public void SetLineEnd(double e0, double e1, double e2)
    {
        lineEnd[0] = e0;
        lineEnd[1] = e1;
        lineEnd[2] = e2;
        Select(5);
    }

    public void SetPlaneOrigin(double[] planeOrigin_)
    {
        planeOrigin[0] = planeOrigin_[0];
        planeOrigin[1] = planeOrigin_[1];
        planeOrigin[2] = planeOrigin_[2];
        Select(6);
    }

    public void SetPlaneOrigin(double e0, double e1, double e2)
    {
        planeOrigin[0] = e0;
        planeOrigin[1] = e1;
        planeOrigin[2] = e2;
        Select(6);
    }

    public void SetPlaneNormal(double[] planeNormal_)
    {
        planeNormal[0] = planeNormal_[0];
        planeNormal[1] = planeNormal_[1];
        planeNormal[2] = planeNormal_[2];
        Select(7);
    }

    public void SetPlaneNormal(double e0, double e1, double e2)
    {
        planeNormal[0] = e0;
        planeNormal[1] = e1;
        planeNormal[2] = e2;
        Select(7);
    }

    public void SetPlaneUpAxis(double[] planeUpAxis_)
    {
        planeUpAxis[0] = planeUpAxis_[0];
        planeUpAxis[1] = planeUpAxis_[1];
        planeUpAxis[2] = planeUpAxis_[2];
        Select(8);
    }

    public void SetPlaneUpAxis(double e0, double e1, double e2)
    {
        planeUpAxis[0] = e0;
        planeUpAxis[1] = e1;
        planeUpAxis[2] = e2;
        Select(8);
    }

    public void SetPlaneRadius(double planeRadius_)
    {
        planeRadius = planeRadius_;
        Select(9);
    }

    public void SetSphereOrigin(double[] sphereOrigin_)
    {
        sphereOrigin[0] = sphereOrigin_[0];
        sphereOrigin[1] = sphereOrigin_[1];
        sphereOrigin[2] = sphereOrigin_[2];
        Select(10);
    }

    public void SetSphereOrigin(double e0, double e1, double e2)
    {
        sphereOrigin[0] = e0;
        sphereOrigin[1] = e1;
        sphereOrigin[2] = e2;
        Select(10);
    }

    public void SetSphereRadius(double sphereRadius_)
    {
        sphereRadius = sphereRadius_;
        Select(11);
    }

    public void SetBoxExtents(double[] boxExtents_)
    {
        for(int i = 0; i < 6; ++i)
             boxExtents[i] = boxExtents_[i];
        Select(12);
    }

    public void SetPointDensity(int pointDensity_)
    {
        pointDensity = pointDensity_;
        Select(13);
    }

    public void SetDisplayMethod(int displayMethod_)
    {
        displayMethod = displayMethod_;
        Select(14);
    }

    public void SetShowStart(boolean showStart_)
    {
        showStart = showStart_;
        Select(15);
    }

    public void SetRadius(double radius_)
    {
        radius = radius_;
        Select(16);
    }

    public void SetLineWidth(int lineWidth_)
    {
        lineWidth = lineWidth_;
        Select(17);
    }

    public void SetColoringMethod(int coloringMethod_)
    {
        coloringMethod = coloringMethod_;
        Select(18);
    }

    public void SetColorTableName(String colorTableName_)
    {
        colorTableName = colorTableName_;
        Select(19);
    }

    public void SetSingleColor(ColorAttribute singleColor_)
    {
        singleColor = singleColor_;
        Select(20);
    }

    public void SetLegendFlag(boolean legendFlag_)
    {
        legendFlag = legendFlag_;
        Select(21);
    }

    public void SetLightingFlag(boolean lightingFlag_)
    {
        lightingFlag = lightingFlag_;
        Select(22);
    }

    // Property getting methods
    public int            GetSourceType() { return sourceType; }
    public double         GetStepLength() { return stepLength; }
    public double         GetMaxTime() { return maxTime; }
    public double[]       GetPointSource() { return pointSource; }
    public double[]       GetLineStart() { return lineStart; }
    public double[]       GetLineEnd() { return lineEnd; }
    public double[]       GetPlaneOrigin() { return planeOrigin; }
    public double[]       GetPlaneNormal() { return planeNormal; }
    public double[]       GetPlaneUpAxis() { return planeUpAxis; }
    public double         GetPlaneRadius() { return planeRadius; }
    public double[]       GetSphereOrigin() { return sphereOrigin; }
    public double         GetSphereRadius() { return sphereRadius; }
    public double[]       GetBoxExtents() { return boxExtents; }
    public int            GetPointDensity() { return pointDensity; }
    public int            GetDisplayMethod() { return displayMethod; }
    public boolean        GetShowStart() { return showStart; }
    public double         GetRadius() { return radius; }
    public int            GetLineWidth() { return lineWidth; }
    public int            GetColoringMethod() { return coloringMethod; }
    public String         GetColorTableName() { return colorTableName; }
    public ColorAttribute GetSingleColor() { return singleColor; }
    public boolean        GetLegendFlag() { return legendFlag; }
    public boolean        GetLightingFlag() { return lightingFlag; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(sourceType);
        if(WriteSelect(1, buf))
            buf.WriteDouble(stepLength);
        if(WriteSelect(2, buf))
            buf.WriteDouble(maxTime);
        if(WriteSelect(3, buf))
            buf.WriteDoubleArray(pointSource);
        if(WriteSelect(4, buf))
            buf.WriteDoubleArray(lineStart);
        if(WriteSelect(5, buf))
            buf.WriteDoubleArray(lineEnd);
        if(WriteSelect(6, buf))
            buf.WriteDoubleArray(planeOrigin);
        if(WriteSelect(7, buf))
            buf.WriteDoubleArray(planeNormal);
        if(WriteSelect(8, buf))
            buf.WriteDoubleArray(planeUpAxis);
        if(WriteSelect(9, buf))
            buf.WriteDouble(planeRadius);
        if(WriteSelect(10, buf))
            buf.WriteDoubleArray(sphereOrigin);
        if(WriteSelect(11, buf))
            buf.WriteDouble(sphereRadius);
        if(WriteSelect(12, buf))
            buf.WriteDoubleArray(boxExtents);
        if(WriteSelect(13, buf))
            buf.WriteInt(pointDensity);
        if(WriteSelect(14, buf))
            buf.WriteInt(displayMethod);
        if(WriteSelect(15, buf))
            buf.WriteBool(showStart);
        if(WriteSelect(16, buf))
            buf.WriteDouble(radius);
        if(WriteSelect(17, buf))
            buf.WriteInt(lineWidth);
        if(WriteSelect(18, buf))
            buf.WriteInt(coloringMethod);
        if(WriteSelect(19, buf))
            buf.WriteString(colorTableName);
        if(WriteSelect(20, buf))
            singleColor.Write(buf);
        if(WriteSelect(21, buf))
            buf.WriteBool(legendFlag);
        if(WriteSelect(22, buf))
            buf.WriteBool(lightingFlag);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetSourceType(buf.ReadInt());
                break;
            case 1:
                SetStepLength(buf.ReadDouble());
                break;
            case 2:
                SetMaxTime(buf.ReadDouble());
                break;
            case 3:
                SetPointSource(buf.ReadDoubleArray());
                break;
            case 4:
                SetLineStart(buf.ReadDoubleArray());
                break;
            case 5:
                SetLineEnd(buf.ReadDoubleArray());
                break;
            case 6:
                SetPlaneOrigin(buf.ReadDoubleArray());
                break;
            case 7:
                SetPlaneNormal(buf.ReadDoubleArray());
                break;
            case 8:
                SetPlaneUpAxis(buf.ReadDoubleArray());
                break;
            case 9:
                SetPlaneRadius(buf.ReadDouble());
                break;
            case 10:
                SetSphereOrigin(buf.ReadDoubleArray());
                break;
            case 11:
                SetSphereRadius(buf.ReadDouble());
                break;
            case 12:
                SetBoxExtents(buf.ReadDoubleArray());
                break;
            case 13:
                SetPointDensity(buf.ReadInt());
                break;
            case 14:
                SetDisplayMethod(buf.ReadInt());
                break;
            case 15:
                SetShowStart(buf.ReadBool());
                break;
            case 16:
                SetRadius(buf.ReadDouble());
                break;
            case 17:
                SetLineWidth(buf.ReadInt());
                break;
            case 18:
                SetColoringMethod(buf.ReadInt());
                break;
            case 19:
                SetColorTableName(buf.ReadString());
                break;
            case 20:
                singleColor.Read(buf);
                Select(20);
                break;
            case 21:
                SetLegendFlag(buf.ReadBool());
                break;
            case 22:
                SetLightingFlag(buf.ReadBool());
                break;
            }
        }
    }


    // Attributes
    private int            sourceType;
    private double         stepLength;
    private double         maxTime;
    private double[]       pointSource;
    private double[]       lineStart;
    private double[]       lineEnd;
    private double[]       planeOrigin;
    private double[]       planeNormal;
    private double[]       planeUpAxis;
    private double         planeRadius;
    private double[]       sphereOrigin;
    private double         sphereRadius;
    private double[]       boxExtents;
    private int            pointDensity;
    private int            displayMethod;
    private boolean        showStart;
    private double         radius;
    private int            lineWidth;
    private int            coloringMethod;
    private String         colorTableName;
    private ColorAttribute singleColor;
    private boolean        legendFlag;
    private boolean        lightingFlag;
}

