#include <StreamlineAttributes.h>
#include <DataNode.h>
#include <PointAttributes.h>
#include <Line.h>
#include <PlaneAttributes.h>
#include <SphereAttributes.h>
#include <PointAttributes.h>
#include <BoxExtents.h>

//
// Enum conversion methods for StreamlineAttributes::SourceType
//

static const char *SourceType_strings[] = {
"SpecifiedPoint", "SpecifiedLine", "SpecifiedPlane", 
"SpecifiedSphere", "SpecifiedBox"};

std::string
StreamlineAttributes::SourceType_ToString(StreamlineAttributes::SourceType t)
{
    int index = int(t);
    if(index < 0 || index >= 5) index = 0;
    return SourceType_strings[index];
}

std::string
StreamlineAttributes::SourceType_ToString(int t)
{
    int index = (t < 0 || t >= 5) ? 0 : t;
    return SourceType_strings[index];
}

bool
StreamlineAttributes::SourceType_FromString(const std::string &s, StreamlineAttributes::SourceType &val)
{
    val = StreamlineAttributes::SpecifiedPoint;
    for(int i = 0; i < 5; ++i)
    {
        if(s == SourceType_strings[i])
        {
            val = (SourceType)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for StreamlineAttributes::ColoringMethod
//

static const char *ColoringMethod_strings[] = {
"Solid", "ColorBySpeed", "ColorByVorticity"
};

std::string
StreamlineAttributes::ColoringMethod_ToString(StreamlineAttributes::ColoringMethod t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return ColoringMethod_strings[index];
}

std::string
StreamlineAttributes::ColoringMethod_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return ColoringMethod_strings[index];
}

bool
StreamlineAttributes::ColoringMethod_FromString(const std::string &s, StreamlineAttributes::ColoringMethod &val)
{
    val = StreamlineAttributes::Solid;
    for(int i = 0; i < 3; ++i)
    {
        if(s == ColoringMethod_strings[i])
        {
            val = (ColoringMethod)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for StreamlineAttributes::DisplayMethod
//

static const char *DisplayMethod_strings[] = {
"Lines", "Tubes", "Ribbons"
};

std::string
StreamlineAttributes::DisplayMethod_ToString(StreamlineAttributes::DisplayMethod t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return DisplayMethod_strings[index];
}

std::string
StreamlineAttributes::DisplayMethod_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return DisplayMethod_strings[index];
}

bool
StreamlineAttributes::DisplayMethod_FromString(const std::string &s, StreamlineAttributes::DisplayMethod &val)
{
    val = StreamlineAttributes::Lines;
    for(int i = 0; i < 3; ++i)
    {
        if(s == DisplayMethod_strings[i])
        {
            val = (DisplayMethod)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: StreamlineAttributes::StreamlineAttributes
//
// Purpose: 
//   Constructor for the StreamlineAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 22 14:35:08 PST 2004
//
// Modifications:
//   
// ****************************************************************************

StreamlineAttributes::StreamlineAttributes() : AttributeSubject("iddDDDDDDdDdDiibdiisabb"),
    colorTableName("Default"), singleColor(0, 0, 0)
{
    sourceType = SpecifiedPoint;
    stepLength = 1;
    maxTime = 10;
    pointSource[0] = 0;
    pointSource[1] = 0;
    pointSource[2] = 0;
    lineStart[0] = 0;
    lineStart[1] = 0;
    lineStart[2] = 0;
    lineEnd[0] = 1;
    lineEnd[1] = 0;
    lineEnd[2] = 0;
    planeOrigin[0] = 0;
    planeOrigin[1] = 0;
    planeOrigin[2] = 0;
    planeNormal[0] = 0;
    planeNormal[1] = 0;
    planeNormal[2] = 1;
    planeUpAxis[0] = 0;
    planeUpAxis[1] = 1;
    planeUpAxis[2] = 0;
    planeRadius = 1;
    sphereOrigin[0] = 0;
    sphereOrigin[1] = 0;
    sphereOrigin[2] = 0;
    sphereRadius = 1;
    boxExtents[0] = 0;
    boxExtents[1] = 1;
    boxExtents[2] = 0;
    boxExtents[3] = 1;
    boxExtents[4] = 0;
    boxExtents[5] = 1;
    pointDensity = 2;
    displayMethod = Lines;
    showStart = true;
    radius = 0.125;
    lineWidth = 2;
    coloringMethod = ColorBySpeed;
    legendFlag = true;
    lightingFlag = true;
}

// ****************************************************************************
// Method: StreamlineAttributes::StreamlineAttributes
//
// Purpose: 
//   Copy constructor for the StreamlineAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 22 14:35:08 PST 2004
//
// Modifications:
//   
// ****************************************************************************

StreamlineAttributes::StreamlineAttributes(const StreamlineAttributes &obj) : AttributeSubject("iddDDDDDDdDdDiibdiisabb")
{
    int i;

    sourceType = obj.sourceType;
    stepLength = obj.stepLength;
    maxTime = obj.maxTime;
    pointSource[0] = obj.pointSource[0];
    pointSource[1] = obj.pointSource[1];
    pointSource[2] = obj.pointSource[2];

    lineStart[0] = obj.lineStart[0];
    lineStart[1] = obj.lineStart[1];
    lineStart[2] = obj.lineStart[2];

    lineEnd[0] = obj.lineEnd[0];
    lineEnd[1] = obj.lineEnd[1];
    lineEnd[2] = obj.lineEnd[2];

    planeOrigin[0] = obj.planeOrigin[0];
    planeOrigin[1] = obj.planeOrigin[1];
    planeOrigin[2] = obj.planeOrigin[2];

    planeNormal[0] = obj.planeNormal[0];
    planeNormal[1] = obj.planeNormal[1];
    planeNormal[2] = obj.planeNormal[2];

    planeUpAxis[0] = obj.planeUpAxis[0];
    planeUpAxis[1] = obj.planeUpAxis[1];
    planeUpAxis[2] = obj.planeUpAxis[2];

    planeRadius = obj.planeRadius;
    sphereOrigin[0] = obj.sphereOrigin[0];
    sphereOrigin[1] = obj.sphereOrigin[1];
    sphereOrigin[2] = obj.sphereOrigin[2];

    sphereRadius = obj.sphereRadius;
    for(i = 0; i < 6; ++i)
        boxExtents[i] = obj.boxExtents[i];

    pointDensity = obj.pointDensity;
    displayMethod = obj.displayMethod;
    showStart = obj.showStart;
    radius = obj.radius;
    lineWidth = obj.lineWidth;
    coloringMethod = obj.coloringMethod;
    colorTableName = obj.colorTableName;
    singleColor = obj.singleColor;
    legendFlag = obj.legendFlag;
    lightingFlag = obj.lightingFlag;

    SelectAll();
}

// ****************************************************************************
// Method: StreamlineAttributes::~StreamlineAttributes
//
// Purpose: 
//   Destructor for the StreamlineAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 22 14:35:08 PST 2004
//
// Modifications:
//   
// ****************************************************************************

StreamlineAttributes::~StreamlineAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: StreamlineAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the StreamlineAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 22 14:35:08 PST 2004
//
// Modifications:
//   
// ****************************************************************************

StreamlineAttributes& 
StreamlineAttributes::operator = (const StreamlineAttributes &obj)
{
    if (this == &obj) return *this;
    int i;

    sourceType = obj.sourceType;
    stepLength = obj.stepLength;
    maxTime = obj.maxTime;
    pointSource[0] = obj.pointSource[0];
    pointSource[1] = obj.pointSource[1];
    pointSource[2] = obj.pointSource[2];

    lineStart[0] = obj.lineStart[0];
    lineStart[1] = obj.lineStart[1];
    lineStart[2] = obj.lineStart[2];

    lineEnd[0] = obj.lineEnd[0];
    lineEnd[1] = obj.lineEnd[1];
    lineEnd[2] = obj.lineEnd[2];

    planeOrigin[0] = obj.planeOrigin[0];
    planeOrigin[1] = obj.planeOrigin[1];
    planeOrigin[2] = obj.planeOrigin[2];

    planeNormal[0] = obj.planeNormal[0];
    planeNormal[1] = obj.planeNormal[1];
    planeNormal[2] = obj.planeNormal[2];

    planeUpAxis[0] = obj.planeUpAxis[0];
    planeUpAxis[1] = obj.planeUpAxis[1];
    planeUpAxis[2] = obj.planeUpAxis[2];

    planeRadius = obj.planeRadius;
    sphereOrigin[0] = obj.sphereOrigin[0];
    sphereOrigin[1] = obj.sphereOrigin[1];
    sphereOrigin[2] = obj.sphereOrigin[2];

    sphereRadius = obj.sphereRadius;
    for(i = 0; i < 6; ++i)
        boxExtents[i] = obj.boxExtents[i];

    pointDensity = obj.pointDensity;
    displayMethod = obj.displayMethod;
    showStart = obj.showStart;
    radius = obj.radius;
    lineWidth = obj.lineWidth;
    coloringMethod = obj.coloringMethod;
    colorTableName = obj.colorTableName;
    singleColor = obj.singleColor;
    legendFlag = obj.legendFlag;
    lightingFlag = obj.lightingFlag;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: StreamlineAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the StreamlineAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 22 14:35:08 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
StreamlineAttributes::operator == (const StreamlineAttributes &obj) const
{
    int i;

    // Compare the pointSource arrays.
    bool pointSource_equal = true;
    for(i = 0; i < 3 && pointSource_equal; ++i)
        pointSource_equal = (pointSource[i] == obj.pointSource[i]);

    // Compare the lineStart arrays.
    bool lineStart_equal = true;
    for(i = 0; i < 3 && lineStart_equal; ++i)
        lineStart_equal = (lineStart[i] == obj.lineStart[i]);

    // Compare the lineEnd arrays.
    bool lineEnd_equal = true;
    for(i = 0; i < 3 && lineEnd_equal; ++i)
        lineEnd_equal = (lineEnd[i] == obj.lineEnd[i]);

    // Compare the planeOrigin arrays.
    bool planeOrigin_equal = true;
    for(i = 0; i < 3 && planeOrigin_equal; ++i)
        planeOrigin_equal = (planeOrigin[i] == obj.planeOrigin[i]);

    // Compare the planeNormal arrays.
    bool planeNormal_equal = true;
    for(i = 0; i < 3 && planeNormal_equal; ++i)
        planeNormal_equal = (planeNormal[i] == obj.planeNormal[i]);

    // Compare the planeUpAxis arrays.
    bool planeUpAxis_equal = true;
    for(i = 0; i < 3 && planeUpAxis_equal; ++i)
        planeUpAxis_equal = (planeUpAxis[i] == obj.planeUpAxis[i]);

    // Compare the sphereOrigin arrays.
    bool sphereOrigin_equal = true;
    for(i = 0; i < 3 && sphereOrigin_equal; ++i)
        sphereOrigin_equal = (sphereOrigin[i] == obj.sphereOrigin[i]);

    // Compare the boxExtents arrays.
    bool boxExtents_equal = true;
    for(i = 0; i < 6 && boxExtents_equal; ++i)
        boxExtents_equal = (boxExtents[i] == obj.boxExtents[i]);

    // Create the return value
    return ((sourceType == obj.sourceType) &&
            (stepLength == obj.stepLength) &&
            (maxTime == obj.maxTime) &&
            pointSource_equal &&
            lineStart_equal &&
            lineEnd_equal &&
            planeOrigin_equal &&
            planeNormal_equal &&
            planeUpAxis_equal &&
            (planeRadius == obj.planeRadius) &&
            sphereOrigin_equal &&
            (sphereRadius == obj.sphereRadius) &&
            boxExtents_equal &&
            (pointDensity == obj.pointDensity) &&
            (displayMethod == obj.displayMethod) &&
            (showStart == obj.showStart) &&
            (radius == obj.radius) &&
            (lineWidth == obj.lineWidth) &&
            (coloringMethod == obj.coloringMethod) &&
            (colorTableName == obj.colorTableName) &&
            (singleColor == obj.singleColor) &&
            (legendFlag == obj.legendFlag) &&
            (lightingFlag == obj.lightingFlag));
}

// ****************************************************************************
// Method: StreamlineAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the StreamlineAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 22 14:35:08 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
StreamlineAttributes::operator != (const StreamlineAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: StreamlineAttributes::TypeName
//
// Purpose: 
//   Type name method for the StreamlineAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 22 14:35:08 PST 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
StreamlineAttributes::TypeName() const
{
    return "StreamlineAttributes";
}

// ****************************************************************************
// Method: StreamlineAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the StreamlineAttributes class.
//
// Programmer: Brad Whitlock
// Creation:   Fri Oct 4 15:22:57 PST 2002
//
// Modifications:
//    Brad Whitlock, Wed Dec 22 12:57:53 PDT 2004
//    I added code to support the point tool.
//
// ****************************************************************************

bool
StreamlineAttributes::CopyAttributes(const AttributeGroup *atts)
{
    bool retval = false;

    if(TypeName() == atts->TypeName())
    {
        // Call assignment operator.
        const StreamlineAttributes *tmp = (const StreamlineAttributes *)atts;
        *this = *tmp;
        retval = true;
    }
    else if(atts->TypeName() == "PointAttributes")
    {
        if(sourceType == SpecifiedPoint)
        {
            const PointAttributes *p = (PointAttributes *)atts;
            SetPointSource(p->GetPoint());
            retval = true;
        }
    } 
    else if(atts->TypeName() == "Line")
    {
        if(sourceType == SpecifiedLine)
        {
            const Line *line = (const Line *)atts;
            SetLineStart(line->GetPoint1());
            SetLineEnd(line->GetPoint2());
            retval = true;
        }
    }
    else if(atts->TypeName() == "PlaneAttributes")
    {
        if(sourceType == SpecifiedPlane)
        {
            const PlaneAttributes *plane = (const PlaneAttributes *)atts;
            SetPlaneOrigin(plane->GetOrigin());
            SetPlaneNormal(plane->GetNormal());
            SetPlaneUpAxis(plane->GetUpAxis());
            SetPlaneRadius(plane->GetRadius());
            retval = true;
        }
    }
    else if(atts->TypeName() == "SphereAttributes")
    {
        if(sourceType == SpecifiedSphere)
        {
            const SphereAttributes *sphere = (const SphereAttributes *)atts;
            SetSphereOrigin(sphere->GetOrigin());
            SetSphereRadius(sphere->GetRadius());
            retval = true;
        }
    }   
    else if(atts->TypeName() == "BoxExtents")
    {
        if(sourceType == SpecifiedBox)
        {
            const BoxExtents *box = (const BoxExtents *)atts;
            SetBoxExtents(box->GetExtents());
            retval = true;
        }
    }

    return retval;
}

// ****************************************************************************
//  Method: StreamlineAttributes::CreateCompatible
//
//  Purpose:
//     Creates a new state object of the desired type.
//
//  Programmer: Brad Whitlock
//  Creation:   Fri Oct 4 15:22:57 PST 2002
//
//  Modifications:
//    Brad Whitlock, Tue Jan 21 12:33:04 PDT 2003
//    I added code to set the "have radius" flag to true so the plane tool
//    resizes properly when resizing the plane radius.
//
//    Brad Whitlock, Wed Dec 22 12:54:43 PDT 2004
//    I added code to support the point tool.
//
// ****************************************************************************

AttributeSubject *
StreamlineAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;

    if(TypeName() == tname)
    {
        retval = new StreamlineAttributes(*this);
    }
    else if(tname == "PointAttributes")
    {
        PointAttributes *p = new PointAttributes;
        p->SetPoint(GetPointSource());
        retval = p;
    }
    else if(tname == "Line")
    {
        Line *l = new Line;
        l->SetPoint1(GetLineStart());
        l->SetPoint2(GetLineEnd());
        retval = l;
    }
    else if(tname == "PlaneAttributes")
    {
        PlaneAttributes *p = new PlaneAttributes;
        p->SetOrigin(GetPlaneOrigin());
        p->SetNormal(GetPlaneNormal());
        p->SetUpAxis(GetPlaneUpAxis());
        p->SetRadius(GetPlaneRadius());
        p->SetHaveRadius(true);
        retval = p;
    }
    else if(tname == "SphereAttributes")
    {
        SphereAttributes *s = new SphereAttributes;
        s->SetOrigin(GetSphereOrigin());
        s->SetRadius(GetSphereRadius());
        retval = s;
    }
    else if(tname == "BoxExtents")
    {
        BoxExtents *b = new BoxExtents;
        b->SetExtents(GetBoxExtents());
        retval = b;
    }

    return retval;
}

// ****************************************************************************
// Method: StreamlineAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the StreamlineAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 22 14:35:08 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
StreamlineAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new StreamlineAttributes(*this);
    else
        retval = new StreamlineAttributes;

    return retval;
}

// ****************************************************************************
// Method: StreamlineAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 22 14:35:08 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
StreamlineAttributes::SelectAll()
{
    Select(0, (void *)&sourceType);
    Select(1, (void *)&stepLength);
    Select(2, (void *)&maxTime);
    Select(3, (void *)pointSource, 3);
    Select(4, (void *)lineStart, 3);
    Select(5, (void *)lineEnd, 3);
    Select(6, (void *)planeOrigin, 3);
    Select(7, (void *)planeNormal, 3);
    Select(8, (void *)planeUpAxis, 3);
    Select(9, (void *)&planeRadius);
    Select(10, (void *)sphereOrigin, 3);
    Select(11, (void *)&sphereRadius);
    Select(12, (void *)boxExtents, 6);
    Select(13, (void *)&pointDensity);
    Select(14, (void *)&displayMethod);
    Select(15, (void *)&showStart);
    Select(16, (void *)&radius);
    Select(17, (void *)&lineWidth);
    Select(18, (void *)&coloringMethod);
    Select(19, (void *)&colorTableName);
    Select(20, (void *)&singleColor);
    Select(21, (void *)&legendFlag);
    Select(22, (void *)&lightingFlag);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: StreamlineAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 22 14:35:08 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
StreamlineAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    StreamlineAttributes defaultObject;
    bool addToParent = false;
    // Create a node for StreamlineAttributes.
    DataNode *node = new DataNode("StreamlineAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("sourceType", SourceType_ToString(sourceType)));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("stepLength", stepLength));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxTime", maxTime));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("pointSource", pointSource, 3));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineStart", lineStart, 3));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineEnd", lineEnd, 3));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("planeOrigin", planeOrigin, 3));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("planeNormal", planeNormal, 3));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("planeUpAxis", planeUpAxis, 3));
    }

    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("planeRadius", planeRadius));
    }

    if(completeSave || !FieldsEqual(10, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("sphereOrigin", sphereOrigin, 3));
    }

    if(completeSave || !FieldsEqual(11, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("sphereRadius", sphereRadius));
    }

    if(completeSave || !FieldsEqual(12, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("boxExtents", boxExtents, 6));
    }

    if(completeSave || !FieldsEqual(13, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("pointDensity", pointDensity));
    }

    if(completeSave || !FieldsEqual(14, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("displayMethod", DisplayMethod_ToString(displayMethod)));
    }

    if(completeSave || !FieldsEqual(15, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showStart", showStart));
    }

    if(completeSave || !FieldsEqual(16, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("radius", radius));
    }

    if(completeSave || !FieldsEqual(17, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineWidth", lineWidth));
    }

    if(completeSave || !FieldsEqual(18, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("coloringMethod", ColoringMethod_ToString(coloringMethod)));
    }

    if(completeSave || !FieldsEqual(19, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("colorTableName", colorTableName));
    }

        DataNode *singleColorNode = new DataNode("singleColor");
        if(singleColor.CreateNode(singleColorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(singleColorNode);
        }
        else
            delete singleColorNode;
    if(completeSave || !FieldsEqual(21, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("legendFlag", legendFlag));
    }

    if(completeSave || !FieldsEqual(22, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lightingFlag", lightingFlag));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: StreamlineAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 22 14:35:08 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
StreamlineAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("StreamlineAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("sourceType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 5)
                SetSourceType(SourceType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            SourceType value;
            if(SourceType_FromString(node->AsString(), value))
                SetSourceType(value);
        }
    }
    if((node = searchNode->GetNode("stepLength")) != 0)
        SetStepLength(node->AsDouble());
    if((node = searchNode->GetNode("maxTime")) != 0)
        SetMaxTime(node->AsDouble());
    if((node = searchNode->GetNode("pointSource")) != 0)
        SetPointSource(node->AsDoubleArray());
    if((node = searchNode->GetNode("lineStart")) != 0)
        SetLineStart(node->AsDoubleArray());
    if((node = searchNode->GetNode("lineEnd")) != 0)
        SetLineEnd(node->AsDoubleArray());
    if((node = searchNode->GetNode("planeOrigin")) != 0)
        SetPlaneOrigin(node->AsDoubleArray());
    if((node = searchNode->GetNode("planeNormal")) != 0)
        SetPlaneNormal(node->AsDoubleArray());
    if((node = searchNode->GetNode("planeUpAxis")) != 0)
        SetPlaneUpAxis(node->AsDoubleArray());
    if((node = searchNode->GetNode("planeRadius")) != 0)
        SetPlaneRadius(node->AsDouble());
    if((node = searchNode->GetNode("sphereOrigin")) != 0)
        SetSphereOrigin(node->AsDoubleArray());
    if((node = searchNode->GetNode("sphereRadius")) != 0)
        SetSphereRadius(node->AsDouble());
    if((node = searchNode->GetNode("boxExtents")) != 0)
        SetBoxExtents(node->AsDoubleArray());
    if((node = searchNode->GetNode("pointDensity")) != 0)
        SetPointDensity(node->AsInt());
    if((node = searchNode->GetNode("displayMethod")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetDisplayMethod(DisplayMethod(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            DisplayMethod value;
            if(DisplayMethod_FromString(node->AsString(), value))
                SetDisplayMethod(value);
        }
    }
    if((node = searchNode->GetNode("showStart")) != 0)
        SetShowStart(node->AsBool());
    if((node = searchNode->GetNode("radius")) != 0)
        SetRadius(node->AsDouble());
    if((node = searchNode->GetNode("lineWidth")) != 0)
        SetLineWidth(node->AsInt());
    if((node = searchNode->GetNode("coloringMethod")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetColoringMethod(ColoringMethod(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            ColoringMethod value;
            if(ColoringMethod_FromString(node->AsString(), value))
                SetColoringMethod(value);
        }
    }
    if((node = searchNode->GetNode("colorTableName")) != 0)
        SetColorTableName(node->AsString());
    if((node = searchNode->GetNode("singleColor")) != 0)
        singleColor.SetFromNode(node);
    if((node = searchNode->GetNode("legendFlag")) != 0)
        SetLegendFlag(node->AsBool());
    if((node = searchNode->GetNode("lightingFlag")) != 0)
        SetLightingFlag(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
StreamlineAttributes::SetSourceType(StreamlineAttributes::SourceType sourceType_)
{
    sourceType = sourceType_;
    Select(0, (void *)&sourceType);
}

void
StreamlineAttributes::SetStepLength(double stepLength_)
{
    stepLength = stepLength_;
    Select(1, (void *)&stepLength);
}

void
StreamlineAttributes::SetMaxTime(double maxTime_)
{
    maxTime = maxTime_;
    Select(2, (void *)&maxTime);
}

void
StreamlineAttributes::SetPointSource(const double *pointSource_)
{
    pointSource[0] = pointSource_[0];
    pointSource[1] = pointSource_[1];
    pointSource[2] = pointSource_[2];
    Select(3, (void *)pointSource, 3);
}

void
StreamlineAttributes::SetLineStart(const double *lineStart_)
{
    lineStart[0] = lineStart_[0];
    lineStart[1] = lineStart_[1];
    lineStart[2] = lineStart_[2];
    Select(4, (void *)lineStart, 3);
}

void
StreamlineAttributes::SetLineEnd(const double *lineEnd_)
{
    lineEnd[0] = lineEnd_[0];
    lineEnd[1] = lineEnd_[1];
    lineEnd[2] = lineEnd_[2];
    Select(5, (void *)lineEnd, 3);
}

void
StreamlineAttributes::SetPlaneOrigin(const double *planeOrigin_)
{
    planeOrigin[0] = planeOrigin_[0];
    planeOrigin[1] = planeOrigin_[1];
    planeOrigin[2] = planeOrigin_[2];
    Select(6, (void *)planeOrigin, 3);
}

void
StreamlineAttributes::SetPlaneNormal(const double *planeNormal_)
{
    planeNormal[0] = planeNormal_[0];
    planeNormal[1] = planeNormal_[1];
    planeNormal[2] = planeNormal_[2];
    Select(7, (void *)planeNormal, 3);
}

void
StreamlineAttributes::SetPlaneUpAxis(const double *planeUpAxis_)
{
    planeUpAxis[0] = planeUpAxis_[0];
    planeUpAxis[1] = planeUpAxis_[1];
    planeUpAxis[2] = planeUpAxis_[2];
    Select(8, (void *)planeUpAxis, 3);
}

void
StreamlineAttributes::SetPlaneRadius(double planeRadius_)
{
    planeRadius = planeRadius_;
    Select(9, (void *)&planeRadius);
}

void
StreamlineAttributes::SetSphereOrigin(const double *sphereOrigin_)
{
    sphereOrigin[0] = sphereOrigin_[0];
    sphereOrigin[1] = sphereOrigin_[1];
    sphereOrigin[2] = sphereOrigin_[2];
    Select(10, (void *)sphereOrigin, 3);
}

void
StreamlineAttributes::SetSphereRadius(double sphereRadius_)
{
    sphereRadius = sphereRadius_;
    Select(11, (void *)&sphereRadius);
}

void
StreamlineAttributes::SetBoxExtents(const double *boxExtents_)
{
    for(int i = 0; i < 6; ++i)
        boxExtents[i] = boxExtents_[i];
    Select(12, (void *)boxExtents, 6);
}

void
StreamlineAttributes::SetPointDensity(int pointDensity_)
{
    pointDensity = pointDensity_;
    Select(13, (void *)&pointDensity);
}

void
StreamlineAttributes::SetDisplayMethod(StreamlineAttributes::DisplayMethod displayMethod_)
{
    displayMethod = displayMethod_;
    Select(14, (void *)&displayMethod);
}

void
StreamlineAttributes::SetShowStart(bool showStart_)
{
    showStart = showStart_;
    Select(15, (void *)&showStart);
}

void
StreamlineAttributes::SetRadius(double radius_)
{
    radius = radius_;
    Select(16, (void *)&radius);
}

void
StreamlineAttributes::SetLineWidth(int lineWidth_)
{
    lineWidth = lineWidth_;
    Select(17, (void *)&lineWidth);
}

void
StreamlineAttributes::SetColoringMethod(StreamlineAttributes::ColoringMethod coloringMethod_)
{
    coloringMethod = coloringMethod_;
    Select(18, (void *)&coloringMethod);
}

void
StreamlineAttributes::SetColorTableName(const std::string &colorTableName_)
{
    colorTableName = colorTableName_;
    Select(19, (void *)&colorTableName);
}

void
StreamlineAttributes::SetSingleColor(const ColorAttribute &singleColor_)
{
    singleColor = singleColor_;
    Select(20, (void *)&singleColor);
}

void
StreamlineAttributes::SetLegendFlag(bool legendFlag_)
{
    legendFlag = legendFlag_;
    Select(21, (void *)&legendFlag);
}

void
StreamlineAttributes::SetLightingFlag(bool lightingFlag_)
{
    lightingFlag = lightingFlag_;
    Select(22, (void *)&lightingFlag);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

StreamlineAttributes::SourceType
StreamlineAttributes::GetSourceType() const
{
    return SourceType(sourceType);
}

double
StreamlineAttributes::GetStepLength() const
{
    return stepLength;
}

double
StreamlineAttributes::GetMaxTime() const
{
    return maxTime;
}

const double *
StreamlineAttributes::GetPointSource() const
{
    return pointSource;
}

double *
StreamlineAttributes::GetPointSource()
{
    return pointSource;
}

const double *
StreamlineAttributes::GetLineStart() const
{
    return lineStart;
}

double *
StreamlineAttributes::GetLineStart()
{
    return lineStart;
}

const double *
StreamlineAttributes::GetLineEnd() const
{
    return lineEnd;
}

double *
StreamlineAttributes::GetLineEnd()
{
    return lineEnd;
}

const double *
StreamlineAttributes::GetPlaneOrigin() const
{
    return planeOrigin;
}

double *
StreamlineAttributes::GetPlaneOrigin()
{
    return planeOrigin;
}

const double *
StreamlineAttributes::GetPlaneNormal() const
{
    return planeNormal;
}

double *
StreamlineAttributes::GetPlaneNormal()
{
    return planeNormal;
}

const double *
StreamlineAttributes::GetPlaneUpAxis() const
{
    return planeUpAxis;
}

double *
StreamlineAttributes::GetPlaneUpAxis()
{
    return planeUpAxis;
}

double
StreamlineAttributes::GetPlaneRadius() const
{
    return planeRadius;
}

const double *
StreamlineAttributes::GetSphereOrigin() const
{
    return sphereOrigin;
}

double *
StreamlineAttributes::GetSphereOrigin()
{
    return sphereOrigin;
}

double
StreamlineAttributes::GetSphereRadius() const
{
    return sphereRadius;
}

const double *
StreamlineAttributes::GetBoxExtents() const
{
    return boxExtents;
}

double *
StreamlineAttributes::GetBoxExtents()
{
    return boxExtents;
}

int
StreamlineAttributes::GetPointDensity() const
{
    return pointDensity;
}

StreamlineAttributes::DisplayMethod
StreamlineAttributes::GetDisplayMethod() const
{
    return DisplayMethod(displayMethod);
}

bool
StreamlineAttributes::GetShowStart() const
{
    return showStart;
}

double
StreamlineAttributes::GetRadius() const
{
    return radius;
}

int
StreamlineAttributes::GetLineWidth() const
{
    return lineWidth;
}

StreamlineAttributes::ColoringMethod
StreamlineAttributes::GetColoringMethod() const
{
    return ColoringMethod(coloringMethod);
}

const std::string &
StreamlineAttributes::GetColorTableName() const
{
    return colorTableName;
}

std::string &
StreamlineAttributes::GetColorTableName()
{
    return colorTableName;
}

const ColorAttribute &
StreamlineAttributes::GetSingleColor() const
{
    return singleColor;
}

ColorAttribute &
StreamlineAttributes::GetSingleColor()
{
    return singleColor;
}

bool
StreamlineAttributes::GetLegendFlag() const
{
    return legendFlag;
}

bool
StreamlineAttributes::GetLightingFlag() const
{
    return lightingFlag;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
StreamlineAttributes::SelectPointSource()
{
    Select(3, (void *)pointSource, 3);
}

void
StreamlineAttributes::SelectLineStart()
{
    Select(4, (void *)lineStart, 3);
}

void
StreamlineAttributes::SelectLineEnd()
{
    Select(5, (void *)lineEnd, 3);
}

void
StreamlineAttributes::SelectPlaneOrigin()
{
    Select(6, (void *)planeOrigin, 3);
}

void
StreamlineAttributes::SelectPlaneNormal()
{
    Select(7, (void *)planeNormal, 3);
}

void
StreamlineAttributes::SelectPlaneUpAxis()
{
    Select(8, (void *)planeUpAxis, 3);
}

void
StreamlineAttributes::SelectSphereOrigin()
{
    Select(10, (void *)sphereOrigin, 3);
}

void
StreamlineAttributes::SelectBoxExtents()
{
    Select(12, (void *)boxExtents, 6);
}

void
StreamlineAttributes::SelectColorTableName()
{
    Select(19, (void *)&colorTableName);
}

void
StreamlineAttributes::SelectSingleColor()
{
    Select(20, (void *)&singleColor);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: StreamlineAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 22 14:35:08 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
StreamlineAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Source";
        case 1:  return "Step length";
        case 2:  return "Maximum time";
        case 3:  return "Starting point";
        case 4:  return "Line start";
        case 5:  return "Line end";
        case 6:  return "Plane origin";
        case 7:  return "Plane normal";
        case 8:  return "Plane up axis";
        case 9:  return "Plane radius";
        case 10:  return "Sphere origin";
        case 11:  return "Sphere radius";
        case 12:  return "Box extents";
        case 13:  return "Point density";
        case 14:  return "Display method";
        case 15:  return "Show tube start";
        case 16:  return "Radius";
        case 17:  return "Line width";
        case 18:  return "Coloring method";
        case 19:  return "Color table";
        case 20:  return "Single color";
        case 21:  return "Legend";
        case 22:  return "Lighting";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: StreamlineAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 22 14:35:08 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
StreamlineAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_enum;
        case 1:  return FieldType_double;
        case 2:  return FieldType_double;
        case 3:  return FieldType_doubleArray;
        case 4:  return FieldType_doubleArray;
        case 5:  return FieldType_doubleArray;
        case 6:  return FieldType_doubleArray;
        case 7:  return FieldType_doubleArray;
        case 8:  return FieldType_doubleArray;
        case 9:  return FieldType_double;
        case 10:  return FieldType_doubleArray;
        case 11:  return FieldType_double;
        case 12:  return FieldType_doubleArray;
        case 13:  return FieldType_int;
        case 14:  return FieldType_enum;
        case 15:  return FieldType_bool;
        case 16:  return FieldType_double;
        case 17:  return FieldType_linewidth;
        case 18:  return FieldType_enum;
        case 19:  return FieldType_colortable;
        case 20:  return FieldType_color;
        case 21:  return FieldType_bool;
        case 22:  return FieldType_bool;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: StreamlineAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 22 14:35:08 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
StreamlineAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "enum";
        case 1:  return "double";
        case 2:  return "double";
        case 3:  return "doubleArray";
        case 4:  return "doubleArray";
        case 5:  return "doubleArray";
        case 6:  return "doubleArray";
        case 7:  return "doubleArray";
        case 8:  return "doubleArray";
        case 9:  return "double";
        case 10:  return "doubleArray";
        case 11:  return "double";
        case 12:  return "doubleArray";
        case 13:  return "int";
        case 14:  return "enum";
        case 15:  return "bool";
        case 16:  return "double";
        case 17:  return "linewidth";
        case 18:  return "enum";
        case 19:  return "colortable";
        case 20:  return "color";
        case 21:  return "bool";
        case 22:  return "bool";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: StreamlineAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 22 14:35:08 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
StreamlineAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    int i;

    const StreamlineAttributes &obj = *((const StreamlineAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (sourceType == obj.sourceType);
        }
        break;
    case 1:
        {  // new scope
        retval = (stepLength == obj.stepLength);
        }
        break;
    case 2:
        {  // new scope
        retval = (maxTime == obj.maxTime);
        }
        break;
    case 3:
        {  // new scope
        // Compare the pointSource arrays.
        bool pointSource_equal = true;
        for(i = 0; i < 3 && pointSource_equal; ++i)
            pointSource_equal = (pointSource[i] == obj.pointSource[i]);

        retval = pointSource_equal;
        }
        break;
    case 4:
        {  // new scope
        // Compare the lineStart arrays.
        bool lineStart_equal = true;
        for(i = 0; i < 3 && lineStart_equal; ++i)
            lineStart_equal = (lineStart[i] == obj.lineStart[i]);

        retval = lineStart_equal;
        }
        break;
    case 5:
        {  // new scope
        // Compare the lineEnd arrays.
        bool lineEnd_equal = true;
        for(i = 0; i < 3 && lineEnd_equal; ++i)
            lineEnd_equal = (lineEnd[i] == obj.lineEnd[i]);

        retval = lineEnd_equal;
        }
        break;
    case 6:
        {  // new scope
        // Compare the planeOrigin arrays.
        bool planeOrigin_equal = true;
        for(i = 0; i < 3 && planeOrigin_equal; ++i)
            planeOrigin_equal = (planeOrigin[i] == obj.planeOrigin[i]);

        retval = planeOrigin_equal;
        }
        break;
    case 7:
        {  // new scope
        // Compare the planeNormal arrays.
        bool planeNormal_equal = true;
        for(i = 0; i < 3 && planeNormal_equal; ++i)
            planeNormal_equal = (planeNormal[i] == obj.planeNormal[i]);

        retval = planeNormal_equal;
        }
        break;
    case 8:
        {  // new scope
        // Compare the planeUpAxis arrays.
        bool planeUpAxis_equal = true;
        for(i = 0; i < 3 && planeUpAxis_equal; ++i)
            planeUpAxis_equal = (planeUpAxis[i] == obj.planeUpAxis[i]);

        retval = planeUpAxis_equal;
        }
        break;
    case 9:
        {  // new scope
        retval = (planeRadius == obj.planeRadius);
        }
        break;
    case 10:
        {  // new scope
        // Compare the sphereOrigin arrays.
        bool sphereOrigin_equal = true;
        for(i = 0; i < 3 && sphereOrigin_equal; ++i)
            sphereOrigin_equal = (sphereOrigin[i] == obj.sphereOrigin[i]);

        retval = sphereOrigin_equal;
        }
        break;
    case 11:
        {  // new scope
        retval = (sphereRadius == obj.sphereRadius);
        }
        break;
    case 12:
        {  // new scope
        // Compare the boxExtents arrays.
        bool boxExtents_equal = true;
        for(i = 0; i < 6 && boxExtents_equal; ++i)
            boxExtents_equal = (boxExtents[i] == obj.boxExtents[i]);

        retval = boxExtents_equal;
        }
        break;
    case 13:
        {  // new scope
        retval = (pointDensity == obj.pointDensity);
        }
        break;
    case 14:
        {  // new scope
        retval = (displayMethod == obj.displayMethod);
        }
        break;
    case 15:
        {  // new scope
        retval = (showStart == obj.showStart);
        }
        break;
    case 16:
        {  // new scope
        retval = (radius == obj.radius);
        }
        break;
    case 17:
        {  // new scope
        retval = (lineWidth == obj.lineWidth);
        }
        break;
    case 18:
        {  // new scope
        retval = (coloringMethod == obj.coloringMethod);
        }
        break;
    case 19:
        {  // new scope
        retval = (colorTableName == obj.colorTableName);
        }
        break;
    case 20:
        {  // new scope
        retval = (singleColor == obj.singleColor);
        }
        break;
    case 21:
        {  // new scope
        retval = (legendFlag == obj.legendFlag);
        }
        break;
    case 22:
        {  // new scope
        retval = (lightingFlag == obj.lightingFlag);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
//  Method: StreamlineAttributes::ChangesRequireRecalculation
//
//  Purpose:
//     Determines whether or not the plot must be recalculated based on the
//     new attributes.
//
//  Programmer: Brad Whitlock
//  Creation:   Fri Oct 4 15:22:57 PST 2002
//
//  Notes:  Most attributes cause the streamline to change.
//
//  Modifications:
//    Brad Whitlock, Wed Dec 22 12:52:45 PDT 2004
//    I made the coloring method matter when comparing streamline attributes
//    and I added support for ribbons.
//
// ****************************************************************************

#define PDIF(p1,p2,i) ((p1)[i] != (p2)[i])
#define POINT_DIFFERS(p1,p2) (PDIF(p1,p2,0) || PDIF(p1,p2,1) || PDIF(p1,p2,2))

bool
StreamlineAttributes::ChangesRequireRecalculation(const StreamlineAttributes &obj) const
{
    // If we're in point source mode and the points differ, sourcePointsDiffer
    // evaluates to true.
    bool sourcePointsDiffer = ((sourceType == SpecifiedPoint) &&
       POINT_DIFFERS(pointSource, obj.pointSource));

    // If we're in line source mode and the line differs, sourceLineDiffers
    // evaluates to true.
    bool sourceLineDiffers = ((sourceType == SpecifiedLine) &&
       (POINT_DIFFERS(lineStart, obj.lineStart) ||
        POINT_DIFFERS(lineEnd, obj.lineEnd)));

    // If we're in plane source mode and the plane differs, sourcePlaneDiffers
    // evaluates to true.
    bool sourcePlaneDiffers = ((sourceType == SpecifiedPlane) &&
       (POINT_DIFFERS(planeOrigin, obj.planeOrigin) ||
        POINT_DIFFERS(planeNormal, obj.planeNormal) ||
        POINT_DIFFERS(planeUpAxis, obj.planeUpAxis) ||
        planeRadius != obj.planeRadius));

    // If we're in sphere source mode and the sphere differs, sourceSphereDiffers
    // evaluates to true.
    bool sourceSphereDiffers = ((sourceType == SpecifiedSphere) &&
       (POINT_DIFFERS(sphereOrigin, obj.sphereOrigin) ||
        (sphereRadius != obj.sphereRadius)));

    // If we're in box source mode and the box differs, boxSourceDiffers
    // evaluates to true.
    bool boxSourceDiffers = (sourceType == SpecifiedBox) &&
        (POINT_DIFFERS(boxExtents, obj.boxExtents) ||
         POINT_DIFFERS(boxExtents+3, obj.boxExtents+3));

    // Other things need to be true before we start paying attention to
    // point density.
    bool densityMatters = (sourceType == SpecifiedLine ||
        sourceType == SpecifiedPlane || sourceType == SpecifiedSphere ||
        sourceType == SpecifiedBox) &&
        (pointDensity != obj.pointDensity);

    bool radiusMatters = (displayMethod != Lines) && (radius != obj.radius);

    return (sourceType != obj.sourceType) ||
           (displayMethod != obj.displayMethod) ||
           (showStart != obj.showStart) ||
           (maxTime != obj.maxTime) ||
           (stepLength != obj.stepLength) ||
           (coloringMethod != obj.coloringMethod && obj.coloringMethod != Solid) ||
           sourcePointsDiffer ||
           sourceLineDiffers ||
           sourcePlaneDiffers ||
           sourceSphereDiffers ||
           boxSourceDiffers ||
           densityMatters ||
           radiusMatters;
}

