#include <PyStreamlineAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyStreamlineAttributes
//
// Purpose: 
//   Attributes for the Streamline plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Wed Dec 22 14:35:20 PST 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a StreamlineAttributes.
//
struct StreamlineAttributesObject
{
    PyObject_HEAD
    StreamlineAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewStreamlineAttributes();

static PyObject *
StreamlineAttributes_Notify(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_SetSourceType(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sourceType in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetSourceType(StreamlineAttributes::SourceType(ival));
    else
    {
        fprintf(stderr, "An invalid sourceType value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "SpecifiedPoint, SpecifiedLine, SpecifiedPlane, SpecifiedSphere, SpecifiedBox.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_GetSourceType(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSourceType()));
    return retval;
}

static PyObject *
StreamlineAttributes_SetStepLength(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the stepLength in the object.
    obj->data->SetStepLength(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_GetStepLength(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetStepLength());
    return retval;
}

static PyObject *
StreamlineAttributes_SetMaxTime(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the maxTime in the object.
    obj->data->SetMaxTime(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_GetMaxTime(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMaxTime());
    return retval;
}

static PyObject *
StreamlineAttributes_SetPointSource(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double *dvals = obj->data->GetPointSource();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the pointSource in the object as modified.
    obj->data->SelectPointSource();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_GetPointSource(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the pointSource.
    PyObject *retval = PyTuple_New(3);
    const double *pointSource = obj->data->GetPointSource();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(pointSource[i]));
    return retval;
}

static PyObject *
StreamlineAttributes_SetLineStart(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double *dvals = obj->data->GetLineStart();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the lineStart in the object as modified.
    obj->data->SelectLineStart();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_GetLineStart(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the lineStart.
    PyObject *retval = PyTuple_New(3);
    const double *lineStart = obj->data->GetLineStart();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(lineStart[i]));
    return retval;
}

static PyObject *
StreamlineAttributes_SetLineEnd(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double *dvals = obj->data->GetLineEnd();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the lineEnd in the object as modified.
    obj->data->SelectLineEnd();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_GetLineEnd(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the lineEnd.
    PyObject *retval = PyTuple_New(3);
    const double *lineEnd = obj->data->GetLineEnd();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(lineEnd[i]));
    return retval;
}

static PyObject *
StreamlineAttributes_SetPlaneOrigin(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double *dvals = obj->data->GetPlaneOrigin();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the planeOrigin in the object as modified.
    obj->data->SelectPlaneOrigin();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_GetPlaneOrigin(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the planeOrigin.
    PyObject *retval = PyTuple_New(3);
    const double *planeOrigin = obj->data->GetPlaneOrigin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(planeOrigin[i]));
    return retval;
}

static PyObject *
StreamlineAttributes_SetPlaneNormal(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double *dvals = obj->data->GetPlaneNormal();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the planeNormal in the object as modified.
    obj->data->SelectPlaneNormal();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_GetPlaneNormal(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the planeNormal.
    PyObject *retval = PyTuple_New(3);
    const double *planeNormal = obj->data->GetPlaneNormal();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(planeNormal[i]));
    return retval;
}

static PyObject *
StreamlineAttributes_SetPlaneUpAxis(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double *dvals = obj->data->GetPlaneUpAxis();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the planeUpAxis in the object as modified.
    obj->data->SelectPlaneUpAxis();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_GetPlaneUpAxis(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the planeUpAxis.
    PyObject *retval = PyTuple_New(3);
    const double *planeUpAxis = obj->data->GetPlaneUpAxis();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(planeUpAxis[i]));
    return retval;
}

static PyObject *
StreamlineAttributes_SetPlaneRadius(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the planeRadius in the object.
    obj->data->SetPlaneRadius(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_GetPlaneRadius(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPlaneRadius());
    return retval;
}

static PyObject *
StreamlineAttributes_SetSphereOrigin(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double *dvals = obj->data->GetSphereOrigin();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the sphereOrigin in the object as modified.
    obj->data->SelectSphereOrigin();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_GetSphereOrigin(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the sphereOrigin.
    PyObject *retval = PyTuple_New(3);
    const double *sphereOrigin = obj->data->GetSphereOrigin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(sphereOrigin[i]));
    return retval;
}

static PyObject *
StreamlineAttributes_SetSphereRadius(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the sphereRadius in the object.
    obj->data->SetSphereRadius(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_GetSphereRadius(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSphereRadius());
    return retval;
}

static PyObject *
StreamlineAttributes_SetBoxExtents(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double *dvals = obj->data->GetBoxExtents();
    if(!PyArg_ParseTuple(args, "dddddd", &dvals[0], &dvals[1], &dvals[2], &dvals[3], &dvals[4], &dvals[5]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 6)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the boxExtents in the object as modified.
    obj->data->SelectBoxExtents();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_GetBoxExtents(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the boxExtents.
    PyObject *retval = PyTuple_New(6);
    const double *boxExtents = obj->data->GetBoxExtents();
    for(int i = 0; i < 6; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(boxExtents[i]));
    return retval;
}

static PyObject *
StreamlineAttributes_SetPointDensity(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointDensity in the object.
    obj->data->SetPointDensity(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_GetPointDensity(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointDensity()));
    return retval;
}

static PyObject *
StreamlineAttributes_SetDisplayMethod(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the displayMethod in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetDisplayMethod(StreamlineAttributes::DisplayMethod(ival));
    else
    {
        fprintf(stderr, "An invalid displayMethod value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Lines, Tubes, Ribbons.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_GetDisplayMethod(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDisplayMethod()));
    return retval;
}

static PyObject *
StreamlineAttributes_SetShowStart(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showStart in the object.
    obj->data->SetShowStart(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_GetShowStart(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowStart()?1L:0L);
    return retval;
}

static PyObject *
StreamlineAttributes_SetRadius(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the radius in the object.
    obj->data->SetRadius(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_GetRadius(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetRadius());
    return retval;
}

static PyObject *
StreamlineAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

static PyObject *
StreamlineAttributes_SetColoringMethod(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the coloringMethod in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetColoringMethod(StreamlineAttributes::ColoringMethod(ival));
    else
    {
        fprintf(stderr, "An invalid coloringMethod value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Solid, ColorBySpeed, ColorByVorticity.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_GetColoringMethod(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColoringMethod()));
    return retval;
}

static PyObject *
StreamlineAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

static PyObject *
StreamlineAttributes_SetSingleColor(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the singleColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetSingleColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_GetSingleColor(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the singleColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *singleColor = obj->data->GetSingleColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(singleColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(singleColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(singleColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(singleColor[3])));
    return retval;
}

static PyObject *
StreamlineAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

static PyObject *
StreamlineAttributes_SetLightingFlag(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lightingFlag in the object.
    obj->data->SetLightingFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
StreamlineAttributes_GetLightingFlag(PyObject *self, PyObject *args)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLightingFlag()?1L:0L);
    return retval;
}



static struct PyMethodDef StreamlineAttributes_methods[] = {
    {"Notify", StreamlineAttributes_Notify, METH_VARARGS},
    {"SetSourceType", StreamlineAttributes_SetSourceType, METH_VARARGS},
    {"GetSourceType", StreamlineAttributes_GetSourceType, METH_VARARGS},
    {"SetStepLength", StreamlineAttributes_SetStepLength, METH_VARARGS},
    {"GetStepLength", StreamlineAttributes_GetStepLength, METH_VARARGS},
    {"SetMaxTime", StreamlineAttributes_SetMaxTime, METH_VARARGS},
    {"GetMaxTime", StreamlineAttributes_GetMaxTime, METH_VARARGS},
    {"SetPointSource", StreamlineAttributes_SetPointSource, METH_VARARGS},
    {"GetPointSource", StreamlineAttributes_GetPointSource, METH_VARARGS},
    {"SetLineStart", StreamlineAttributes_SetLineStart, METH_VARARGS},
    {"GetLineStart", StreamlineAttributes_GetLineStart, METH_VARARGS},
    {"SetLineEnd", StreamlineAttributes_SetLineEnd, METH_VARARGS},
    {"GetLineEnd", StreamlineAttributes_GetLineEnd, METH_VARARGS},
    {"SetPlaneOrigin", StreamlineAttributes_SetPlaneOrigin, METH_VARARGS},
    {"GetPlaneOrigin", StreamlineAttributes_GetPlaneOrigin, METH_VARARGS},
    {"SetPlaneNormal", StreamlineAttributes_SetPlaneNormal, METH_VARARGS},
    {"GetPlaneNormal", StreamlineAttributes_GetPlaneNormal, METH_VARARGS},
    {"SetPlaneUpAxis", StreamlineAttributes_SetPlaneUpAxis, METH_VARARGS},
    {"GetPlaneUpAxis", StreamlineAttributes_GetPlaneUpAxis, METH_VARARGS},
    {"SetPlaneRadius", StreamlineAttributes_SetPlaneRadius, METH_VARARGS},
    {"GetPlaneRadius", StreamlineAttributes_GetPlaneRadius, METH_VARARGS},
    {"SetSphereOrigin", StreamlineAttributes_SetSphereOrigin, METH_VARARGS},
    {"GetSphereOrigin", StreamlineAttributes_GetSphereOrigin, METH_VARARGS},
    {"SetSphereRadius", StreamlineAttributes_SetSphereRadius, METH_VARARGS},
    {"GetSphereRadius", StreamlineAttributes_GetSphereRadius, METH_VARARGS},
    {"SetBoxExtents", StreamlineAttributes_SetBoxExtents, METH_VARARGS},
    {"GetBoxExtents", StreamlineAttributes_GetBoxExtents, METH_VARARGS},
    {"SetPointDensity", StreamlineAttributes_SetPointDensity, METH_VARARGS},
    {"GetPointDensity", StreamlineAttributes_GetPointDensity, METH_VARARGS},
    {"SetDisplayMethod", StreamlineAttributes_SetDisplayMethod, METH_VARARGS},
    {"GetDisplayMethod", StreamlineAttributes_GetDisplayMethod, METH_VARARGS},
    {"SetShowStart", StreamlineAttributes_SetShowStart, METH_VARARGS},
    {"GetShowStart", StreamlineAttributes_GetShowStart, METH_VARARGS},
    {"SetRadius", StreamlineAttributes_SetRadius, METH_VARARGS},
    {"GetRadius", StreamlineAttributes_GetRadius, METH_VARARGS},
    {"SetLineWidth", StreamlineAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", StreamlineAttributes_GetLineWidth, METH_VARARGS},
    {"SetColoringMethod", StreamlineAttributes_SetColoringMethod, METH_VARARGS},
    {"GetColoringMethod", StreamlineAttributes_GetColoringMethod, METH_VARARGS},
    {"SetColorTableName", StreamlineAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", StreamlineAttributes_GetColorTableName, METH_VARARGS},
    {"SetSingleColor", StreamlineAttributes_SetSingleColor, METH_VARARGS},
    {"GetSingleColor", StreamlineAttributes_GetSingleColor, METH_VARARGS},
    {"SetLegendFlag", StreamlineAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", StreamlineAttributes_GetLegendFlag, METH_VARARGS},
    {"SetLightingFlag", StreamlineAttributes_SetLightingFlag, METH_VARARGS},
    {"GetLightingFlag", StreamlineAttributes_GetLightingFlag, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
StreamlineAttributes_dealloc(PyObject *v)
{
   StreamlineAttributesObject *obj = (StreamlineAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
StreamlineAttributes_compare(PyObject *v, PyObject *w)
{
    StreamlineAttributes *a = ((StreamlineAttributesObject *)v)->data;
    StreamlineAttributes *b = ((StreamlineAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
StreamlineAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "sourceType") == 0)
        return StreamlineAttributes_GetSourceType(self, NULL);
    if(strcmp(name, "SpecifiedPoint") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::SpecifiedPoint));
    else if(strcmp(name, "SpecifiedLine") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::SpecifiedLine));
    else if(strcmp(name, "SpecifiedPlane") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::SpecifiedPlane));
    else if(strcmp(name, "SpecifiedSphere") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::SpecifiedSphere));
    else if(strcmp(name, "SpecifiedBox") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::SpecifiedBox));

    if(strcmp(name, "stepLength") == 0)
        return StreamlineAttributes_GetStepLength(self, NULL);
    if(strcmp(name, "maxTime") == 0)
        return StreamlineAttributes_GetMaxTime(self, NULL);
    if(strcmp(name, "pointSource") == 0)
        return StreamlineAttributes_GetPointSource(self, NULL);
    if(strcmp(name, "lineStart") == 0)
        return StreamlineAttributes_GetLineStart(self, NULL);
    if(strcmp(name, "lineEnd") == 0)
        return StreamlineAttributes_GetLineEnd(self, NULL);
    if(strcmp(name, "planeOrigin") == 0)
        return StreamlineAttributes_GetPlaneOrigin(self, NULL);
    if(strcmp(name, "planeNormal") == 0)
        return StreamlineAttributes_GetPlaneNormal(self, NULL);
    if(strcmp(name, "planeUpAxis") == 0)
        return StreamlineAttributes_GetPlaneUpAxis(self, NULL);
    if(strcmp(name, "planeRadius") == 0)
        return StreamlineAttributes_GetPlaneRadius(self, NULL);
    if(strcmp(name, "sphereOrigin") == 0)
        return StreamlineAttributes_GetSphereOrigin(self, NULL);
    if(strcmp(name, "sphereRadius") == 0)
        return StreamlineAttributes_GetSphereRadius(self, NULL);
    if(strcmp(name, "boxExtents") == 0)
        return StreamlineAttributes_GetBoxExtents(self, NULL);
    if(strcmp(name, "pointDensity") == 0)
        return StreamlineAttributes_GetPointDensity(self, NULL);
    if(strcmp(name, "displayMethod") == 0)
        return StreamlineAttributes_GetDisplayMethod(self, NULL);
    if(strcmp(name, "Lines") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::Lines));
    else if(strcmp(name, "Tubes") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::Tubes));
    else if(strcmp(name, "Ribbons") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::Ribbons));

    if(strcmp(name, "showStart") == 0)
        return StreamlineAttributes_GetShowStart(self, NULL);
    if(strcmp(name, "radius") == 0)
        return StreamlineAttributes_GetRadius(self, NULL);
    if(strcmp(name, "lineWidth") == 0)
        return StreamlineAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "coloringMethod") == 0)
        return StreamlineAttributes_GetColoringMethod(self, NULL);
    if(strcmp(name, "Solid") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::Solid));
    else if(strcmp(name, "ColorBySpeed") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::ColorBySpeed));
    else if(strcmp(name, "ColorByVorticity") == 0)
        return PyInt_FromLong(long(StreamlineAttributes::ColorByVorticity));

    if(strcmp(name, "colorTableName") == 0)
        return StreamlineAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "singleColor") == 0)
        return StreamlineAttributes_GetSingleColor(self, NULL);
    if(strcmp(name, "legendFlag") == 0)
        return StreamlineAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "lightingFlag") == 0)
        return StreamlineAttributes_GetLightingFlag(self, NULL);

    return Py_FindMethod(StreamlineAttributes_methods, self, name);
}

static int
StreamlineAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "sourceType") == 0)
        retval = (StreamlineAttributes_SetSourceType(self, tuple) != NULL);
    else if(strcmp(name, "stepLength") == 0)
        retval = (StreamlineAttributes_SetStepLength(self, tuple) != NULL);
    else if(strcmp(name, "maxTime") == 0)
        retval = (StreamlineAttributes_SetMaxTime(self, tuple) != NULL);
    else if(strcmp(name, "pointSource") == 0)
        retval = (StreamlineAttributes_SetPointSource(self, tuple) != NULL);
    else if(strcmp(name, "lineStart") == 0)
        retval = (StreamlineAttributes_SetLineStart(self, tuple) != NULL);
    else if(strcmp(name, "lineEnd") == 0)
        retval = (StreamlineAttributes_SetLineEnd(self, tuple) != NULL);
    else if(strcmp(name, "planeOrigin") == 0)
        retval = (StreamlineAttributes_SetPlaneOrigin(self, tuple) != NULL);
    else if(strcmp(name, "planeNormal") == 0)
        retval = (StreamlineAttributes_SetPlaneNormal(self, tuple) != NULL);
    else if(strcmp(name, "planeUpAxis") == 0)
        retval = (StreamlineAttributes_SetPlaneUpAxis(self, tuple) != NULL);
    else if(strcmp(name, "planeRadius") == 0)
        retval = (StreamlineAttributes_SetPlaneRadius(self, tuple) != NULL);
    else if(strcmp(name, "sphereOrigin") == 0)
        retval = (StreamlineAttributes_SetSphereOrigin(self, tuple) != NULL);
    else if(strcmp(name, "sphereRadius") == 0)
        retval = (StreamlineAttributes_SetSphereRadius(self, tuple) != NULL);
    else if(strcmp(name, "boxExtents") == 0)
        retval = (StreamlineAttributes_SetBoxExtents(self, tuple) != NULL);
    else if(strcmp(name, "pointDensity") == 0)
        retval = (StreamlineAttributes_SetPointDensity(self, tuple) != NULL);
    else if(strcmp(name, "displayMethod") == 0)
        retval = (StreamlineAttributes_SetDisplayMethod(self, tuple) != NULL);
    else if(strcmp(name, "showStart") == 0)
        retval = (StreamlineAttributes_SetShowStart(self, tuple) != NULL);
    else if(strcmp(name, "radius") == 0)
        retval = (StreamlineAttributes_SetRadius(self, tuple) != NULL);
    else if(strcmp(name, "lineWidth") == 0)
        retval = (StreamlineAttributes_SetLineWidth(self, tuple) != NULL);
    else if(strcmp(name, "coloringMethod") == 0)
        retval = (StreamlineAttributes_SetColoringMethod(self, tuple) != NULL);
    else if(strcmp(name, "colorTableName") == 0)
        retval = (StreamlineAttributes_SetColorTableName(self, tuple) != NULL);
    else if(strcmp(name, "singleColor") == 0)
        retval = (StreamlineAttributes_SetSingleColor(self, tuple) != NULL);
    else if(strcmp(name, "legendFlag") == 0)
        retval = (StreamlineAttributes_SetLegendFlag(self, tuple) != NULL);
    else if(strcmp(name, "lightingFlag") == 0)
        retval = (StreamlineAttributes_SetLightingFlag(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
StreamlineAttributes_print(PyObject *v, FILE *fp, int flags)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)v;

    const char *sourceType_names = "SpecifiedPoint, SpecifiedLine, SpecifiedPlane, SpecifiedSphere, SpecifiedBox";
    if(obj->data->GetSourceType() == StreamlineAttributes::SpecifiedPoint)
        fprintf(fp, "sourceType = SpecifiedPoint  # %s\n", sourceType_names);
    else if(obj->data->GetSourceType() == StreamlineAttributes::SpecifiedLine)
        fprintf(fp, "sourceType = SpecifiedLine  # %s\n", sourceType_names);
    else if(obj->data->GetSourceType() == StreamlineAttributes::SpecifiedPlane)
        fprintf(fp, "sourceType = SpecifiedPlane  # %s\n", sourceType_names);
    else if(obj->data->GetSourceType() == StreamlineAttributes::SpecifiedSphere)
        fprintf(fp, "sourceType = SpecifiedSphere  # %s\n", sourceType_names);
    else
        fprintf(fp, "sourceType = SpecifiedBox  # %s\n", sourceType_names);

    fprintf(fp, "stepLength = %g\n", obj->data->GetStepLength());
    fprintf(fp, "maxTime = %g\n", obj->data->GetMaxTime());
    {   const double *pointSource = obj->data->GetPointSource();
        fprintf(fp, "pointSource = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", pointSource[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const double *lineStart = obj->data->GetLineStart();
        fprintf(fp, "lineStart = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", lineStart[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const double *lineEnd = obj->data->GetLineEnd();
        fprintf(fp, "lineEnd = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", lineEnd[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const double *planeOrigin = obj->data->GetPlaneOrigin();
        fprintf(fp, "planeOrigin = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", planeOrigin[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const double *planeNormal = obj->data->GetPlaneNormal();
        fprintf(fp, "planeNormal = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", planeNormal[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    {   const double *planeUpAxis = obj->data->GetPlaneUpAxis();
        fprintf(fp, "planeUpAxis = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", planeUpAxis[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    fprintf(fp, "planeRadius = %g\n", obj->data->GetPlaneRadius());
    {   const double *sphereOrigin = obj->data->GetSphereOrigin();
        fprintf(fp, "sphereOrigin = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", sphereOrigin[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    fprintf(fp, "sphereRadius = %g\n", obj->data->GetSphereRadius());
    {   const double *boxExtents = obj->data->GetBoxExtents();
        fprintf(fp, "boxExtents = (");
        for(int i = 0; i < 6; ++i)
        {
            fprintf(fp, "%g", boxExtents[i]);
            if(i < 5)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    fprintf(fp, "pointDensity = %d\n", obj->data->GetPointDensity());
    const char *displayMethod_names = "Lines, Tubes, Ribbons";
    if(obj->data->GetDisplayMethod() == StreamlineAttributes::Lines)
        fprintf(fp, "displayMethod = Lines  # %s\n", displayMethod_names);
    else if(obj->data->GetDisplayMethod() == StreamlineAttributes::Tubes)
        fprintf(fp, "displayMethod = Tubes  # %s\n", displayMethod_names);
    else
        fprintf(fp, "displayMethod = Ribbons  # %s\n", displayMethod_names);

    if(obj->data->GetShowStart())
        fprintf(fp, "showStart = 1\n");
    else
        fprintf(fp, "showStart = 0\n");
    fprintf(fp, "radius = %g\n", obj->data->GetRadius());
    fprintf(fp, "lineWidth = %d\n", obj->data->GetLineWidth());
    const char *coloringMethod_names = "Solid, ColorBySpeed, ColorByVorticity";
    if(obj->data->GetColoringMethod() == StreamlineAttributes::Solid)
        fprintf(fp, "coloringMethod = Solid  # %s\n", coloringMethod_names);
    else if(obj->data->GetColoringMethod() == StreamlineAttributes::ColorBySpeed)
        fprintf(fp, "coloringMethod = ColorBySpeed  # %s\n", coloringMethod_names);
    else
        fprintf(fp, "coloringMethod = ColorByVorticity  # %s\n", coloringMethod_names);

    fprintf(fp, "colorTableName = \"%s\"\n", obj->data->GetColorTableName().c_str());
    const unsigned char *singleColor = obj->data->GetSingleColor().GetColor();
    fprintf(fp, "singleColor = (%d, %d, %d, %d)\n", int(singleColor[0]), int(singleColor[1]), int(singleColor[2]), int(singleColor[3]));
    if(obj->data->GetLegendFlag())
        fprintf(fp, "legendFlag = 1\n");
    else
        fprintf(fp, "legendFlag = 0\n");
    if(obj->data->GetLightingFlag())
        fprintf(fp, "lightingFlag = 1\n");
    else
        fprintf(fp, "lightingFlag = 0\n");

    return 0;
}

#include <snprintf.h>
PyObject *
PyStreamlineAttributes_StringRepresentation(const StreamlineAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    const char *sourceType_names = "SpecifiedPoint, SpecifiedLine, SpecifiedPlane, SpecifiedSphere, SpecifiedBox";
    if(atts->GetSourceType() == StreamlineAttributes::SpecifiedPoint)
        {
             SNPRINTF(tmpStr, 1000, "sourceType = SpecifiedPoint  # %s\n", sourceType_names);
             str += tmpStr;
        }
    else if(atts->GetSourceType() == StreamlineAttributes::SpecifiedLine)
        {
             SNPRINTF(tmpStr, 1000, "sourceType = SpecifiedLine  # %s\n", sourceType_names);
             str += tmpStr;
        }
    else if(atts->GetSourceType() == StreamlineAttributes::SpecifiedPlane)
        {
             SNPRINTF(tmpStr, 1000, "sourceType = SpecifiedPlane  # %s\n", sourceType_names);
             str += tmpStr;
        }
    else if(atts->GetSourceType() == StreamlineAttributes::SpecifiedSphere)
        {
             SNPRINTF(tmpStr, 1000, "sourceType = SpecifiedSphere  # %s\n", sourceType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "sourceType = SpecifiedBox  # %s\n", sourceType_names);
             str += tmpStr;
        }

    SNPRINTF(tmpStr, 1000, "stepLength = %g\n", atts->GetStepLength());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "maxTime = %g\n", atts->GetMaxTime());
    str += tmpStr;
    {   const double *pointSource = atts->GetPointSource();
        SNPRINTF(tmpStr, 1000, "pointSource = (");
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", pointSource[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *lineStart = atts->GetLineStart();
        SNPRINTF(tmpStr, 1000, "lineStart = (");
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", lineStart[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *lineEnd = atts->GetLineEnd();
        SNPRINTF(tmpStr, 1000, "lineEnd = (");
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", lineEnd[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *planeOrigin = atts->GetPlaneOrigin();
        SNPRINTF(tmpStr, 1000, "planeOrigin = (");
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", planeOrigin[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *planeNormal = atts->GetPlaneNormal();
        SNPRINTF(tmpStr, 1000, "planeNormal = (");
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", planeNormal[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *planeUpAxis = atts->GetPlaneUpAxis();
        SNPRINTF(tmpStr, 1000, "planeUpAxis = (");
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", planeUpAxis[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "planeRadius = %g\n", atts->GetPlaneRadius());
    str += tmpStr;
    {   const double *sphereOrigin = atts->GetSphereOrigin();
        SNPRINTF(tmpStr, 1000, "sphereOrigin = (");
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", sphereOrigin[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "sphereRadius = %g\n", atts->GetSphereRadius());
    str += tmpStr;
    {   const double *boxExtents = atts->GetBoxExtents();
        SNPRINTF(tmpStr, 1000, "boxExtents = (");
        str += tmpStr;
        for(int i = 0; i < 6; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", boxExtents[i]);
            str += tmpStr;
            if(i < 5)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "pointDensity = %d\n", atts->GetPointDensity());
    str += tmpStr;
    const char *displayMethod_names = "Lines, Tubes, Ribbons";
    if(atts->GetDisplayMethod() == StreamlineAttributes::Lines)
        {
             SNPRINTF(tmpStr, 1000, "displayMethod = Lines  # %s\n", displayMethod_names);
             str += tmpStr;
        }
    else if(atts->GetDisplayMethod() == StreamlineAttributes::Tubes)
        {
             SNPRINTF(tmpStr, 1000, "displayMethod = Tubes  # %s\n", displayMethod_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "displayMethod = Ribbons  # %s\n", displayMethod_names);
             str += tmpStr;
        }

    if(atts->GetShowStart())
        SNPRINTF(tmpStr, 1000, "showStart = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "showStart = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "radius = %g\n", atts->GetRadius());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "lineWidth = %d\n", atts->GetLineWidth());
    str += tmpStr;
    const char *coloringMethod_names = "Solid, ColorBySpeed, ColorByVorticity";
    if(atts->GetColoringMethod() == StreamlineAttributes::Solid)
        {
             SNPRINTF(tmpStr, 1000, "coloringMethod = Solid  # %s\n", coloringMethod_names);
             str += tmpStr;
        }
    else if(atts->GetColoringMethod() == StreamlineAttributes::ColorBySpeed)
        {
             SNPRINTF(tmpStr, 1000, "coloringMethod = ColorBySpeed  # %s\n", coloringMethod_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "coloringMethod = ColorByVorticity  # %s\n", coloringMethod_names);
             str += tmpStr;
        }

   SNPRINTF(tmpStr, 1000, "colorTableName = \"%s\"\n", atts->GetColorTableName().c_str());
   str += tmpStr;
    const unsigned char *singleColor = atts->GetSingleColor().GetColor();
    SNPRINTF(tmpStr, 1000, "singleColor = (%d, %d, %d, %d)\n", int(singleColor[0]), int(singleColor[1]), int(singleColor[2]), int(singleColor[3]));
    str += tmpStr;
    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "legendFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "legendFlag = 0\n");
    str += tmpStr;
    if(atts->GetLightingFlag())
        SNPRINTF(tmpStr, 1000, "lightingFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "lightingFlag = 0\n");
    str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
StreamlineAttributes_str(PyObject *v)
{
    StreamlineAttributesObject *obj = (StreamlineAttributesObject *)v;
    return PyStreamlineAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *StreamlineAttributes_Purpose = "Attributes for the Streamline plot";

//
// The type description structure
//
static PyTypeObject StreamlineAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "StreamlineAttributes",                    // tp_name
    sizeof(StreamlineAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)StreamlineAttributes_dealloc,  // tp_dealloc
    (printfunc)StreamlineAttributes_print,     // tp_print
    (getattrfunc)StreamlineAttributes_getattr, // tp_getattr
    (setattrfunc)StreamlineAttributes_setattr, // tp_setattr
    (cmpfunc)StreamlineAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)StreamlineAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    StreamlineAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static StreamlineAttributes *defaultAtts = 0;

static PyObject *
NewStreamlineAttributes()
{
    StreamlineAttributesObject *newObject;
    newObject = PyObject_NEW(StreamlineAttributesObject, &StreamlineAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new StreamlineAttributes(*defaultAtts);
    else
        newObject->data = new StreamlineAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapStreamlineAttributes(const StreamlineAttributes *attr)
{
    StreamlineAttributesObject *newObject;
    newObject = PyObject_NEW(StreamlineAttributesObject, &StreamlineAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (StreamlineAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
StreamlineAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewStreamlineAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef StreamlineAttributesMethods[] = {
    {"StreamlineAttributes", StreamlineAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *StreamlineAttributesObserver = 0;
static bool StreamlineAttributesEnableLogging = true;

static void
PyStreamlineAttributes_WriteLog(Subject *subj, void *data)
{
    StreamlineAttributes *atts = (StreamlineAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!StreamlineAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# StreamlineAttributes_WriteLog()\n");
}

void
PyStreamlineAttributes_StartUp(StreamlineAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyStreamlineAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(StreamlineAttributesObserver == 0)
    {
        StreamlineAttributesObserver = new ObserverToCallback(subj,
            PyStreamlineAttributes_WriteLog, (void *)logFile);
    }

    StreamlineAttributesEnableLogging = true;
}

void
PyStreamlineAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete StreamlineAttributesObserver;
    StreamlineAttributesObserver = 0;
}

PyMethodDef *
PyStreamlineAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return StreamlineAttributesMethods;
}

bool
PyStreamlineAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &StreamlineAttributesType);
}

StreamlineAttributes *
PyStreamlineAttributes_FromPyObject(PyObject *obj)
{
    StreamlineAttributesObject *obj2 = (StreamlineAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyStreamlineAttributes_NewPyObject()
{
    return NewStreamlineAttributes();
}

PyObject *
PyStreamlineAttributes_WrapPyObject(const StreamlineAttributes *attr)
{
    return WrapStreamlineAttributes(attr);
}

void
PyStreamlineAttributes_SetLogging(bool val)
{
    StreamlineAttributesEnableLogging = val;
}

void
PyStreamlineAttributes_SetDefaults(const StreamlineAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new StreamlineAttributes(*atts);
}

