// ************************************************************************* //
//  File: ScatterViewerPluginInfo.C
// ************************************************************************* //

#include <ScatterPluginInfo.h>
#include <avtScatterPlot.h>

#if defined(__APPLE__)
#define GetViewerInfo Scatter_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Scatter plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:45 PST 2004
//
// ****************************************************************************
extern "C" ViewerPlotPluginInfo* GetViewerInfo()
{
    ScatterViewerPluginInfo::InitializeGlobalObjects();
    return new ScatterViewerPluginInfo;
}

//
// Storage for static data elements.
//
ScatterAttributes *ScatterViewerPluginInfo::clientAtts = NULL;
ScatterAttributes *ScatterViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  ScatterViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:45 PST 2004
//
// ****************************************************************************
void
ScatterViewerPluginInfo::InitializeGlobalObjects()
{
    ScatterViewerPluginInfo::clientAtts  = new ScatterAttributes;
    ScatterViewerPluginInfo::defaultAtts = new ScatterAttributes;
}

// ****************************************************************************
//  Method: ScatterViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:45 PST 2004
//
// ****************************************************************************

AttributeSubject *
ScatterViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: ScatterViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:45 PST 2004
//
// ****************************************************************************

AttributeSubject *
ScatterViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: ScatterViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:45 PST 2004
//
// ****************************************************************************

void
ScatterViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(ScatterAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: ScatterViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:45 PST 2004
//
// ****************************************************************************

void
ScatterViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(ScatterAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ScatterViewerPluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:45 PST 2004
//
// ****************************************************************************

avtPlot *
ScatterViewerPluginInfo::AllocAvtPlot()
{
    return new avtScatterPlot;
}

// ****************************************************************************
//  Method: ScatterViewerPluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:45 PST 2004
//
// ****************************************************************************

void
ScatterViewerPluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtDatabaseMetaData *, const char *)
{
    *(ScatterAttributes*)atts = *defaultAtts;
}

// ****************************************************************************
// Method: ScatterViewerPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:45 PST 2004
//
// Modifications:
//   
// ****************************************************************************

int
ScatterViewerPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SCALAR | VAR_CATEGORY_SPECIES;
}


// ****************************************************************************
//  Method: ScatterViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:45 PST 2004
//
// ****************************************************************************

#include <Scatter.xpm>
const char **
ScatterViewerPluginInfo::XPMIconData() const
{
    return Scatter_xpm;
}
