// ************************************************************************* //
//                        ScatterScriptingPluginInfo.C
// ************************************************************************* //
#include <ScatterPluginInfo.h>
#include <PyScatterAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Scatter_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Scatter plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// ****************************************************************************
extern "C" ScriptingPlotPluginInfo* GetScriptingInfo()
{
    return new ScatterScriptingPluginInfo;
}

// ****************************************************************************
// Method: ScatterScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
ScatterScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyScatterAttributes_StartUp((ScatterAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: ScatterScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void *
ScatterScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyScatterAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ScatterScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Scatter plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

bool
ScatterScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyScatterAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ScatterScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
ScatterScriptingPluginInfo::SetLogging(bool val)
{
    PyScatterAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: ScatterScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
ScatterScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyScatterAttributes_SetDefaults((const ScatterAttributes *)atts);
}
