// ************************************************************************* //
//  File: ScatterGUIPluginInfo.C
// ************************************************************************* //

#include <ScatterPluginInfo.h>
#include <ScatterAttributes.h>
#include <QvisScatterPlotWindow.h>
#include <QvisScatterPlotWizard.h>

#if defined(__APPLE__)
#define GetGUIInfo Scatter_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Scatter plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Tue Nov 2 21:52:23 PST 2004
//
// ****************************************************************************
extern "C" GUIPlotPluginInfo* GetGUIInfo()
{
    return new ScatterGUIPluginInfo;
}

// ****************************************************************************
//  Method: ScatterGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Tue Nov 2 21:52:23 PST 2004
//
// ****************************************************************************

const char *
ScatterGUIPluginInfo::GetMenuName() const
{
    return "Scatter";
}


// ****************************************************************************
// Method: ScatterGUIPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Tue Nov 2 21:52:23 PST 2004
//
// Modifications:
//   
// ****************************************************************************

int
ScatterGUIPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SCALAR;
}

// ****************************************************************************
//  Method: ScatterGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Tue Nov 2 21:52:23 PST 2004
//
// ****************************************************************************

QvisPostableWindowObserver *
ScatterGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisScatterPlotWindow(type, (ScatterAttributes *)attr,
        "Scatter plot attributes", "Scatter plot", notepad);
}

// ****************************************************************************
// Method: ScatterGUIPluginInfo::CreatePluginWizard
//
// Purpose: 
//   Creates a Scatter plot wizard and returns a pointer to it.
//
// Arguments:
//   attr   : The attributes that should be used for the plot.
//   parent : The wizard's parent widget.
//   name   : The name of the wizard.
//
// Returns:    A pointer to the new wizard.
//
// Note:       
//
// Programmer: Brad Whitlock
// Creation:   Tue Dec 14 09:48:06 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

QvisWizard *
ScatterGUIPluginInfo::CreatePluginWizard(AttributeSubject *attr,
    QWidget *parent, const char *name)
{
    return new QvisScatterPlotWizard(attr, parent, name);
}

// ****************************************************************************
//  Method: ScatterGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Tue Nov 2 21:52:23 PST 2004
//
// ****************************************************************************

#include <Scatter.xpm>
const char **
ScatterGUIPluginInfo::XPMIconData() const
{
    return Scatter_xpm;
}
