package llnl.visit.plots;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;
import llnl.visit.ColorAttribute;

// ****************************************************************************
// Class: ScatterAttributes
//
// Purpose:
//    Attributes for the scatter plot
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Tue Jan 4 13:29:58 PST 2005
//
// Modifications:
//   
// ****************************************************************************

public class ScatterAttributes extends AttributeSubject implements Plugin
{
    // Enum values
    public final static int SCALING_LINEAR = 0;
    public final static int SCALING_LOG = 1;
    public final static int SCALING_SKEW = 2;

    public final static int POINTTYPE_BOX = 0;
    public final static int POINTTYPE_AXIS = 1;
    public final static int POINTTYPE_ICOSAHEDRON = 2;
    public final static int POINTTYPE_POINT = 3;

    public final static int VARIABLEROLE_COORDINATE0 = 0;
    public final static int VARIABLEROLE_COORDINATE1 = 1;
    public final static int VARIABLEROLE_COORDINATE2 = 2;
    public final static int VARIABLEROLE_COLOR = 3;
    public final static int VARIABLEROLE_NONE = 4;


    public ScatterAttributes()
    {
        super(38);

        var1Role = VARIABLEROLE_COORDINATE0;
        var1MinFlag = false;
        var1MaxFlag = false;
        var1Min = 0;
        var1Max = 1;
        var1Scaling = SCALING_LINEAR;
        var1SkewFactor = 1;
        var2Role = VARIABLEROLE_COORDINATE1;
        var2 = new String("default");
        var2MinFlag = false;
        var2MaxFlag = false;
        var2Min = 0;
        var2Max = 1;
        var2Scaling = SCALING_LINEAR;
        var2SkewFactor = 1;
        var3Role = VARIABLEROLE_NONE;
        var3 = new String("default");
        var3MinFlag = false;
        var3MaxFlag = false;
        var3Min = 0;
        var3Max = 1;
        var3Scaling = SCALING_LINEAR;
        var3SkewFactor = 1;
        var4Role = VARIABLEROLE_NONE;
        var4 = new String("default");
        var4MinFlag = false;
        var4MaxFlag = false;
        var4Min = 0;
        var4Max = 1;
        var4Scaling = SCALING_LINEAR;
        var4SkewFactor = 1;
        pointSize = 0.05;
        pointType = POINTTYPE_POINT;
        scaleCube = true;
        colorTableName = new String("hot");
        singleColor = new ColorAttribute(255, 0, 0);
        foregroundFlag = true;
        legendFlag = true;
    }

    public ScatterAttributes(ScatterAttributes obj)
    {
        super(38);

        var1Role = obj.var1Role;
        var1MinFlag = obj.var1MinFlag;
        var1MaxFlag = obj.var1MaxFlag;
        var1Min = obj.var1Min;
        var1Max = obj.var1Max;
        var1Scaling = obj.var1Scaling;
        var1SkewFactor = obj.var1SkewFactor;
        var2Role = obj.var2Role;
        var2 = new String(obj.var2);
        var2MinFlag = obj.var2MinFlag;
        var2MaxFlag = obj.var2MaxFlag;
        var2Min = obj.var2Min;
        var2Max = obj.var2Max;
        var2Scaling = obj.var2Scaling;
        var2SkewFactor = obj.var2SkewFactor;
        var3Role = obj.var3Role;
        var3 = new String(obj.var3);
        var3MinFlag = obj.var3MinFlag;
        var3MaxFlag = obj.var3MaxFlag;
        var3Min = obj.var3Min;
        var3Max = obj.var3Max;
        var3Scaling = obj.var3Scaling;
        var3SkewFactor = obj.var3SkewFactor;
        var4Role = obj.var4Role;
        var4 = new String(obj.var4);
        var4MinFlag = obj.var4MinFlag;
        var4MaxFlag = obj.var4MaxFlag;
        var4Min = obj.var4Min;
        var4Max = obj.var4Max;
        var4Scaling = obj.var4Scaling;
        var4SkewFactor = obj.var4SkewFactor;
        pointSize = obj.pointSize;
        pointType = obj.pointType;
        scaleCube = obj.scaleCube;
        colorTableName = new String(obj.colorTableName);
        singleColor = new ColorAttribute(obj.singleColor);
        foregroundFlag = obj.foregroundFlag;
        legendFlag = obj.legendFlag;

        SelectAll();
    }

    public boolean equals(ScatterAttributes obj)
    {
        // Create the return value
        return ((var1Role == obj.var1Role) &&
                (var1MinFlag == obj.var1MinFlag) &&
                (var1MaxFlag == obj.var1MaxFlag) &&
                (var1Min == obj.var1Min) &&
                (var1Max == obj.var1Max) &&
                (var1Scaling == obj.var1Scaling) &&
                (var1SkewFactor == obj.var1SkewFactor) &&
                (var2Role == obj.var2Role) &&
                (var2 == obj.var2) &&
                (var2MinFlag == obj.var2MinFlag) &&
                (var2MaxFlag == obj.var2MaxFlag) &&
                (var2Min == obj.var2Min) &&
                (var2Max == obj.var2Max) &&
                (var2Scaling == obj.var2Scaling) &&
                (var2SkewFactor == obj.var2SkewFactor) &&
                (var3Role == obj.var3Role) &&
                (var3 == obj.var3) &&
                (var3MinFlag == obj.var3MinFlag) &&
                (var3MaxFlag == obj.var3MaxFlag) &&
                (var3Min == obj.var3Min) &&
                (var3Max == obj.var3Max) &&
                (var3Scaling == obj.var3Scaling) &&
                (var3SkewFactor == obj.var3SkewFactor) &&
                (var4Role == obj.var4Role) &&
                (var4 == obj.var4) &&
                (var4MinFlag == obj.var4MinFlag) &&
                (var4MaxFlag == obj.var4MaxFlag) &&
                (var4Min == obj.var4Min) &&
                (var4Max == obj.var4Max) &&
                (var4Scaling == obj.var4Scaling) &&
                (var4SkewFactor == obj.var4SkewFactor) &&
                (pointSize == obj.pointSize) &&
                (pointType == obj.pointType) &&
                (scaleCube == obj.scaleCube) &&
                (colorTableName == obj.colorTableName) &&
                (singleColor == obj.singleColor) &&
                (foregroundFlag == obj.foregroundFlag) &&
                (legendFlag == obj.legendFlag));
    }

    public String GetName() { return "Scatter"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetVar1Role(int var1Role_)
    {
        var1Role = var1Role_;
        Select(0);
    }

    public void SetVar1MinFlag(boolean var1MinFlag_)
    {
        var1MinFlag = var1MinFlag_;
        Select(1);
    }

    public void SetVar1MaxFlag(boolean var1MaxFlag_)
    {
        var1MaxFlag = var1MaxFlag_;
        Select(2);
    }

    public void SetVar1Min(double var1Min_)
    {
        var1Min = var1Min_;
        Select(3);
    }

    public void SetVar1Max(double var1Max_)
    {
        var1Max = var1Max_;
        Select(4);
    }

    public void SetVar1Scaling(int var1Scaling_)
    {
        var1Scaling = var1Scaling_;
        Select(5);
    }

    public void SetVar1SkewFactor(double var1SkewFactor_)
    {
        var1SkewFactor = var1SkewFactor_;
        Select(6);
    }

    public void SetVar2Role(int var2Role_)
    {
        var2Role = var2Role_;
        Select(7);
    }

    public void SetVar2(String var2_)
    {
        var2 = var2_;
        Select(8);
    }

    public void SetVar2MinFlag(boolean var2MinFlag_)
    {
        var2MinFlag = var2MinFlag_;
        Select(9);
    }

    public void SetVar2MaxFlag(boolean var2MaxFlag_)
    {
        var2MaxFlag = var2MaxFlag_;
        Select(10);
    }

    public void SetVar2Min(double var2Min_)
    {
        var2Min = var2Min_;
        Select(11);
    }

    public void SetVar2Max(double var2Max_)
    {
        var2Max = var2Max_;
        Select(12);
    }

    public void SetVar2Scaling(int var2Scaling_)
    {
        var2Scaling = var2Scaling_;
        Select(13);
    }

    public void SetVar2SkewFactor(double var2SkewFactor_)
    {
        var2SkewFactor = var2SkewFactor_;
        Select(14);
    }

    public void SetVar3Role(int var3Role_)
    {
        var3Role = var3Role_;
        Select(15);
    }

    public void SetVar3(String var3_)
    {
        var3 = var3_;
        Select(16);
    }

    public void SetVar3MinFlag(boolean var3MinFlag_)
    {
        var3MinFlag = var3MinFlag_;
        Select(17);
    }

    public void SetVar3MaxFlag(boolean var3MaxFlag_)
    {
        var3MaxFlag = var3MaxFlag_;
        Select(18);
    }

    public void SetVar3Min(double var3Min_)
    {
        var3Min = var3Min_;
        Select(19);
    }

    public void SetVar3Max(double var3Max_)
    {
        var3Max = var3Max_;
        Select(20);
    }

    public void SetVar3Scaling(int var3Scaling_)
    {
        var3Scaling = var3Scaling_;
        Select(21);
    }

    public void SetVar3SkewFactor(double var3SkewFactor_)
    {
        var3SkewFactor = var3SkewFactor_;
        Select(22);
    }

    public void SetVar4Role(int var4Role_)
    {
        var4Role = var4Role_;
        Select(23);
    }

    public void SetVar4(String var4_)
    {
        var4 = var4_;
        Select(24);
    }

    public void SetVar4MinFlag(boolean var4MinFlag_)
    {
        var4MinFlag = var4MinFlag_;
        Select(25);
    }

    public void SetVar4MaxFlag(boolean var4MaxFlag_)
    {
        var4MaxFlag = var4MaxFlag_;
        Select(26);
    }

    public void SetVar4Min(double var4Min_)
    {
        var4Min = var4Min_;
        Select(27);
    }

    public void SetVar4Max(double var4Max_)
    {
        var4Max = var4Max_;
        Select(28);
    }

    public void SetVar4Scaling(int var4Scaling_)
    {
        var4Scaling = var4Scaling_;
        Select(29);
    }

    public void SetVar4SkewFactor(double var4SkewFactor_)
    {
        var4SkewFactor = var4SkewFactor_;
        Select(30);
    }

    public void SetPointSize(double pointSize_)
    {
        pointSize = pointSize_;
        Select(31);
    }

    public void SetPointType(int pointType_)
    {
        pointType = pointType_;
        Select(32);
    }

    public void SetScaleCube(boolean scaleCube_)
    {
        scaleCube = scaleCube_;
        Select(33);
    }

    public void SetColorTableName(String colorTableName_)
    {
        colorTableName = colorTableName_;
        Select(34);
    }

    public void SetSingleColor(ColorAttribute singleColor_)
    {
        singleColor = singleColor_;
        Select(35);
    }

    public void SetForegroundFlag(boolean foregroundFlag_)
    {
        foregroundFlag = foregroundFlag_;
        Select(36);
    }

    public void SetLegendFlag(boolean legendFlag_)
    {
        legendFlag = legendFlag_;
        Select(37);
    }

    // Property getting methods
    public int            GetVar1Role() { return var1Role; }
    public boolean        GetVar1MinFlag() { return var1MinFlag; }
    public boolean        GetVar1MaxFlag() { return var1MaxFlag; }
    public double         GetVar1Min() { return var1Min; }
    public double         GetVar1Max() { return var1Max; }
    public int            GetVar1Scaling() { return var1Scaling; }
    public double         GetVar1SkewFactor() { return var1SkewFactor; }
    public int            GetVar2Role() { return var2Role; }
    public String         GetVar2() { return var2; }
    public boolean        GetVar2MinFlag() { return var2MinFlag; }
    public boolean        GetVar2MaxFlag() { return var2MaxFlag; }
    public double         GetVar2Min() { return var2Min; }
    public double         GetVar2Max() { return var2Max; }
    public int            GetVar2Scaling() { return var2Scaling; }
    public double         GetVar2SkewFactor() { return var2SkewFactor; }
    public int            GetVar3Role() { return var3Role; }
    public String         GetVar3() { return var3; }
    public boolean        GetVar3MinFlag() { return var3MinFlag; }
    public boolean        GetVar3MaxFlag() { return var3MaxFlag; }
    public double         GetVar3Min() { return var3Min; }
    public double         GetVar3Max() { return var3Max; }
    public int            GetVar3Scaling() { return var3Scaling; }
    public double         GetVar3SkewFactor() { return var3SkewFactor; }
    public int            GetVar4Role() { return var4Role; }
    public String         GetVar4() { return var4; }
    public boolean        GetVar4MinFlag() { return var4MinFlag; }
    public boolean        GetVar4MaxFlag() { return var4MaxFlag; }
    public double         GetVar4Min() { return var4Min; }
    public double         GetVar4Max() { return var4Max; }
    public int            GetVar4Scaling() { return var4Scaling; }
    public double         GetVar4SkewFactor() { return var4SkewFactor; }
    public double         GetPointSize() { return pointSize; }
    public int            GetPointType() { return pointType; }
    public boolean        GetScaleCube() { return scaleCube; }
    public String         GetColorTableName() { return colorTableName; }
    public ColorAttribute GetSingleColor() { return singleColor; }
    public boolean        GetForegroundFlag() { return foregroundFlag; }
    public boolean        GetLegendFlag() { return legendFlag; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(var1Role);
        if(WriteSelect(1, buf))
            buf.WriteBool(var1MinFlag);
        if(WriteSelect(2, buf))
            buf.WriteBool(var1MaxFlag);
        if(WriteSelect(3, buf))
            buf.WriteDouble(var1Min);
        if(WriteSelect(4, buf))
            buf.WriteDouble(var1Max);
        if(WriteSelect(5, buf))
            buf.WriteInt(var1Scaling);
        if(WriteSelect(6, buf))
            buf.WriteDouble(var1SkewFactor);
        if(WriteSelect(7, buf))
            buf.WriteInt(var2Role);
        if(WriteSelect(8, buf))
            buf.WriteString(var2);
        if(WriteSelect(9, buf))
            buf.WriteBool(var2MinFlag);
        if(WriteSelect(10, buf))
            buf.WriteBool(var2MaxFlag);
        if(WriteSelect(11, buf))
            buf.WriteDouble(var2Min);
        if(WriteSelect(12, buf))
            buf.WriteDouble(var2Max);
        if(WriteSelect(13, buf))
            buf.WriteInt(var2Scaling);
        if(WriteSelect(14, buf))
            buf.WriteDouble(var2SkewFactor);
        if(WriteSelect(15, buf))
            buf.WriteInt(var3Role);
        if(WriteSelect(16, buf))
            buf.WriteString(var3);
        if(WriteSelect(17, buf))
            buf.WriteBool(var3MinFlag);
        if(WriteSelect(18, buf))
            buf.WriteBool(var3MaxFlag);
        if(WriteSelect(19, buf))
            buf.WriteDouble(var3Min);
        if(WriteSelect(20, buf))
            buf.WriteDouble(var3Max);
        if(WriteSelect(21, buf))
            buf.WriteInt(var3Scaling);
        if(WriteSelect(22, buf))
            buf.WriteDouble(var3SkewFactor);
        if(WriteSelect(23, buf))
            buf.WriteInt(var4Role);
        if(WriteSelect(24, buf))
            buf.WriteString(var4);
        if(WriteSelect(25, buf))
            buf.WriteBool(var4MinFlag);
        if(WriteSelect(26, buf))
            buf.WriteBool(var4MaxFlag);
        if(WriteSelect(27, buf))
            buf.WriteDouble(var4Min);
        if(WriteSelect(28, buf))
            buf.WriteDouble(var4Max);
        if(WriteSelect(29, buf))
            buf.WriteInt(var4Scaling);
        if(WriteSelect(30, buf))
            buf.WriteDouble(var4SkewFactor);
        if(WriteSelect(31, buf))
            buf.WriteDouble(pointSize);
        if(WriteSelect(32, buf))
            buf.WriteInt(pointType);
        if(WriteSelect(33, buf))
            buf.WriteBool(scaleCube);
        if(WriteSelect(34, buf))
            buf.WriteString(colorTableName);
        if(WriteSelect(35, buf))
            singleColor.Write(buf);
        if(WriteSelect(36, buf))
            buf.WriteBool(foregroundFlag);
        if(WriteSelect(37, buf))
            buf.WriteBool(legendFlag);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetVar1Role(buf.ReadInt());
                break;
            case 1:
                SetVar1MinFlag(buf.ReadBool());
                break;
            case 2:
                SetVar1MaxFlag(buf.ReadBool());
                break;
            case 3:
                SetVar1Min(buf.ReadDouble());
                break;
            case 4:
                SetVar1Max(buf.ReadDouble());
                break;
            case 5:
                SetVar1Scaling(buf.ReadInt());
                break;
            case 6:
                SetVar1SkewFactor(buf.ReadDouble());
                break;
            case 7:
                SetVar2Role(buf.ReadInt());
                break;
            case 8:
                SetVar2(buf.ReadString());
                break;
            case 9:
                SetVar2MinFlag(buf.ReadBool());
                break;
            case 10:
                SetVar2MaxFlag(buf.ReadBool());
                break;
            case 11:
                SetVar2Min(buf.ReadDouble());
                break;
            case 12:
                SetVar2Max(buf.ReadDouble());
                break;
            case 13:
                SetVar2Scaling(buf.ReadInt());
                break;
            case 14:
                SetVar2SkewFactor(buf.ReadDouble());
                break;
            case 15:
                SetVar3Role(buf.ReadInt());
                break;
            case 16:
                SetVar3(buf.ReadString());
                break;
            case 17:
                SetVar3MinFlag(buf.ReadBool());
                break;
            case 18:
                SetVar3MaxFlag(buf.ReadBool());
                break;
            case 19:
                SetVar3Min(buf.ReadDouble());
                break;
            case 20:
                SetVar3Max(buf.ReadDouble());
                break;
            case 21:
                SetVar3Scaling(buf.ReadInt());
                break;
            case 22:
                SetVar3SkewFactor(buf.ReadDouble());
                break;
            case 23:
                SetVar4Role(buf.ReadInt());
                break;
            case 24:
                SetVar4(buf.ReadString());
                break;
            case 25:
                SetVar4MinFlag(buf.ReadBool());
                break;
            case 26:
                SetVar4MaxFlag(buf.ReadBool());
                break;
            case 27:
                SetVar4Min(buf.ReadDouble());
                break;
            case 28:
                SetVar4Max(buf.ReadDouble());
                break;
            case 29:
                SetVar4Scaling(buf.ReadInt());
                break;
            case 30:
                SetVar4SkewFactor(buf.ReadDouble());
                break;
            case 31:
                SetPointSize(buf.ReadDouble());
                break;
            case 32:
                SetPointType(buf.ReadInt());
                break;
            case 33:
                SetScaleCube(buf.ReadBool());
                break;
            case 34:
                SetColorTableName(buf.ReadString());
                break;
            case 35:
                singleColor.Read(buf);
                Select(35);
                break;
            case 36:
                SetForegroundFlag(buf.ReadBool());
                break;
            case 37:
                SetLegendFlag(buf.ReadBool());
                break;
            }
        }
    }


    // Attributes
    private int            var1Role;
    private boolean        var1MinFlag;
    private boolean        var1MaxFlag;
    private double         var1Min;
    private double         var1Max;
    private int            var1Scaling;
    private double         var1SkewFactor;
    private int            var2Role;
    private String         var2;
    private boolean        var2MinFlag;
    private boolean        var2MaxFlag;
    private double         var2Min;
    private double         var2Max;
    private int            var2Scaling;
    private double         var2SkewFactor;
    private int            var3Role;
    private String         var3;
    private boolean        var3MinFlag;
    private boolean        var3MaxFlag;
    private double         var3Min;
    private double         var3Max;
    private int            var3Scaling;
    private double         var3SkewFactor;
    private int            var4Role;
    private String         var4;
    private boolean        var4MinFlag;
    private boolean        var4MaxFlag;
    private double         var4Min;
    private double         var4Max;
    private int            var4Scaling;
    private double         var4SkewFactor;
    private double         pointSize;
    private int            pointType;
    private boolean        scaleCube;
    private String         colorTableName;
    private ColorAttribute singleColor;
    private boolean        foregroundFlag;
    private boolean        legendFlag;
}

