#include <ScatterAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for ScatterAttributes::Scaling
//

static const char *Scaling_strings[] = {
"Linear", "Log", "Skew"
};

std::string
ScatterAttributes::Scaling_ToString(ScatterAttributes::Scaling t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return Scaling_strings[index];
}

std::string
ScatterAttributes::Scaling_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return Scaling_strings[index];
}

bool
ScatterAttributes::Scaling_FromString(const std::string &s, ScatterAttributes::Scaling &val)
{
    val = ScatterAttributes::Linear;
    for(int i = 0; i < 3; ++i)
    {
        if(s == Scaling_strings[i])
        {
            val = (Scaling)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for ScatterAttributes::PointType
//

static const char *PointType_strings[] = {
"Box", "Axis", "Icosahedron", 
"Point"};

std::string
ScatterAttributes::PointType_ToString(ScatterAttributes::PointType t)
{
    int index = int(t);
    if(index < 0 || index >= 4) index = 0;
    return PointType_strings[index];
}

std::string
ScatterAttributes::PointType_ToString(int t)
{
    int index = (t < 0 || t >= 4) ? 0 : t;
    return PointType_strings[index];
}

bool
ScatterAttributes::PointType_FromString(const std::string &s, ScatterAttributes::PointType &val)
{
    val = ScatterAttributes::Box;
    for(int i = 0; i < 4; ++i)
    {
        if(s == PointType_strings[i])
        {
            val = (PointType)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for ScatterAttributes::VariableRole
//

static const char *VariableRole_strings[] = {
"Coordinate0", "Coordinate1", "Coordinate2", 
"Color", "None"};

std::string
ScatterAttributes::VariableRole_ToString(ScatterAttributes::VariableRole t)
{
    int index = int(t);
    if(index < 0 || index >= 5) index = 0;
    return VariableRole_strings[index];
}

std::string
ScatterAttributes::VariableRole_ToString(int t)
{
    int index = (t < 0 || t >= 5) ? 0 : t;
    return VariableRole_strings[index];
}

bool
ScatterAttributes::VariableRole_FromString(const std::string &s, ScatterAttributes::VariableRole &val)
{
    val = ScatterAttributes::Coordinate0;
    for(int i = 0; i < 5; ++i)
    {
        if(s == VariableRole_strings[i])
        {
            val = (VariableRole)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: ScatterAttributes::ScatterAttributes
//
// Purpose: 
//   Constructor for the ScatterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 1 15:16:09 PST 2004
//
// Modifications:
//   
// ****************************************************************************

ScatterAttributes::ScatterAttributes() : AttributeSubject("ibbddidisbbddidisbbddidisbbddiddibsabb"),
    colorTableName("hot"), singleColor(255, 0, 0)
{
    var1Role = Coordinate0;
    var1MinFlag = false;
    var1MaxFlag = false;
    var1Min = 0;
    var1Max = 1;
    var1Scaling = Linear;
    var1SkewFactor = 1;
    var2Role = Coordinate1;
    var2 = "default";
    var2MinFlag = false;
    var2MaxFlag = false;
    var2Min = 0;
    var2Max = 1;
    var2Scaling = Linear;
    var2SkewFactor = 1;
    var3Role = None;
    var3 = "default";
    var3MinFlag = false;
    var3MaxFlag = false;
    var3Min = 0;
    var3Max = 1;
    var3Scaling = Linear;
    var3SkewFactor = 1;
    var4Role = None;
    var4 = "default";
    var4MinFlag = false;
    var4MaxFlag = false;
    var4Min = 0;
    var4Max = 1;
    var4Scaling = Linear;
    var4SkewFactor = 1;
    pointSize = 0.05;
    pointType = Point;
    scaleCube = true;
    foregroundFlag = true;
    legendFlag = true;
}

// ****************************************************************************
// Method: ScatterAttributes::ScatterAttributes
//
// Purpose: 
//   Copy constructor for the ScatterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 1 15:16:09 PST 2004
//
// Modifications:
//   
// ****************************************************************************

ScatterAttributes::ScatterAttributes(const ScatterAttributes &obj) : AttributeSubject("ibbddidisbbddidisbbddidisbbddiddibsabb")
{
    var1Role = obj.var1Role;
    var1MinFlag = obj.var1MinFlag;
    var1MaxFlag = obj.var1MaxFlag;
    var1Min = obj.var1Min;
    var1Max = obj.var1Max;
    var1Scaling = obj.var1Scaling;
    var1SkewFactor = obj.var1SkewFactor;
    var2Role = obj.var2Role;
    var2 = obj.var2;
    var2MinFlag = obj.var2MinFlag;
    var2MaxFlag = obj.var2MaxFlag;
    var2Min = obj.var2Min;
    var2Max = obj.var2Max;
    var2Scaling = obj.var2Scaling;
    var2SkewFactor = obj.var2SkewFactor;
    var3Role = obj.var3Role;
    var3 = obj.var3;
    var3MinFlag = obj.var3MinFlag;
    var3MaxFlag = obj.var3MaxFlag;
    var3Min = obj.var3Min;
    var3Max = obj.var3Max;
    var3Scaling = obj.var3Scaling;
    var3SkewFactor = obj.var3SkewFactor;
    var4Role = obj.var4Role;
    var4 = obj.var4;
    var4MinFlag = obj.var4MinFlag;
    var4MaxFlag = obj.var4MaxFlag;
    var4Min = obj.var4Min;
    var4Max = obj.var4Max;
    var4Scaling = obj.var4Scaling;
    var4SkewFactor = obj.var4SkewFactor;
    pointSize = obj.pointSize;
    pointType = obj.pointType;
    scaleCube = obj.scaleCube;
    colorTableName = obj.colorTableName;
    singleColor = obj.singleColor;
    foregroundFlag = obj.foregroundFlag;
    legendFlag = obj.legendFlag;

    SelectAll();
}

// ****************************************************************************
// Method: ScatterAttributes::~ScatterAttributes
//
// Purpose: 
//   Destructor for the ScatterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 1 15:16:09 PST 2004
//
// Modifications:
//   
// ****************************************************************************

ScatterAttributes::~ScatterAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ScatterAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ScatterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 1 15:16:09 PST 2004
//
// Modifications:
//   
// ****************************************************************************

ScatterAttributes& 
ScatterAttributes::operator = (const ScatterAttributes &obj)
{
    if (this == &obj) return *this;
    var1Role = obj.var1Role;
    var1MinFlag = obj.var1MinFlag;
    var1MaxFlag = obj.var1MaxFlag;
    var1Min = obj.var1Min;
    var1Max = obj.var1Max;
    var1Scaling = obj.var1Scaling;
    var1SkewFactor = obj.var1SkewFactor;
    var2Role = obj.var2Role;
    var2 = obj.var2;
    var2MinFlag = obj.var2MinFlag;
    var2MaxFlag = obj.var2MaxFlag;
    var2Min = obj.var2Min;
    var2Max = obj.var2Max;
    var2Scaling = obj.var2Scaling;
    var2SkewFactor = obj.var2SkewFactor;
    var3Role = obj.var3Role;
    var3 = obj.var3;
    var3MinFlag = obj.var3MinFlag;
    var3MaxFlag = obj.var3MaxFlag;
    var3Min = obj.var3Min;
    var3Max = obj.var3Max;
    var3Scaling = obj.var3Scaling;
    var3SkewFactor = obj.var3SkewFactor;
    var4Role = obj.var4Role;
    var4 = obj.var4;
    var4MinFlag = obj.var4MinFlag;
    var4MaxFlag = obj.var4MaxFlag;
    var4Min = obj.var4Min;
    var4Max = obj.var4Max;
    var4Scaling = obj.var4Scaling;
    var4SkewFactor = obj.var4SkewFactor;
    pointSize = obj.pointSize;
    pointType = obj.pointType;
    scaleCube = obj.scaleCube;
    colorTableName = obj.colorTableName;
    singleColor = obj.singleColor;
    foregroundFlag = obj.foregroundFlag;
    legendFlag = obj.legendFlag;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: ScatterAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ScatterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 1 15:16:09 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
ScatterAttributes::operator == (const ScatterAttributes &obj) const
{
    // Create the return value
    return ((var1Role == obj.var1Role) &&
            (var1MinFlag == obj.var1MinFlag) &&
            (var1MaxFlag == obj.var1MaxFlag) &&
            (var1Min == obj.var1Min) &&
            (var1Max == obj.var1Max) &&
            (var1Scaling == obj.var1Scaling) &&
            (var1SkewFactor == obj.var1SkewFactor) &&
            (var2Role == obj.var2Role) &&
            (var2 == obj.var2) &&
            (var2MinFlag == obj.var2MinFlag) &&
            (var2MaxFlag == obj.var2MaxFlag) &&
            (var2Min == obj.var2Min) &&
            (var2Max == obj.var2Max) &&
            (var2Scaling == obj.var2Scaling) &&
            (var2SkewFactor == obj.var2SkewFactor) &&
            (var3Role == obj.var3Role) &&
            (var3 == obj.var3) &&
            (var3MinFlag == obj.var3MinFlag) &&
            (var3MaxFlag == obj.var3MaxFlag) &&
            (var3Min == obj.var3Min) &&
            (var3Max == obj.var3Max) &&
            (var3Scaling == obj.var3Scaling) &&
            (var3SkewFactor == obj.var3SkewFactor) &&
            (var4Role == obj.var4Role) &&
            (var4 == obj.var4) &&
            (var4MinFlag == obj.var4MinFlag) &&
            (var4MaxFlag == obj.var4MaxFlag) &&
            (var4Min == obj.var4Min) &&
            (var4Max == obj.var4Max) &&
            (var4Scaling == obj.var4Scaling) &&
            (var4SkewFactor == obj.var4SkewFactor) &&
            (pointSize == obj.pointSize) &&
            (pointType == obj.pointType) &&
            (scaleCube == obj.scaleCube) &&
            (colorTableName == obj.colorTableName) &&
            (singleColor == obj.singleColor) &&
            (foregroundFlag == obj.foregroundFlag) &&
            (legendFlag == obj.legendFlag));
}

// ****************************************************************************
// Method: ScatterAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ScatterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 1 15:16:09 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
ScatterAttributes::operator != (const ScatterAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ScatterAttributes::TypeName
//
// Purpose: 
//   Type name method for the ScatterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 1 15:16:09 PST 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
ScatterAttributes::TypeName() const
{
    return "ScatterAttributes";
}

// ****************************************************************************
// Method: ScatterAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ScatterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 1 15:16:09 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
ScatterAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ScatterAttributes *tmp = (const ScatterAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ScatterAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ScatterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 1 15:16:09 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ScatterAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ScatterAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ScatterAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ScatterAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 1 15:16:09 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ScatterAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ScatterAttributes(*this);
    else
        retval = new ScatterAttributes;

    return retval;
}

// ****************************************************************************
// Method: ScatterAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 1 15:16:09 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
ScatterAttributes::SelectAll()
{
    Select(0, (void *)&var1Role);
    Select(1, (void *)&var1MinFlag);
    Select(2, (void *)&var1MaxFlag);
    Select(3, (void *)&var1Min);
    Select(4, (void *)&var1Max);
    Select(5, (void *)&var1Scaling);
    Select(6, (void *)&var1SkewFactor);
    Select(7, (void *)&var2Role);
    Select(8, (void *)&var2);
    Select(9, (void *)&var2MinFlag);
    Select(10, (void *)&var2MaxFlag);
    Select(11, (void *)&var2Min);
    Select(12, (void *)&var2Max);
    Select(13, (void *)&var2Scaling);
    Select(14, (void *)&var2SkewFactor);
    Select(15, (void *)&var3Role);
    Select(16, (void *)&var3);
    Select(17, (void *)&var3MinFlag);
    Select(18, (void *)&var3MaxFlag);
    Select(19, (void *)&var3Min);
    Select(20, (void *)&var3Max);
    Select(21, (void *)&var3Scaling);
    Select(22, (void *)&var3SkewFactor);
    Select(23, (void *)&var4Role);
    Select(24, (void *)&var4);
    Select(25, (void *)&var4MinFlag);
    Select(26, (void *)&var4MaxFlag);
    Select(27, (void *)&var4Min);
    Select(28, (void *)&var4Max);
    Select(29, (void *)&var4Scaling);
    Select(30, (void *)&var4SkewFactor);
    Select(31, (void *)&pointSize);
    Select(32, (void *)&pointType);
    Select(33, (void *)&scaleCube);
    Select(34, (void *)&colorTableName);
    Select(35, (void *)&singleColor);
    Select(36, (void *)&foregroundFlag);
    Select(37, (void *)&legendFlag);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ScatterAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 1 15:16:09 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
ScatterAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ScatterAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ScatterAttributes.
    DataNode *node = new DataNode("ScatterAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var1Role", VariableRole_ToString(var1Role)));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var1MinFlag", var1MinFlag));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var1MaxFlag", var1MaxFlag));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var1Min", var1Min));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var1Max", var1Max));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var1Scaling", Scaling_ToString(var1Scaling)));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var1SkewFactor", var1SkewFactor));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var2Role", VariableRole_ToString(var2Role)));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var2", var2));
    }

    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var2MinFlag", var2MinFlag));
    }

    if(completeSave || !FieldsEqual(10, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var2MaxFlag", var2MaxFlag));
    }

    if(completeSave || !FieldsEqual(11, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var2Min", var2Min));
    }

    if(completeSave || !FieldsEqual(12, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var2Max", var2Max));
    }

    if(completeSave || !FieldsEqual(13, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var2Scaling", Scaling_ToString(var2Scaling)));
    }

    if(completeSave || !FieldsEqual(14, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var2SkewFactor", var2SkewFactor));
    }

    if(completeSave || !FieldsEqual(15, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var3Role", VariableRole_ToString(var3Role)));
    }

    if(completeSave || !FieldsEqual(16, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var3", var3));
    }

    if(completeSave || !FieldsEqual(17, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var3MinFlag", var3MinFlag));
    }

    if(completeSave || !FieldsEqual(18, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var3MaxFlag", var3MaxFlag));
    }

    if(completeSave || !FieldsEqual(19, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var3Min", var3Min));
    }

    if(completeSave || !FieldsEqual(20, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var3Max", var3Max));
    }

    if(completeSave || !FieldsEqual(21, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var3Scaling", Scaling_ToString(var3Scaling)));
    }

    if(completeSave || !FieldsEqual(22, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var3SkewFactor", var3SkewFactor));
    }

    if(completeSave || !FieldsEqual(23, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var4Role", VariableRole_ToString(var4Role)));
    }

    if(completeSave || !FieldsEqual(24, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var4", var4));
    }

    if(completeSave || !FieldsEqual(25, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var4MinFlag", var4MinFlag));
    }

    if(completeSave || !FieldsEqual(26, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var4MaxFlag", var4MaxFlag));
    }

    if(completeSave || !FieldsEqual(27, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var4Min", var4Min));
    }

    if(completeSave || !FieldsEqual(28, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var4Max", var4Max));
    }

    if(completeSave || !FieldsEqual(29, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var4Scaling", Scaling_ToString(var4Scaling)));
    }

    if(completeSave || !FieldsEqual(30, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("var4SkewFactor", var4SkewFactor));
    }

    if(completeSave || !FieldsEqual(31, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("pointSize", pointSize));
    }

    if(completeSave || !FieldsEqual(32, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("pointType", PointType_ToString(pointType)));
    }

    if(completeSave || !FieldsEqual(33, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scaleCube", scaleCube));
    }

    if(completeSave || !FieldsEqual(34, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("colorTableName", colorTableName));
    }

        DataNode *singleColorNode = new DataNode("singleColor");
        if(singleColor.CreateNode(singleColorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(singleColorNode);
        }
        else
            delete singleColorNode;
    if(completeSave || !FieldsEqual(36, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("foregroundFlag", foregroundFlag));
    }

    if(completeSave || !FieldsEqual(37, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("legendFlag", legendFlag));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ScatterAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 1 15:16:09 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
ScatterAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ScatterAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("var1Role")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 5)
                SetVar1Role(VariableRole(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            VariableRole value;
            if(VariableRole_FromString(node->AsString(), value))
                SetVar1Role(value);
        }
    }
    if((node = searchNode->GetNode("var1MinFlag")) != 0)
        SetVar1MinFlag(node->AsBool());
    if((node = searchNode->GetNode("var1MaxFlag")) != 0)
        SetVar1MaxFlag(node->AsBool());
    if((node = searchNode->GetNode("var1Min")) != 0)
        SetVar1Min(node->AsDouble());
    if((node = searchNode->GetNode("var1Max")) != 0)
        SetVar1Max(node->AsDouble());
    if((node = searchNode->GetNode("var1Scaling")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetVar1Scaling(Scaling(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Scaling value;
            if(Scaling_FromString(node->AsString(), value))
                SetVar1Scaling(value);
        }
    }
    if((node = searchNode->GetNode("var1SkewFactor")) != 0)
        SetVar1SkewFactor(node->AsDouble());
    if((node = searchNode->GetNode("var2Role")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 5)
                SetVar2Role(VariableRole(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            VariableRole value;
            if(VariableRole_FromString(node->AsString(), value))
                SetVar2Role(value);
        }
    }
    if((node = searchNode->GetNode("var2")) != 0)
        SetVar2(node->AsString());
    if((node = searchNode->GetNode("var2MinFlag")) != 0)
        SetVar2MinFlag(node->AsBool());
    if((node = searchNode->GetNode("var2MaxFlag")) != 0)
        SetVar2MaxFlag(node->AsBool());
    if((node = searchNode->GetNode("var2Min")) != 0)
        SetVar2Min(node->AsDouble());
    if((node = searchNode->GetNode("var2Max")) != 0)
        SetVar2Max(node->AsDouble());
    if((node = searchNode->GetNode("var2Scaling")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetVar2Scaling(Scaling(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Scaling value;
            if(Scaling_FromString(node->AsString(), value))
                SetVar2Scaling(value);
        }
    }
    if((node = searchNode->GetNode("var2SkewFactor")) != 0)
        SetVar2SkewFactor(node->AsDouble());
    if((node = searchNode->GetNode("var3Role")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 5)
                SetVar3Role(VariableRole(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            VariableRole value;
            if(VariableRole_FromString(node->AsString(), value))
                SetVar3Role(value);
        }
    }
    if((node = searchNode->GetNode("var3")) != 0)
        SetVar3(node->AsString());
    if((node = searchNode->GetNode("var3MinFlag")) != 0)
        SetVar3MinFlag(node->AsBool());
    if((node = searchNode->GetNode("var3MaxFlag")) != 0)
        SetVar3MaxFlag(node->AsBool());
    if((node = searchNode->GetNode("var3Min")) != 0)
        SetVar3Min(node->AsDouble());
    if((node = searchNode->GetNode("var3Max")) != 0)
        SetVar3Max(node->AsDouble());
    if((node = searchNode->GetNode("var3Scaling")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetVar3Scaling(Scaling(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Scaling value;
            if(Scaling_FromString(node->AsString(), value))
                SetVar3Scaling(value);
        }
    }
    if((node = searchNode->GetNode("var3SkewFactor")) != 0)
        SetVar3SkewFactor(node->AsDouble());
    if((node = searchNode->GetNode("var4Role")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 5)
                SetVar4Role(VariableRole(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            VariableRole value;
            if(VariableRole_FromString(node->AsString(), value))
                SetVar4Role(value);
        }
    }
    if((node = searchNode->GetNode("var4")) != 0)
        SetVar4(node->AsString());
    if((node = searchNode->GetNode("var4MinFlag")) != 0)
        SetVar4MinFlag(node->AsBool());
    if((node = searchNode->GetNode("var4MaxFlag")) != 0)
        SetVar4MaxFlag(node->AsBool());
    if((node = searchNode->GetNode("var4Min")) != 0)
        SetVar4Min(node->AsDouble());
    if((node = searchNode->GetNode("var4Max")) != 0)
        SetVar4Max(node->AsDouble());
    if((node = searchNode->GetNode("var4Scaling")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetVar4Scaling(Scaling(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Scaling value;
            if(Scaling_FromString(node->AsString(), value))
                SetVar4Scaling(value);
        }
    }
    if((node = searchNode->GetNode("var4SkewFactor")) != 0)
        SetVar4SkewFactor(node->AsDouble());
    if((node = searchNode->GetNode("pointSize")) != 0)
        SetPointSize(node->AsDouble());
    if((node = searchNode->GetNode("pointType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 4)
                SetPointType(PointType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            PointType value;
            if(PointType_FromString(node->AsString(), value))
                SetPointType(value);
        }
    }
    if((node = searchNode->GetNode("scaleCube")) != 0)
        SetScaleCube(node->AsBool());
    if((node = searchNode->GetNode("colorTableName")) != 0)
        SetColorTableName(node->AsString());
    if((node = searchNode->GetNode("singleColor")) != 0)
        singleColor.SetFromNode(node);
    if((node = searchNode->GetNode("foregroundFlag")) != 0)
        SetForegroundFlag(node->AsBool());
    if((node = searchNode->GetNode("legendFlag")) != 0)
        SetLegendFlag(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ScatterAttributes::SetVar1Role(ScatterAttributes::VariableRole var1Role_)
{
    var1Role = var1Role_;
    Select(0, (void *)&var1Role);
}

void
ScatterAttributes::SetVar1MinFlag(bool var1MinFlag_)
{
    var1MinFlag = var1MinFlag_;
    Select(1, (void *)&var1MinFlag);
}

void
ScatterAttributes::SetVar1MaxFlag(bool var1MaxFlag_)
{
    var1MaxFlag = var1MaxFlag_;
    Select(2, (void *)&var1MaxFlag);
}

void
ScatterAttributes::SetVar1Min(double var1Min_)
{
    var1Min = var1Min_;
    Select(3, (void *)&var1Min);
}

void
ScatterAttributes::SetVar1Max(double var1Max_)
{
    var1Max = var1Max_;
    Select(4, (void *)&var1Max);
}

void
ScatterAttributes::SetVar1Scaling(ScatterAttributes::Scaling var1Scaling_)
{
    var1Scaling = var1Scaling_;
    Select(5, (void *)&var1Scaling);
}

void
ScatterAttributes::SetVar1SkewFactor(double var1SkewFactor_)
{
    var1SkewFactor = var1SkewFactor_;
    Select(6, (void *)&var1SkewFactor);
}

void
ScatterAttributes::SetVar2Role(ScatterAttributes::VariableRole var2Role_)
{
    var2Role = var2Role_;
    Select(7, (void *)&var2Role);
}

void
ScatterAttributes::SetVar2(const std::string &var2_)
{
    var2 = var2_;
    Select(8, (void *)&var2);
}

void
ScatterAttributes::SetVar2MinFlag(bool var2MinFlag_)
{
    var2MinFlag = var2MinFlag_;
    Select(9, (void *)&var2MinFlag);
}

void
ScatterAttributes::SetVar2MaxFlag(bool var2MaxFlag_)
{
    var2MaxFlag = var2MaxFlag_;
    Select(10, (void *)&var2MaxFlag);
}

void
ScatterAttributes::SetVar2Min(double var2Min_)
{
    var2Min = var2Min_;
    Select(11, (void *)&var2Min);
}

void
ScatterAttributes::SetVar2Max(double var2Max_)
{
    var2Max = var2Max_;
    Select(12, (void *)&var2Max);
}

void
ScatterAttributes::SetVar2Scaling(ScatterAttributes::Scaling var2Scaling_)
{
    var2Scaling = var2Scaling_;
    Select(13, (void *)&var2Scaling);
}

void
ScatterAttributes::SetVar2SkewFactor(double var2SkewFactor_)
{
    var2SkewFactor = var2SkewFactor_;
    Select(14, (void *)&var2SkewFactor);
}

void
ScatterAttributes::SetVar3Role(ScatterAttributes::VariableRole var3Role_)
{
    var3Role = var3Role_;
    Select(15, (void *)&var3Role);
}

void
ScatterAttributes::SetVar3(const std::string &var3_)
{
    var3 = var3_;
    Select(16, (void *)&var3);
}

void
ScatterAttributes::SetVar3MinFlag(bool var3MinFlag_)
{
    var3MinFlag = var3MinFlag_;
    Select(17, (void *)&var3MinFlag);
}

void
ScatterAttributes::SetVar3MaxFlag(bool var3MaxFlag_)
{
    var3MaxFlag = var3MaxFlag_;
    Select(18, (void *)&var3MaxFlag);
}

void
ScatterAttributes::SetVar3Min(double var3Min_)
{
    var3Min = var3Min_;
    Select(19, (void *)&var3Min);
}

void
ScatterAttributes::SetVar3Max(double var3Max_)
{
    var3Max = var3Max_;
    Select(20, (void *)&var3Max);
}

void
ScatterAttributes::SetVar3Scaling(ScatterAttributes::Scaling var3Scaling_)
{
    var3Scaling = var3Scaling_;
    Select(21, (void *)&var3Scaling);
}

void
ScatterAttributes::SetVar3SkewFactor(double var3SkewFactor_)
{
    var3SkewFactor = var3SkewFactor_;
    Select(22, (void *)&var3SkewFactor);
}

void
ScatterAttributes::SetVar4Role(ScatterAttributes::VariableRole var4Role_)
{
    var4Role = var4Role_;
    Select(23, (void *)&var4Role);
}

void
ScatterAttributes::SetVar4(const std::string &var4_)
{
    var4 = var4_;
    Select(24, (void *)&var4);
}

void
ScatterAttributes::SetVar4MinFlag(bool var4MinFlag_)
{
    var4MinFlag = var4MinFlag_;
    Select(25, (void *)&var4MinFlag);
}

void
ScatterAttributes::SetVar4MaxFlag(bool var4MaxFlag_)
{
    var4MaxFlag = var4MaxFlag_;
    Select(26, (void *)&var4MaxFlag);
}

void
ScatterAttributes::SetVar4Min(double var4Min_)
{
    var4Min = var4Min_;
    Select(27, (void *)&var4Min);
}

void
ScatterAttributes::SetVar4Max(double var4Max_)
{
    var4Max = var4Max_;
    Select(28, (void *)&var4Max);
}

void
ScatterAttributes::SetVar4Scaling(ScatterAttributes::Scaling var4Scaling_)
{
    var4Scaling = var4Scaling_;
    Select(29, (void *)&var4Scaling);
}

void
ScatterAttributes::SetVar4SkewFactor(double var4SkewFactor_)
{
    var4SkewFactor = var4SkewFactor_;
    Select(30, (void *)&var4SkewFactor);
}

void
ScatterAttributes::SetPointSize(double pointSize_)
{
    pointSize = pointSize_;
    Select(31, (void *)&pointSize);
}

void
ScatterAttributes::SetPointType(ScatterAttributes::PointType pointType_)
{
    pointType = pointType_;
    Select(32, (void *)&pointType);
}

void
ScatterAttributes::SetScaleCube(bool scaleCube_)
{
    scaleCube = scaleCube_;
    Select(33, (void *)&scaleCube);
}

void
ScatterAttributes::SetColorTableName(const std::string &colorTableName_)
{
    colorTableName = colorTableName_;
    Select(34, (void *)&colorTableName);
}

void
ScatterAttributes::SetSingleColor(const ColorAttribute &singleColor_)
{
    singleColor = singleColor_;
    Select(35, (void *)&singleColor);
}

void
ScatterAttributes::SetForegroundFlag(bool foregroundFlag_)
{
    foregroundFlag = foregroundFlag_;
    Select(36, (void *)&foregroundFlag);
}

void
ScatterAttributes::SetLegendFlag(bool legendFlag_)
{
    legendFlag = legendFlag_;
    Select(37, (void *)&legendFlag);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

ScatterAttributes::VariableRole
ScatterAttributes::GetVar1Role() const
{
    return VariableRole(var1Role);
}

bool
ScatterAttributes::GetVar1MinFlag() const
{
    return var1MinFlag;
}

bool
ScatterAttributes::GetVar1MaxFlag() const
{
    return var1MaxFlag;
}

double
ScatterAttributes::GetVar1Min() const
{
    return var1Min;
}

double
ScatterAttributes::GetVar1Max() const
{
    return var1Max;
}

ScatterAttributes::Scaling
ScatterAttributes::GetVar1Scaling() const
{
    return Scaling(var1Scaling);
}

double
ScatterAttributes::GetVar1SkewFactor() const
{
    return var1SkewFactor;
}

ScatterAttributes::VariableRole
ScatterAttributes::GetVar2Role() const
{
    return VariableRole(var2Role);
}

const std::string &
ScatterAttributes::GetVar2() const
{
    return var2;
}

std::string &
ScatterAttributes::GetVar2()
{
    return var2;
}

bool
ScatterAttributes::GetVar2MinFlag() const
{
    return var2MinFlag;
}

bool
ScatterAttributes::GetVar2MaxFlag() const
{
    return var2MaxFlag;
}

double
ScatterAttributes::GetVar2Min() const
{
    return var2Min;
}

double
ScatterAttributes::GetVar2Max() const
{
    return var2Max;
}

ScatterAttributes::Scaling
ScatterAttributes::GetVar2Scaling() const
{
    return Scaling(var2Scaling);
}

double
ScatterAttributes::GetVar2SkewFactor() const
{
    return var2SkewFactor;
}

ScatterAttributes::VariableRole
ScatterAttributes::GetVar3Role() const
{
    return VariableRole(var3Role);
}

const std::string &
ScatterAttributes::GetVar3() const
{
    return var3;
}

std::string &
ScatterAttributes::GetVar3()
{
    return var3;
}

bool
ScatterAttributes::GetVar3MinFlag() const
{
    return var3MinFlag;
}

bool
ScatterAttributes::GetVar3MaxFlag() const
{
    return var3MaxFlag;
}

double
ScatterAttributes::GetVar3Min() const
{
    return var3Min;
}

double
ScatterAttributes::GetVar3Max() const
{
    return var3Max;
}

ScatterAttributes::Scaling
ScatterAttributes::GetVar3Scaling() const
{
    return Scaling(var3Scaling);
}

double
ScatterAttributes::GetVar3SkewFactor() const
{
    return var3SkewFactor;
}

ScatterAttributes::VariableRole
ScatterAttributes::GetVar4Role() const
{
    return VariableRole(var4Role);
}

const std::string &
ScatterAttributes::GetVar4() const
{
    return var4;
}

std::string &
ScatterAttributes::GetVar4()
{
    return var4;
}

bool
ScatterAttributes::GetVar4MinFlag() const
{
    return var4MinFlag;
}

bool
ScatterAttributes::GetVar4MaxFlag() const
{
    return var4MaxFlag;
}

double
ScatterAttributes::GetVar4Min() const
{
    return var4Min;
}

double
ScatterAttributes::GetVar4Max() const
{
    return var4Max;
}

ScatterAttributes::Scaling
ScatterAttributes::GetVar4Scaling() const
{
    return Scaling(var4Scaling);
}

double
ScatterAttributes::GetVar4SkewFactor() const
{
    return var4SkewFactor;
}

double
ScatterAttributes::GetPointSize() const
{
    return pointSize;
}

ScatterAttributes::PointType
ScatterAttributes::GetPointType() const
{
    return PointType(pointType);
}

bool
ScatterAttributes::GetScaleCube() const
{
    return scaleCube;
}

const std::string &
ScatterAttributes::GetColorTableName() const
{
    return colorTableName;
}

std::string &
ScatterAttributes::GetColorTableName()
{
    return colorTableName;
}

const ColorAttribute &
ScatterAttributes::GetSingleColor() const
{
    return singleColor;
}

ColorAttribute &
ScatterAttributes::GetSingleColor()
{
    return singleColor;
}

bool
ScatterAttributes::GetForegroundFlag() const
{
    return foregroundFlag;
}

bool
ScatterAttributes::GetLegendFlag() const
{
    return legendFlag;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ScatterAttributes::SelectVar2()
{
    Select(8, (void *)&var2);
}

void
ScatterAttributes::SelectVar3()
{
    Select(16, (void *)&var3);
}

void
ScatterAttributes::SelectVar4()
{
    Select(24, (void *)&var4);
}

void
ScatterAttributes::SelectColorTableName()
{
    Select(34, (void *)&colorTableName);
}

void
ScatterAttributes::SelectSingleColor()
{
    Select(35, (void *)&singleColor);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ScatterAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 1 15:16:09 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
ScatterAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Variable 1 role";
        case 1:  return "Use variable 1 min";
        case 2:  return "Use variable 1 max";
        case 3:  return "Variable 1 Min";
        case 4:  return "Variable 1 Max";
        case 5:  return "Variable 1 scale";
        case 6:  return "Variable 1 skew factor";
        case 7:  return "Variable 2 role";
        case 8:  return "Variable 2";
        case 9:  return "Use variable 2 min";
        case 10:  return "Use variable 2 max";
        case 11:  return "Variable 2 Min";
        case 12:  return "Variable 2 Max";
        case 13:  return "Variable 2 scale";
        case 14:  return "Variable 2 skew factor";
        case 15:  return "Variable 3 role";
        case 16:  return "Variable 3";
        case 17:  return "Use variable 3 min";
        case 18:  return "Use variable 3 max";
        case 19:  return "Variable 3 Min";
        case 20:  return "Variable 3 Max";
        case 21:  return "Variable 3 scale";
        case 22:  return "Variable 3 skew factor";
        case 23:  return "Variable 4 role";
        case 24:  return "Variable 4";
        case 25:  return "Use Variable 4 min";
        case 26:  return "Use Variable 4 max";
        case 27:  return "Variable 4 Min";
        case 28:  return "Variable 4 Max";
        case 29:  return "Variable 4 scale";
        case 30:  return "Variable 4 skew factor";
        case 31:  return "Point size";
        case 32:  return "Point Type";
        case 33:  return "Scale to cube";
        case 34:  return "Color table";
        case 35:  return "Single color";
        case 36:  return "Use Foreground ";
        case 37:  return "Legend";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ScatterAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 1 15:16:09 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ScatterAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_enum;
        case 1:  return FieldType_bool;
        case 2:  return FieldType_bool;
        case 3:  return FieldType_double;
        case 4:  return FieldType_double;
        case 5:  return FieldType_enum;
        case 6:  return FieldType_double;
        case 7:  return FieldType_enum;
        case 8:  return FieldType_string;
        case 9:  return FieldType_bool;
        case 10:  return FieldType_bool;
        case 11:  return FieldType_double;
        case 12:  return FieldType_double;
        case 13:  return FieldType_enum;
        case 14:  return FieldType_double;
        case 15:  return FieldType_enum;
        case 16:  return FieldType_string;
        case 17:  return FieldType_bool;
        case 18:  return FieldType_bool;
        case 19:  return FieldType_double;
        case 20:  return FieldType_double;
        case 21:  return FieldType_enum;
        case 22:  return FieldType_double;
        case 23:  return FieldType_enum;
        case 24:  return FieldType_string;
        case 25:  return FieldType_bool;
        case 26:  return FieldType_bool;
        case 27:  return FieldType_double;
        case 28:  return FieldType_double;
        case 29:  return FieldType_enum;
        case 30:  return FieldType_double;
        case 31:  return FieldType_double;
        case 32:  return FieldType_enum;
        case 33:  return FieldType_bool;
        case 34:  return FieldType_colortable;
        case 35:  return FieldType_color;
        case 36:  return FieldType_bool;
        case 37:  return FieldType_bool;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ScatterAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 1 15:16:09 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
ScatterAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "enum";
        case 1:  return "bool";
        case 2:  return "bool";
        case 3:  return "double";
        case 4:  return "double";
        case 5:  return "enum";
        case 6:  return "double";
        case 7:  return "enum";
        case 8:  return "string";
        case 9:  return "bool";
        case 10:  return "bool";
        case 11:  return "double";
        case 12:  return "double";
        case 13:  return "enum";
        case 14:  return "double";
        case 15:  return "enum";
        case 16:  return "string";
        case 17:  return "bool";
        case 18:  return "bool";
        case 19:  return "double";
        case 20:  return "double";
        case 21:  return "enum";
        case 22:  return "double";
        case 23:  return "enum";
        case 24:  return "string";
        case 25:  return "bool";
        case 26:  return "bool";
        case 27:  return "double";
        case 28:  return "double";
        case 29:  return "enum";
        case 30:  return "double";
        case 31:  return "double";
        case 32:  return "enum";
        case 33:  return "bool";
        case 34:  return "colortable";
        case 35:  return "color";
        case 36:  return "bool";
        case 37:  return "bool";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ScatterAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Wed Dec 1 15:16:09 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
ScatterAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ScatterAttributes &obj = *((const ScatterAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (var1Role == obj.var1Role);
        }
        break;
    case 1:
        {  // new scope
        retval = (var1MinFlag == obj.var1MinFlag);
        }
        break;
    case 2:
        {  // new scope
        retval = (var1MaxFlag == obj.var1MaxFlag);
        }
        break;
    case 3:
        {  // new scope
        retval = (var1Min == obj.var1Min);
        }
        break;
    case 4:
        {  // new scope
        retval = (var1Max == obj.var1Max);
        }
        break;
    case 5:
        {  // new scope
        retval = (var1Scaling == obj.var1Scaling);
        }
        break;
    case 6:
        {  // new scope
        retval = (var1SkewFactor == obj.var1SkewFactor);
        }
        break;
    case 7:
        {  // new scope
        retval = (var2Role == obj.var2Role);
        }
        break;
    case 8:
        {  // new scope
        retval = (var2 == obj.var2);
        }
        break;
    case 9:
        {  // new scope
        retval = (var2MinFlag == obj.var2MinFlag);
        }
        break;
    case 10:
        {  // new scope
        retval = (var2MaxFlag == obj.var2MaxFlag);
        }
        break;
    case 11:
        {  // new scope
        retval = (var2Min == obj.var2Min);
        }
        break;
    case 12:
        {  // new scope
        retval = (var2Max == obj.var2Max);
        }
        break;
    case 13:
        {  // new scope
        retval = (var2Scaling == obj.var2Scaling);
        }
        break;
    case 14:
        {  // new scope
        retval = (var2SkewFactor == obj.var2SkewFactor);
        }
        break;
    case 15:
        {  // new scope
        retval = (var3Role == obj.var3Role);
        }
        break;
    case 16:
        {  // new scope
        retval = (var3 == obj.var3);
        }
        break;
    case 17:
        {  // new scope
        retval = (var3MinFlag == obj.var3MinFlag);
        }
        break;
    case 18:
        {  // new scope
        retval = (var3MaxFlag == obj.var3MaxFlag);
        }
        break;
    case 19:
        {  // new scope
        retval = (var3Min == obj.var3Min);
        }
        break;
    case 20:
        {  // new scope
        retval = (var3Max == obj.var3Max);
        }
        break;
    case 21:
        {  // new scope
        retval = (var3Scaling == obj.var3Scaling);
        }
        break;
    case 22:
        {  // new scope
        retval = (var3SkewFactor == obj.var3SkewFactor);
        }
        break;
    case 23:
        {  // new scope
        retval = (var4Role == obj.var4Role);
        }
        break;
    case 24:
        {  // new scope
        retval = (var4 == obj.var4);
        }
        break;
    case 25:
        {  // new scope
        retval = (var4MinFlag == obj.var4MinFlag);
        }
        break;
    case 26:
        {  // new scope
        retval = (var4MaxFlag == obj.var4MaxFlag);
        }
        break;
    case 27:
        {  // new scope
        retval = (var4Min == obj.var4Min);
        }
        break;
    case 28:
        {  // new scope
        retval = (var4Max == obj.var4Max);
        }
        break;
    case 29:
        {  // new scope
        retval = (var4Scaling == obj.var4Scaling);
        }
        break;
    case 30:
        {  // new scope
        retval = (var4SkewFactor == obj.var4SkewFactor);
        }
        break;
    case 31:
        {  // new scope
        retval = (pointSize == obj.pointSize);
        }
        break;
    case 32:
        {  // new scope
        retval = (pointType == obj.pointType);
        }
        break;
    case 33:
        {  // new scope
        retval = (scaleCube == obj.scaleCube);
        }
        break;
    case 34:
        {  // new scope
        retval = (colorTableName == obj.colorTableName);
        }
        break;
    case 35:
        {  // new scope
        retval = (singleColor == obj.singleColor);
        }
        break;
    case 36:
        {  // new scope
        retval = (foregroundFlag == obj.foregroundFlag);
        }
        break;
    case 37:
        {  // new scope
        retval = (legendFlag == obj.legendFlag);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Modifications:
//
// ****************************************************************************
bool
ScatterAttributes::ChangesRequireRecalculation(const ScatterAttributes &obj) const
{
    bool var1Changed = false;
    if(var1Role != None && var1Role != Color)
    {
        bool minMaxChanged =
            var1MinFlag != obj.var1MinFlag ||
            var1MaxFlag != obj.var1MaxFlag ||
            var1Min != obj.var1Min ||
            var1Max != obj.var1Max;

        bool scalingChanged = 
            var1Scaling != obj.var1Scaling ||
            (var1Scaling == Skew && var1SkewFactor != obj.var1SkewFactor);

        var1Changed = minMaxChanged || scalingChanged;
    }

    bool var2Changed = false;
    if(var2Role != None)
    {
        if(var2Role != Color)
        {
            bool minMaxChanged =
                var2MinFlag != obj.var2MinFlag ||
                var2MaxFlag != obj.var2MaxFlag ||
                var2Min != obj.var2Min ||
                var2Max != obj.var2Max;

            bool scalingChanged = 
                var2Scaling != obj.var2Scaling ||
                (var2Scaling == Skew && var2SkewFactor != obj.var2SkewFactor);

            var2Changed = var2 != obj.var2 || minMaxChanged || scalingChanged;
        }
        else
            var2Changed = var2 != obj.var2;
    }

    bool var3Changed = false;
    if(var3Role != None)
    {
        if(var3Role != Color)
        {
            bool minMaxChanged =
                var3MinFlag != obj.var3MinFlag ||
                var3MaxFlag != obj.var3MaxFlag ||
                var3Min != obj.var3Min ||
                var3Max != obj.var3Max;

            bool scalingChanged = 
                var3Scaling != obj.var3Scaling ||
                (var3Scaling == Skew && var3SkewFactor != obj.var3SkewFactor);

            var3Changed = var3 != obj.var3 || minMaxChanged || scalingChanged;
        }
        else
            var3Changed = var3 != obj.var3;
    }

    bool var4Changed = false;
    if(var4Role != None)
    {
        if(var4Role != Color)
        {
            bool minMaxChanged =
                var4MinFlag != obj.var4MinFlag ||
                var4MaxFlag != obj.var4MaxFlag ||
                var4Min != obj.var4Min ||
                var4Max != obj.var4Max;

            bool scalingChanged = 
                var4Scaling != obj.var4Scaling ||
                (var4Scaling == Skew && var4SkewFactor != obj.var4SkewFactor);

            var4Changed = var4 != obj.var4 || minMaxChanged || scalingChanged;
        }
        else
            var4Changed = var4 != obj.var4;
    }

    return var1Role != obj.var1Role ||
           var2Role != obj.var2Role ||
           var3Role != obj.var3Role ||
           var4Role != obj.var4Role ||
           scaleCube != obj.scaleCube ||
           var1Changed ||
           var2Changed ||
           var3Changed ||
           var4Changed;
}


