#include <PyScatterAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyScatterAttributes
//
// Purpose: 
//   Attributes for the scatter plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Nov 19 14:32:17 PST 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a ScatterAttributes.
//
struct ScatterAttributesObject
{
    PyObject_HEAD
    ScatterAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewScatterAttributes();

static PyObject *
ScatterAttributes_Notify(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_SetVar1Role(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var1Role in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetVar1Role(ScatterAttributes::VariableRole(ival));
    else
    {
        fprintf(stderr, "An invalid var1Role value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "Coordinate0, Coordinate1, Coordinate2, Color, None.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar1Role(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVar1Role()));
    return retval;
}

static PyObject *
ScatterAttributes_SetVar1MinFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var1MinFlag in the object.
    obj->data->SetVar1MinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar1MinFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVar1MinFlag()?1L:0L);
    return retval;
}

static PyObject *
ScatterAttributes_SetVar1MaxFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var1MaxFlag in the object.
    obj->data->SetVar1MaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar1MaxFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVar1MaxFlag()?1L:0L);
    return retval;
}

static PyObject *
ScatterAttributes_SetVar1Min(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var1Min in the object.
    obj->data->SetVar1Min(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar1Min(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar1Min());
    return retval;
}

static PyObject *
ScatterAttributes_SetVar1Max(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var1Max in the object.
    obj->data->SetVar1Max(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar1Max(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar1Max());
    return retval;
}

static PyObject *
ScatterAttributes_SetVar1Scaling(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var1Scaling in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetVar1Scaling(ScatterAttributes::Scaling(ival));
    else
    {
        fprintf(stderr, "An invalid var1Scaling value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Linear, Log, Skew.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar1Scaling(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVar1Scaling()));
    return retval;
}

static PyObject *
ScatterAttributes_SetVar1SkewFactor(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var1SkewFactor in the object.
    obj->data->SetVar1SkewFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar1SkewFactor(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar1SkewFactor());
    return retval;
}

static PyObject *
ScatterAttributes_SetVar2Role(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var2Role in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetVar2Role(ScatterAttributes::VariableRole(ival));
    else
    {
        fprintf(stderr, "An invalid var2Role value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "Coordinate0, Coordinate1, Coordinate2, Color, None.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar2Role(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVar2Role()));
    return retval;
}

static PyObject *
ScatterAttributes_SetVar2(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the var2 in the object.
    obj->data->SetVar2(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar2(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVar2().c_str());
    return retval;
}

static PyObject *
ScatterAttributes_SetVar2MinFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var2MinFlag in the object.
    obj->data->SetVar2MinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar2MinFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVar2MinFlag()?1L:0L);
    return retval;
}

static PyObject *
ScatterAttributes_SetVar2MaxFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var2MaxFlag in the object.
    obj->data->SetVar2MaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar2MaxFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVar2MaxFlag()?1L:0L);
    return retval;
}

static PyObject *
ScatterAttributes_SetVar2Min(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var2Min in the object.
    obj->data->SetVar2Min(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar2Min(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar2Min());
    return retval;
}

static PyObject *
ScatterAttributes_SetVar2Max(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var2Max in the object.
    obj->data->SetVar2Max(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar2Max(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar2Max());
    return retval;
}

static PyObject *
ScatterAttributes_SetVar2Scaling(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var2Scaling in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetVar2Scaling(ScatterAttributes::Scaling(ival));
    else
    {
        fprintf(stderr, "An invalid var2Scaling value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Linear, Log, Skew.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar2Scaling(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVar2Scaling()));
    return retval;
}

static PyObject *
ScatterAttributes_SetVar2SkewFactor(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var2SkewFactor in the object.
    obj->data->SetVar2SkewFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar2SkewFactor(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar2SkewFactor());
    return retval;
}

static PyObject *
ScatterAttributes_SetVar3Role(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var3Role in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetVar3Role(ScatterAttributes::VariableRole(ival));
    else
    {
        fprintf(stderr, "An invalid var3Role value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "Coordinate0, Coordinate1, Coordinate2, Color, None.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar3Role(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVar3Role()));
    return retval;
}

static PyObject *
ScatterAttributes_SetVar3(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the var3 in the object.
    obj->data->SetVar3(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar3(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVar3().c_str());
    return retval;
}

static PyObject *
ScatterAttributes_SetVar3MinFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var3MinFlag in the object.
    obj->data->SetVar3MinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar3MinFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVar3MinFlag()?1L:0L);
    return retval;
}

static PyObject *
ScatterAttributes_SetVar3MaxFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var3MaxFlag in the object.
    obj->data->SetVar3MaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar3MaxFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVar3MaxFlag()?1L:0L);
    return retval;
}

static PyObject *
ScatterAttributes_SetVar3Min(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var3Min in the object.
    obj->data->SetVar3Min(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar3Min(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar3Min());
    return retval;
}

static PyObject *
ScatterAttributes_SetVar3Max(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var3Max in the object.
    obj->data->SetVar3Max(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar3Max(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar3Max());
    return retval;
}

static PyObject *
ScatterAttributes_SetVar3Scaling(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var3Scaling in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetVar3Scaling(ScatterAttributes::Scaling(ival));
    else
    {
        fprintf(stderr, "An invalid var3Scaling value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Linear, Log, Skew.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar3Scaling(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVar3Scaling()));
    return retval;
}

static PyObject *
ScatterAttributes_SetVar3SkewFactor(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var3SkewFactor in the object.
    obj->data->SetVar3SkewFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar3SkewFactor(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar3SkewFactor());
    return retval;
}

static PyObject *
ScatterAttributes_SetVar4Role(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var4Role in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetVar4Role(ScatterAttributes::VariableRole(ival));
    else
    {
        fprintf(stderr, "An invalid var4Role value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "Coordinate0, Coordinate1, Coordinate2, Color, None.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar4Role(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVar4Role()));
    return retval;
}

static PyObject *
ScatterAttributes_SetVar4(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the var4 in the object.
    obj->data->SetVar4(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar4(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVar4().c_str());
    return retval;
}

static PyObject *
ScatterAttributes_SetVar4MinFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var4MinFlag in the object.
    obj->data->SetVar4MinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar4MinFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVar4MinFlag()?1L:0L);
    return retval;
}

static PyObject *
ScatterAttributes_SetVar4MaxFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var4MaxFlag in the object.
    obj->data->SetVar4MaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar4MaxFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVar4MaxFlag()?1L:0L);
    return retval;
}

static PyObject *
ScatterAttributes_SetVar4Min(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var4Min in the object.
    obj->data->SetVar4Min(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar4Min(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar4Min());
    return retval;
}

static PyObject *
ScatterAttributes_SetVar4Max(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var4Max in the object.
    obj->data->SetVar4Max(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar4Max(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar4Max());
    return retval;
}

static PyObject *
ScatterAttributes_SetVar4Scaling(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the var4Scaling in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetVar4Scaling(ScatterAttributes::Scaling(ival));
    else
    {
        fprintf(stderr, "An invalid var4Scaling value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Linear, Log, Skew.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar4Scaling(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVar4Scaling()));
    return retval;
}

static PyObject *
ScatterAttributes_SetVar4SkewFactor(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the var4SkewFactor in the object.
    obj->data->SetVar4SkewFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetVar4SkewFactor(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetVar4SkewFactor());
    return retval;
}

static PyObject *
ScatterAttributes_SetPointSize(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pointSize in the object.
    obj->data->SetPointSize(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetPointSize(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPointSize());
    return retval;
}

static PyObject *
ScatterAttributes_SetPointType(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointType in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetPointType(ScatterAttributes::PointType(ival));
    else
    {
        fprintf(stderr, "An invalid pointType value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "Box, Axis, Icosahedron, Point.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetPointType(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointType()));
    return retval;
}

static PyObject *
ScatterAttributes_SetScaleCube(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scaleCube in the object.
    obj->data->SetScaleCube(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetScaleCube(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetScaleCube()?1L:0L);
    return retval;
}

static PyObject *
ScatterAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

static PyObject *
ScatterAttributes_SetSingleColor(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the singleColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetSingleColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetSingleColor(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the singleColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *singleColor = obj->data->GetSingleColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(singleColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(singleColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(singleColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(singleColor[3])));
    return retval;
}

static PyObject *
ScatterAttributes_SetForegroundFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the foregroundFlag in the object.
    obj->data->SetForegroundFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetForegroundFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetForegroundFlag()?1L:0L);
    return retval;
}

static PyObject *
ScatterAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ScatterAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}



static struct PyMethodDef ScatterAttributes_methods[] = {
    {"Notify", ScatterAttributes_Notify, METH_VARARGS},
    {"SetVar1Role", ScatterAttributes_SetVar1Role, METH_VARARGS},
    {"GetVar1Role", ScatterAttributes_GetVar1Role, METH_VARARGS},
    {"SetVar1MinFlag", ScatterAttributes_SetVar1MinFlag, METH_VARARGS},
    {"GetVar1MinFlag", ScatterAttributes_GetVar1MinFlag, METH_VARARGS},
    {"SetVar1MaxFlag", ScatterAttributes_SetVar1MaxFlag, METH_VARARGS},
    {"GetVar1MaxFlag", ScatterAttributes_GetVar1MaxFlag, METH_VARARGS},
    {"SetVar1Min", ScatterAttributes_SetVar1Min, METH_VARARGS},
    {"GetVar1Min", ScatterAttributes_GetVar1Min, METH_VARARGS},
    {"SetVar1Max", ScatterAttributes_SetVar1Max, METH_VARARGS},
    {"GetVar1Max", ScatterAttributes_GetVar1Max, METH_VARARGS},
    {"SetVar1Scaling", ScatterAttributes_SetVar1Scaling, METH_VARARGS},
    {"GetVar1Scaling", ScatterAttributes_GetVar1Scaling, METH_VARARGS},
    {"SetVar1SkewFactor", ScatterAttributes_SetVar1SkewFactor, METH_VARARGS},
    {"GetVar1SkewFactor", ScatterAttributes_GetVar1SkewFactor, METH_VARARGS},
    {"SetVar2Role", ScatterAttributes_SetVar2Role, METH_VARARGS},
    {"GetVar2Role", ScatterAttributes_GetVar2Role, METH_VARARGS},
    {"SetVar2", ScatterAttributes_SetVar2, METH_VARARGS},
    {"GetVar2", ScatterAttributes_GetVar2, METH_VARARGS},
    {"SetVar2MinFlag", ScatterAttributes_SetVar2MinFlag, METH_VARARGS},
    {"GetVar2MinFlag", ScatterAttributes_GetVar2MinFlag, METH_VARARGS},
    {"SetVar2MaxFlag", ScatterAttributes_SetVar2MaxFlag, METH_VARARGS},
    {"GetVar2MaxFlag", ScatterAttributes_GetVar2MaxFlag, METH_VARARGS},
    {"SetVar2Min", ScatterAttributes_SetVar2Min, METH_VARARGS},
    {"GetVar2Min", ScatterAttributes_GetVar2Min, METH_VARARGS},
    {"SetVar2Max", ScatterAttributes_SetVar2Max, METH_VARARGS},
    {"GetVar2Max", ScatterAttributes_GetVar2Max, METH_VARARGS},
    {"SetVar2Scaling", ScatterAttributes_SetVar2Scaling, METH_VARARGS},
    {"GetVar2Scaling", ScatterAttributes_GetVar2Scaling, METH_VARARGS},
    {"SetVar2SkewFactor", ScatterAttributes_SetVar2SkewFactor, METH_VARARGS},
    {"GetVar2SkewFactor", ScatterAttributes_GetVar2SkewFactor, METH_VARARGS},
    {"SetVar3Role", ScatterAttributes_SetVar3Role, METH_VARARGS},
    {"GetVar3Role", ScatterAttributes_GetVar3Role, METH_VARARGS},
    {"SetVar3", ScatterAttributes_SetVar3, METH_VARARGS},
    {"GetVar3", ScatterAttributes_GetVar3, METH_VARARGS},
    {"SetVar3MinFlag", ScatterAttributes_SetVar3MinFlag, METH_VARARGS},
    {"GetVar3MinFlag", ScatterAttributes_GetVar3MinFlag, METH_VARARGS},
    {"SetVar3MaxFlag", ScatterAttributes_SetVar3MaxFlag, METH_VARARGS},
    {"GetVar3MaxFlag", ScatterAttributes_GetVar3MaxFlag, METH_VARARGS},
    {"SetVar3Min", ScatterAttributes_SetVar3Min, METH_VARARGS},
    {"GetVar3Min", ScatterAttributes_GetVar3Min, METH_VARARGS},
    {"SetVar3Max", ScatterAttributes_SetVar3Max, METH_VARARGS},
    {"GetVar3Max", ScatterAttributes_GetVar3Max, METH_VARARGS},
    {"SetVar3Scaling", ScatterAttributes_SetVar3Scaling, METH_VARARGS},
    {"GetVar3Scaling", ScatterAttributes_GetVar3Scaling, METH_VARARGS},
    {"SetVar3SkewFactor", ScatterAttributes_SetVar3SkewFactor, METH_VARARGS},
    {"GetVar3SkewFactor", ScatterAttributes_GetVar3SkewFactor, METH_VARARGS},
    {"SetVar4Role", ScatterAttributes_SetVar4Role, METH_VARARGS},
    {"GetVar4Role", ScatterAttributes_GetVar4Role, METH_VARARGS},
    {"SetVar4", ScatterAttributes_SetVar4, METH_VARARGS},
    {"GetVar4", ScatterAttributes_GetVar4, METH_VARARGS},
    {"SetVar4MinFlag", ScatterAttributes_SetVar4MinFlag, METH_VARARGS},
    {"GetVar4MinFlag", ScatterAttributes_GetVar4MinFlag, METH_VARARGS},
    {"SetVar4MaxFlag", ScatterAttributes_SetVar4MaxFlag, METH_VARARGS},
    {"GetVar4MaxFlag", ScatterAttributes_GetVar4MaxFlag, METH_VARARGS},
    {"SetVar4Min", ScatterAttributes_SetVar4Min, METH_VARARGS},
    {"GetVar4Min", ScatterAttributes_GetVar4Min, METH_VARARGS},
    {"SetVar4Max", ScatterAttributes_SetVar4Max, METH_VARARGS},
    {"GetVar4Max", ScatterAttributes_GetVar4Max, METH_VARARGS},
    {"SetVar4Scaling", ScatterAttributes_SetVar4Scaling, METH_VARARGS},
    {"GetVar4Scaling", ScatterAttributes_GetVar4Scaling, METH_VARARGS},
    {"SetVar4SkewFactor", ScatterAttributes_SetVar4SkewFactor, METH_VARARGS},
    {"GetVar4SkewFactor", ScatterAttributes_GetVar4SkewFactor, METH_VARARGS},
    {"SetPointSize", ScatterAttributes_SetPointSize, METH_VARARGS},
    {"GetPointSize", ScatterAttributes_GetPointSize, METH_VARARGS},
    {"SetPointType", ScatterAttributes_SetPointType, METH_VARARGS},
    {"GetPointType", ScatterAttributes_GetPointType, METH_VARARGS},
    {"SetScaleCube", ScatterAttributes_SetScaleCube, METH_VARARGS},
    {"GetScaleCube", ScatterAttributes_GetScaleCube, METH_VARARGS},
    {"SetColorTableName", ScatterAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", ScatterAttributes_GetColorTableName, METH_VARARGS},
    {"SetSingleColor", ScatterAttributes_SetSingleColor, METH_VARARGS},
    {"GetSingleColor", ScatterAttributes_GetSingleColor, METH_VARARGS},
    {"SetForegroundFlag", ScatterAttributes_SetForegroundFlag, METH_VARARGS},
    {"GetForegroundFlag", ScatterAttributes_GetForegroundFlag, METH_VARARGS},
    {"SetLegendFlag", ScatterAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", ScatterAttributes_GetLegendFlag, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ScatterAttributes_dealloc(PyObject *v)
{
   ScatterAttributesObject *obj = (ScatterAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
ScatterAttributes_compare(PyObject *v, PyObject *w)
{
    ScatterAttributes *a = ((ScatterAttributesObject *)v)->data;
    ScatterAttributes *b = ((ScatterAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
ScatterAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "var1Role") == 0)
        return ScatterAttributes_GetVar1Role(self, NULL);
    if(strcmp(name, "Coordinate0") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate0));
    else if(strcmp(name, "Coordinate1") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate1));
    else if(strcmp(name, "Coordinate2") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate2));
    else if(strcmp(name, "Color") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Color));
    else if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(ScatterAttributes::None));

    if(strcmp(name, "var1MinFlag") == 0)
        return ScatterAttributes_GetVar1MinFlag(self, NULL);
    if(strcmp(name, "var1MaxFlag") == 0)
        return ScatterAttributes_GetVar1MaxFlag(self, NULL);
    if(strcmp(name, "var1Min") == 0)
        return ScatterAttributes_GetVar1Min(self, NULL);
    if(strcmp(name, "var1Max") == 0)
        return ScatterAttributes_GetVar1Max(self, NULL);
    if(strcmp(name, "var1Scaling") == 0)
        return ScatterAttributes_GetVar1Scaling(self, NULL);
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Linear));
    else if(strcmp(name, "Log") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Log));
    else if(strcmp(name, "Skew") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Skew));

    if(strcmp(name, "var1SkewFactor") == 0)
        return ScatterAttributes_GetVar1SkewFactor(self, NULL);
    if(strcmp(name, "var2Role") == 0)
        return ScatterAttributes_GetVar2Role(self, NULL);
    if(strcmp(name, "Coordinate0") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate0));
    else if(strcmp(name, "Coordinate1") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate1));
    else if(strcmp(name, "Coordinate2") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate2));
    else if(strcmp(name, "Color") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Color));
    else if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(ScatterAttributes::None));

    if(strcmp(name, "var2") == 0)
        return ScatterAttributes_GetVar2(self, NULL);
    if(strcmp(name, "var2MinFlag") == 0)
        return ScatterAttributes_GetVar2MinFlag(self, NULL);
    if(strcmp(name, "var2MaxFlag") == 0)
        return ScatterAttributes_GetVar2MaxFlag(self, NULL);
    if(strcmp(name, "var2Min") == 0)
        return ScatterAttributes_GetVar2Min(self, NULL);
    if(strcmp(name, "var2Max") == 0)
        return ScatterAttributes_GetVar2Max(self, NULL);
    if(strcmp(name, "var2Scaling") == 0)
        return ScatterAttributes_GetVar2Scaling(self, NULL);
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Linear));
    else if(strcmp(name, "Log") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Log));
    else if(strcmp(name, "Skew") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Skew));

    if(strcmp(name, "var2SkewFactor") == 0)
        return ScatterAttributes_GetVar2SkewFactor(self, NULL);
    if(strcmp(name, "var3Role") == 0)
        return ScatterAttributes_GetVar3Role(self, NULL);
    if(strcmp(name, "Coordinate0") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate0));
    else if(strcmp(name, "Coordinate1") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate1));
    else if(strcmp(name, "Coordinate2") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate2));
    else if(strcmp(name, "Color") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Color));
    else if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(ScatterAttributes::None));

    if(strcmp(name, "var3") == 0)
        return ScatterAttributes_GetVar3(self, NULL);
    if(strcmp(name, "var3MinFlag") == 0)
        return ScatterAttributes_GetVar3MinFlag(self, NULL);
    if(strcmp(name, "var3MaxFlag") == 0)
        return ScatterAttributes_GetVar3MaxFlag(self, NULL);
    if(strcmp(name, "var3Min") == 0)
        return ScatterAttributes_GetVar3Min(self, NULL);
    if(strcmp(name, "var3Max") == 0)
        return ScatterAttributes_GetVar3Max(self, NULL);
    if(strcmp(name, "var3Scaling") == 0)
        return ScatterAttributes_GetVar3Scaling(self, NULL);
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Linear));
    else if(strcmp(name, "Log") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Log));
    else if(strcmp(name, "Skew") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Skew));

    if(strcmp(name, "var3SkewFactor") == 0)
        return ScatterAttributes_GetVar3SkewFactor(self, NULL);
    if(strcmp(name, "var4Role") == 0)
        return ScatterAttributes_GetVar4Role(self, NULL);
    if(strcmp(name, "Coordinate0") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate0));
    else if(strcmp(name, "Coordinate1") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate1));
    else if(strcmp(name, "Coordinate2") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Coordinate2));
    else if(strcmp(name, "Color") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Color));
    else if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(ScatterAttributes::None));

    if(strcmp(name, "var4") == 0)
        return ScatterAttributes_GetVar4(self, NULL);
    if(strcmp(name, "var4MinFlag") == 0)
        return ScatterAttributes_GetVar4MinFlag(self, NULL);
    if(strcmp(name, "var4MaxFlag") == 0)
        return ScatterAttributes_GetVar4MaxFlag(self, NULL);
    if(strcmp(name, "var4Min") == 0)
        return ScatterAttributes_GetVar4Min(self, NULL);
    if(strcmp(name, "var4Max") == 0)
        return ScatterAttributes_GetVar4Max(self, NULL);
    if(strcmp(name, "var4Scaling") == 0)
        return ScatterAttributes_GetVar4Scaling(self, NULL);
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Linear));
    else if(strcmp(name, "Log") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Log));
    else if(strcmp(name, "Skew") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Skew));

    if(strcmp(name, "var4SkewFactor") == 0)
        return ScatterAttributes_GetVar4SkewFactor(self, NULL);
    if(strcmp(name, "pointSize") == 0)
        return ScatterAttributes_GetPointSize(self, NULL);
    if(strcmp(name, "pointType") == 0)
        return ScatterAttributes_GetPointType(self, NULL);
    if(strcmp(name, "Box") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Box));
    else if(strcmp(name, "Axis") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Axis));
    else if(strcmp(name, "Icosahedron") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Icosahedron));
    else if(strcmp(name, "Point") == 0)
        return PyInt_FromLong(long(ScatterAttributes::Point));

    if(strcmp(name, "scaleCube") == 0)
        return ScatterAttributes_GetScaleCube(self, NULL);
    if(strcmp(name, "colorTableName") == 0)
        return ScatterAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "singleColor") == 0)
        return ScatterAttributes_GetSingleColor(self, NULL);
    if(strcmp(name, "foregroundFlag") == 0)
        return ScatterAttributes_GetForegroundFlag(self, NULL);
    if(strcmp(name, "legendFlag") == 0)
        return ScatterAttributes_GetLegendFlag(self, NULL);

    return Py_FindMethod(ScatterAttributes_methods, self, name);
}

static int
ScatterAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "var1Role") == 0)
        retval = (ScatterAttributes_SetVar1Role(self, tuple) != NULL);
    else if(strcmp(name, "var1MinFlag") == 0)
        retval = (ScatterAttributes_SetVar1MinFlag(self, tuple) != NULL);
    else if(strcmp(name, "var1MaxFlag") == 0)
        retval = (ScatterAttributes_SetVar1MaxFlag(self, tuple) != NULL);
    else if(strcmp(name, "var1Min") == 0)
        retval = (ScatterAttributes_SetVar1Min(self, tuple) != NULL);
    else if(strcmp(name, "var1Max") == 0)
        retval = (ScatterAttributes_SetVar1Max(self, tuple) != NULL);
    else if(strcmp(name, "var1Scaling") == 0)
        retval = (ScatterAttributes_SetVar1Scaling(self, tuple) != NULL);
    else if(strcmp(name, "var1SkewFactor") == 0)
        retval = (ScatterAttributes_SetVar1SkewFactor(self, tuple) != NULL);
    else if(strcmp(name, "var2Role") == 0)
        retval = (ScatterAttributes_SetVar2Role(self, tuple) != NULL);
    else if(strcmp(name, "var2") == 0)
        retval = (ScatterAttributes_SetVar2(self, tuple) != NULL);
    else if(strcmp(name, "var2MinFlag") == 0)
        retval = (ScatterAttributes_SetVar2MinFlag(self, tuple) != NULL);
    else if(strcmp(name, "var2MaxFlag") == 0)
        retval = (ScatterAttributes_SetVar2MaxFlag(self, tuple) != NULL);
    else if(strcmp(name, "var2Min") == 0)
        retval = (ScatterAttributes_SetVar2Min(self, tuple) != NULL);
    else if(strcmp(name, "var2Max") == 0)
        retval = (ScatterAttributes_SetVar2Max(self, tuple) != NULL);
    else if(strcmp(name, "var2Scaling") == 0)
        retval = (ScatterAttributes_SetVar2Scaling(self, tuple) != NULL);
    else if(strcmp(name, "var2SkewFactor") == 0)
        retval = (ScatterAttributes_SetVar2SkewFactor(self, tuple) != NULL);
    else if(strcmp(name, "var3Role") == 0)
        retval = (ScatterAttributes_SetVar3Role(self, tuple) != NULL);
    else if(strcmp(name, "var3") == 0)
        retval = (ScatterAttributes_SetVar3(self, tuple) != NULL);
    else if(strcmp(name, "var3MinFlag") == 0)
        retval = (ScatterAttributes_SetVar3MinFlag(self, tuple) != NULL);
    else if(strcmp(name, "var3MaxFlag") == 0)
        retval = (ScatterAttributes_SetVar3MaxFlag(self, tuple) != NULL);
    else if(strcmp(name, "var3Min") == 0)
        retval = (ScatterAttributes_SetVar3Min(self, tuple) != NULL);
    else if(strcmp(name, "var3Max") == 0)
        retval = (ScatterAttributes_SetVar3Max(self, tuple) != NULL);
    else if(strcmp(name, "var3Scaling") == 0)
        retval = (ScatterAttributes_SetVar3Scaling(self, tuple) != NULL);
    else if(strcmp(name, "var3SkewFactor") == 0)
        retval = (ScatterAttributes_SetVar3SkewFactor(self, tuple) != NULL);
    else if(strcmp(name, "var4Role") == 0)
        retval = (ScatterAttributes_SetVar4Role(self, tuple) != NULL);
    else if(strcmp(name, "var4") == 0)
        retval = (ScatterAttributes_SetVar4(self, tuple) != NULL);
    else if(strcmp(name, "var4MinFlag") == 0)
        retval = (ScatterAttributes_SetVar4MinFlag(self, tuple) != NULL);
    else if(strcmp(name, "var4MaxFlag") == 0)
        retval = (ScatterAttributes_SetVar4MaxFlag(self, tuple) != NULL);
    else if(strcmp(name, "var4Min") == 0)
        retval = (ScatterAttributes_SetVar4Min(self, tuple) != NULL);
    else if(strcmp(name, "var4Max") == 0)
        retval = (ScatterAttributes_SetVar4Max(self, tuple) != NULL);
    else if(strcmp(name, "var4Scaling") == 0)
        retval = (ScatterAttributes_SetVar4Scaling(self, tuple) != NULL);
    else if(strcmp(name, "var4SkewFactor") == 0)
        retval = (ScatterAttributes_SetVar4SkewFactor(self, tuple) != NULL);
    else if(strcmp(name, "pointSize") == 0)
        retval = (ScatterAttributes_SetPointSize(self, tuple) != NULL);
    else if(strcmp(name, "pointType") == 0)
        retval = (ScatterAttributes_SetPointType(self, tuple) != NULL);
    else if(strcmp(name, "scaleCube") == 0)
        retval = (ScatterAttributes_SetScaleCube(self, tuple) != NULL);
    else if(strcmp(name, "colorTableName") == 0)
        retval = (ScatterAttributes_SetColorTableName(self, tuple) != NULL);
    else if(strcmp(name, "singleColor") == 0)
        retval = (ScatterAttributes_SetSingleColor(self, tuple) != NULL);
    else if(strcmp(name, "foregroundFlag") == 0)
        retval = (ScatterAttributes_SetForegroundFlag(self, tuple) != NULL);
    else if(strcmp(name, "legendFlag") == 0)
        retval = (ScatterAttributes_SetLegendFlag(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
ScatterAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)v;

    const char *var1Role_names = "Coordinate0, Coordinate1, Coordinate2, Color, None";
    if(obj->data->GetVar1Role() == ScatterAttributes::Coordinate0)
        fprintf(fp, "var1Role = Coordinate0  # %s\n", var1Role_names);
    else if(obj->data->GetVar1Role() == ScatterAttributes::Coordinate1)
        fprintf(fp, "var1Role = Coordinate1  # %s\n", var1Role_names);
    else if(obj->data->GetVar1Role() == ScatterAttributes::Coordinate2)
        fprintf(fp, "var1Role = Coordinate2  # %s\n", var1Role_names);
    else if(obj->data->GetVar1Role() == ScatterAttributes::Color)
        fprintf(fp, "var1Role = Color  # %s\n", var1Role_names);
    else
        fprintf(fp, "var1Role = None  # %s\n", var1Role_names);

    if(obj->data->GetVar1MinFlag())
        fprintf(fp, "var1MinFlag = 1\n");
    else
        fprintf(fp, "var1MinFlag = 0\n");
    if(obj->data->GetVar1MaxFlag())
        fprintf(fp, "var1MaxFlag = 1\n");
    else
        fprintf(fp, "var1MaxFlag = 0\n");
    fprintf(fp, "var1Min = %g\n", obj->data->GetVar1Min());
    fprintf(fp, "var1Max = %g\n", obj->data->GetVar1Max());
    const char *var1Scaling_names = "Linear, Log, Skew";
    if(obj->data->GetVar1Scaling() == ScatterAttributes::Linear)
        fprintf(fp, "var1Scaling = Linear  # %s\n", var1Scaling_names);
    else if(obj->data->GetVar1Scaling() == ScatterAttributes::Log)
        fprintf(fp, "var1Scaling = Log  # %s\n", var1Scaling_names);
    else
        fprintf(fp, "var1Scaling = Skew  # %s\n", var1Scaling_names);

    fprintf(fp, "var1SkewFactor = %g\n", obj->data->GetVar1SkewFactor());
    const char *var2Role_names = "Coordinate0, Coordinate1, Coordinate2, Color, None";
    if(obj->data->GetVar2Role() == ScatterAttributes::Coordinate0)
        fprintf(fp, "var2Role = Coordinate0  # %s\n", var2Role_names);
    else if(obj->data->GetVar2Role() == ScatterAttributes::Coordinate1)
        fprintf(fp, "var2Role = Coordinate1  # %s\n", var2Role_names);
    else if(obj->data->GetVar2Role() == ScatterAttributes::Coordinate2)
        fprintf(fp, "var2Role = Coordinate2  # %s\n", var2Role_names);
    else if(obj->data->GetVar2Role() == ScatterAttributes::Color)
        fprintf(fp, "var2Role = Color  # %s\n", var2Role_names);
    else
        fprintf(fp, "var2Role = None  # %s\n", var2Role_names);

    fprintf(fp, "var2 = \"%s\"\n", obj->data->GetVar2().c_str());
    if(obj->data->GetVar2MinFlag())
        fprintf(fp, "var2MinFlag = 1\n");
    else
        fprintf(fp, "var2MinFlag = 0\n");
    if(obj->data->GetVar2MaxFlag())
        fprintf(fp, "var2MaxFlag = 1\n");
    else
        fprintf(fp, "var2MaxFlag = 0\n");
    fprintf(fp, "var2Min = %g\n", obj->data->GetVar2Min());
    fprintf(fp, "var2Max = %g\n", obj->data->GetVar2Max());
    const char *var2Scaling_names = "Linear, Log, Skew";
    if(obj->data->GetVar2Scaling() == ScatterAttributes::Linear)
        fprintf(fp, "var2Scaling = Linear  # %s\n", var2Scaling_names);
    else if(obj->data->GetVar2Scaling() == ScatterAttributes::Log)
        fprintf(fp, "var2Scaling = Log  # %s\n", var2Scaling_names);
    else
        fprintf(fp, "var2Scaling = Skew  # %s\n", var2Scaling_names);

    fprintf(fp, "var2SkewFactor = %g\n", obj->data->GetVar2SkewFactor());
    const char *var3Role_names = "Coordinate0, Coordinate1, Coordinate2, Color, None";
    if(obj->data->GetVar3Role() == ScatterAttributes::Coordinate0)
        fprintf(fp, "var3Role = Coordinate0  # %s\n", var3Role_names);
    else if(obj->data->GetVar3Role() == ScatterAttributes::Coordinate1)
        fprintf(fp, "var3Role = Coordinate1  # %s\n", var3Role_names);
    else if(obj->data->GetVar3Role() == ScatterAttributes::Coordinate2)
        fprintf(fp, "var3Role = Coordinate2  # %s\n", var3Role_names);
    else if(obj->data->GetVar3Role() == ScatterAttributes::Color)
        fprintf(fp, "var3Role = Color  # %s\n", var3Role_names);
    else
        fprintf(fp, "var3Role = None  # %s\n", var3Role_names);

    fprintf(fp, "var3 = \"%s\"\n", obj->data->GetVar3().c_str());
    if(obj->data->GetVar3MinFlag())
        fprintf(fp, "var3MinFlag = 1\n");
    else
        fprintf(fp, "var3MinFlag = 0\n");
    if(obj->data->GetVar3MaxFlag())
        fprintf(fp, "var3MaxFlag = 1\n");
    else
        fprintf(fp, "var3MaxFlag = 0\n");
    fprintf(fp, "var3Min = %g\n", obj->data->GetVar3Min());
    fprintf(fp, "var3Max = %g\n", obj->data->GetVar3Max());
    const char *var3Scaling_names = "Linear, Log, Skew";
    if(obj->data->GetVar3Scaling() == ScatterAttributes::Linear)
        fprintf(fp, "var3Scaling = Linear  # %s\n", var3Scaling_names);
    else if(obj->data->GetVar3Scaling() == ScatterAttributes::Log)
        fprintf(fp, "var3Scaling = Log  # %s\n", var3Scaling_names);
    else
        fprintf(fp, "var3Scaling = Skew  # %s\n", var3Scaling_names);

    fprintf(fp, "var3SkewFactor = %g\n", obj->data->GetVar3SkewFactor());
    const char *var4Role_names = "Coordinate0, Coordinate1, Coordinate2, Color, None";
    if(obj->data->GetVar4Role() == ScatterAttributes::Coordinate0)
        fprintf(fp, "var4Role = Coordinate0  # %s\n", var4Role_names);
    else if(obj->data->GetVar4Role() == ScatterAttributes::Coordinate1)
        fprintf(fp, "var4Role = Coordinate1  # %s\n", var4Role_names);
    else if(obj->data->GetVar4Role() == ScatterAttributes::Coordinate2)
        fprintf(fp, "var4Role = Coordinate2  # %s\n", var4Role_names);
    else if(obj->data->GetVar4Role() == ScatterAttributes::Color)
        fprintf(fp, "var4Role = Color  # %s\n", var4Role_names);
    else
        fprintf(fp, "var4Role = None  # %s\n", var4Role_names);

    fprintf(fp, "var4 = \"%s\"\n", obj->data->GetVar4().c_str());
    if(obj->data->GetVar4MinFlag())
        fprintf(fp, "var4MinFlag = 1\n");
    else
        fprintf(fp, "var4MinFlag = 0\n");
    if(obj->data->GetVar4MaxFlag())
        fprintf(fp, "var4MaxFlag = 1\n");
    else
        fprintf(fp, "var4MaxFlag = 0\n");
    fprintf(fp, "var4Min = %g\n", obj->data->GetVar4Min());
    fprintf(fp, "var4Max = %g\n", obj->data->GetVar4Max());
    const char *var4Scaling_names = "Linear, Log, Skew";
    if(obj->data->GetVar4Scaling() == ScatterAttributes::Linear)
        fprintf(fp, "var4Scaling = Linear  # %s\n", var4Scaling_names);
    else if(obj->data->GetVar4Scaling() == ScatterAttributes::Log)
        fprintf(fp, "var4Scaling = Log  # %s\n", var4Scaling_names);
    else
        fprintf(fp, "var4Scaling = Skew  # %s\n", var4Scaling_names);

    fprintf(fp, "var4SkewFactor = %g\n", obj->data->GetVar4SkewFactor());
    fprintf(fp, "pointSize = %g\n", obj->data->GetPointSize());
    const char *pointType_names = "Box, Axis, Icosahedron, Point";
    if(obj->data->GetPointType() == ScatterAttributes::Box)
        fprintf(fp, "pointType = Box  # %s\n", pointType_names);
    else if(obj->data->GetPointType() == ScatterAttributes::Axis)
        fprintf(fp, "pointType = Axis  # %s\n", pointType_names);
    else if(obj->data->GetPointType() == ScatterAttributes::Icosahedron)
        fprintf(fp, "pointType = Icosahedron  # %s\n", pointType_names);
    else
        fprintf(fp, "pointType = Point  # %s\n", pointType_names);

    if(obj->data->GetScaleCube())
        fprintf(fp, "scaleCube = 1\n");
    else
        fprintf(fp, "scaleCube = 0\n");
    fprintf(fp, "colorTableName = %s\n", obj->data->GetColorTableName().c_str());
    const unsigned char *singleColor = obj->data->GetSingleColor().GetColor();
    fprintf(fp, "singleColor = (%d, %d, %d, %d)\n", int(singleColor[0]), int(singleColor[1]), int(singleColor[2]), int(singleColor[3]));
    if(obj->data->GetForegroundFlag())
        fprintf(fp, "foregroundFlag = 1\n");
    else
        fprintf(fp, "foregroundFlag = 0\n");
    if(obj->data->GetLegendFlag())
        fprintf(fp, "legendFlag = 1\n");
    else
        fprintf(fp, "legendFlag = 0\n");

    return 0;
}

#include <snprintf.h>
PyObject *
PyScatterAttributes_StringRepresentation(const ScatterAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    const char *var1Role_names = "Coordinate0, Coordinate1, Coordinate2, Color, None";
    if(atts->GetVar1Role() == ScatterAttributes::Coordinate0)
        {
             SNPRINTF(tmpStr, 1000, "var1Role = Coordinate0  # %s\n", var1Role_names);
             str += tmpStr;
        }
    else if(atts->GetVar1Role() == ScatterAttributes::Coordinate1)
        {
             SNPRINTF(tmpStr, 1000, "var1Role = Coordinate1  # %s\n", var1Role_names);
             str += tmpStr;
        }
    else if(atts->GetVar1Role() == ScatterAttributes::Coordinate2)
        {
             SNPRINTF(tmpStr, 1000, "var1Role = Coordinate2  # %s\n", var1Role_names);
             str += tmpStr;
        }
    else if(atts->GetVar1Role() == ScatterAttributes::Color)
        {
             SNPRINTF(tmpStr, 1000, "var1Role = Color  # %s\n", var1Role_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "var1Role = None  # %s\n", var1Role_names);
             str += tmpStr;
        }

    if(atts->GetVar1MinFlag())
        SNPRINTF(tmpStr, 1000, "var1MinFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "var1MinFlag = 0\n");
    str += tmpStr;
    if(atts->GetVar1MaxFlag())
        SNPRINTF(tmpStr, 1000, "var1MaxFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "var1MaxFlag = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "var1Min = %g\n", atts->GetVar1Min());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "var1Max = %g\n", atts->GetVar1Max());
    str += tmpStr;
    const char *var1Scaling_names = "Linear, Log, Skew";
    if(atts->GetVar1Scaling() == ScatterAttributes::Linear)
        {
             SNPRINTF(tmpStr, 1000, "var1Scaling = Linear  # %s\n", var1Scaling_names);
             str += tmpStr;
        }
    else if(atts->GetVar1Scaling() == ScatterAttributes::Log)
        {
             SNPRINTF(tmpStr, 1000, "var1Scaling = Log  # %s\n", var1Scaling_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "var1Scaling = Skew  # %s\n", var1Scaling_names);
             str += tmpStr;
        }

    SNPRINTF(tmpStr, 1000, "var1SkewFactor = %g\n", atts->GetVar1SkewFactor());
    str += tmpStr;
    const char *var2Role_names = "Coordinate0, Coordinate1, Coordinate2, Color, None";
    if(atts->GetVar2Role() == ScatterAttributes::Coordinate0)
        {
             SNPRINTF(tmpStr, 1000, "var2Role = Coordinate0  # %s\n", var2Role_names);
             str += tmpStr;
        }
    else if(atts->GetVar2Role() == ScatterAttributes::Coordinate1)
        {
             SNPRINTF(tmpStr, 1000, "var2Role = Coordinate1  # %s\n", var2Role_names);
             str += tmpStr;
        }
    else if(atts->GetVar2Role() == ScatterAttributes::Coordinate2)
        {
             SNPRINTF(tmpStr, 1000, "var2Role = Coordinate2  # %s\n", var2Role_names);
             str += tmpStr;
        }
    else if(atts->GetVar2Role() == ScatterAttributes::Color)
        {
             SNPRINTF(tmpStr, 1000, "var2Role = Color  # %s\n", var2Role_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "var2Role = None  # %s\n", var2Role_names);
             str += tmpStr;
        }

    SNPRINTF(tmpStr, 1000, "var2 = \"%s\"\n", atts->GetVar2().c_str());
    str += tmpStr;
    if(atts->GetVar2MinFlag())
        SNPRINTF(tmpStr, 1000, "var2MinFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "var2MinFlag = 0\n");
    str += tmpStr;
    if(atts->GetVar2MaxFlag())
        SNPRINTF(tmpStr, 1000, "var2MaxFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "var2MaxFlag = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "var2Min = %g\n", atts->GetVar2Min());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "var2Max = %g\n", atts->GetVar2Max());
    str += tmpStr;
    const char *var2Scaling_names = "Linear, Log, Skew";
    if(atts->GetVar2Scaling() == ScatterAttributes::Linear)
        {
             SNPRINTF(tmpStr, 1000, "var2Scaling = Linear  # %s\n", var2Scaling_names);
             str += tmpStr;
        }
    else if(atts->GetVar2Scaling() == ScatterAttributes::Log)
        {
             SNPRINTF(tmpStr, 1000, "var2Scaling = Log  # %s\n", var2Scaling_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "var2Scaling = Skew  # %s\n", var2Scaling_names);
             str += tmpStr;
        }

    SNPRINTF(tmpStr, 1000, "var2SkewFactor = %g\n", atts->GetVar2SkewFactor());
    str += tmpStr;
    const char *var3Role_names = "Coordinate0, Coordinate1, Coordinate2, Color, None";
    if(atts->GetVar3Role() == ScatterAttributes::Coordinate0)
        {
             SNPRINTF(tmpStr, 1000, "var3Role = Coordinate0  # %s\n", var3Role_names);
             str += tmpStr;
        }
    else if(atts->GetVar3Role() == ScatterAttributes::Coordinate1)
        {
             SNPRINTF(tmpStr, 1000, "var3Role = Coordinate1  # %s\n", var3Role_names);
             str += tmpStr;
        }
    else if(atts->GetVar3Role() == ScatterAttributes::Coordinate2)
        {
             SNPRINTF(tmpStr, 1000, "var3Role = Coordinate2  # %s\n", var3Role_names);
             str += tmpStr;
        }
    else if(atts->GetVar3Role() == ScatterAttributes::Color)
        {
             SNPRINTF(tmpStr, 1000, "var3Role = Color  # %s\n", var3Role_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "var3Role = None  # %s\n", var3Role_names);
             str += tmpStr;
        }

    SNPRINTF(tmpStr, 1000, "var3 = \"%s\"\n", atts->GetVar3().c_str());
    str += tmpStr;
    if(atts->GetVar3MinFlag())
        SNPRINTF(tmpStr, 1000, "var3MinFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "var3MinFlag = 0\n");
    str += tmpStr;
    if(atts->GetVar3MaxFlag())
        SNPRINTF(tmpStr, 1000, "var3MaxFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "var3MaxFlag = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "var3Min = %g\n", atts->GetVar3Min());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "var3Max = %g\n", atts->GetVar3Max());
    str += tmpStr;
    const char *var3Scaling_names = "Linear, Log, Skew";
    if(atts->GetVar3Scaling() == ScatterAttributes::Linear)
        {
             SNPRINTF(tmpStr, 1000, "var3Scaling = Linear  # %s\n", var3Scaling_names);
             str += tmpStr;
        }
    else if(atts->GetVar3Scaling() == ScatterAttributes::Log)
        {
             SNPRINTF(tmpStr, 1000, "var3Scaling = Log  # %s\n", var3Scaling_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "var3Scaling = Skew  # %s\n", var3Scaling_names);
             str += tmpStr;
        }

    SNPRINTF(tmpStr, 1000, "var3SkewFactor = %g\n", atts->GetVar3SkewFactor());
    str += tmpStr;
    const char *var4Role_names = "Coordinate0, Coordinate1, Coordinate2, Color, None";
    if(atts->GetVar4Role() == ScatterAttributes::Coordinate0)
        {
             SNPRINTF(tmpStr, 1000, "var4Role = Coordinate0  # %s\n", var4Role_names);
             str += tmpStr;
        }
    else if(atts->GetVar4Role() == ScatterAttributes::Coordinate1)
        {
             SNPRINTF(tmpStr, 1000, "var4Role = Coordinate1  # %s\n", var4Role_names);
             str += tmpStr;
        }
    else if(atts->GetVar4Role() == ScatterAttributes::Coordinate2)
        {
             SNPRINTF(tmpStr, 1000, "var4Role = Coordinate2  # %s\n", var4Role_names);
             str += tmpStr;
        }
    else if(atts->GetVar4Role() == ScatterAttributes::Color)
        {
             SNPRINTF(tmpStr, 1000, "var4Role = Color  # %s\n", var4Role_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "var4Role = None  # %s\n", var4Role_names);
             str += tmpStr;
        }

    SNPRINTF(tmpStr, 1000, "var4 = \"%s\"\n", atts->GetVar4().c_str());
    str += tmpStr;
    if(atts->GetVar4MinFlag())
        SNPRINTF(tmpStr, 1000, "var4MinFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "var4MinFlag = 0\n");
    str += tmpStr;
    if(atts->GetVar4MaxFlag())
        SNPRINTF(tmpStr, 1000, "var4MaxFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "var4MaxFlag = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "var4Min = %g\n", atts->GetVar4Min());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "var4Max = %g\n", atts->GetVar4Max());
    str += tmpStr;
    const char *var4Scaling_names = "Linear, Log, Skew";
    if(atts->GetVar4Scaling() == ScatterAttributes::Linear)
        {
             SNPRINTF(tmpStr, 1000, "var4Scaling = Linear  # %s\n", var4Scaling_names);
             str += tmpStr;
        }
    else if(atts->GetVar4Scaling() == ScatterAttributes::Log)
        {
             SNPRINTF(tmpStr, 1000, "var4Scaling = Log  # %s\n", var4Scaling_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "var4Scaling = Skew  # %s\n", var4Scaling_names);
             str += tmpStr;
        }

    SNPRINTF(tmpStr, 1000, "var4SkewFactor = %g\n", atts->GetVar4SkewFactor());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "pointSize = %g\n", atts->GetPointSize());
    str += tmpStr;
    const char *pointType_names = "Box, Axis, Icosahedron, Point";
    if(atts->GetPointType() == ScatterAttributes::Box)
        {
             SNPRINTF(tmpStr, 1000, "pointType = Box  # %s\n", pointType_names);
             str += tmpStr;
        }
    else if(atts->GetPointType() == ScatterAttributes::Axis)
        {
             SNPRINTF(tmpStr, 1000, "pointType = Axis  # %s\n", pointType_names);
             str += tmpStr;
        }
    else if(atts->GetPointType() == ScatterAttributes::Icosahedron)
        {
             SNPRINTF(tmpStr, 1000, "pointType = Icosahedron  # %s\n", pointType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "pointType = Point  # %s\n", pointType_names);
             str += tmpStr;
        }

    if(atts->GetScaleCube())
        SNPRINTF(tmpStr, 1000, "scaleCube = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "scaleCube = 0\n");
    str += tmpStr;
   SNPRINTF(tmpStr, 1000, "colorTableName = %s\n", atts->GetColorTableName().c_str());
   str += tmpStr;
    const unsigned char *singleColor = atts->GetSingleColor().GetColor();
    SNPRINTF(tmpStr, 1000, "singleColor = (%d, %d, %d, %d)\n", int(singleColor[0]), int(singleColor[1]), int(singleColor[2]), int(singleColor[3]));
    str += tmpStr;
    if(atts->GetForegroundFlag())
        SNPRINTF(tmpStr, 1000, "foregroundFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "foregroundFlag = 0\n");
    str += tmpStr;
    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "legendFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "legendFlag = 0\n");
    str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
ScatterAttributes_str(PyObject *v)
{
    ScatterAttributesObject *obj = (ScatterAttributesObject *)v;
    return PyScatterAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *ScatterAttributes_Purpose = "Attributes for the scatter plot";

//
// The type description structure
//
static PyTypeObject ScatterAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ScatterAttributes",                    // tp_name
    sizeof(ScatterAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ScatterAttributes_dealloc,  // tp_dealloc
    (printfunc)ScatterAttributes_print,     // tp_print
    (getattrfunc)ScatterAttributes_getattr, // tp_getattr
    (setattrfunc)ScatterAttributes_setattr, // tp_setattr
    (cmpfunc)ScatterAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ScatterAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ScatterAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ScatterAttributes *defaultAtts = 0;

static PyObject *
NewScatterAttributes()
{
    ScatterAttributesObject *newObject;
    newObject = PyObject_NEW(ScatterAttributesObject, &ScatterAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new ScatterAttributes(*defaultAtts);
    else
        newObject->data = new ScatterAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapScatterAttributes(const ScatterAttributes *attr)
{
    ScatterAttributesObject *newObject;
    newObject = PyObject_NEW(ScatterAttributesObject, &ScatterAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ScatterAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ScatterAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewScatterAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ScatterAttributesMethods[] = {
    {"ScatterAttributes", ScatterAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ScatterAttributesObserver = 0;
static bool ScatterAttributesEnableLogging = true;

static void
PyScatterAttributes_WriteLog(Subject *subj, void *data)
{
    ScatterAttributes *atts = (ScatterAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!ScatterAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# ScatterAttributes_WriteLog()\n");
}

void
PyScatterAttributes_StartUp(ScatterAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyScatterAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ScatterAttributesObserver == 0)
    {
        ScatterAttributesObserver = new ObserverToCallback(subj,
            PyScatterAttributes_WriteLog, (void *)logFile);
    }

    ScatterAttributesEnableLogging = true;
}

void
PyScatterAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ScatterAttributesObserver;
    ScatterAttributesObserver = 0;
}

PyMethodDef *
PyScatterAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ScatterAttributesMethods;
}

bool
PyScatterAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ScatterAttributesType);
}

ScatterAttributes *
PyScatterAttributes_FromPyObject(PyObject *obj)
{
    ScatterAttributesObject *obj2 = (ScatterAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyScatterAttributes_NewPyObject()
{
    return NewScatterAttributes();
}

PyObject *
PyScatterAttributes_WrapPyObject(const ScatterAttributes *attr)
{
    return WrapScatterAttributes(attr);
}

void
PyScatterAttributes_SetLogging(bool val)
{
    ScatterAttributesEnableLogging = val;
}

void
PyScatterAttributes_SetDefaults(const ScatterAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ScatterAttributes(*atts);
}

