#include <PyPseudocolorAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyPseudocolorAttributes
//
// Purpose: 
//   Attributes for the pseudocolor plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Nov 12 11:24:43 PDT 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a PseudocolorAttributes.
//
struct PseudocolorAttributesObject
{
    PyObject_HEAD
    PseudocolorAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewPseudocolorAttributes();

static PyObject *
PseudocolorAttributes_Notify(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PseudocolorAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PseudocolorAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

static PyObject *
PseudocolorAttributes_SetLightingFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lightingFlag in the object.
    obj->data->SetLightingFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PseudocolorAttributes_GetLightingFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLightingFlag()?1L:0L);
    return retval;
}

static PyObject *
PseudocolorAttributes_SetMinFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the minFlag in the object.
    obj->data->SetMinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PseudocolorAttributes_GetMinFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMinFlag()?1L:0L);
    return retval;
}

static PyObject *
PseudocolorAttributes_SetMaxFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxFlag in the object.
    obj->data->SetMaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PseudocolorAttributes_GetMaxFlag(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMaxFlag()?1L:0L);
    return retval;
}

static PyObject *
PseudocolorAttributes_SetCentering(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the centering in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetCentering(PseudocolorAttributes::Centering(ival));
    else
    {
        fprintf(stderr, "An invalid centering value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Natural, Nodal, Zonal.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PseudocolorAttributes_GetCentering(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCentering()));
    return retval;
}

static PyObject *
PseudocolorAttributes_SetScaling(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scaling in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetScaling(PseudocolorAttributes::Scaling(ival));
    else
    {
        fprintf(stderr, "An invalid scaling value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Linear, Log, Skew.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PseudocolorAttributes_GetScaling(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetScaling()));
    return retval;
}

static PyObject *
PseudocolorAttributes_SetLimitsMode(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the limitsMode in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetLimitsMode(PseudocolorAttributes::LimitsMode(ival));
    else
    {
        fprintf(stderr, "An invalid limitsMode value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "OriginalData, CurrentPlot.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PseudocolorAttributes_GetLimitsMode(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLimitsMode()));
    return retval;
}

static PyObject *
PseudocolorAttributes_SetMin(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the min in the object.
    obj->data->SetMin(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PseudocolorAttributes_GetMin(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMin());
    return retval;
}

static PyObject *
PseudocolorAttributes_SetMax(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the max in the object.
    obj->data->SetMax(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PseudocolorAttributes_GetMax(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMax());
    return retval;
}

static PyObject *
PseudocolorAttributes_SetPointSize(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pointSize in the object.
    obj->data->SetPointSize(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PseudocolorAttributes_GetPointSize(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPointSize());
    return retval;
}

static PyObject *
PseudocolorAttributes_SetPointType(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointType in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetPointType(PseudocolorAttributes::PointType(ival));
    else
    {
        fprintf(stderr, "An invalid pointType value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "Box, Axis, Icosahedron, Point.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PseudocolorAttributes_GetPointType(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointType()));
    return retval;
}

static PyObject *
PseudocolorAttributes_SetSkewFactor(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the skewFactor in the object.
    obj->data->SetSkewFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PseudocolorAttributes_GetSkewFactor(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSkewFactor());
    return retval;
}

static PyObject *
PseudocolorAttributes_SetOpacity(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the opacity in the object.
    obj->data->SetOpacity(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PseudocolorAttributes_GetOpacity(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOpacity());
    return retval;
}

static PyObject *
PseudocolorAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PseudocolorAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

static PyObject *
PseudocolorAttributes_SetSmoothingLevel(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the smoothingLevel in the object.
    obj->data->SetSmoothingLevel(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PseudocolorAttributes_GetSmoothingLevel(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSmoothingLevel()));
    return retval;
}

static PyObject *
PseudocolorAttributes_SetPointSizeVarEnabled(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointSizeVarEnabled in the object.
    obj->data->SetPointSizeVarEnabled(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PseudocolorAttributes_GetPointSizeVarEnabled(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPointSizeVarEnabled()?1L:0L);
    return retval;
}

static PyObject *
PseudocolorAttributes_SetPointSizeVar(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the pointSizeVar in the object.
    obj->data->SetPointSizeVar(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
PseudocolorAttributes_GetPointSizeVar(PyObject *self, PyObject *args)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetPointSizeVar().c_str());
    return retval;
}



static struct PyMethodDef PseudocolorAttributes_methods[] = {
    {"Notify", PseudocolorAttributes_Notify, METH_VARARGS},
    {"SetLegendFlag", PseudocolorAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", PseudocolorAttributes_GetLegendFlag, METH_VARARGS},
    {"SetLightingFlag", PseudocolorAttributes_SetLightingFlag, METH_VARARGS},
    {"GetLightingFlag", PseudocolorAttributes_GetLightingFlag, METH_VARARGS},
    {"SetMinFlag", PseudocolorAttributes_SetMinFlag, METH_VARARGS},
    {"GetMinFlag", PseudocolorAttributes_GetMinFlag, METH_VARARGS},
    {"SetMaxFlag", PseudocolorAttributes_SetMaxFlag, METH_VARARGS},
    {"GetMaxFlag", PseudocolorAttributes_GetMaxFlag, METH_VARARGS},
    {"SetCentering", PseudocolorAttributes_SetCentering, METH_VARARGS},
    {"GetCentering", PseudocolorAttributes_GetCentering, METH_VARARGS},
    {"SetScaling", PseudocolorAttributes_SetScaling, METH_VARARGS},
    {"GetScaling", PseudocolorAttributes_GetScaling, METH_VARARGS},
    {"SetLimitsMode", PseudocolorAttributes_SetLimitsMode, METH_VARARGS},
    {"GetLimitsMode", PseudocolorAttributes_GetLimitsMode, METH_VARARGS},
    {"SetMin", PseudocolorAttributes_SetMin, METH_VARARGS},
    {"GetMin", PseudocolorAttributes_GetMin, METH_VARARGS},
    {"SetMax", PseudocolorAttributes_SetMax, METH_VARARGS},
    {"GetMax", PseudocolorAttributes_GetMax, METH_VARARGS},
    {"SetPointSize", PseudocolorAttributes_SetPointSize, METH_VARARGS},
    {"GetPointSize", PseudocolorAttributes_GetPointSize, METH_VARARGS},
    {"SetPointType", PseudocolorAttributes_SetPointType, METH_VARARGS},
    {"GetPointType", PseudocolorAttributes_GetPointType, METH_VARARGS},
    {"SetSkewFactor", PseudocolorAttributes_SetSkewFactor, METH_VARARGS},
    {"GetSkewFactor", PseudocolorAttributes_GetSkewFactor, METH_VARARGS},
    {"SetOpacity", PseudocolorAttributes_SetOpacity, METH_VARARGS},
    {"GetOpacity", PseudocolorAttributes_GetOpacity, METH_VARARGS},
    {"SetColorTableName", PseudocolorAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", PseudocolorAttributes_GetColorTableName, METH_VARARGS},
    {"SetSmoothingLevel", PseudocolorAttributes_SetSmoothingLevel, METH_VARARGS},
    {"GetSmoothingLevel", PseudocolorAttributes_GetSmoothingLevel, METH_VARARGS},
    {"SetPointSizeVarEnabled", PseudocolorAttributes_SetPointSizeVarEnabled, METH_VARARGS},
    {"GetPointSizeVarEnabled", PseudocolorAttributes_GetPointSizeVarEnabled, METH_VARARGS},
    {"SetPointSizeVar", PseudocolorAttributes_SetPointSizeVar, METH_VARARGS},
    {"GetPointSizeVar", PseudocolorAttributes_GetPointSizeVar, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
PseudocolorAttributes_dealloc(PyObject *v)
{
   PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
PseudocolorAttributes_compare(PyObject *v, PyObject *w)
{
    PseudocolorAttributes *a = ((PseudocolorAttributesObject *)v)->data;
    PseudocolorAttributes *b = ((PseudocolorAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
PseudocolorAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "legendFlag") == 0)
        return PseudocolorAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "lightingFlag") == 0)
        return PseudocolorAttributes_GetLightingFlag(self, NULL);
    if(strcmp(name, "minFlag") == 0)
        return PseudocolorAttributes_GetMinFlag(self, NULL);
    if(strcmp(name, "maxFlag") == 0)
        return PseudocolorAttributes_GetMaxFlag(self, NULL);
    if(strcmp(name, "centering") == 0)
        return PseudocolorAttributes_GetCentering(self, NULL);
    if(strcmp(name, "Natural") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Natural));
    else if(strcmp(name, "Nodal") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Nodal));
    else if(strcmp(name, "Zonal") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Zonal));

    if(strcmp(name, "scaling") == 0)
        return PseudocolorAttributes_GetScaling(self, NULL);
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Linear));
    else if(strcmp(name, "Log") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Log));
    else if(strcmp(name, "Skew") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Skew));

    if(strcmp(name, "limitsMode") == 0)
        return PseudocolorAttributes_GetLimitsMode(self, NULL);
    if(strcmp(name, "OriginalData") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::OriginalData));
    else if(strcmp(name, "CurrentPlot") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::CurrentPlot));

    if(strcmp(name, "min") == 0)
        return PseudocolorAttributes_GetMin(self, NULL);
    if(strcmp(name, "max") == 0)
        return PseudocolorAttributes_GetMax(self, NULL);
    if(strcmp(name, "pointSize") == 0)
        return PseudocolorAttributes_GetPointSize(self, NULL);
    if(strcmp(name, "pointType") == 0)
        return PseudocolorAttributes_GetPointType(self, NULL);
    if(strcmp(name, "Box") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Box));
    else if(strcmp(name, "Axis") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Axis));
    else if(strcmp(name, "Icosahedron") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Icosahedron));
    else if(strcmp(name, "Point") == 0)
        return PyInt_FromLong(long(PseudocolorAttributes::Point));

    if(strcmp(name, "skewFactor") == 0)
        return PseudocolorAttributes_GetSkewFactor(self, NULL);
    if(strcmp(name, "opacity") == 0)
        return PseudocolorAttributes_GetOpacity(self, NULL);
    if(strcmp(name, "colorTableName") == 0)
        return PseudocolorAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "smoothingLevel") == 0)
        return PseudocolorAttributes_GetSmoothingLevel(self, NULL);
    if(strcmp(name, "pointSizeVarEnabled") == 0)
        return PseudocolorAttributes_GetPointSizeVarEnabled(self, NULL);
    if(strcmp(name, "pointSizeVar") == 0)
        return PseudocolorAttributes_GetPointSizeVar(self, NULL);

    return Py_FindMethod(PseudocolorAttributes_methods, self, name);
}

static int
PseudocolorAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "legendFlag") == 0)
        retval = (PseudocolorAttributes_SetLegendFlag(self, tuple) != NULL);
    else if(strcmp(name, "lightingFlag") == 0)
        retval = (PseudocolorAttributes_SetLightingFlag(self, tuple) != NULL);
    else if(strcmp(name, "minFlag") == 0)
        retval = (PseudocolorAttributes_SetMinFlag(self, tuple) != NULL);
    else if(strcmp(name, "maxFlag") == 0)
        retval = (PseudocolorAttributes_SetMaxFlag(self, tuple) != NULL);
    else if(strcmp(name, "centering") == 0)
        retval = (PseudocolorAttributes_SetCentering(self, tuple) != NULL);
    else if(strcmp(name, "scaling") == 0)
        retval = (PseudocolorAttributes_SetScaling(self, tuple) != NULL);
    else if(strcmp(name, "limitsMode") == 0)
        retval = (PseudocolorAttributes_SetLimitsMode(self, tuple) != NULL);
    else if(strcmp(name, "min") == 0)
        retval = (PseudocolorAttributes_SetMin(self, tuple) != NULL);
    else if(strcmp(name, "max") == 0)
        retval = (PseudocolorAttributes_SetMax(self, tuple) != NULL);
    else if(strcmp(name, "pointSize") == 0)
        retval = (PseudocolorAttributes_SetPointSize(self, tuple) != NULL);
    else if(strcmp(name, "pointType") == 0)
        retval = (PseudocolorAttributes_SetPointType(self, tuple) != NULL);
    else if(strcmp(name, "skewFactor") == 0)
        retval = (PseudocolorAttributes_SetSkewFactor(self, tuple) != NULL);
    else if(strcmp(name, "opacity") == 0)
        retval = (PseudocolorAttributes_SetOpacity(self, tuple) != NULL);
    else if(strcmp(name, "colorTableName") == 0)
        retval = (PseudocolorAttributes_SetColorTableName(self, tuple) != NULL);
    else if(strcmp(name, "smoothingLevel") == 0)
        retval = (PseudocolorAttributes_SetSmoothingLevel(self, tuple) != NULL);
    else if(strcmp(name, "pointSizeVarEnabled") == 0)
        retval = (PseudocolorAttributes_SetPointSizeVarEnabled(self, tuple) != NULL);
    else if(strcmp(name, "pointSizeVar") == 0)
        retval = (PseudocolorAttributes_SetPointSizeVar(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
PseudocolorAttributes_print(PyObject *v, FILE *fp, int flags)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)v;

    if(obj->data->GetLegendFlag())
        fprintf(fp, "legendFlag = 1\n");
    else
        fprintf(fp, "legendFlag = 0\n");
    if(obj->data->GetLightingFlag())
        fprintf(fp, "lightingFlag = 1\n");
    else
        fprintf(fp, "lightingFlag = 0\n");
    if(obj->data->GetMinFlag())
        fprintf(fp, "minFlag = 1\n");
    else
        fprintf(fp, "minFlag = 0\n");
    if(obj->data->GetMaxFlag())
        fprintf(fp, "maxFlag = 1\n");
    else
        fprintf(fp, "maxFlag = 0\n");
    const char *centering_names = "Natural, Nodal, Zonal";
    if(obj->data->GetCentering() == PseudocolorAttributes::Natural)
        fprintf(fp, "centering = Natural  # %s\n", centering_names);
    else if(obj->data->GetCentering() == PseudocolorAttributes::Nodal)
        fprintf(fp, "centering = Nodal  # %s\n", centering_names);
    else
        fprintf(fp, "centering = Zonal  # %s\n", centering_names);

    const char *scaling_names = "Linear, Log, Skew";
    if(obj->data->GetScaling() == PseudocolorAttributes::Linear)
        fprintf(fp, "scaling = Linear  # %s\n", scaling_names);
    else if(obj->data->GetScaling() == PseudocolorAttributes::Log)
        fprintf(fp, "scaling = Log  # %s\n", scaling_names);
    else
        fprintf(fp, "scaling = Skew  # %s\n", scaling_names);

    const char *limitsMode_names = "OriginalData, CurrentPlot";
    if(obj->data->GetLimitsMode() == PseudocolorAttributes::OriginalData)
        fprintf(fp, "limitsMode = OriginalData  # %s\n", limitsMode_names);
    else
        fprintf(fp, "limitsMode = CurrentPlot  # %s\n", limitsMode_names);

    fprintf(fp, "min = %g\n", obj->data->GetMin());
    fprintf(fp, "max = %g\n", obj->data->GetMax());
    fprintf(fp, "pointSize = %g\n", obj->data->GetPointSize());
    const char *pointType_names = "Box, Axis, Icosahedron, Point";
    if(obj->data->GetPointType() == PseudocolorAttributes::Box)
        fprintf(fp, "pointType = Box  # %s\n", pointType_names);
    else if(obj->data->GetPointType() == PseudocolorAttributes::Axis)
        fprintf(fp, "pointType = Axis  # %s\n", pointType_names);
    else if(obj->data->GetPointType() == PseudocolorAttributes::Icosahedron)
        fprintf(fp, "pointType = Icosahedron  # %s\n", pointType_names);
    else
        fprintf(fp, "pointType = Point  # %s\n", pointType_names);

    fprintf(fp, "skewFactor = %g\n", obj->data->GetSkewFactor());
    fprintf(fp, "opacity = %g\n", obj->data->GetOpacity());
    fprintf(fp, "colorTableName = %s\n", obj->data->GetColorTableName().c_str());
    fprintf(fp, "smoothingLevel = %d\n", obj->data->GetSmoothingLevel());
    if(obj->data->GetPointSizeVarEnabled())
        fprintf(fp, "pointSizeVarEnabled = 1\n");
    else
        fprintf(fp, "pointSizeVarEnabled = 0\n");
    fprintf(fp, "pointSizeVar = \"%s\"\n", obj->data->GetPointSizeVar().c_str());

    return 0;
}

#include <snprintf.h>
PyObject *
PyPseudocolorAttributes_StringRepresentation(const PseudocolorAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "legendFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "legendFlag = 0\n");
    str += tmpStr;
    if(atts->GetLightingFlag())
        SNPRINTF(tmpStr, 1000, "lightingFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "lightingFlag = 0\n");
    str += tmpStr;
    if(atts->GetMinFlag())
        SNPRINTF(tmpStr, 1000, "minFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "minFlag = 0\n");
    str += tmpStr;
    if(atts->GetMaxFlag())
        SNPRINTF(tmpStr, 1000, "maxFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "maxFlag = 0\n");
    str += tmpStr;
    const char *centering_names = "Natural, Nodal, Zonal";
    if(atts->GetCentering() == PseudocolorAttributes::Natural)
        {
             SNPRINTF(tmpStr, 1000, "centering = Natural  # %s\n", centering_names);
             str += tmpStr;
        }
    else if(atts->GetCentering() == PseudocolorAttributes::Nodal)
        {
             SNPRINTF(tmpStr, 1000, "centering = Nodal  # %s\n", centering_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "centering = Zonal  # %s\n", centering_names);
             str += tmpStr;
        }

    const char *scaling_names = "Linear, Log, Skew";
    if(atts->GetScaling() == PseudocolorAttributes::Linear)
        {
             SNPRINTF(tmpStr, 1000, "scaling = Linear  # %s\n", scaling_names);
             str += tmpStr;
        }
    else if(atts->GetScaling() == PseudocolorAttributes::Log)
        {
             SNPRINTF(tmpStr, 1000, "scaling = Log  # %s\n", scaling_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "scaling = Skew  # %s\n", scaling_names);
             str += tmpStr;
        }

    const char *limitsMode_names = "OriginalData, CurrentPlot";
    if(atts->GetLimitsMode() == PseudocolorAttributes::OriginalData)
        {
             SNPRINTF(tmpStr, 1000, "limitsMode = OriginalData  # %s\n", limitsMode_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "limitsMode = CurrentPlot  # %s\n", limitsMode_names);
             str += tmpStr;
        }

    SNPRINTF(tmpStr, 1000, "min = %g\n", atts->GetMin());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "max = %g\n", atts->GetMax());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "pointSize = %g\n", atts->GetPointSize());
    str += tmpStr;
    const char *pointType_names = "Box, Axis, Icosahedron, Point";
    if(atts->GetPointType() == PseudocolorAttributes::Box)
        {
             SNPRINTF(tmpStr, 1000, "pointType = Box  # %s\n", pointType_names);
             str += tmpStr;
        }
    else if(atts->GetPointType() == PseudocolorAttributes::Axis)
        {
             SNPRINTF(tmpStr, 1000, "pointType = Axis  # %s\n", pointType_names);
             str += tmpStr;
        }
    else if(atts->GetPointType() == PseudocolorAttributes::Icosahedron)
        {
             SNPRINTF(tmpStr, 1000, "pointType = Icosahedron  # %s\n", pointType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "pointType = Point  # %s\n", pointType_names);
             str += tmpStr;
        }

    SNPRINTF(tmpStr, 1000, "skewFactor = %g\n", atts->GetSkewFactor());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "opacity = %g\n", atts->GetOpacity());
    str += tmpStr;
   SNPRINTF(tmpStr, 1000, "colorTableName = %s\n", atts->GetColorTableName().c_str());
   str += tmpStr;
    SNPRINTF(tmpStr, 1000, "smoothingLevel = %d\n", atts->GetSmoothingLevel());
    str += tmpStr;
    if(atts->GetPointSizeVarEnabled())
        SNPRINTF(tmpStr, 1000, "pointSizeVarEnabled = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "pointSizeVarEnabled = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "pointSizeVar = \"%s\"\n", atts->GetPointSizeVar().c_str());
    str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
PseudocolorAttributes_str(PyObject *v)
{
    PseudocolorAttributesObject *obj = (PseudocolorAttributesObject *)v;
    return PyPseudocolorAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *PseudocolorAttributes_Purpose = "Attributes for the pseudocolor plot";

//
// The type description structure
//
static PyTypeObject PseudocolorAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "PseudocolorAttributes",                    // tp_name
    sizeof(PseudocolorAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)PseudocolorAttributes_dealloc,  // tp_dealloc
    (printfunc)PseudocolorAttributes_print,     // tp_print
    (getattrfunc)PseudocolorAttributes_getattr, // tp_getattr
    (setattrfunc)PseudocolorAttributes_setattr, // tp_setattr
    (cmpfunc)PseudocolorAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)PseudocolorAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    PseudocolorAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static PseudocolorAttributes *defaultAtts = 0;

static PyObject *
NewPseudocolorAttributes()
{
    PseudocolorAttributesObject *newObject;
    newObject = PyObject_NEW(PseudocolorAttributesObject, &PseudocolorAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new PseudocolorAttributes(*defaultAtts);
    else
        newObject->data = new PseudocolorAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapPseudocolorAttributes(const PseudocolorAttributes *attr)
{
    PseudocolorAttributesObject *newObject;
    newObject = PyObject_NEW(PseudocolorAttributesObject, &PseudocolorAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (PseudocolorAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
PseudocolorAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewPseudocolorAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef PseudocolorAttributesMethods[] = {
    {"PseudocolorAttributes", PseudocolorAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *PseudocolorAttributesObserver = 0;
static bool PseudocolorAttributesEnableLogging = true;

static void
PyPseudocolorAttributes_WriteLog(Subject *subj, void *data)
{
    PseudocolorAttributes *atts = (PseudocolorAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!PseudocolorAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# PseudocolorAttributes_WriteLog()\n");
}

void
PyPseudocolorAttributes_StartUp(PseudocolorAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyPseudocolorAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(PseudocolorAttributesObserver == 0)
    {
        PseudocolorAttributesObserver = new ObserverToCallback(subj,
            PyPseudocolorAttributes_WriteLog, (void *)logFile);
    }

    PseudocolorAttributesEnableLogging = true;
}

void
PyPseudocolorAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete PseudocolorAttributesObserver;
    PseudocolorAttributesObserver = 0;
}

PyMethodDef *
PyPseudocolorAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return PseudocolorAttributesMethods;
}

bool
PyPseudocolorAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &PseudocolorAttributesType);
}

PseudocolorAttributes *
PyPseudocolorAttributes_FromPyObject(PyObject *obj)
{
    PseudocolorAttributesObject *obj2 = (PseudocolorAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyPseudocolorAttributes_NewPyObject()
{
    return NewPseudocolorAttributes();
}

PyObject *
PyPseudocolorAttributes_WrapPyObject(const PseudocolorAttributes *attr)
{
    return WrapPseudocolorAttributes(attr);
}

void
PyPseudocolorAttributes_SetLogging(bool val)
{
    PseudocolorAttributesEnableLogging = val;
}

void
PyPseudocolorAttributes_SetDefaults(const PseudocolorAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new PseudocolorAttributes(*atts);
}

