// ************************************************************************* //
//  File: PseudocolorViewerPluginInfo.C
// ************************************************************************* //

#include <PseudocolorPluginInfo.h>
#include <avtPseudocolorPlot.h>

#if defined(__APPLE__)
#define GetViewerInfo Pseudocolor_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Pseudocolor plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:45 PST 2004
//
// ****************************************************************************
extern "C" ViewerPlotPluginInfo* GetViewerInfo()
{
    PseudocolorViewerPluginInfo::InitializeGlobalObjects();
    return new PseudocolorViewerPluginInfo;
}

//
// Storage for static data elements.
//
PseudocolorAttributes *PseudocolorViewerPluginInfo::clientAtts = NULL;
PseudocolorAttributes *PseudocolorViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  PseudocolorViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:45 PST 2004
//
// ****************************************************************************
void
PseudocolorViewerPluginInfo::InitializeGlobalObjects()
{
    PseudocolorViewerPluginInfo::clientAtts  = new PseudocolorAttributes;
    PseudocolorViewerPluginInfo::defaultAtts = new PseudocolorAttributes;
}

// ****************************************************************************
//  Method: PseudocolorViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:45 PST 2004
//
// ****************************************************************************

AttributeSubject *
PseudocolorViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: PseudocolorViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:45 PST 2004
//
// ****************************************************************************

AttributeSubject *
PseudocolorViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: PseudocolorViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:45 PST 2004
//
// ****************************************************************************

void
PseudocolorViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(PseudocolorAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: PseudocolorViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:45 PST 2004
//
// ****************************************************************************

void
PseudocolorViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(PseudocolorAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: PseudocolorViewerPluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:45 PST 2004
//
// ****************************************************************************

avtPlot *
PseudocolorViewerPluginInfo::AllocAvtPlot()
{
    return new avtPseudocolorPlot;
}

// ****************************************************************************
//  Method: PseudocolorViewerPluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:45 PST 2004
//
// ****************************************************************************

void
PseudocolorViewerPluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtDatabaseMetaData *, const char *)
{
    *(PseudocolorAttributes*)atts = *defaultAtts;
}

// ****************************************************************************
// Method: PseudocolorViewerPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:45 PST 2004
//
// Modifications:
//   
// ****************************************************************************

int
PseudocolorViewerPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SCALAR | VAR_CATEGORY_SPECIES;
}


// ****************************************************************************
//  Method: PseudocolorViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:45 PST 2004
//
// ****************************************************************************

#include <Pseudocolor.xpm>
const char **
PseudocolorViewerPluginInfo::XPMIconData() const
{
    return Pseudocolor_xpm;
}
