// ************************************************************************* //
//  File: PseudocolorGUIPluginInfo.C
// ************************************************************************* //

#include <PseudocolorPluginInfo.h>
#include <PseudocolorAttributes.h>
#include <QvisPseudocolorPlotWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Pseudocolor_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Pseudocolor plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 11:51:34 PDT 2003
//
// ****************************************************************************
extern "C" GUIPlotPluginInfo* GetGUIInfo()
{
    return new PseudocolorGUIPluginInfo;
}

// ****************************************************************************
//  Method: PseudocolorGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 11:51:34 PDT 2003
//
// ****************************************************************************

const char *
PseudocolorGUIPluginInfo::GetMenuName() const
{
    return "Pseudocolor";
}


// ****************************************************************************
// Method: PseudocolorGUIPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 11:51:34 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

int
PseudocolorGUIPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SCALAR | VAR_CATEGORY_SPECIES;
}

// ****************************************************************************
//  Method: PseudocolorGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 11:51:34 PDT 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
PseudocolorGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisPseudocolorPlotWindow(type, (PseudocolorAttributes *)attr,
        "Pseudocolor plot attributes", "Pseudocolor plot", notepad);
}

// ****************************************************************************
//  Method: PseudocolorGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 11:51:34 PDT 2003
//
// ****************************************************************************

#include <Pseudocolor.xpm>
const char **
PseudocolorGUIPluginInfo::XPMIconData() const
{
    return Pseudocolor_xpm;
}
