#include <PyMeshAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyMeshAttributes
//
// Purpose: 
//   Attributes for the mesh plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Mon May 3 14:20:07 PST 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a MeshAttributes.
//
struct MeshAttributesObject
{
    PyObject_HEAD
    MeshAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewMeshAttributes();

static PyObject *
MeshAttributes_Notify(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MeshAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MeshAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

static PyObject *
MeshAttributes_SetLineStyle(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineStyle in the object.
    obj->data->SetLineStyle(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MeshAttributes_GetLineStyle(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineStyle()));
    return retval;
}

static PyObject *
MeshAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MeshAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

static PyObject *
MeshAttributes_SetMeshColor(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the meshColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetMeshColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MeshAttributes_GetMeshColor(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the meshColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *meshColor = obj->data->GetMeshColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(meshColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(meshColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(meshColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(meshColor[3])));
    return retval;
}

static PyObject *
MeshAttributes_SetOutlineOnlyFlag(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the outlineOnlyFlag in the object.
    obj->data->SetOutlineOnlyFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MeshAttributes_GetOutlineOnlyFlag(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOutlineOnlyFlag()?1L:0L);
    return retval;
}

static PyObject *
MeshAttributes_SetErrorTolerance(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the errorTolerance in the object.
    obj->data->SetErrorTolerance(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MeshAttributes_GetErrorTolerance(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetErrorTolerance());
    return retval;
}

static PyObject *
MeshAttributes_SetOpaqueMode(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the opaqueMode in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetOpaqueMode(MeshAttributes::OpaqueMode(ival));
    else
    {
        fprintf(stderr, "An invalid opaqueMode value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Auto, On, Off.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MeshAttributes_GetOpaqueMode(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOpaqueMode()));
    return retval;
}

static PyObject *
MeshAttributes_SetPointSize(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pointSize in the object.
    obj->data->SetPointSize(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MeshAttributes_GetPointSize(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPointSize());
    return retval;
}

static PyObject *
MeshAttributes_SetOpaqueColor(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the opaqueColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetOpaqueColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MeshAttributes_GetOpaqueColor(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the opaqueColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *opaqueColor = obj->data->GetOpaqueColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(opaqueColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(opaqueColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(opaqueColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(opaqueColor[3])));
    return retval;
}

static PyObject *
MeshAttributes_SetBackgroundFlag(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the backgroundFlag in the object.
    obj->data->SetBackgroundFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MeshAttributes_GetBackgroundFlag(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetBackgroundFlag()?1L:0L);
    return retval;
}

static PyObject *
MeshAttributes_SetForegroundFlag(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the foregroundFlag in the object.
    obj->data->SetForegroundFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MeshAttributes_GetForegroundFlag(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetForegroundFlag()?1L:0L);
    return retval;
}

static PyObject *
MeshAttributes_SetSmoothingLevel(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the smoothingLevel in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetSmoothingLevel(MeshAttributes::SmoothingLevel(ival));
    else
    {
        fprintf(stderr, "An invalid smoothingLevel value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "None, Fast, High.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MeshAttributes_GetSmoothingLevel(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSmoothingLevel()));
    return retval;
}

static PyObject *
MeshAttributes_SetPointSizeVarEnabled(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointSizeVarEnabled in the object.
    obj->data->SetPointSizeVarEnabled(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MeshAttributes_GetPointSizeVarEnabled(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPointSizeVarEnabled()?1L:0L);
    return retval;
}

static PyObject *
MeshAttributes_SetPointSizeVar(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the pointSizeVar in the object.
    obj->data->SetPointSizeVar(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MeshAttributes_GetPointSizeVar(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetPointSizeVar().c_str());
    return retval;
}

static PyObject *
MeshAttributes_SetPointType(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointType in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetPointType(MeshAttributes::PointType(ival));
    else
    {
        fprintf(stderr, "An invalid pointType value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "Box, Axis, Icosahedron, Point.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MeshAttributes_GetPointType(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointType()));
    return retval;
}

static PyObject *
MeshAttributes_SetShowInternal(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showInternal in the object.
    obj->data->SetShowInternal(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
MeshAttributes_GetShowInternal(PyObject *self, PyObject *args)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowInternal()?1L:0L);
    return retval;
}



static struct PyMethodDef MeshAttributes_methods[] = {
    {"Notify", MeshAttributes_Notify, METH_VARARGS},
    {"SetLegendFlag", MeshAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", MeshAttributes_GetLegendFlag, METH_VARARGS},
    {"SetLineStyle", MeshAttributes_SetLineStyle, METH_VARARGS},
    {"GetLineStyle", MeshAttributes_GetLineStyle, METH_VARARGS},
    {"SetLineWidth", MeshAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", MeshAttributes_GetLineWidth, METH_VARARGS},
    {"SetMeshColor", MeshAttributes_SetMeshColor, METH_VARARGS},
    {"GetMeshColor", MeshAttributes_GetMeshColor, METH_VARARGS},
    {"SetOutlineOnlyFlag", MeshAttributes_SetOutlineOnlyFlag, METH_VARARGS},
    {"GetOutlineOnlyFlag", MeshAttributes_GetOutlineOnlyFlag, METH_VARARGS},
    {"SetErrorTolerance", MeshAttributes_SetErrorTolerance, METH_VARARGS},
    {"GetErrorTolerance", MeshAttributes_GetErrorTolerance, METH_VARARGS},
    {"SetOpaqueMode", MeshAttributes_SetOpaqueMode, METH_VARARGS},
    {"GetOpaqueMode", MeshAttributes_GetOpaqueMode, METH_VARARGS},
    {"SetPointSize", MeshAttributes_SetPointSize, METH_VARARGS},
    {"GetPointSize", MeshAttributes_GetPointSize, METH_VARARGS},
    {"SetOpaqueColor", MeshAttributes_SetOpaqueColor, METH_VARARGS},
    {"GetOpaqueColor", MeshAttributes_GetOpaqueColor, METH_VARARGS},
    {"SetBackgroundFlag", MeshAttributes_SetBackgroundFlag, METH_VARARGS},
    {"GetBackgroundFlag", MeshAttributes_GetBackgroundFlag, METH_VARARGS},
    {"SetForegroundFlag", MeshAttributes_SetForegroundFlag, METH_VARARGS},
    {"GetForegroundFlag", MeshAttributes_GetForegroundFlag, METH_VARARGS},
    {"SetSmoothingLevel", MeshAttributes_SetSmoothingLevel, METH_VARARGS},
    {"GetSmoothingLevel", MeshAttributes_GetSmoothingLevel, METH_VARARGS},
    {"SetPointSizeVarEnabled", MeshAttributes_SetPointSizeVarEnabled, METH_VARARGS},
    {"GetPointSizeVarEnabled", MeshAttributes_GetPointSizeVarEnabled, METH_VARARGS},
    {"SetPointSizeVar", MeshAttributes_SetPointSizeVar, METH_VARARGS},
    {"GetPointSizeVar", MeshAttributes_GetPointSizeVar, METH_VARARGS},
    {"SetPointType", MeshAttributes_SetPointType, METH_VARARGS},
    {"GetPointType", MeshAttributes_GetPointType, METH_VARARGS},
    {"SetShowInternal", MeshAttributes_SetShowInternal, METH_VARARGS},
    {"GetShowInternal", MeshAttributes_GetShowInternal, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
MeshAttributes_dealloc(PyObject *v)
{
   MeshAttributesObject *obj = (MeshAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
MeshAttributes_compare(PyObject *v, PyObject *w)
{
    MeshAttributes *a = ((MeshAttributesObject *)v)->data;
    MeshAttributes *b = ((MeshAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
MeshAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "legendFlag") == 0)
        return MeshAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "lineStyle") == 0)
        return MeshAttributes_GetLineStyle(self, NULL);
    if(strcmp(name, "lineWidth") == 0)
        return MeshAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "meshColor") == 0)
        return MeshAttributes_GetMeshColor(self, NULL);
    if(strcmp(name, "outlineOnlyFlag") == 0)
        return MeshAttributes_GetOutlineOnlyFlag(self, NULL);
    if(strcmp(name, "errorTolerance") == 0)
        return MeshAttributes_GetErrorTolerance(self, NULL);
    if(strcmp(name, "opaqueMode") == 0)
        return MeshAttributes_GetOpaqueMode(self, NULL);
    if(strcmp(name, "Auto") == 0)
        return PyInt_FromLong(long(MeshAttributes::Auto));
    else if(strcmp(name, "On") == 0)
        return PyInt_FromLong(long(MeshAttributes::On));
    else if(strcmp(name, "Off") == 0)
        return PyInt_FromLong(long(MeshAttributes::Off));

    if(strcmp(name, "pointSize") == 0)
        return MeshAttributes_GetPointSize(self, NULL);
    if(strcmp(name, "opaqueColor") == 0)
        return MeshAttributes_GetOpaqueColor(self, NULL);
    if(strcmp(name, "backgroundFlag") == 0)
        return MeshAttributes_GetBackgroundFlag(self, NULL);
    if(strcmp(name, "foregroundFlag") == 0)
        return MeshAttributes_GetForegroundFlag(self, NULL);
    if(strcmp(name, "smoothingLevel") == 0)
        return MeshAttributes_GetSmoothingLevel(self, NULL);
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(MeshAttributes::None));
    else if(strcmp(name, "Fast") == 0)
        return PyInt_FromLong(long(MeshAttributes::Fast));
    else if(strcmp(name, "High") == 0)
        return PyInt_FromLong(long(MeshAttributes::High));

    if(strcmp(name, "pointSizeVarEnabled") == 0)
        return MeshAttributes_GetPointSizeVarEnabled(self, NULL);
    if(strcmp(name, "pointSizeVar") == 0)
        return MeshAttributes_GetPointSizeVar(self, NULL);
    if(strcmp(name, "pointType") == 0)
        return MeshAttributes_GetPointType(self, NULL);
    if(strcmp(name, "Box") == 0)
        return PyInt_FromLong(long(MeshAttributes::Box));
    else if(strcmp(name, "Axis") == 0)
        return PyInt_FromLong(long(MeshAttributes::Axis));
    else if(strcmp(name, "Icosahedron") == 0)
        return PyInt_FromLong(long(MeshAttributes::Icosahedron));
    else if(strcmp(name, "Point") == 0)
        return PyInt_FromLong(long(MeshAttributes::Point));

    if(strcmp(name, "showInternal") == 0)
        return MeshAttributes_GetShowInternal(self, NULL);

    return Py_FindMethod(MeshAttributes_methods, self, name);
}

static int
MeshAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "legendFlag") == 0)
        retval = (MeshAttributes_SetLegendFlag(self, tuple) != NULL);
    else if(strcmp(name, "lineStyle") == 0)
        retval = (MeshAttributes_SetLineStyle(self, tuple) != NULL);
    else if(strcmp(name, "lineWidth") == 0)
        retval = (MeshAttributes_SetLineWidth(self, tuple) != NULL);
    else if(strcmp(name, "meshColor") == 0)
        retval = (MeshAttributes_SetMeshColor(self, tuple) != NULL);
    else if(strcmp(name, "outlineOnlyFlag") == 0)
        retval = (MeshAttributes_SetOutlineOnlyFlag(self, tuple) != NULL);
    else if(strcmp(name, "errorTolerance") == 0)
        retval = (MeshAttributes_SetErrorTolerance(self, tuple) != NULL);
    else if(strcmp(name, "opaqueMode") == 0)
        retval = (MeshAttributes_SetOpaqueMode(self, tuple) != NULL);
    else if(strcmp(name, "pointSize") == 0)
        retval = (MeshAttributes_SetPointSize(self, tuple) != NULL);
    else if(strcmp(name, "opaqueColor") == 0)
        retval = (MeshAttributes_SetOpaqueColor(self, tuple) != NULL);
    else if(strcmp(name, "backgroundFlag") == 0)
        retval = (MeshAttributes_SetBackgroundFlag(self, tuple) != NULL);
    else if(strcmp(name, "foregroundFlag") == 0)
        retval = (MeshAttributes_SetForegroundFlag(self, tuple) != NULL);
    else if(strcmp(name, "smoothingLevel") == 0)
        retval = (MeshAttributes_SetSmoothingLevel(self, tuple) != NULL);
    else if(strcmp(name, "pointSizeVarEnabled") == 0)
        retval = (MeshAttributes_SetPointSizeVarEnabled(self, tuple) != NULL);
    else if(strcmp(name, "pointSizeVar") == 0)
        retval = (MeshAttributes_SetPointSizeVar(self, tuple) != NULL);
    else if(strcmp(name, "pointType") == 0)
        retval = (MeshAttributes_SetPointType(self, tuple) != NULL);
    else if(strcmp(name, "showInternal") == 0)
        retval = (MeshAttributes_SetShowInternal(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
MeshAttributes_print(PyObject *v, FILE *fp, int flags)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)v;

    if(obj->data->GetLegendFlag())
        fprintf(fp, "legendFlag = 1\n");
    else
        fprintf(fp, "legendFlag = 0\n");
    fprintf(fp, "lineStyle = %d\n", obj->data->GetLineStyle());
    fprintf(fp, "lineWidth = %d\n", obj->data->GetLineWidth());
    const unsigned char *meshColor = obj->data->GetMeshColor().GetColor();
    fprintf(fp, "meshColor = (%d, %d, %d, %d)\n", int(meshColor[0]), int(meshColor[1]), int(meshColor[2]), int(meshColor[3]));
    if(obj->data->GetOutlineOnlyFlag())
        fprintf(fp, "outlineOnlyFlag = 1\n");
    else
        fprintf(fp, "outlineOnlyFlag = 0\n");
    fprintf(fp, "errorTolerance = %g\n", obj->data->GetErrorTolerance());
    const char *opaqueMode_names = "Auto, On, Off";
    if(obj->data->GetOpaqueMode() == MeshAttributes::Auto)
        fprintf(fp, "opaqueMode = Auto  # %s\n", opaqueMode_names);
    else if(obj->data->GetOpaqueMode() == MeshAttributes::On)
        fprintf(fp, "opaqueMode = On  # %s\n", opaqueMode_names);
    else
        fprintf(fp, "opaqueMode = Off  # %s\n", opaqueMode_names);

    fprintf(fp, "pointSize = %g\n", obj->data->GetPointSize());
    const unsigned char *opaqueColor = obj->data->GetOpaqueColor().GetColor();
    fprintf(fp, "opaqueColor = (%d, %d, %d, %d)\n", int(opaqueColor[0]), int(opaqueColor[1]), int(opaqueColor[2]), int(opaqueColor[3]));
    if(obj->data->GetBackgroundFlag())
        fprintf(fp, "backgroundFlag = 1\n");
    else
        fprintf(fp, "backgroundFlag = 0\n");
    if(obj->data->GetForegroundFlag())
        fprintf(fp, "foregroundFlag = 1\n");
    else
        fprintf(fp, "foregroundFlag = 0\n");
    const char *smoothingLevel_names = "None, Fast, High";
    if(obj->data->GetSmoothingLevel() == MeshAttributes::None)
        fprintf(fp, "smoothingLevel = None  # %s\n", smoothingLevel_names);
    else if(obj->data->GetSmoothingLevel() == MeshAttributes::Fast)
        fprintf(fp, "smoothingLevel = Fast  # %s\n", smoothingLevel_names);
    else
        fprintf(fp, "smoothingLevel = High  # %s\n", smoothingLevel_names);

    if(obj->data->GetPointSizeVarEnabled())
        fprintf(fp, "pointSizeVarEnabled = 1\n");
    else
        fprintf(fp, "pointSizeVarEnabled = 0\n");
    fprintf(fp, "pointSizeVar = \"%s\"\n", obj->data->GetPointSizeVar().c_str());
    const char *pointType_names = "Box, Axis, Icosahedron, Point";
    if(obj->data->GetPointType() == MeshAttributes::Box)
        fprintf(fp, "pointType = Box  # %s\n", pointType_names);
    else if(obj->data->GetPointType() == MeshAttributes::Axis)
        fprintf(fp, "pointType = Axis  # %s\n", pointType_names);
    else if(obj->data->GetPointType() == MeshAttributes::Icosahedron)
        fprintf(fp, "pointType = Icosahedron  # %s\n", pointType_names);
    else
        fprintf(fp, "pointType = Point  # %s\n", pointType_names);

    if(obj->data->GetShowInternal())
        fprintf(fp, "showInternal = 1\n");
    else
        fprintf(fp, "showInternal = 0\n");

    return 0;
}

#include <snprintf.h>
PyObject *
PyMeshAttributes_StringRepresentation(const MeshAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "legendFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "legendFlag = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "lineStyle = %d\n", atts->GetLineStyle());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "lineWidth = %d\n", atts->GetLineWidth());
    str += tmpStr;
    const unsigned char *meshColor = atts->GetMeshColor().GetColor();
    SNPRINTF(tmpStr, 1000, "meshColor = (%d, %d, %d, %d)\n", int(meshColor[0]), int(meshColor[1]), int(meshColor[2]), int(meshColor[3]));
    str += tmpStr;
    if(atts->GetOutlineOnlyFlag())
        SNPRINTF(tmpStr, 1000, "outlineOnlyFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "outlineOnlyFlag = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "errorTolerance = %g\n", atts->GetErrorTolerance());
    str += tmpStr;
    const char *opaqueMode_names = "Auto, On, Off";
    if(atts->GetOpaqueMode() == MeshAttributes::Auto)
        {
             SNPRINTF(tmpStr, 10000, "opaqueMode = Auto  # %s\n", opaqueMode_names);
             str += tmpStr;
        }
    else if(atts->GetOpaqueMode() == MeshAttributes::On)
        {
             SNPRINTF(tmpStr, 10000, "opaqueMode = On  # %s\n", opaqueMode_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 10000, "opaqueMode = Off  # %s\n", opaqueMode_names);
             str += tmpStr;
        }

    SNPRINTF(tmpStr, 1000, "pointSize = %g\n", atts->GetPointSize());
    str += tmpStr;
    const unsigned char *opaqueColor = atts->GetOpaqueColor().GetColor();
    SNPRINTF(tmpStr, 1000, "opaqueColor = (%d, %d, %d, %d)\n", int(opaqueColor[0]), int(opaqueColor[1]), int(opaqueColor[2]), int(opaqueColor[3]));
    str += tmpStr;
    if(atts->GetBackgroundFlag())
        SNPRINTF(tmpStr, 1000, "backgroundFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "backgroundFlag = 0\n");
    str += tmpStr;
    if(atts->GetForegroundFlag())
        SNPRINTF(tmpStr, 1000, "foregroundFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "foregroundFlag = 0\n");
    str += tmpStr;
    const char *smoothingLevel_names = "None, Fast, High";
    if(atts->GetSmoothingLevel() == MeshAttributes::None)
        {
             SNPRINTF(tmpStr, 10000, "smoothingLevel = None  # %s\n", smoothingLevel_names);
             str += tmpStr;
        }
    else if(atts->GetSmoothingLevel() == MeshAttributes::Fast)
        {
             SNPRINTF(tmpStr, 10000, "smoothingLevel = Fast  # %s\n", smoothingLevel_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 10000, "smoothingLevel = High  # %s\n", smoothingLevel_names);
             str += tmpStr;
        }

    if(atts->GetPointSizeVarEnabled())
        SNPRINTF(tmpStr, 1000, "pointSizeVarEnabled = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "pointSizeVarEnabled = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "pointSizeVar = \"%s\"\n", atts->GetPointSizeVar().c_str());
    str += tmpStr;
    const char *pointType_names = "Box, Axis, Icosahedron, Point";
    if(atts->GetPointType() == MeshAttributes::Box)
        {
             SNPRINTF(tmpStr, 10000, "pointType = Box  # %s\n", pointType_names);
             str += tmpStr;
        }
    else if(atts->GetPointType() == MeshAttributes::Axis)
        {
             SNPRINTF(tmpStr, 10000, "pointType = Axis  # %s\n", pointType_names);
             str += tmpStr;
        }
    else if(atts->GetPointType() == MeshAttributes::Icosahedron)
        {
             SNPRINTF(tmpStr, 10000, "pointType = Icosahedron  # %s\n", pointType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 10000, "pointType = Point  # %s\n", pointType_names);
             str += tmpStr;
        }

    if(atts->GetOpaqueMeshIsAppropriate())
        SNPRINTF(tmpStr, 1000, "opaqueMeshIsAppropriate = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "opaqueMeshIsAppropriate = 0\n");
    str += tmpStr;
    if(atts->GetShowInternal())
        SNPRINTF(tmpStr, 1000, "showInternal = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "showInternal = 0\n");
    str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
MeshAttributes_str(PyObject *v)
{
    MeshAttributesObject *obj = (MeshAttributesObject *)v;
    return PyMeshAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *MeshAttributes_Purpose = "Attributes for the mesh plot";

//
// The type description structure
//
static PyTypeObject MeshAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "MeshAttributes",                    // tp_name
    sizeof(MeshAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)MeshAttributes_dealloc,  // tp_dealloc
    (printfunc)MeshAttributes_print,     // tp_print
    (getattrfunc)MeshAttributes_getattr, // tp_getattr
    (setattrfunc)MeshAttributes_setattr, // tp_setattr
    (cmpfunc)MeshAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)MeshAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    MeshAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static MeshAttributes *defaultAtts = 0;

static PyObject *
NewMeshAttributes()
{
    MeshAttributesObject *newObject;
    newObject = PyObject_NEW(MeshAttributesObject, &MeshAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new MeshAttributes(*defaultAtts);
    else
        newObject->data = new MeshAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapMeshAttributes(const MeshAttributes *attr)
{
    MeshAttributesObject *newObject;
    newObject = PyObject_NEW(MeshAttributesObject, &MeshAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (MeshAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
MeshAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewMeshAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef MeshAttributesMethods[] = {
    {"MeshAttributes", MeshAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *MeshAttributesObserver = 0;
static bool MeshAttributesEnableLogging = true;

static void
PyMeshAttributes_WriteLog(Subject *subj, void *data)
{
    MeshAttributes *atts = (MeshAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!MeshAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# MeshAttributes_WriteLog()\n");
}

void
PyMeshAttributes_StartUp(MeshAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyMeshAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(MeshAttributesObserver == 0)
    {
        MeshAttributesObserver = new ObserverToCallback(subj,
            PyMeshAttributes_WriteLog, (void *)logFile);
    }

    MeshAttributesEnableLogging = true;
}

void
PyMeshAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete MeshAttributesObserver;
    MeshAttributesObserver = 0;
}

PyMethodDef *
PyMeshAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return MeshAttributesMethods;
}

bool
PyMeshAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &MeshAttributesType);
}

MeshAttributes *
PyMeshAttributes_FromPyObject(PyObject *obj)
{
    MeshAttributesObject *obj2 = (MeshAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyMeshAttributes_NewPyObject()
{
    return NewMeshAttributes();
}

PyObject *
PyMeshAttributes_WrapPyObject(const MeshAttributes *attr)
{
    return WrapMeshAttributes(attr);
}

void
PyMeshAttributes_SetLogging(bool val)
{
    MeshAttributesEnableLogging = val;
}

void
PyMeshAttributes_SetDefaults(const MeshAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new MeshAttributes(*atts);
}

