// ************************************************************************* //
//  File: MeshViewerPluginInfo.C
// ************************************************************************* //

#include <MeshPluginInfo.h>
#include <avtMeshPlot.h>

#if defined(__APPLE__)
#define GetViewerInfo Mesh_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Mesh plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:42 PST 2004
//
// ****************************************************************************
extern "C" ViewerPlotPluginInfo* GetViewerInfo()
{
    MeshViewerPluginInfo::InitializeGlobalObjects();
    return new MeshViewerPluginInfo;
}

//
// Storage for static data elements.
//
MeshAttributes *MeshViewerPluginInfo::clientAtts = NULL;
MeshAttributes *MeshViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  MeshViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:42 PST 2004
//
// ****************************************************************************
void
MeshViewerPluginInfo::InitializeGlobalObjects()
{
    MeshViewerPluginInfo::clientAtts  = new MeshAttributes;
    MeshViewerPluginInfo::defaultAtts = new MeshAttributes;
}

// ****************************************************************************
//  Method: MeshViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:42 PST 2004
//
// ****************************************************************************

AttributeSubject *
MeshViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: MeshViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:42 PST 2004
//
// ****************************************************************************

AttributeSubject *
MeshViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: MeshViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:42 PST 2004
//
// ****************************************************************************

void
MeshViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(MeshAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: MeshViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:42 PST 2004
//
// ****************************************************************************

void
MeshViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(MeshAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: MeshViewerPluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:42 PST 2004
//
// ****************************************************************************

avtPlot *
MeshViewerPluginInfo::AllocAvtPlot()
{
    return new avtMeshPlot;
}

// ****************************************************************************
//  Method: MeshViewerPluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:42 PST 2004
//
// ****************************************************************************

void
MeshViewerPluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtDatabaseMetaData *, const char *)
{
    *(MeshAttributes*)atts = *defaultAtts;
}

// ****************************************************************************
// Method: MeshViewerPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:42 PST 2004
//
// Modifications:
//   
// ****************************************************************************

int
MeshViewerPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_MESH;
}


// ****************************************************************************
//  Method: MeshViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:42 PST 2004
//
// ****************************************************************************

#include <Mesh.xpm>
const char **
MeshViewerPluginInfo::XPMIconData() const
{
    return Mesh_xpm;
}
