// ************************************************************************* //
//                        MeshScriptingPluginInfo.C
// ************************************************************************* //
#include <MeshPluginInfo.h>
#include <PyMeshAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Mesh_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Mesh plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// ****************************************************************************
extern "C" ScriptingPlotPluginInfo* GetScriptingInfo()
{
    return new MeshScriptingPluginInfo;
}

// ****************************************************************************
// Method: MeshScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
MeshScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyMeshAttributes_StartUp((MeshAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: MeshScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void *
MeshScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyMeshAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: MeshScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Mesh plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

bool
MeshScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyMeshAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: MeshScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
MeshScriptingPluginInfo::SetLogging(bool val)
{
    PyMeshAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: MeshScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon May 6 15:19:07 PST 2002
//
// Modifications:
//   
// ****************************************************************************

void
MeshScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyMeshAttributes_SetDefaults((const MeshAttributes *)atts);
}
