// ************************************************************************* //
//  File: MeshGUIPluginInfo.C
// ************************************************************************* //

#include <MeshPluginInfo.h>
#include <MeshAttributes.h>
#include <QvisMeshPlotWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Mesh_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Mesh plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 13:45:22 PST 2003
//
// ****************************************************************************
extern "C" GUIPlotPluginInfo* GetGUIInfo()
{
    return new MeshGUIPluginInfo;
}

// ****************************************************************************
//  Method: MeshGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 13:45:22 PST 2003
//
// ****************************************************************************

const char *
MeshGUIPluginInfo::GetMenuName() const
{
    return "Mesh";
}


// ****************************************************************************
// Method: MeshGUIPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 13:45:22 PST 2003
//
// Modifications:
//   
// ****************************************************************************

int
MeshGUIPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_MESH;
}

// ****************************************************************************
//  Method: MeshGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 13:45:22 PST 2003
//
// ****************************************************************************

QvisPostableWindowObserver *
MeshGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisMeshPlotWindow(type, (MeshAttributes *)attr,
        "Mesh plot attributes", "Mesh plot", notepad);
}

// ****************************************************************************
//  Method: MeshGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 14 13:45:22 PST 2003
//
// ****************************************************************************

#include <Mesh.xpm>
const char **
MeshGUIPluginInfo::XPMIconData() const
{
    return Mesh_xpm;
}
