#include <MeshAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for MeshAttributes::PointType
//

static const char *PointType_strings[] = {
"Box", "Axis", "Icosahedron", 
"Point"};

std::string
MeshAttributes::PointType_ToString(MeshAttributes::PointType t)
{
    int index = int(t);
    if(index < 0 || index >= 4) index = 0;
    return PointType_strings[index];
}

std::string
MeshAttributes::PointType_ToString(int t)
{
    int index = (t < 0 || t >= 4) ? 0 : t;
    return PointType_strings[index];
}

bool
MeshAttributes::PointType_FromString(const std::string &s, MeshAttributes::PointType &val)
{
    val = MeshAttributes::Box;
    for(int i = 0; i < 4; ++i)
    {
        if(s == PointType_strings[i])
        {
            val = (PointType)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for MeshAttributes::SmoothingLevel
//

static const char *SmoothingLevel_strings[] = {
"None", "Fast", "High"
};

std::string
MeshAttributes::SmoothingLevel_ToString(MeshAttributes::SmoothingLevel t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return SmoothingLevel_strings[index];
}

std::string
MeshAttributes::SmoothingLevel_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return SmoothingLevel_strings[index];
}

bool
MeshAttributes::SmoothingLevel_FromString(const std::string &s, MeshAttributes::SmoothingLevel &val)
{
    val = MeshAttributes::None;
    for(int i = 0; i < 3; ++i)
    {
        if(s == SmoothingLevel_strings[i])
        {
            val = (SmoothingLevel)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for MeshAttributes::OpaqueMode
//

static const char *OpaqueMode_strings[] = {
"Auto", "On", "Off"
};

std::string
MeshAttributes::OpaqueMode_ToString(MeshAttributes::OpaqueMode t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return OpaqueMode_strings[index];
}

std::string
MeshAttributes::OpaqueMode_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return OpaqueMode_strings[index];
}

bool
MeshAttributes::OpaqueMode_FromString(const std::string &s, MeshAttributes::OpaqueMode &val)
{
    val = MeshAttributes::Auto;
    for(int i = 0; i < 3; ++i)
    {
        if(s == OpaqueMode_strings[i])
        {
            val = (OpaqueMode)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: MeshAttributes::MeshAttributes
//
// Purpose: 
//   Constructor for the MeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 10:35:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

MeshAttributes::MeshAttributes() : AttributeSubject("biiabdidabbibsibb"),
    meshColor(0, 0, 0), opaqueColor(255, 255, 255)
{
    legendFlag = true;
    lineStyle = 0;
    lineWidth = 0;
    outlineOnlyFlag = false;
    errorTolerance = 0.01;
    opaqueMode = Auto;
    pointSize = 0.05;
    backgroundFlag = true;
    foregroundFlag = true;
    smoothingLevel = None;
    pointSizeVarEnabled = false;
    pointSizeVar = "default";
    pointType = Box;
    opaqueMeshIsAppropriate = true;
    showInternal = false;
}

// ****************************************************************************
// Method: MeshAttributes::MeshAttributes
//
// Purpose: 
//   Copy constructor for the MeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 10:35:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

MeshAttributes::MeshAttributes(const MeshAttributes &obj) : AttributeSubject("biiabdidabbibsibb")
{
    legendFlag = obj.legendFlag;
    lineStyle = obj.lineStyle;
    lineWidth = obj.lineWidth;
    meshColor = obj.meshColor;
    outlineOnlyFlag = obj.outlineOnlyFlag;
    errorTolerance = obj.errorTolerance;
    opaqueMode = obj.opaqueMode;
    pointSize = obj.pointSize;
    opaqueColor = obj.opaqueColor;
    backgroundFlag = obj.backgroundFlag;
    foregroundFlag = obj.foregroundFlag;
    smoothingLevel = obj.smoothingLevel;
    pointSizeVarEnabled = obj.pointSizeVarEnabled;
    pointSizeVar = obj.pointSizeVar;
    pointType = obj.pointType;
    opaqueMeshIsAppropriate = obj.opaqueMeshIsAppropriate;
    showInternal = obj.showInternal;

    SelectAll();
}

// ****************************************************************************
// Method: MeshAttributes::~MeshAttributes
//
// Purpose: 
//   Destructor for the MeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 10:35:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

MeshAttributes::~MeshAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: MeshAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the MeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 10:35:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

MeshAttributes& 
MeshAttributes::operator = (const MeshAttributes &obj)
{
    if (this == &obj) return *this;
    legendFlag = obj.legendFlag;
    lineStyle = obj.lineStyle;
    lineWidth = obj.lineWidth;
    meshColor = obj.meshColor;
    outlineOnlyFlag = obj.outlineOnlyFlag;
    errorTolerance = obj.errorTolerance;
    opaqueMode = obj.opaqueMode;
    pointSize = obj.pointSize;
    opaqueColor = obj.opaqueColor;
    backgroundFlag = obj.backgroundFlag;
    foregroundFlag = obj.foregroundFlag;
    smoothingLevel = obj.smoothingLevel;
    pointSizeVarEnabled = obj.pointSizeVarEnabled;
    pointSizeVar = obj.pointSizeVar;
    pointType = obj.pointType;
    opaqueMeshIsAppropriate = obj.opaqueMeshIsAppropriate;
    showInternal = obj.showInternal;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: MeshAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the MeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 10:35:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
MeshAttributes::operator == (const MeshAttributes &obj) const
{
    // Create the return value
    return ((legendFlag == obj.legendFlag) &&
            (lineStyle == obj.lineStyle) &&
            (lineWidth == obj.lineWidth) &&
            (meshColor == obj.meshColor) &&
            (outlineOnlyFlag == obj.outlineOnlyFlag) &&
            (errorTolerance == obj.errorTolerance) &&
            (opaqueMode == obj.opaqueMode) &&
            (pointSize == obj.pointSize) &&
            (opaqueColor == obj.opaqueColor) &&
            (backgroundFlag == obj.backgroundFlag) &&
            (foregroundFlag == obj.foregroundFlag) &&
            (smoothingLevel == obj.smoothingLevel) &&
            (pointSizeVarEnabled == obj.pointSizeVarEnabled) &&
            (pointSizeVar == obj.pointSizeVar) &&
            (pointType == obj.pointType) &&
            (opaqueMeshIsAppropriate == obj.opaqueMeshIsAppropriate) &&
            (showInternal == obj.showInternal));
}

// ****************************************************************************
// Method: MeshAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the MeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 10:35:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
MeshAttributes::operator != (const MeshAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: MeshAttributes::TypeName
//
// Purpose: 
//   Type name method for the MeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 10:35:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
MeshAttributes::TypeName() const
{
    return "MeshAttributes";
}

// ****************************************************************************
// Method: MeshAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the MeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 10:35:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
MeshAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const MeshAttributes *tmp = (const MeshAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: MeshAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the MeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 10:35:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
MeshAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new MeshAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: MeshAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the MeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 10:35:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
MeshAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new MeshAttributes(*this);
    else
        retval = new MeshAttributes;

    return retval;
}

// ****************************************************************************
// Method: MeshAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 10:35:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
MeshAttributes::SelectAll()
{
    Select(0, (void *)&legendFlag);
    Select(1, (void *)&lineStyle);
    Select(2, (void *)&lineWidth);
    Select(3, (void *)&meshColor);
    Select(4, (void *)&outlineOnlyFlag);
    Select(5, (void *)&errorTolerance);
    Select(6, (void *)&opaqueMode);
    Select(7, (void *)&pointSize);
    Select(8, (void *)&opaqueColor);
    Select(9, (void *)&backgroundFlag);
    Select(10, (void *)&foregroundFlag);
    Select(11, (void *)&smoothingLevel);
    Select(12, (void *)&pointSizeVarEnabled);
    Select(13, (void *)&pointSizeVar);
    Select(14, (void *)&pointType);
    Select(15, (void *)&opaqueMeshIsAppropriate);
    Select(16, (void *)&showInternal);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: MeshAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 10:35:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
MeshAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    MeshAttributes defaultObject;
    bool addToParent = false;
    // Create a node for MeshAttributes.
    DataNode *node = new DataNode("MeshAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("legendFlag", legendFlag));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineStyle", lineStyle));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineWidth", lineWidth));
    }

        DataNode *meshColorNode = new DataNode("meshColor");
        if(meshColor.CreateNode(meshColorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(meshColorNode);
        }
        else
            delete meshColorNode;
    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("outlineOnlyFlag", outlineOnlyFlag));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("errorTolerance", errorTolerance));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("opaqueMode", OpaqueMode_ToString(opaqueMode)));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("pointSize", pointSize));
    }

        DataNode *opaqueColorNode = new DataNode("opaqueColor");
        if(opaqueColor.CreateNode(opaqueColorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(opaqueColorNode);
        }
        else
            delete opaqueColorNode;
    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("backgroundFlag", backgroundFlag));
    }

    if(completeSave || !FieldsEqual(10, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("foregroundFlag", foregroundFlag));
    }

    if(completeSave || !FieldsEqual(11, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("smoothingLevel", SmoothingLevel_ToString(smoothingLevel)));
    }

    if(completeSave || !FieldsEqual(12, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("pointSizeVarEnabled", pointSizeVarEnabled));
    }

    if(completeSave || !FieldsEqual(13, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("pointSizeVar", pointSizeVar));
    }

    if(completeSave || !FieldsEqual(14, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("pointType", PointType_ToString(pointType)));
    }

    if(completeSave || !FieldsEqual(15, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("opaqueMeshIsAppropriate", opaqueMeshIsAppropriate));
    }

    if(completeSave || !FieldsEqual(16, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showInternal", showInternal));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: MeshAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 10:35:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

void
MeshAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("MeshAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("legendFlag")) != 0)
        SetLegendFlag(node->AsBool());
    if((node = searchNode->GetNode("lineStyle")) != 0)
        SetLineStyle(node->AsInt());
    if((node = searchNode->GetNode("lineWidth")) != 0)
        SetLineWidth(node->AsInt());
    if((node = searchNode->GetNode("meshColor")) != 0)
        meshColor.SetFromNode(node);
    if((node = searchNode->GetNode("outlineOnlyFlag")) != 0)
        SetOutlineOnlyFlag(node->AsBool());
    if((node = searchNode->GetNode("errorTolerance")) != 0)
        SetErrorTolerance(node->AsDouble());
    if((node = searchNode->GetNode("opaqueMode")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetOpaqueMode(OpaqueMode(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            OpaqueMode value;
            if(OpaqueMode_FromString(node->AsString(), value))
                SetOpaqueMode(value);
        }
    }
    if((node = searchNode->GetNode("pointSize")) != 0)
        SetPointSize(node->AsDouble());
    if((node = searchNode->GetNode("opaqueColor")) != 0)
        opaqueColor.SetFromNode(node);
    if((node = searchNode->GetNode("backgroundFlag")) != 0)
        SetBackgroundFlag(node->AsBool());
    if((node = searchNode->GetNode("foregroundFlag")) != 0)
        SetForegroundFlag(node->AsBool());
    if((node = searchNode->GetNode("smoothingLevel")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetSmoothingLevel(SmoothingLevel(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            SmoothingLevel value;
            if(SmoothingLevel_FromString(node->AsString(), value))
                SetSmoothingLevel(value);
        }
    }
    if((node = searchNode->GetNode("pointSizeVarEnabled")) != 0)
        SetPointSizeVarEnabled(node->AsBool());
    if((node = searchNode->GetNode("pointSizeVar")) != 0)
        SetPointSizeVar(node->AsString());
    if((node = searchNode->GetNode("pointType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 4)
                SetPointType(PointType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            PointType value;
            if(PointType_FromString(node->AsString(), value))
                SetPointType(value);
        }
    }
    if((node = searchNode->GetNode("opaqueMeshIsAppropriate")) != 0)
        SetOpaqueMeshIsAppropriate(node->AsBool());
    if((node = searchNode->GetNode("showInternal")) != 0)
        SetShowInternal(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
MeshAttributes::SetLegendFlag(bool legendFlag_)
{
    legendFlag = legendFlag_;
    Select(0, (void *)&legendFlag);
}

void
MeshAttributes::SetLineStyle(int lineStyle_)
{
    lineStyle = lineStyle_;
    Select(1, (void *)&lineStyle);
}

void
MeshAttributes::SetLineWidth(int lineWidth_)
{
    lineWidth = lineWidth_;
    Select(2, (void *)&lineWidth);
}

void
MeshAttributes::SetMeshColor(const ColorAttribute &meshColor_)
{
    meshColor = meshColor_;
    Select(3, (void *)&meshColor);
}

void
MeshAttributes::SetOutlineOnlyFlag(bool outlineOnlyFlag_)
{
    outlineOnlyFlag = outlineOnlyFlag_;
    Select(4, (void *)&outlineOnlyFlag);
}

void
MeshAttributes::SetErrorTolerance(double errorTolerance_)
{
    errorTolerance = errorTolerance_;
    Select(5, (void *)&errorTolerance);
}

void
MeshAttributes::SetOpaqueMode(MeshAttributes::OpaqueMode opaqueMode_)
{
    opaqueMode = opaqueMode_;
    Select(6, (void *)&opaqueMode);
}

void
MeshAttributes::SetPointSize(double pointSize_)
{
    pointSize = pointSize_;
    Select(7, (void *)&pointSize);
}

void
MeshAttributes::SetOpaqueColor(const ColorAttribute &opaqueColor_)
{
    opaqueColor = opaqueColor_;
    Select(8, (void *)&opaqueColor);
}

void
MeshAttributes::SetBackgroundFlag(bool backgroundFlag_)
{
    backgroundFlag = backgroundFlag_;
    Select(9, (void *)&backgroundFlag);
}

void
MeshAttributes::SetForegroundFlag(bool foregroundFlag_)
{
    foregroundFlag = foregroundFlag_;
    Select(10, (void *)&foregroundFlag);
}

void
MeshAttributes::SetSmoothingLevel(MeshAttributes::SmoothingLevel smoothingLevel_)
{
    smoothingLevel = smoothingLevel_;
    Select(11, (void *)&smoothingLevel);
}

void
MeshAttributes::SetPointSizeVarEnabled(bool pointSizeVarEnabled_)
{
    pointSizeVarEnabled = pointSizeVarEnabled_;
    Select(12, (void *)&pointSizeVarEnabled);
}

void
MeshAttributes::SetPointSizeVar(const std::string &pointSizeVar_)
{
    pointSizeVar = pointSizeVar_;
    Select(13, (void *)&pointSizeVar);
}

void
MeshAttributes::SetPointType(MeshAttributes::PointType pointType_)
{
    pointType = pointType_;
    Select(14, (void *)&pointType);
}

void
MeshAttributes::SetOpaqueMeshIsAppropriate(bool opaqueMeshIsAppropriate_)
{
    opaqueMeshIsAppropriate = opaqueMeshIsAppropriate_;
    Select(15, (void *)&opaqueMeshIsAppropriate);
}

void
MeshAttributes::SetShowInternal(bool showInternal_)
{
    showInternal = showInternal_;
    Select(16, (void *)&showInternal);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
MeshAttributes::GetLegendFlag() const
{
    return legendFlag;
}

int
MeshAttributes::GetLineStyle() const
{
    return lineStyle;
}

int
MeshAttributes::GetLineWidth() const
{
    return lineWidth;
}

const ColorAttribute &
MeshAttributes::GetMeshColor() const
{
    return meshColor;
}

ColorAttribute &
MeshAttributes::GetMeshColor()
{
    return meshColor;
}

bool
MeshAttributes::GetOutlineOnlyFlag() const
{
    return outlineOnlyFlag;
}

double
MeshAttributes::GetErrorTolerance() const
{
    return errorTolerance;
}

MeshAttributes::OpaqueMode
MeshAttributes::GetOpaqueMode() const
{
    return OpaqueMode(opaqueMode);
}

double
MeshAttributes::GetPointSize() const
{
    return pointSize;
}

const ColorAttribute &
MeshAttributes::GetOpaqueColor() const
{
    return opaqueColor;
}

ColorAttribute &
MeshAttributes::GetOpaqueColor()
{
    return opaqueColor;
}

bool
MeshAttributes::GetBackgroundFlag() const
{
    return backgroundFlag;
}

bool
MeshAttributes::GetForegroundFlag() const
{
    return foregroundFlag;
}

MeshAttributes::SmoothingLevel
MeshAttributes::GetSmoothingLevel() const
{
    return SmoothingLevel(smoothingLevel);
}

bool
MeshAttributes::GetPointSizeVarEnabled() const
{
    return pointSizeVarEnabled;
}

const std::string &
MeshAttributes::GetPointSizeVar() const
{
    return pointSizeVar;
}

std::string &
MeshAttributes::GetPointSizeVar()
{
    return pointSizeVar;
}

MeshAttributes::PointType
MeshAttributes::GetPointType() const
{
    return PointType(pointType);
}

bool
MeshAttributes::GetOpaqueMeshIsAppropriate() const
{
    return opaqueMeshIsAppropriate;
}

bool
MeshAttributes::GetShowInternal() const
{
    return showInternal;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
MeshAttributes::SelectMeshColor()
{
    Select(3, (void *)&meshColor);
}

void
MeshAttributes::SelectOpaqueColor()
{
    Select(8, (void *)&opaqueColor);
}

void
MeshAttributes::SelectPointSizeVar()
{
    Select(13, (void *)&pointSizeVar);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: MeshAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 10:35:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
MeshAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Legend";
        case 1:  return "Line style";
        case 2:  return "Line width";
        case 3:  return "Color";
        case 4:  return "Outline only";
        case 5:  return "Tolerance";
        case 6:  return "Opaque mode";
        case 7:  return "Point size";
        case 8:  return "Color";
        case 9:  return "Use Background ";
        case 10:  return "Use Foreground ";
        case 11:  return "Smoothing";
        case 12:  return "Point size by var enabled";
        case 13:  return "Point size by var";
        case 14:  return "Point Type";
        case 15:  return "Opaque Mesh Is Appropriate";
        case 16:  return "Show Internal";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: MeshAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 10:35:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
MeshAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_bool;
        case 1:  return FieldType_linestyle;
        case 2:  return FieldType_linewidth;
        case 3:  return FieldType_color;
        case 4:  return FieldType_bool;
        case 5:  return FieldType_double;
        case 6:  return FieldType_enum;
        case 7:  return FieldType_double;
        case 8:  return FieldType_color;
        case 9:  return FieldType_bool;
        case 10:  return FieldType_bool;
        case 11:  return FieldType_enum;
        case 12:  return FieldType_bool;
        case 13:  return FieldType_variablename;
        case 14:  return FieldType_enum;
        case 15:  return FieldType_bool;
        case 16:  return FieldType_bool;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: MeshAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 10:35:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
MeshAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "bool";
        case 1:  return "linestyle";
        case 2:  return "linewidth";
        case 3:  return "color";
        case 4:  return "bool";
        case 5:  return "double";
        case 6:  return "enum";
        case 7:  return "double";
        case 8:  return "color";
        case 9:  return "bool";
        case 10:  return "bool";
        case 11:  return "enum";
        case 12:  return "bool";
        case 13:  return "variablename";
        case 14:  return "enum";
        case 15:  return "bool";
        case 16:  return "bool";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: MeshAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Tue Nov 2 10:35:34 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

bool
MeshAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const MeshAttributes &obj = *((const MeshAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (legendFlag == obj.legendFlag);
        }
        break;
    case 1:
        {  // new scope
        retval = (lineStyle == obj.lineStyle);
        }
        break;
    case 2:
        {  // new scope
        retval = (lineWidth == obj.lineWidth);
        }
        break;
    case 3:
        {  // new scope
        retval = (meshColor == obj.meshColor);
        }
        break;
    case 4:
        {  // new scope
        retval = (outlineOnlyFlag == obj.outlineOnlyFlag);
        }
        break;
    case 5:
        {  // new scope
        retval = (errorTolerance == obj.errorTolerance);
        }
        break;
    case 6:
        {  // new scope
        retval = (opaqueMode == obj.opaqueMode);
        }
        break;
    case 7:
        {  // new scope
        retval = (pointSize == obj.pointSize);
        }
        break;
    case 8:
        {  // new scope
        retval = (opaqueColor == obj.opaqueColor);
        }
        break;
    case 9:
        {  // new scope
        retval = (backgroundFlag == obj.backgroundFlag);
        }
        break;
    case 10:
        {  // new scope
        retval = (foregroundFlag == obj.foregroundFlag);
        }
        break;
    case 11:
        {  // new scope
        retval = (smoothingLevel == obj.smoothingLevel);
        }
        break;
    case 12:
        {  // new scope
        retval = (pointSizeVarEnabled == obj.pointSizeVarEnabled);
        }
        break;
    case 13:
        {  // new scope
        retval = (pointSizeVar == obj.pointSizeVar);
        }
        break;
    case 14:
        {  // new scope
        retval = (pointType == obj.pointType);
        }
        break;
    case 15:
        {  // new scope
        retval = (opaqueMeshIsAppropriate == obj.opaqueMeshIsAppropriate);
        }
        break;
    case 16:
        {  // new scope
        retval = (showInternal == obj.showInternal);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
//  Modifications: 
//
//    Kathleen Bonnell, Wed Aug 22 16:00:32 PDT 2001
//    Changing opaque mode no longer requires recalculation.
//
//    Jeremy Meredith, Mon Dec  9 16:30:54 PST 2002
//    Added smoothing level.
//
//    Jeremy Meredith, Fri Dec 20 11:33:43 PST 2002
//    Added point size variable and its enabled flag.
//
//    Hank Childs, Thu Aug 21 23:05:45 PDT 2003
//    Added point type.
//
//    Kathleen Bonnell, Thu Feb  5 13:07:06 PST 2004 
//    Added spatDim argument, added showInternal. 
//
//    Kathleen Bonnell, Tue Nov  2 10:32:21 PST 2004 
//    Removed point type and point size from test, changed pointSizeVar test
//    so that only true if changes require adding new secondary varaible. 
//
// ****************************************************************************

bool
MeshAttributes::ChangesRequireRecalculation(const MeshAttributes &obj,
                                            const int spatDim)
{
    bool needSecondaryVar = (obj.pointSizeVarEnabled && 
                            ((pointSizeVar != obj.pointSizeVar) &&
                             (obj.pointSizeVar != "default") &&
                             (obj.pointSizeVar != "") &&
                             (obj.pointSizeVar != "\0"))); 

    return ((outlineOnlyFlag != obj.outlineOnlyFlag) ||
            (errorTolerance != obj.errorTolerance) ||
            (needSecondaryVar) ||
            (smoothingLevel != obj.smoothingLevel) ||
            (showInternal != obj.showInternal && spatDim == 3));
}

