#include <PyLabelAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyLabelAttributes
//
// Purpose: 
//   This class contains the fields that we need to set the attributes for the Label plot.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Thu Oct 21 18:18:12 PST 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a LabelAttributes.
//
struct LabelAttributesObject
{
    PyObject_HEAD
    LabelAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewLabelAttributes();

static PyObject *
LabelAttributes_Notify(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LabelAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LabelAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

static PyObject *
LabelAttributes_SetShowNodes(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showNodes in the object.
    obj->data->SetShowNodes(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LabelAttributes_GetShowNodes(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowNodes()?1L:0L);
    return retval;
}

static PyObject *
LabelAttributes_SetShowCells(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showCells in the object.
    obj->data->SetShowCells(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LabelAttributes_GetShowCells(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowCells()?1L:0L);
    return retval;
}

static PyObject *
LabelAttributes_SetRestrictNumberOfLabels(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the restrictNumberOfLabels in the object.
    obj->data->SetRestrictNumberOfLabels(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LabelAttributes_GetRestrictNumberOfLabels(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetRestrictNumberOfLabels()?1L:0L);
    return retval;
}

static PyObject *
LabelAttributes_SetDrawLabelsFacing(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the drawLabelsFacing in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetDrawLabelsFacing(LabelAttributes::LabelDrawFacing(ival));
    else
    {
        fprintf(stderr, "An invalid drawLabelsFacing value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Front, Back, FrontAndBack.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LabelAttributes_GetDrawLabelsFacing(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDrawLabelsFacing()));
    return retval;
}

static PyObject *
LabelAttributes_SetShowSingleNode(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showSingleNode in the object.
    obj->data->SetShowSingleNode(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LabelAttributes_GetShowSingleNode(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowSingleNode()?1L:0L);
    return retval;
}

static PyObject *
LabelAttributes_SetShowSingleCell(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showSingleCell in the object.
    obj->data->SetShowSingleCell(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LabelAttributes_GetShowSingleCell(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowSingleCell()?1L:0L);
    return retval;
}

static PyObject *
LabelAttributes_SetUseForegroundTextColor(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useForegroundTextColor in the object.
    obj->data->SetUseForegroundTextColor(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LabelAttributes_GetUseForegroundTextColor(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseForegroundTextColor()?1L:0L);
    return retval;
}

static PyObject *
LabelAttributes_SetLabelDisplayFormat(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the labelDisplayFormat in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetLabelDisplayFormat(LabelAttributes::LabelIndexDisplay(ival));
    else
    {
        fprintf(stderr, "An invalid labelDisplayFormat value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Natural, LogicalIndex, Index.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LabelAttributes_GetLabelDisplayFormat(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLabelDisplayFormat()));
    return retval;
}

static PyObject *
LabelAttributes_SetNumberOfLabels(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numberOfLabels in the object.
    obj->data->SetNumberOfLabels(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LabelAttributes_GetNumberOfLabels(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumberOfLabels()));
    return retval;
}

static PyObject *
LabelAttributes_SetTextColor(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the textColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetTextColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LabelAttributes_GetTextColor(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the textColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *textColor = obj->data->GetTextColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(textColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(textColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(textColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(textColor[3])));
    return retval;
}

static PyObject *
LabelAttributes_SetTextHeight(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the textHeight in the object.
    obj->data->SetTextHeight(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LabelAttributes_GetTextHeight(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetTextHeight()));
    return retval;
}

static PyObject *
LabelAttributes_SetTextLabel(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the textLabel in the object.
    obj->data->SetTextLabel(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LabelAttributes_GetTextLabel(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetTextLabel().c_str());
    return retval;
}

static PyObject *
LabelAttributes_SetHorizontalJustification(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the horizontalJustification in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetHorizontalJustification(LabelAttributes::LabelHorizontalAlignment(ival));
    else
    {
        fprintf(stderr, "An invalid horizontalJustification value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "HCenter, Left, Right.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LabelAttributes_GetHorizontalJustification(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetHorizontalJustification()));
    return retval;
}

static PyObject *
LabelAttributes_SetVerticalJustification(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the verticalJustification in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetVerticalJustification(LabelAttributes::LabelVerticalAlignment(ival));
    else
    {
        fprintf(stderr, "An invalid verticalJustification value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "VCenter, Top, Bottom.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LabelAttributes_GetVerticalJustification(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVerticalJustification()));
    return retval;
}

static PyObject *
LabelAttributes_SetSingleNodeIndex(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the singleNodeIndex in the object.
    obj->data->SetSingleNodeIndex(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LabelAttributes_GetSingleNodeIndex(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSingleNodeIndex()));
    return retval;
}

static PyObject *
LabelAttributes_SetSingleCellIndex(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the singleCellIndex in the object.
    obj->data->SetSingleCellIndex(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
LabelAttributes_GetSingleCellIndex(PyObject *self, PyObject *args)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSingleCellIndex()));
    return retval;
}



static struct PyMethodDef LabelAttributes_methods[] = {
    {"Notify", LabelAttributes_Notify, METH_VARARGS},
    {"SetLegendFlag", LabelAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", LabelAttributes_GetLegendFlag, METH_VARARGS},
    {"SetShowNodes", LabelAttributes_SetShowNodes, METH_VARARGS},
    {"GetShowNodes", LabelAttributes_GetShowNodes, METH_VARARGS},
    {"SetShowCells", LabelAttributes_SetShowCells, METH_VARARGS},
    {"GetShowCells", LabelAttributes_GetShowCells, METH_VARARGS},
    {"SetRestrictNumberOfLabels", LabelAttributes_SetRestrictNumberOfLabels, METH_VARARGS},
    {"GetRestrictNumberOfLabels", LabelAttributes_GetRestrictNumberOfLabels, METH_VARARGS},
    {"SetDrawLabelsFacing", LabelAttributes_SetDrawLabelsFacing, METH_VARARGS},
    {"GetDrawLabelsFacing", LabelAttributes_GetDrawLabelsFacing, METH_VARARGS},
    {"SetShowSingleNode", LabelAttributes_SetShowSingleNode, METH_VARARGS},
    {"GetShowSingleNode", LabelAttributes_GetShowSingleNode, METH_VARARGS},
    {"SetShowSingleCell", LabelAttributes_SetShowSingleCell, METH_VARARGS},
    {"GetShowSingleCell", LabelAttributes_GetShowSingleCell, METH_VARARGS},
    {"SetUseForegroundTextColor", LabelAttributes_SetUseForegroundTextColor, METH_VARARGS},
    {"GetUseForegroundTextColor", LabelAttributes_GetUseForegroundTextColor, METH_VARARGS},
    {"SetLabelDisplayFormat", LabelAttributes_SetLabelDisplayFormat, METH_VARARGS},
    {"GetLabelDisplayFormat", LabelAttributes_GetLabelDisplayFormat, METH_VARARGS},
    {"SetNumberOfLabels", LabelAttributes_SetNumberOfLabels, METH_VARARGS},
    {"GetNumberOfLabels", LabelAttributes_GetNumberOfLabels, METH_VARARGS},
    {"SetTextColor", LabelAttributes_SetTextColor, METH_VARARGS},
    {"GetTextColor", LabelAttributes_GetTextColor, METH_VARARGS},
    {"SetTextHeight", LabelAttributes_SetTextHeight, METH_VARARGS},
    {"GetTextHeight", LabelAttributes_GetTextHeight, METH_VARARGS},
    {"SetTextLabel", LabelAttributes_SetTextLabel, METH_VARARGS},
    {"GetTextLabel", LabelAttributes_GetTextLabel, METH_VARARGS},
    {"SetHorizontalJustification", LabelAttributes_SetHorizontalJustification, METH_VARARGS},
    {"GetHorizontalJustification", LabelAttributes_GetHorizontalJustification, METH_VARARGS},
    {"SetVerticalJustification", LabelAttributes_SetVerticalJustification, METH_VARARGS},
    {"GetVerticalJustification", LabelAttributes_GetVerticalJustification, METH_VARARGS},
    {"SetSingleNodeIndex", LabelAttributes_SetSingleNodeIndex, METH_VARARGS},
    {"GetSingleNodeIndex", LabelAttributes_GetSingleNodeIndex, METH_VARARGS},
    {"SetSingleCellIndex", LabelAttributes_SetSingleCellIndex, METH_VARARGS},
    {"GetSingleCellIndex", LabelAttributes_GetSingleCellIndex, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
LabelAttributes_dealloc(PyObject *v)
{
   LabelAttributesObject *obj = (LabelAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
LabelAttributes_compare(PyObject *v, PyObject *w)
{
    LabelAttributes *a = ((LabelAttributesObject *)v)->data;
    LabelAttributes *b = ((LabelAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
LabelAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "legendFlag") == 0)
        return LabelAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "showNodes") == 0)
        return LabelAttributes_GetShowNodes(self, NULL);
    if(strcmp(name, "showCells") == 0)
        return LabelAttributes_GetShowCells(self, NULL);
    if(strcmp(name, "restrictNumberOfLabels") == 0)
        return LabelAttributes_GetRestrictNumberOfLabels(self, NULL);
    if(strcmp(name, "drawLabelsFacing") == 0)
        return LabelAttributes_GetDrawLabelsFacing(self, NULL);
    if(strcmp(name, "Front") == 0)
        return PyInt_FromLong(long(LabelAttributes::Front));
    else if(strcmp(name, "Back") == 0)
        return PyInt_FromLong(long(LabelAttributes::Back));
    else if(strcmp(name, "FrontAndBack") == 0)
        return PyInt_FromLong(long(LabelAttributes::FrontAndBack));

    if(strcmp(name, "showSingleNode") == 0)
        return LabelAttributes_GetShowSingleNode(self, NULL);
    if(strcmp(name, "showSingleCell") == 0)
        return LabelAttributes_GetShowSingleCell(self, NULL);
    if(strcmp(name, "useForegroundTextColor") == 0)
        return LabelAttributes_GetUseForegroundTextColor(self, NULL);
    if(strcmp(name, "labelDisplayFormat") == 0)
        return LabelAttributes_GetLabelDisplayFormat(self, NULL);
    if(strcmp(name, "Natural") == 0)
        return PyInt_FromLong(long(LabelAttributes::Natural));
    else if(strcmp(name, "LogicalIndex") == 0)
        return PyInt_FromLong(long(LabelAttributes::LogicalIndex));
    else if(strcmp(name, "Index") == 0)
        return PyInt_FromLong(long(LabelAttributes::Index));

    if(strcmp(name, "numberOfLabels") == 0)
        return LabelAttributes_GetNumberOfLabels(self, NULL);
    if(strcmp(name, "textColor") == 0)
        return LabelAttributes_GetTextColor(self, NULL);
    if(strcmp(name, "textHeight") == 0)
        return LabelAttributes_GetTextHeight(self, NULL);
    if(strcmp(name, "textLabel") == 0)
        return LabelAttributes_GetTextLabel(self, NULL);
    if(strcmp(name, "horizontalJustification") == 0)
        return LabelAttributes_GetHorizontalJustification(self, NULL);
    if(strcmp(name, "HCenter") == 0)
        return PyInt_FromLong(long(LabelAttributes::HCenter));
    else if(strcmp(name, "Left") == 0)
        return PyInt_FromLong(long(LabelAttributes::Left));
    else if(strcmp(name, "Right") == 0)
        return PyInt_FromLong(long(LabelAttributes::Right));

    if(strcmp(name, "verticalJustification") == 0)
        return LabelAttributes_GetVerticalJustification(self, NULL);
    if(strcmp(name, "VCenter") == 0)
        return PyInt_FromLong(long(LabelAttributes::VCenter));
    else if(strcmp(name, "Top") == 0)
        return PyInt_FromLong(long(LabelAttributes::Top));
    else if(strcmp(name, "Bottom") == 0)
        return PyInt_FromLong(long(LabelAttributes::Bottom));

    if(strcmp(name, "singleNodeIndex") == 0)
        return LabelAttributes_GetSingleNodeIndex(self, NULL);
    if(strcmp(name, "singleCellIndex") == 0)
        return LabelAttributes_GetSingleCellIndex(self, NULL);

    return Py_FindMethod(LabelAttributes_methods, self, name);
}

static int
LabelAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "legendFlag") == 0)
        retval = (LabelAttributes_SetLegendFlag(self, tuple) != NULL);
    else if(strcmp(name, "showNodes") == 0)
        retval = (LabelAttributes_SetShowNodes(self, tuple) != NULL);
    else if(strcmp(name, "showCells") == 0)
        retval = (LabelAttributes_SetShowCells(self, tuple) != NULL);
    else if(strcmp(name, "restrictNumberOfLabels") == 0)
        retval = (LabelAttributes_SetRestrictNumberOfLabels(self, tuple) != NULL);
    else if(strcmp(name, "drawLabelsFacing") == 0)
        retval = (LabelAttributes_SetDrawLabelsFacing(self, tuple) != NULL);
    else if(strcmp(name, "showSingleNode") == 0)
        retval = (LabelAttributes_SetShowSingleNode(self, tuple) != NULL);
    else if(strcmp(name, "showSingleCell") == 0)
        retval = (LabelAttributes_SetShowSingleCell(self, tuple) != NULL);
    else if(strcmp(name, "useForegroundTextColor") == 0)
        retval = (LabelAttributes_SetUseForegroundTextColor(self, tuple) != NULL);
    else if(strcmp(name, "labelDisplayFormat") == 0)
        retval = (LabelAttributes_SetLabelDisplayFormat(self, tuple) != NULL);
    else if(strcmp(name, "numberOfLabels") == 0)
        retval = (LabelAttributes_SetNumberOfLabels(self, tuple) != NULL);
    else if(strcmp(name, "textColor") == 0)
        retval = (LabelAttributes_SetTextColor(self, tuple) != NULL);
    else if(strcmp(name, "textHeight") == 0)
        retval = (LabelAttributes_SetTextHeight(self, tuple) != NULL);
    else if(strcmp(name, "textLabel") == 0)
        retval = (LabelAttributes_SetTextLabel(self, tuple) != NULL);
    else if(strcmp(name, "horizontalJustification") == 0)
        retval = (LabelAttributes_SetHorizontalJustification(self, tuple) != NULL);
    else if(strcmp(name, "verticalJustification") == 0)
        retval = (LabelAttributes_SetVerticalJustification(self, tuple) != NULL);
    else if(strcmp(name, "singleNodeIndex") == 0)
        retval = (LabelAttributes_SetSingleNodeIndex(self, tuple) != NULL);
    else if(strcmp(name, "singleCellIndex") == 0)
        retval = (LabelAttributes_SetSingleCellIndex(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
LabelAttributes_print(PyObject *v, FILE *fp, int flags)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)v;

    if(obj->data->GetLegendFlag())
        fprintf(fp, "legendFlag = 1\n");
    else
        fprintf(fp, "legendFlag = 0\n");
    if(obj->data->GetShowNodes())
        fprintf(fp, "showNodes = 1\n");
    else
        fprintf(fp, "showNodes = 0\n");
    if(obj->data->GetShowCells())
        fprintf(fp, "showCells = 1\n");
    else
        fprintf(fp, "showCells = 0\n");
    if(obj->data->GetRestrictNumberOfLabels())
        fprintf(fp, "restrictNumberOfLabels = 1\n");
    else
        fprintf(fp, "restrictNumberOfLabels = 0\n");
    const char *drawLabelsFacing_names = "Front, Back, FrontAndBack";
    if(obj->data->GetDrawLabelsFacing() == LabelAttributes::Front)
        fprintf(fp, "drawLabelsFacing = Front  # %s\n", drawLabelsFacing_names);
    else if(obj->data->GetDrawLabelsFacing() == LabelAttributes::Back)
        fprintf(fp, "drawLabelsFacing = Back  # %s\n", drawLabelsFacing_names);
    else
        fprintf(fp, "drawLabelsFacing = FrontAndBack  # %s\n", drawLabelsFacing_names);

    if(obj->data->GetShowSingleNode())
        fprintf(fp, "showSingleNode = 1\n");
    else
        fprintf(fp, "showSingleNode = 0\n");
    if(obj->data->GetShowSingleCell())
        fprintf(fp, "showSingleCell = 1\n");
    else
        fprintf(fp, "showSingleCell = 0\n");
    if(obj->data->GetUseForegroundTextColor())
        fprintf(fp, "useForegroundTextColor = 1\n");
    else
        fprintf(fp, "useForegroundTextColor = 0\n");
    const char *labelDisplayFormat_names = "Natural, LogicalIndex, Index";
    if(obj->data->GetLabelDisplayFormat() == LabelAttributes::Natural)
        fprintf(fp, "labelDisplayFormat = Natural  # %s\n", labelDisplayFormat_names);
    else if(obj->data->GetLabelDisplayFormat() == LabelAttributes::LogicalIndex)
        fprintf(fp, "labelDisplayFormat = LogicalIndex  # %s\n", labelDisplayFormat_names);
    else
        fprintf(fp, "labelDisplayFormat = Index  # %s\n", labelDisplayFormat_names);

    fprintf(fp, "numberOfLabels = %d\n", obj->data->GetNumberOfLabels());
    const unsigned char *textColor = obj->data->GetTextColor().GetColor();
    fprintf(fp, "textColor = (%d, %d, %d, %d)\n", int(textColor[0]), int(textColor[1]), int(textColor[2]), int(textColor[3]));
    fprintf(fp, "textHeight = %g\n", obj->data->GetTextHeight());
    fprintf(fp, "textLabel = \"%s\"\n", obj->data->GetTextLabel().c_str());
    const char *horizontalJustification_names = "HCenter, Left, Right";
    if(obj->data->GetHorizontalJustification() == LabelAttributes::HCenter)
        fprintf(fp, "horizontalJustification = HCenter  # %s\n", horizontalJustification_names);
    else if(obj->data->GetHorizontalJustification() == LabelAttributes::Left)
        fprintf(fp, "horizontalJustification = Left  # %s\n", horizontalJustification_names);
    else
        fprintf(fp, "horizontalJustification = Right  # %s\n", horizontalJustification_names);

    const char *verticalJustification_names = "VCenter, Top, Bottom";
    if(obj->data->GetVerticalJustification() == LabelAttributes::VCenter)
        fprintf(fp, "verticalJustification = VCenter  # %s\n", verticalJustification_names);
    else if(obj->data->GetVerticalJustification() == LabelAttributes::Top)
        fprintf(fp, "verticalJustification = Top  # %s\n", verticalJustification_names);
    else
        fprintf(fp, "verticalJustification = Bottom  # %s\n", verticalJustification_names);

    fprintf(fp, "singleNodeIndex = %d\n", obj->data->GetSingleNodeIndex());
    fprintf(fp, "singleCellIndex = %d\n", obj->data->GetSingleCellIndex());

    return 0;
}

#include <snprintf.h>
PyObject *
PyLabelAttributes_StringRepresentation(const LabelAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "legendFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "legendFlag = 0\n");
    str += tmpStr;
    if(atts->GetShowNodes())
        SNPRINTF(tmpStr, 1000, "showNodes = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "showNodes = 0\n");
    str += tmpStr;
    if(atts->GetShowCells())
        SNPRINTF(tmpStr, 1000, "showCells = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "showCells = 0\n");
    str += tmpStr;
    if(atts->GetRestrictNumberOfLabels())
        SNPRINTF(tmpStr, 1000, "restrictNumberOfLabels = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "restrictNumberOfLabels = 0\n");
    str += tmpStr;
    const char *drawLabelsFacing_names = "Front, Back, FrontAndBack";
    if(atts->GetDrawLabelsFacing() == LabelAttributes::Front)
        {
             SNPRINTF(tmpStr, 1000, "drawLabelsFacing = Front  # %s\n", drawLabelsFacing_names);
             str += tmpStr;
        }
    else if(atts->GetDrawLabelsFacing() == LabelAttributes::Back)
        {
             SNPRINTF(tmpStr, 1000, "drawLabelsFacing = Back  # %s\n", drawLabelsFacing_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "drawLabelsFacing = FrontAndBack  # %s\n", drawLabelsFacing_names);
             str += tmpStr;
        }

    if(atts->GetShowSingleNode())
        SNPRINTF(tmpStr, 1000, "showSingleNode = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "showSingleNode = 0\n");
    str += tmpStr;
    if(atts->GetShowSingleCell())
        SNPRINTF(tmpStr, 1000, "showSingleCell = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "showSingleCell = 0\n");
    str += tmpStr;
    if(atts->GetUseForegroundTextColor())
        SNPRINTF(tmpStr, 1000, "useForegroundTextColor = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "useForegroundTextColor = 0\n");
    str += tmpStr;
    const char *labelDisplayFormat_names = "Natural, LogicalIndex, Index";
    if(atts->GetLabelDisplayFormat() == LabelAttributes::Natural)
        {
             SNPRINTF(tmpStr, 1000, "labelDisplayFormat = Natural  # %s\n", labelDisplayFormat_names);
             str += tmpStr;
        }
    else if(atts->GetLabelDisplayFormat() == LabelAttributes::LogicalIndex)
        {
             SNPRINTF(tmpStr, 1000, "labelDisplayFormat = LogicalIndex  # %s\n", labelDisplayFormat_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "labelDisplayFormat = Index  # %s\n", labelDisplayFormat_names);
             str += tmpStr;
        }

    SNPRINTF(tmpStr, 1000, "numberOfLabels = %d\n", atts->GetNumberOfLabels());
    str += tmpStr;
    const unsigned char *textColor = atts->GetTextColor().GetColor();
    SNPRINTF(tmpStr, 1000, "textColor = (%d, %d, %d, %d)\n", int(textColor[0]), int(textColor[1]), int(textColor[2]), int(textColor[3]));
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "textHeight = %g\n", atts->GetTextHeight());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "textLabel = \"%s\"\n", atts->GetTextLabel().c_str());
    str += tmpStr;
    const char *horizontalJustification_names = "HCenter, Left, Right";
    if(atts->GetHorizontalJustification() == LabelAttributes::HCenter)
        {
             SNPRINTF(tmpStr, 1000, "horizontalJustification = HCenter  # %s\n", horizontalJustification_names);
             str += tmpStr;
        }
    else if(atts->GetHorizontalJustification() == LabelAttributes::Left)
        {
             SNPRINTF(tmpStr, 1000, "horizontalJustification = Left  # %s\n", horizontalJustification_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "horizontalJustification = Right  # %s\n", horizontalJustification_names);
             str += tmpStr;
        }

    const char *verticalJustification_names = "VCenter, Top, Bottom";
    if(atts->GetVerticalJustification() == LabelAttributes::VCenter)
        {
             SNPRINTF(tmpStr, 1000, "verticalJustification = VCenter  # %s\n", verticalJustification_names);
             str += tmpStr;
        }
    else if(atts->GetVerticalJustification() == LabelAttributes::Top)
        {
             SNPRINTF(tmpStr, 1000, "verticalJustification = Top  # %s\n", verticalJustification_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "verticalJustification = Bottom  # %s\n", verticalJustification_names);
             str += tmpStr;
        }

    SNPRINTF(tmpStr, 1000, "singleNodeIndex = %d\n", atts->GetSingleNodeIndex());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "singleCellIndex = %d\n", atts->GetSingleCellIndex());
    str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
LabelAttributes_str(PyObject *v)
{
    LabelAttributesObject *obj = (LabelAttributesObject *)v;
    return PyLabelAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *LabelAttributes_Purpose = "This class contains the fields that we need to set the attributes for the Label plot.";

//
// The type description structure
//
static PyTypeObject LabelAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "LabelAttributes",                    // tp_name
    sizeof(LabelAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)LabelAttributes_dealloc,  // tp_dealloc
    (printfunc)LabelAttributes_print,     // tp_print
    (getattrfunc)LabelAttributes_getattr, // tp_getattr
    (setattrfunc)LabelAttributes_setattr, // tp_setattr
    (cmpfunc)LabelAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)LabelAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    LabelAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static LabelAttributes *defaultAtts = 0;

static PyObject *
NewLabelAttributes()
{
    LabelAttributesObject *newObject;
    newObject = PyObject_NEW(LabelAttributesObject, &LabelAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new LabelAttributes(*defaultAtts);
    else
        newObject->data = new LabelAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapLabelAttributes(const LabelAttributes *attr)
{
    LabelAttributesObject *newObject;
    newObject = PyObject_NEW(LabelAttributesObject, &LabelAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (LabelAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
LabelAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewLabelAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef LabelAttributesMethods[] = {
    {"LabelAttributes", LabelAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *LabelAttributesObserver = 0;
static bool LabelAttributesEnableLogging = true;

static void
PyLabelAttributes_WriteLog(Subject *subj, void *data)
{
    LabelAttributes *atts = (LabelAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!LabelAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# LabelAttributes_WriteLog()\n");
}

void
PyLabelAttributes_StartUp(LabelAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyLabelAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(LabelAttributesObserver == 0)
    {
        LabelAttributesObserver = new ObserverToCallback(subj,
            PyLabelAttributes_WriteLog, (void *)logFile);
    }

    LabelAttributesEnableLogging = true;
}

void
PyLabelAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete LabelAttributesObserver;
    LabelAttributesObserver = 0;
}

PyMethodDef *
PyLabelAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return LabelAttributesMethods;
}

bool
PyLabelAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &LabelAttributesType);
}

LabelAttributes *
PyLabelAttributes_FromPyObject(PyObject *obj)
{
    LabelAttributesObject *obj2 = (LabelAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyLabelAttributes_NewPyObject()
{
    return NewLabelAttributes();
}

PyObject *
PyLabelAttributes_WrapPyObject(const LabelAttributes *attr)
{
    return WrapLabelAttributes(attr);
}

void
PyLabelAttributes_SetLogging(bool val)
{
    LabelAttributesEnableLogging = val;
}

void
PyLabelAttributes_SetDefaults(const LabelAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new LabelAttributes(*atts);
}

