// ************************************************************************* //
//  File: LabelViewerPluginInfo.C
// ************************************************************************* //

#include <LabelPluginInfo.h>
#include <avtLabelPlot.h>

#if defined(__APPLE__)
#define GetViewerInfo Label_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Label plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon Aug 9 14:22:02 PST 2004
//
// ****************************************************************************
extern "C" ViewerPlotPluginInfo* GetViewerInfo()
{
    LabelViewerPluginInfo::InitializeGlobalObjects();
    return new LabelViewerPluginInfo;
}

//
// Storage for static data elements.
//
LabelAttributes *LabelViewerPluginInfo::clientAtts = NULL;
LabelAttributes *LabelViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  LabelViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon Aug 9 14:22:02 PST 2004
//
// ****************************************************************************
void
LabelViewerPluginInfo::InitializeGlobalObjects()
{
    LabelViewerPluginInfo::clientAtts  = new LabelAttributes;
    LabelViewerPluginInfo::defaultAtts = new LabelAttributes;
}

// ****************************************************************************
//  Method: LabelViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon Aug 9 14:22:02 PST 2004
//
// ****************************************************************************

AttributeSubject *
LabelViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: LabelViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon Aug 9 14:22:02 PST 2004
//
// ****************************************************************************

AttributeSubject *
LabelViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: LabelViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon Aug 9 14:22:02 PST 2004
//
// ****************************************************************************

void
LabelViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(LabelAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: LabelViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon Aug 9 14:22:02 PST 2004
//
// ****************************************************************************

void
LabelViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(LabelAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: LabelViewerPluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon Aug 9 14:22:02 PST 2004
//
// ****************************************************************************

avtPlot *
LabelViewerPluginInfo::AllocAvtPlot()
{
    return new avtLabelPlot;
}

// ****************************************************************************
//  Method: LabelViewerPluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon Aug 9 14:22:02 PST 2004
//
// ****************************************************************************

void
LabelViewerPluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtDatabaseMetaData *, const char *)
{
    *(LabelAttributes*)atts = *defaultAtts;
}

// ****************************************************************************
// Method: LabelViewerPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon Aug 9 14:22:02 PST 2004
//
// Modifications:
//   
// ****************************************************************************

int
LabelViewerPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_MESH | VAR_CATEGORY_SCALAR | VAR_CATEGORY_VECTOR;
}


// ****************************************************************************
//  Method: LabelViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon Aug 9 14:22:02 PST 2004
//
// ****************************************************************************

#include <Label.xpm>
const char **
LabelViewerPluginInfo::XPMIconData() const
{
    return Label_xpm;
}
