// ************************************************************************* //
//                        LabelScriptingPluginInfo.C
// ************************************************************************* //
#include <LabelPluginInfo.h>
#include <PyLabelAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Label_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Label plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon Aug 9 14:22:02 PST 2004
//
// ****************************************************************************
extern "C" ScriptingPlotPluginInfo* GetScriptingInfo()
{
    return new LabelScriptingPluginInfo;
}

// ****************************************************************************
// Method: LabelScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon Aug 9 14:22:02 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
LabelScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyLabelAttributes_StartUp((LabelAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: LabelScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon Aug 9 14:22:02 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void *
LabelScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyLabelAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: LabelScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Label plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon Aug 9 14:22:02 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
LabelScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyLabelAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: LabelScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon Aug 9 14:22:02 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
LabelScriptingPluginInfo::SetLogging(bool val)
{
    PyLabelAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: LabelScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon Aug 9 14:22:02 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
LabelScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyLabelAttributes_SetDefaults((const LabelAttributes *)atts);
}
