// ************************************************************************* //
//  File: LabelGUIPluginInfo.C
// ************************************************************************* //

#include <LabelPluginInfo.h>
#include <LabelAttributes.h>
#include <QvisLabelPlotWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Label_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Label plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon Aug 9 14:22:02 PST 2004
//
// ****************************************************************************
extern "C" GUIPlotPluginInfo* GetGUIInfo()
{
    return new LabelGUIPluginInfo;
}

// ****************************************************************************
//  Method: LabelGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon Aug 9 14:22:02 PST 2004
//
// ****************************************************************************

const char *
LabelGUIPluginInfo::GetMenuName() const
{
    return "Label";
}


// ****************************************************************************
// Method: LabelGUIPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon Aug 9 14:22:02 PST 2004
//
// Modifications:
//   
// ****************************************************************************

int
LabelGUIPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_MESH | VAR_CATEGORY_SCALAR | VAR_CATEGORY_VECTOR;
}

// ****************************************************************************
//  Method: LabelGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon Aug 9 14:22:02 PST 2004
//
// ****************************************************************************

QvisPostableWindowObserver *
LabelGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisLabelPlotWindow(type, (LabelAttributes *)attr,
        "Label plot attributes", "Label plot", notepad);
}

// ****************************************************************************
//  Method: LabelGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Mon Aug 9 14:22:02 PST 2004
//
// ****************************************************************************

#include <Label.xpm>
const char **
LabelGUIPluginInfo::XPMIconData() const
{
    return Label_xpm;
}
