package llnl.visit.plots;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;
import llnl.visit.ColorAttribute;

// ****************************************************************************
// Class: LabelAttributes
//
// Purpose:
//    This class contains the fields that we need to set the attributes for the Label plot.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Thu Oct 21 18:18:08 PST 2004
//
// Modifications:
//   
// ****************************************************************************

public class LabelAttributes extends AttributeSubject implements Plugin
{
    // Enum values
    public final static int LABELINDEXDISPLAY_NATURAL = 0;
    public final static int LABELINDEXDISPLAY_LOGICALINDEX = 1;
    public final static int LABELINDEXDISPLAY_INDEX = 2;

    public final static int LABELHORIZONTALALIGNMENT_HCENTER = 0;
    public final static int LABELHORIZONTALALIGNMENT_LEFT = 1;
    public final static int LABELHORIZONTALALIGNMENT_RIGHT = 2;

    public final static int LABELVERTICALALIGNMENT_VCENTER = 0;
    public final static int LABELVERTICALALIGNMENT_TOP = 1;
    public final static int LABELVERTICALALIGNMENT_BOTTOM = 2;

    public final static int LABELDRAWFACING_FRONT = 0;
    public final static int LABELDRAWFACING_BACK = 1;
    public final static int LABELDRAWFACING_FRONTANDBACK = 2;


    public LabelAttributes()
    {
        super(17);

        legendFlag = true;
        showNodes = false;
        showCells = true;
        restrictNumberOfLabels = true;
        drawLabelsFacing = LABELDRAWFACING_FRONT;
        showSingleNode = false;
        showSingleCell = false;
        useForegroundTextColor = true;
        labelDisplayFormat = LABELINDEXDISPLAY_NATURAL;
        numberOfLabels = 200;
        textColor = new ColorAttribute(255, 0, 0, 0);
        textHeight = 0.02f;
        textLabel = new String("*");
        horizontalJustification = LABELHORIZONTALALIGNMENT_HCENTER;
        verticalJustification = LABELVERTICALALIGNMENT_VCENTER;
        singleNodeIndex = 0;
        singleCellIndex = 0;
    }

    public LabelAttributes(LabelAttributes obj)
    {
        super(17);

        legendFlag = obj.legendFlag;
        showNodes = obj.showNodes;
        showCells = obj.showCells;
        restrictNumberOfLabels = obj.restrictNumberOfLabels;
        drawLabelsFacing = obj.drawLabelsFacing;
        showSingleNode = obj.showSingleNode;
        showSingleCell = obj.showSingleCell;
        useForegroundTextColor = obj.useForegroundTextColor;
        labelDisplayFormat = obj.labelDisplayFormat;
        numberOfLabels = obj.numberOfLabels;
        textColor = new ColorAttribute(obj.textColor);
        textHeight = obj.textHeight;
        textLabel = new String(obj.textLabel);
        horizontalJustification = obj.horizontalJustification;
        verticalJustification = obj.verticalJustification;
        singleNodeIndex = obj.singleNodeIndex;
        singleCellIndex = obj.singleCellIndex;

        SelectAll();
    }

    public boolean equals(LabelAttributes obj)
    {
        // Create the return value
        return ((legendFlag == obj.legendFlag) &&
                (showNodes == obj.showNodes) &&
                (showCells == obj.showCells) &&
                (restrictNumberOfLabels == obj.restrictNumberOfLabels) &&
                (drawLabelsFacing == obj.drawLabelsFacing) &&
                (showSingleNode == obj.showSingleNode) &&
                (showSingleCell == obj.showSingleCell) &&
                (useForegroundTextColor == obj.useForegroundTextColor) &&
                (labelDisplayFormat == obj.labelDisplayFormat) &&
                (numberOfLabels == obj.numberOfLabels) &&
                (textColor == obj.textColor) &&
                (textHeight == obj.textHeight) &&
                (textLabel == obj.textLabel) &&
                (horizontalJustification == obj.horizontalJustification) &&
                (verticalJustification == obj.verticalJustification) &&
                (singleNodeIndex == obj.singleNodeIndex) &&
                (singleCellIndex == obj.singleCellIndex));
    }

    public String GetName() { return "Label"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetLegendFlag(boolean legendFlag_)
    {
        legendFlag = legendFlag_;
        Select(0);
    }

    public void SetShowNodes(boolean showNodes_)
    {
        showNodes = showNodes_;
        Select(1);
    }

    public void SetShowCells(boolean showCells_)
    {
        showCells = showCells_;
        Select(2);
    }

    public void SetRestrictNumberOfLabels(boolean restrictNumberOfLabels_)
    {
        restrictNumberOfLabels = restrictNumberOfLabels_;
        Select(3);
    }

    public void SetDrawLabelsFacing(int drawLabelsFacing_)
    {
        drawLabelsFacing = drawLabelsFacing_;
        Select(4);
    }

    public void SetShowSingleNode(boolean showSingleNode_)
    {
        showSingleNode = showSingleNode_;
        Select(5);
    }

    public void SetShowSingleCell(boolean showSingleCell_)
    {
        showSingleCell = showSingleCell_;
        Select(6);
    }

    public void SetUseForegroundTextColor(boolean useForegroundTextColor_)
    {
        useForegroundTextColor = useForegroundTextColor_;
        Select(7);
    }

    public void SetLabelDisplayFormat(int labelDisplayFormat_)
    {
        labelDisplayFormat = labelDisplayFormat_;
        Select(8);
    }

    public void SetNumberOfLabels(int numberOfLabels_)
    {
        numberOfLabels = numberOfLabels_;
        Select(9);
    }

    public void SetTextColor(ColorAttribute textColor_)
    {
        textColor = textColor_;
        Select(10);
    }

    public void SetTextHeight(float textHeight_)
    {
        textHeight = textHeight_;
        Select(11);
    }

    public void SetTextLabel(String textLabel_)
    {
        textLabel = textLabel_;
        Select(12);
    }

    public void SetHorizontalJustification(int horizontalJustification_)
    {
        horizontalJustification = horizontalJustification_;
        Select(13);
    }

    public void SetVerticalJustification(int verticalJustification_)
    {
        verticalJustification = verticalJustification_;
        Select(14);
    }

    public void SetSingleNodeIndex(int singleNodeIndex_)
    {
        singleNodeIndex = singleNodeIndex_;
        Select(15);
    }

    public void SetSingleCellIndex(int singleCellIndex_)
    {
        singleCellIndex = singleCellIndex_;
        Select(16);
    }

    // Property getting methods
    public boolean        GetLegendFlag() { return legendFlag; }
    public boolean        GetShowNodes() { return showNodes; }
    public boolean        GetShowCells() { return showCells; }
    public boolean        GetRestrictNumberOfLabels() { return restrictNumberOfLabels; }
    public int            GetDrawLabelsFacing() { return drawLabelsFacing; }
    public boolean        GetShowSingleNode() { return showSingleNode; }
    public boolean        GetShowSingleCell() { return showSingleCell; }
    public boolean        GetUseForegroundTextColor() { return useForegroundTextColor; }
    public int            GetLabelDisplayFormat() { return labelDisplayFormat; }
    public int            GetNumberOfLabels() { return numberOfLabels; }
    public ColorAttribute GetTextColor() { return textColor; }
    public float          GetTextHeight() { return textHeight; }
    public String         GetTextLabel() { return textLabel; }
    public int            GetHorizontalJustification() { return horizontalJustification; }
    public int            GetVerticalJustification() { return verticalJustification; }
    public int            GetSingleNodeIndex() { return singleNodeIndex; }
    public int            GetSingleCellIndex() { return singleCellIndex; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteBool(legendFlag);
        if(WriteSelect(1, buf))
            buf.WriteBool(showNodes);
        if(WriteSelect(2, buf))
            buf.WriteBool(showCells);
        if(WriteSelect(3, buf))
            buf.WriteBool(restrictNumberOfLabels);
        if(WriteSelect(4, buf))
            buf.WriteInt(drawLabelsFacing);
        if(WriteSelect(5, buf))
            buf.WriteBool(showSingleNode);
        if(WriteSelect(6, buf))
            buf.WriteBool(showSingleCell);
        if(WriteSelect(7, buf))
            buf.WriteBool(useForegroundTextColor);
        if(WriteSelect(8, buf))
            buf.WriteInt(labelDisplayFormat);
        if(WriteSelect(9, buf))
            buf.WriteInt(numberOfLabels);
        if(WriteSelect(10, buf))
            textColor.Write(buf);
        if(WriteSelect(11, buf))
            buf.WriteFloat(textHeight);
        if(WriteSelect(12, buf))
            buf.WriteString(textLabel);
        if(WriteSelect(13, buf))
            buf.WriteInt(horizontalJustification);
        if(WriteSelect(14, buf))
            buf.WriteInt(verticalJustification);
        if(WriteSelect(15, buf))
            buf.WriteInt(singleNodeIndex);
        if(WriteSelect(16, buf))
            buf.WriteInt(singleCellIndex);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetLegendFlag(buf.ReadBool());
                break;
            case 1:
                SetShowNodes(buf.ReadBool());
                break;
            case 2:
                SetShowCells(buf.ReadBool());
                break;
            case 3:
                SetRestrictNumberOfLabels(buf.ReadBool());
                break;
            case 4:
                SetDrawLabelsFacing(buf.ReadInt());
                break;
            case 5:
                SetShowSingleNode(buf.ReadBool());
                break;
            case 6:
                SetShowSingleCell(buf.ReadBool());
                break;
            case 7:
                SetUseForegroundTextColor(buf.ReadBool());
                break;
            case 8:
                SetLabelDisplayFormat(buf.ReadInt());
                break;
            case 9:
                SetNumberOfLabels(buf.ReadInt());
                break;
            case 10:
                textColor.Read(buf);
                Select(10);
                break;
            case 11:
                SetTextHeight(buf.ReadFloat());
                break;
            case 12:
                SetTextLabel(buf.ReadString());
                break;
            case 13:
                SetHorizontalJustification(buf.ReadInt());
                break;
            case 14:
                SetVerticalJustification(buf.ReadInt());
                break;
            case 15:
                SetSingleNodeIndex(buf.ReadInt());
                break;
            case 16:
                SetSingleCellIndex(buf.ReadInt());
                break;
            }
        }
    }


    // Attributes
    private boolean        legendFlag;
    private boolean        showNodes;
    private boolean        showCells;
    private boolean        restrictNumberOfLabels;
    private int            drawLabelsFacing;
    private boolean        showSingleNode;
    private boolean        showSingleCell;
    private boolean        useForegroundTextColor;
    private int            labelDisplayFormat;
    private int            numberOfLabels;
    private ColorAttribute textColor;
    private float          textHeight;
    private String         textLabel;
    private int            horizontalJustification;
    private int            verticalJustification;
    private int            singleNodeIndex;
    private int            singleCellIndex;
}

