#include <LabelAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for LabelAttributes::LabelIndexDisplay
//

static const char *LabelIndexDisplay_strings[] = {
"Natural", "LogicalIndex", "Index"
};

std::string
LabelAttributes::LabelIndexDisplay_ToString(LabelAttributes::LabelIndexDisplay t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return LabelIndexDisplay_strings[index];
}

std::string
LabelAttributes::LabelIndexDisplay_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return LabelIndexDisplay_strings[index];
}

bool
LabelAttributes::LabelIndexDisplay_FromString(const std::string &s, LabelAttributes::LabelIndexDisplay &val)
{
    val = LabelAttributes::Natural;
    for(int i = 0; i < 3; ++i)
    {
        if(s == LabelIndexDisplay_strings[i])
        {
            val = (LabelIndexDisplay)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for LabelAttributes::LabelHorizontalAlignment
//

static const char *LabelHorizontalAlignment_strings[] = {
"HCenter", "Left", "Right"
};

std::string
LabelAttributes::LabelHorizontalAlignment_ToString(LabelAttributes::LabelHorizontalAlignment t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return LabelHorizontalAlignment_strings[index];
}

std::string
LabelAttributes::LabelHorizontalAlignment_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return LabelHorizontalAlignment_strings[index];
}

bool
LabelAttributes::LabelHorizontalAlignment_FromString(const std::string &s, LabelAttributes::LabelHorizontalAlignment &val)
{
    val = LabelAttributes::HCenter;
    for(int i = 0; i < 3; ++i)
    {
        if(s == LabelHorizontalAlignment_strings[i])
        {
            val = (LabelHorizontalAlignment)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for LabelAttributes::LabelVerticalAlignment
//

static const char *LabelVerticalAlignment_strings[] = {
"VCenter", "Top", "Bottom"
};

std::string
LabelAttributes::LabelVerticalAlignment_ToString(LabelAttributes::LabelVerticalAlignment t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return LabelVerticalAlignment_strings[index];
}

std::string
LabelAttributes::LabelVerticalAlignment_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return LabelVerticalAlignment_strings[index];
}

bool
LabelAttributes::LabelVerticalAlignment_FromString(const std::string &s, LabelAttributes::LabelVerticalAlignment &val)
{
    val = LabelAttributes::VCenter;
    for(int i = 0; i < 3; ++i)
    {
        if(s == LabelVerticalAlignment_strings[i])
        {
            val = (LabelVerticalAlignment)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for LabelAttributes::LabelDrawFacing
//

static const char *LabelDrawFacing_strings[] = {
"Front", "Back", "FrontAndBack"
};

std::string
LabelAttributes::LabelDrawFacing_ToString(LabelAttributes::LabelDrawFacing t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return LabelDrawFacing_strings[index];
}

std::string
LabelAttributes::LabelDrawFacing_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return LabelDrawFacing_strings[index];
}

bool
LabelAttributes::LabelDrawFacing_FromString(const std::string &s, LabelAttributes::LabelDrawFacing &val)
{
    val = LabelAttributes::Front;
    for(int i = 0; i < 3; ++i)
    {
        if(s == LabelDrawFacing_strings[i])
        {
            val = (LabelDrawFacing)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: LabelAttributes::LabelAttributes
//
// Purpose: 
//   Constructor for the LabelAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Oct 21 18:18:05 PST 2004
//
// Modifications:
//   
// ****************************************************************************

LabelAttributes::LabelAttributes() : AttributeSubject("bbbbibbbiiafsiiii"),
    textColor(255, 0, 0, 255)
{
    legendFlag = true;
    showNodes = false;
    showCells = true;
    restrictNumberOfLabels = true;
    drawLabelsFacing = Front;
    showSingleNode = false;
    showSingleCell = false;
    useForegroundTextColor = true;
    labelDisplayFormat = Natural;
    numberOfLabels = 200;
    textHeight = 0.02;
    textLabel = "*";
    horizontalJustification = HCenter;
    verticalJustification = VCenter;
    singleNodeIndex = 0;
    singleCellIndex = 0;
}

// ****************************************************************************
// Method: LabelAttributes::LabelAttributes
//
// Purpose: 
//   Copy constructor for the LabelAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Oct 21 18:18:05 PST 2004
//
// Modifications:
//   
// ****************************************************************************

LabelAttributes::LabelAttributes(const LabelAttributes &obj) : AttributeSubject("bbbbibbbiiafsiiii")
{
    legendFlag = obj.legendFlag;
    showNodes = obj.showNodes;
    showCells = obj.showCells;
    restrictNumberOfLabels = obj.restrictNumberOfLabels;
    drawLabelsFacing = obj.drawLabelsFacing;
    showSingleNode = obj.showSingleNode;
    showSingleCell = obj.showSingleCell;
    useForegroundTextColor = obj.useForegroundTextColor;
    labelDisplayFormat = obj.labelDisplayFormat;
    numberOfLabels = obj.numberOfLabels;
    textColor = obj.textColor;
    textHeight = obj.textHeight;
    textLabel = obj.textLabel;
    horizontalJustification = obj.horizontalJustification;
    verticalJustification = obj.verticalJustification;
    singleNodeIndex = obj.singleNodeIndex;
    singleCellIndex = obj.singleCellIndex;

    SelectAll();
}

// ****************************************************************************
// Method: LabelAttributes::~LabelAttributes
//
// Purpose: 
//   Destructor for the LabelAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Oct 21 18:18:05 PST 2004
//
// Modifications:
//   
// ****************************************************************************

LabelAttributes::~LabelAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: LabelAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the LabelAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Oct 21 18:18:05 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
LabelAttributes::operator = (const LabelAttributes &obj)
{
    legendFlag = obj.legendFlag;
    showNodes = obj.showNodes;
    showCells = obj.showCells;
    restrictNumberOfLabels = obj.restrictNumberOfLabels;
    drawLabelsFacing = obj.drawLabelsFacing;
    showSingleNode = obj.showSingleNode;
    showSingleCell = obj.showSingleCell;
    useForegroundTextColor = obj.useForegroundTextColor;
    labelDisplayFormat = obj.labelDisplayFormat;
    numberOfLabels = obj.numberOfLabels;
    textColor = obj.textColor;
    textHeight = obj.textHeight;
    textLabel = obj.textLabel;
    horizontalJustification = obj.horizontalJustification;
    verticalJustification = obj.verticalJustification;
    singleNodeIndex = obj.singleNodeIndex;
    singleCellIndex = obj.singleCellIndex;

    SelectAll();
}

// ****************************************************************************
// Method: LabelAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the LabelAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Oct 21 18:18:05 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
LabelAttributes::operator == (const LabelAttributes &obj) const
{
    // Create the return value
    return ((legendFlag == obj.legendFlag) &&
            (showNodes == obj.showNodes) &&
            (showCells == obj.showCells) &&
            (restrictNumberOfLabels == obj.restrictNumberOfLabels) &&
            (drawLabelsFacing == obj.drawLabelsFacing) &&
            (showSingleNode == obj.showSingleNode) &&
            (showSingleCell == obj.showSingleCell) &&
            (useForegroundTextColor == obj.useForegroundTextColor) &&
            (labelDisplayFormat == obj.labelDisplayFormat) &&
            (numberOfLabels == obj.numberOfLabels) &&
            (textColor == obj.textColor) &&
            (textHeight == obj.textHeight) &&
            (textLabel == obj.textLabel) &&
            (horizontalJustification == obj.horizontalJustification) &&
            (verticalJustification == obj.verticalJustification) &&
            (singleNodeIndex == obj.singleNodeIndex) &&
            (singleCellIndex == obj.singleCellIndex));
}

// ****************************************************************************
// Method: LabelAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the LabelAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Oct 21 18:18:05 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
LabelAttributes::operator != (const LabelAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: LabelAttributes::TypeName
//
// Purpose: 
//   Type name method for the LabelAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Oct 21 18:18:05 PST 2004
//
// Modifications:
//   
// ****************************************************************************

const std::string
LabelAttributes::TypeName() const
{
    return "LabelAttributes";
}

// ****************************************************************************
// Method: LabelAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the LabelAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Oct 21 18:18:05 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
LabelAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const LabelAttributes *tmp = (const LabelAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: LabelAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the LabelAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Oct 21 18:18:05 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
LabelAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new LabelAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: LabelAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the LabelAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Oct 21 18:18:05 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
LabelAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new LabelAttributes(*this);
    else
        retval = new LabelAttributes;

    return retval;
}

// ****************************************************************************
// Method: LabelAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Oct 21 18:18:05 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
LabelAttributes::SelectAll()
{
    Select(0, (void *)&legendFlag);
    Select(1, (void *)&showNodes);
    Select(2, (void *)&showCells);
    Select(3, (void *)&restrictNumberOfLabels);
    Select(4, (void *)&drawLabelsFacing);
    Select(5, (void *)&showSingleNode);
    Select(6, (void *)&showSingleCell);
    Select(7, (void *)&useForegroundTextColor);
    Select(8, (void *)&labelDisplayFormat);
    Select(9, (void *)&numberOfLabels);
    Select(10, (void *)&textColor);
    Select(11, (void *)&textHeight);
    Select(12, (void *)&textLabel);
    Select(13, (void *)&horizontalJustification);
    Select(14, (void *)&verticalJustification);
    Select(15, (void *)&singleNodeIndex);
    Select(16, (void *)&singleCellIndex);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: LabelAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Oct 21 18:18:05 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
LabelAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    LabelAttributes defaultObject;
    bool addToParent = false;
    // Create a node for LabelAttributes.
    DataNode *node = new DataNode("LabelAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("legendFlag", legendFlag));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showNodes", showNodes));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showCells", showCells));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("restrictNumberOfLabels", restrictNumberOfLabels));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("drawLabelsFacing", LabelDrawFacing_ToString(drawLabelsFacing)));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showSingleNode", showSingleNode));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showSingleCell", showSingleCell));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useForegroundTextColor", useForegroundTextColor));
    }

    if(completeSave || !FieldsEqual(8, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("labelDisplayFormat", LabelIndexDisplay_ToString(labelDisplayFormat)));
    }

    if(completeSave || !FieldsEqual(9, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numberOfLabels", numberOfLabels));
    }

        DataNode *textColorNode = new DataNode("textColor");
        if(textColor.CreateNode(textColorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(textColorNode);
        }
        else
            delete textColorNode;
    if(completeSave || !FieldsEqual(11, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("textHeight", textHeight));
    }

    if(completeSave || !FieldsEqual(12, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("textLabel", textLabel));
    }

    if(completeSave || !FieldsEqual(13, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("horizontalJustification", LabelHorizontalAlignment_ToString(horizontalJustification)));
    }

    if(completeSave || !FieldsEqual(14, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("verticalJustification", LabelVerticalAlignment_ToString(verticalJustification)));
    }

    if(completeSave || !FieldsEqual(15, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("singleNodeIndex", singleNodeIndex));
    }

    if(completeSave || !FieldsEqual(16, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("singleCellIndex", singleCellIndex));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: LabelAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Oct 21 18:18:05 PST 2004
//
// Modifications:
//   
// ****************************************************************************

void
LabelAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("LabelAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("legendFlag")) != 0)
        SetLegendFlag(node->AsBool());
    if((node = searchNode->GetNode("showNodes")) != 0)
        SetShowNodes(node->AsBool());
    if((node = searchNode->GetNode("showCells")) != 0)
        SetShowCells(node->AsBool());
    if((node = searchNode->GetNode("restrictNumberOfLabels")) != 0)
        SetRestrictNumberOfLabels(node->AsBool());
    if((node = searchNode->GetNode("drawLabelsFacing")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetDrawLabelsFacing(LabelDrawFacing(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            LabelDrawFacing value;
            if(LabelDrawFacing_FromString(node->AsString(), value))
                SetDrawLabelsFacing(value);
        }
    }
    if((node = searchNode->GetNode("showSingleNode")) != 0)
        SetShowSingleNode(node->AsBool());
    if((node = searchNode->GetNode("showSingleCell")) != 0)
        SetShowSingleCell(node->AsBool());
    if((node = searchNode->GetNode("useForegroundTextColor")) != 0)
        SetUseForegroundTextColor(node->AsBool());
    if((node = searchNode->GetNode("labelDisplayFormat")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetLabelDisplayFormat(LabelIndexDisplay(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            LabelIndexDisplay value;
            if(LabelIndexDisplay_FromString(node->AsString(), value))
                SetLabelDisplayFormat(value);
        }
    }
    if((node = searchNode->GetNode("numberOfLabels")) != 0)
        SetNumberOfLabels(node->AsInt());
    if((node = searchNode->GetNode("textColor")) != 0)
        textColor.SetFromNode(node);
    if((node = searchNode->GetNode("textHeight")) != 0)
        SetTextHeight(node->AsFloat());
    if((node = searchNode->GetNode("textLabel")) != 0)
        SetTextLabel(node->AsString());
    if((node = searchNode->GetNode("horizontalJustification")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetHorizontalJustification(LabelHorizontalAlignment(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            LabelHorizontalAlignment value;
            if(LabelHorizontalAlignment_FromString(node->AsString(), value))
                SetHorizontalJustification(value);
        }
    }
    if((node = searchNode->GetNode("verticalJustification")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetVerticalJustification(LabelVerticalAlignment(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            LabelVerticalAlignment value;
            if(LabelVerticalAlignment_FromString(node->AsString(), value))
                SetVerticalJustification(value);
        }
    }
    if((node = searchNode->GetNode("singleNodeIndex")) != 0)
        SetSingleNodeIndex(node->AsInt());
    if((node = searchNode->GetNode("singleCellIndex")) != 0)
        SetSingleCellIndex(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
LabelAttributes::SetLegendFlag(bool legendFlag_)
{
    legendFlag = legendFlag_;
    Select(0, (void *)&legendFlag);
}

void
LabelAttributes::SetShowNodes(bool showNodes_)
{
    showNodes = showNodes_;
    Select(1, (void *)&showNodes);
}

void
LabelAttributes::SetShowCells(bool showCells_)
{
    showCells = showCells_;
    Select(2, (void *)&showCells);
}

void
LabelAttributes::SetRestrictNumberOfLabels(bool restrictNumberOfLabels_)
{
    restrictNumberOfLabels = restrictNumberOfLabels_;
    Select(3, (void *)&restrictNumberOfLabels);
}

void
LabelAttributes::SetDrawLabelsFacing(LabelAttributes::LabelDrawFacing drawLabelsFacing_)
{
    drawLabelsFacing = drawLabelsFacing_;
    Select(4, (void *)&drawLabelsFacing);
}

void
LabelAttributes::SetShowSingleNode(bool showSingleNode_)
{
    showSingleNode = showSingleNode_;
    Select(5, (void *)&showSingleNode);
}

void
LabelAttributes::SetShowSingleCell(bool showSingleCell_)
{
    showSingleCell = showSingleCell_;
    Select(6, (void *)&showSingleCell);
}

void
LabelAttributes::SetUseForegroundTextColor(bool useForegroundTextColor_)
{
    useForegroundTextColor = useForegroundTextColor_;
    Select(7, (void *)&useForegroundTextColor);
}

void
LabelAttributes::SetLabelDisplayFormat(LabelAttributes::LabelIndexDisplay labelDisplayFormat_)
{
    labelDisplayFormat = labelDisplayFormat_;
    Select(8, (void *)&labelDisplayFormat);
}

void
LabelAttributes::SetNumberOfLabels(int numberOfLabels_)
{
    numberOfLabels = numberOfLabels_;
    Select(9, (void *)&numberOfLabels);
}

void
LabelAttributes::SetTextColor(const ColorAttribute &textColor_)
{
    textColor = textColor_;
    Select(10, (void *)&textColor);
}

void
LabelAttributes::SetTextHeight(float textHeight_)
{
    textHeight = textHeight_;
    Select(11, (void *)&textHeight);
}

void
LabelAttributes::SetTextLabel(const std::string &textLabel_)
{
    textLabel = textLabel_;
    Select(12, (void *)&textLabel);
}

void
LabelAttributes::SetHorizontalJustification(LabelAttributes::LabelHorizontalAlignment horizontalJustification_)
{
    horizontalJustification = horizontalJustification_;
    Select(13, (void *)&horizontalJustification);
}

void
LabelAttributes::SetVerticalJustification(LabelAttributes::LabelVerticalAlignment verticalJustification_)
{
    verticalJustification = verticalJustification_;
    Select(14, (void *)&verticalJustification);
}

void
LabelAttributes::SetSingleNodeIndex(int singleNodeIndex_)
{
    singleNodeIndex = singleNodeIndex_;
    Select(15, (void *)&singleNodeIndex);
}

void
LabelAttributes::SetSingleCellIndex(int singleCellIndex_)
{
    singleCellIndex = singleCellIndex_;
    Select(16, (void *)&singleCellIndex);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
LabelAttributes::GetLegendFlag() const
{
    return legendFlag;
}

bool
LabelAttributes::GetShowNodes() const
{
    return showNodes;
}

bool
LabelAttributes::GetShowCells() const
{
    return showCells;
}

bool
LabelAttributes::GetRestrictNumberOfLabels() const
{
    return restrictNumberOfLabels;
}

LabelAttributes::LabelDrawFacing
LabelAttributes::GetDrawLabelsFacing() const
{
    return LabelDrawFacing(drawLabelsFacing);
}

bool
LabelAttributes::GetShowSingleNode() const
{
    return showSingleNode;
}

bool
LabelAttributes::GetShowSingleCell() const
{
    return showSingleCell;
}

bool
LabelAttributes::GetUseForegroundTextColor() const
{
    return useForegroundTextColor;
}

LabelAttributes::LabelIndexDisplay
LabelAttributes::GetLabelDisplayFormat() const
{
    return LabelIndexDisplay(labelDisplayFormat);
}

int
LabelAttributes::GetNumberOfLabels() const
{
    return numberOfLabels;
}

const ColorAttribute &
LabelAttributes::GetTextColor() const
{
    return textColor;
}

ColorAttribute &
LabelAttributes::GetTextColor()
{
    return textColor;
}

float
LabelAttributes::GetTextHeight() const
{
    return textHeight;
}

const std::string &
LabelAttributes::GetTextLabel() const
{
    return textLabel;
}

std::string &
LabelAttributes::GetTextLabel()
{
    return textLabel;
}

LabelAttributes::LabelHorizontalAlignment
LabelAttributes::GetHorizontalJustification() const
{
    return LabelHorizontalAlignment(horizontalJustification);
}

LabelAttributes::LabelVerticalAlignment
LabelAttributes::GetVerticalJustification() const
{
    return LabelVerticalAlignment(verticalJustification);
}

int
LabelAttributes::GetSingleNodeIndex() const
{
    return singleNodeIndex;
}

int
LabelAttributes::GetSingleCellIndex() const
{
    return singleCellIndex;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
LabelAttributes::SelectTextColor()
{
    Select(10, (void *)&textColor);
}

void
LabelAttributes::SelectTextLabel()
{
    Select(12, (void *)&textLabel);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: LabelAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Oct 21 18:18:05 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
LabelAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Legend";
        case 1:  return "Show nodes";
        case 2:  return "Show cells";
        case 3:  return "Restrict number of labels";
        case 4:  return "Draw labels facing";
        case 5:  return "Show single node";
        case 6:  return "Show single cell";
        case 7:  return "Use foreground text color";
        case 8:  return "Label display";
        case 9:  return "numberOfLabels";
        case 10:  return "Text color";
        case 11:  return "textHeight";
        case 12:  return "textLabel";
        case 13:  return "Horizontal justification";
        case 14:  return "Vertical Justification";
        case 15:  return "Single node index";
        case 16:  return "Single cell index";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: LabelAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Oct 21 18:18:05 PST 2004
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
LabelAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_bool;
        case 1:  return FieldType_bool;
        case 2:  return FieldType_bool;
        case 3:  return FieldType_bool;
        case 4:  return FieldType_enum;
        case 5:  return FieldType_bool;
        case 6:  return FieldType_bool;
        case 7:  return FieldType_bool;
        case 8:  return FieldType_enum;
        case 9:  return FieldType_int;
        case 10:  return FieldType_color;
        case 11:  return FieldType_float;
        case 12:  return FieldType_string;
        case 13:  return FieldType_enum;
        case 14:  return FieldType_enum;
        case 15:  return FieldType_int;
        case 16:  return FieldType_int;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: LabelAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Oct 21 18:18:05 PST 2004
//
// Modifications:
//   
// ****************************************************************************

std::string
LabelAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "bool";
        case 1:  return "bool";
        case 2:  return "bool";
        case 3:  return "bool";
        case 4:  return "enum";
        case 5:  return "bool";
        case 6:  return "bool";
        case 7:  return "bool";
        case 8:  return "enum";
        case 9:  return "int";
        case 10:  return "color";
        case 11:  return "float";
        case 12:  return "string";
        case 13:  return "enum";
        case 14:  return "enum";
        case 15:  return "int";
        case 16:  return "int";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: LabelAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Oct 21 18:18:05 PST 2004
//
// Modifications:
//   
// ****************************************************************************

bool
LabelAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const LabelAttributes &obj = *((const LabelAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (legendFlag == obj.legendFlag);
        }
        break;
    case 1:
        {  // new scope
        retval = (showNodes == obj.showNodes);
        }
        break;
    case 2:
        {  // new scope
        retval = (showCells == obj.showCells);
        }
        break;
    case 3:
        {  // new scope
        retval = (restrictNumberOfLabels == obj.restrictNumberOfLabels);
        }
        break;
    case 4:
        {  // new scope
        retval = (drawLabelsFacing == obj.drawLabelsFacing);
        }
        break;
    case 5:
        {  // new scope
        retval = (showSingleNode == obj.showSingleNode);
        }
        break;
    case 6:
        {  // new scope
        retval = (showSingleCell == obj.showSingleCell);
        }
        break;
    case 7:
        {  // new scope
        retval = (useForegroundTextColor == obj.useForegroundTextColor);
        }
        break;
    case 8:
        {  // new scope
        retval = (labelDisplayFormat == obj.labelDisplayFormat);
        }
        break;
    case 9:
        {  // new scope
        retval = (numberOfLabels == obj.numberOfLabels);
        }
        break;
    case 10:
        {  // new scope
        retval = (textColor == obj.textColor);
        }
        break;
    case 11:
        {  // new scope
        retval = (textHeight == obj.textHeight);
        }
        break;
    case 12:
        {  // new scope
        retval = (textLabel == obj.textLabel);
        }
        break;
    case 13:
        {  // new scope
        retval = (horizontalJustification == obj.horizontalJustification);
        }
        break;
    case 14:
        {  // new scope
        retval = (verticalJustification == obj.verticalJustification);
        }
        break;
    case 15:
        {  // new scope
        retval = (singleNodeIndex == obj.singleNodeIndex);
        }
        break;
    case 16:
        {  // new scope
        retval = (singleCellIndex == obj.singleCellIndex);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

bool
LabelAttributes::ChangesRequireRecalculation(const LabelAttributes &) const
{
    return false;
}

