// ************************************************************************* //
//                             avtKerbelPlot.C                                 //
// ************************************************************************* //

#include <avtKerbelPlot.h>
#include <avtVariableMapper.h>
#include <avtKerbelFilter.h>
#include <avtVariableLegend.h>
#include <avtLookupTable.h>
#include <vtkLookupTable.h>

// ****************************************************************************
//  Method: avtKerbelPlot constructor
//
//  Programmer: ahern -- generated by xml2info
//  Creation:   Tue Dec 18 16:23:56 PST 2001
//
// ****************************************************************************

avtKerbelPlot::avtKerbelPlot()
{
    filter = NULL;
    varMapper   = new avtVariableMapper;
    colorsInitialized = false;

    avtLUT = new avtLookupTable;

    varLegend = new avtVariableLegend;
    varLegend->SetTitle("Kerbel");
    vtkLookupTable *lut = vtkLookupTable::New();
    varLegend->SetLookupTable(lut);
    lut->Delete();

    // This is to allow the legend to be reference counted so the behavior
    // can still access it after the plot is deleted.  The legend cannot be
    // reference counted all of the time since we need to konw that it is a
    // VariableLegend.
    varLegendRefPtr = varLegend;
}


// ****************************************************************************
//  Method: avtKerbelPlot destructor
//
//  Programmer: ahern -- generated by xml2info
//  Creation:   Tue Dec 18 16:23:56 PST 2001
//
// ****************************************************************************

avtKerbelPlot::~avtKerbelPlot()
{
    if (varMapper != NULL)
    {
        delete varMapper;
        varMapper = NULL;
    }
    if (filter != NULL)
    {
        delete filter;
        filter = NULL;
    }
    if (avtLUT != NULL)
    {
        delete avtLUT;
        avtLUT = NULL;
    }

    // Do not delete the varLegend since it is being held by varLegendRefPtr;
}

// ****************************************************************************
//  Method: avtKerbelPlot::ApplyOperators
//
//  Purpose:
//      Applies the operators associated with a Kerbel plot.  
//
//  Arguments:
//      input   The input data object.
//
//  Returns:    The data object after the Kerbel plot has been applied.
//
//  Programmer: ahern -- generated by xml2info
//  Creation:   Tue Dec 18 16:23:56 PST 2001
//
// ****************************************************************************

avtDataObject_p
avtKerbelPlot::ApplyOperators(avtDataObject_p input)
{
    filter = new avtKerbelFilter(atts);
    filter->SetInput(input);
    return filter->GetOutput();
}


// ****************************************************************************
//  Method: avtKerbelPlot::CustomizeBehavior
//
//  Purpose:
//      Customizes the behavior as appropriate for a Kerbel plot.  This includes
//      behavior like shifting towards or away from the screen.
//
//  Programmer: ahern -- generated by xml2info
//  Creation:   Tue Dec 18 16:23:56 PST 2001
//
//  Modifications:
//    Kathleen Bonnell, Thu Sep 18 11:55:37 PDT 2003
//    Set Antialiased render order.
//
// ****************************************************************************

void
avtKerbelPlot::CustomizeBehavior(void)
{
    if (atts.GetOpacity() < 1.)
    {
        behavior->SetRenderOrder(MUST_GO_LAST);
        behavior->SetAntialiasedRenderOrder(MUST_GO_LAST);
    }
    else
    {
        behavior->SetRenderOrder(DOES_NOT_MATTER);
        behavior->SetAntialiasedRenderOrder(DOES_NOT_MATTER);
    }

    varMapper->SetLookupTable(avtLUT->GetLookupTable());

    // Don't need a color bar for this plot right now, so turn it off.  We
    // might want it later, though.
    varLegend->SetColorBar(0);

    behavior->SetLegend(varLegendRefPtr);
}


// ****************************************************************************
//  Method: avtKerbelPlot::CustomizeMapper
//
//  Purpose:
//      A hook from the base class that allows the plot to change its mapper
//      based on the dataset input. 
//
//  Arguments:
//      doi     The data object information.
//
//  Programmer: ahern -- generated by xml2info
//  Creation:   Tue Dec 18 16:23:56 PST 2001
//
// ****************************************************************************

void
avtKerbelPlot::CustomizeMapper(avtDataObjectInformation &doi)
{
/* Example of usage.
    int dim = doi.GetAttributes().GetCurrentSpatialDimension();
    if (dim == 2)
    {
    }
    else
    {
    }
 */
}


// ****************************************************************************
//  Method: avtKerbelPlot::SetAtts
//
//  Purpose:
//      Sets the atts for the Kerbel plot.
//
//  Arguments:
//      atts    The attributes for this Kerbel plot.
//
//  Programmer: ahern -- generated by xml2info
//  Creation:   Tue Dec 18 16:23:56 PST 2001
//
// ****************************************************************************

void
avtKerbelPlot::SetAtts(const AttributeGroup *a)
{
    const KerbelAttributes *newAtts = (const KerbelAttributes *)a;

    // See if the colors will need to be updated
    bool updateColors =
        (!colorsInitialized) ||
        (atts.GetColorTableName() != newAtts->GetColorTableName());

    atts = *(const KerbelAttributes *)a;

    // Based on attribute values, change parameters in mapper and filter.
    SetOpacity(atts.GetOpacity());

    if (updateColors || atts.GetColorTableName() == "Default")
    {
        colorsInitialized = true;
        SetColorTable(atts.GetColorTableName().c_str());
    }

    SetLegend(atts.GetLegendFlag());
}


// ****************************************************************************
//  Method: avtKerbelPlot::SetOpactiy
//
//  Purpose:
//    Change the mapper's opacity, and update the Render order.
//
//  Arguments:
//    o        The data object information.
//
//  Programmer: Kathleen Bonnell 
//  Creation:   September 18, 2003 
//
// ****************************************************************************

void
avtKerbelPlot::SetOpacity(float o)
{
    varMapper->SetOpacity(o);
    if (o < 1.)
    {
        behavior->SetRenderOrder(MUST_GO_LAST);
        behavior->SetAntialiasedRenderOrder(MUST_GO_LAST);
    }
    else
    {
        behavior->SetRenderOrder(DOES_NOT_MATTER);
        behavior->SetAntialiasedRenderOrder(DOES_NOT_MATTER);
    }
}

void
avtKerbelPlot::SetLegend(bool legendOn)
{
    if (legendOn)
        varLegend->LegendOn();
    else
        varLegend->LegendOff();
}

bool
avtKerbelPlot::SetColorTable(const char *ctName)
{
    bool namesMatch = (atts.GetColorTableName() == std::string(ctName));

    if (atts.GetColorTableName() == "Default")
        return avtLUT->SetColorTable(NULL, namesMatch);
    else
        return avtLUT->SetColorTable(ctName, namesMatch);
}
