// ************************************************************************* //
//                              avtKerbelFilter.C                            //
// ************************************************************************* //

#include <avtKerbelFilter.h>
#include <avtExtents.h>
#include <vtkPolyData.h>
#include <vtkDataSet.h>
#include <vtkIdList.h>
#include <vtkFloatArray.h>

// ****************************************************************************
//  Method: avtKerbelFilter constructor
//
//  Programmer: ahern -- generated by xml2info
//  Creation:   Tue Dec 18 16:23:56 PST 2001
//
// ****************************************************************************

avtKerbelFilter::avtKerbelFilter(const KerbelAttributes &a)
{
    atts = a;
}


// ****************************************************************************
//  Method: avtKerbelFilter destructor
//
//  Programmer: ahern -- generated by xml2info
//  Creation:   Tue Dec 18 16:23:56 PST 2001
//
// ****************************************************************************

avtKerbelFilter::~avtKerbelFilter()
{
}

// ****************************************************************************
//  Method: avtKerbelFilter::Execute
//
//  Purpose:
//      Does the actual VTK code to modify the dataset.
//
//  Arguments:
//
//  Programmer: ahern -- generated by xml2info
//  Creation:   Tue Dec 18 16:23:56 PST 2001
//
// ****************************************************************************
void
avtKerbelFilter::Execute(void)
{
    float *center = atts.GetCenter();
    float radius = atts.GetRadius();

    vtkPolyData *polydata = vtkPolyData::New();
        polydata->Allocate(6,6*4);

    vtkPoints *points = vtkPoints::New();
    vtkDataArray *scalars = vtkFloatArray::New();
    scalars->SetNumberOfTuples(8);

    // Define a unit box.
    float point[8][3] = {{-.5,-.5,-.5},   // 0
                         {-.5,-.5, .5},   // 1
                         {-.5, .5,-.5},   // 2
                         {-.5, .5, .5},   // 3
                         { .5,-.5,-.5},   // 4
                         { .5,-.5, .5},   // 5
                         { .5, .5,-.5},   // 6
                         { .5, .5, .5}};  // 7

    for(int i=0;i<8;i++)
    {
        for(int j=0;j<3;j++)
        {
            point[i][j] *= radius;
            point[i][j] += center[j];
        }
        points->InsertNextPoint(point[i]);
        float f = (float)i;
        scalars->SetTuple(i,&f);
    }
    polydata->GetPointData()->SetScalars(scalars);

    vtkIdList *quad = vtkIdList::New();
    quad->SetNumberOfIds(4);

    quad->SetId(0,0);
    quad->SetId(1,1);
    quad->SetId(2,3);
    quad->SetId(3,2);
    polydata->InsertNextCell(VTK_QUAD, quad);

    quad->SetId(0,0);
    quad->SetId(3,4);
    quad->SetId(2,5);
    quad->SetId(1,1);
    polydata->InsertNextCell(VTK_QUAD, quad);

    quad->SetId(0,1);
    quad->SetId(1,5);
    quad->SetId(2,7);
    quad->SetId(3,3);
    polydata->InsertNextCell(VTK_QUAD, quad);

    quad->SetId(0,0);
    quad->SetId(1,4);
    quad->SetId(2,6);
    quad->SetId(3,2);
    polydata->InsertNextCell(VTK_QUAD, quad);

    quad->SetId(0,2);
    quad->SetId(1,3);
    quad->SetId(2,7);
    quad->SetId(3,6);
    polydata->InsertNextCell(VTK_QUAD, quad);

    quad->SetId(0,4);
    quad->SetId(1,5);
    quad->SetId(2,7);
    quad->SetId(3,6);
    polydata->InsertNextCell(VTK_QUAD, quad);

    polydata->SetPoints(points);
    points->Delete();
    scalars->Delete();

    avtDataTree_p tree = new avtDataTree(polydata,0);
    SetOutputDataTree(tree);
}


// ****************************************************************************
//  Method: avtKerbelFilter::RefashionDataObjectInfo
//
//  Purpose:
//      Allows the filter to change its output's data object information, which
//      is a description of the data object.
//
//  Programmer: ahern -- generated by xml2info
//  Creation:   Tue Dec 18 16:23:56 PST 2001
//
// ****************************************************************************

void
avtKerbelFilter::RefashionDataObjectInfo(void)
{
    avtDataAttributes &outAtts = GetOutput()->GetInfo().GetAttributes();

    outAtts.SetVariableDimension(1);
    outAtts.SetTopologicalDimension(2);
    outAtts.SetSpatialDimension(3);

    // Fix up the extents.  We need to totally erase what came from the database.
    avtExtents *ext= outAtts.GetTrueSpatialExtents();
    double newext[6] = {-.5, .5, -.5, .5, -.5, .5};
    float radius = atts.GetRadius();
    float *center = atts.GetCenter();
    for(int i=0;i<6;i++)
        newext[i] *= radius;
    for(int i=0;i<3;i++)
    {
        newext[i*2] += center[i];
        newext[i*2+1] += center[i];
    }
    ext->Set(newext);

}
