#include <PyKerbelAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyKerbelAttributes
//
// Purpose: 
//   This class contains the attributes for a Kerbel plot.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Nov 15 10:46:19 PDT 2002
//
// ****************************************************************************

//
// This struct contains the Python type information and a KerbelAttributes.
//
struct KerbelAttributesObject
{
    PyObject_HEAD
    KerbelAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewKerbelAttributes();

static PyObject *
KerbelAttributes_Notify(PyObject *self, PyObject *args)
{
    KerbelAttributesObject *obj = (KerbelAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
KerbelAttributes_SetCenter(PyObject *self, PyObject *args)
{
    KerbelAttributesObject *obj = (KerbelAttributesObject *)self;

    float *fvals = obj->data->GetCenter();
    if(!PyArg_ParseTuple(args, "fff", &fvals[0], &fvals[1], &fvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    fvals[i] = float(PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    fvals[i] = float(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    fvals[i] = float(PyLong_AsDouble(item));
                else
                    fvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the Center in the object as modified.
    obj->data->SelectCenter();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
KerbelAttributes_GetCenter(PyObject *self, PyObject *args)
{
    KerbelAttributesObject *obj = (KerbelAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the Center.
    PyObject *retval = PyTuple_New(3);
    const float *Center = obj->data->GetCenter();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(double(Center[i])));
    return retval;
}

static PyObject *
KerbelAttributes_SetRadius(PyObject *self, PyObject *args)
{
    KerbelAttributesObject *obj = (KerbelAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the Radius in the object.
    obj->data->SetRadius(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
KerbelAttributes_GetRadius(PyObject *self, PyObject *args)
{
    KerbelAttributesObject *obj = (KerbelAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetRadius()));
    return retval;
}

static PyObject *
KerbelAttributes_SetOpacity(PyObject *self, PyObject *args)
{
    KerbelAttributesObject *obj = (KerbelAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the opacity in the object.
    obj->data->SetOpacity(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
KerbelAttributes_GetOpacity(PyObject *self, PyObject *args)
{
    KerbelAttributesObject *obj = (KerbelAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOpacity());
    return retval;
}

static PyObject *
KerbelAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    KerbelAttributesObject *obj = (KerbelAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
KerbelAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    KerbelAttributesObject *obj = (KerbelAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

static PyObject *
KerbelAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    KerbelAttributesObject *obj = (KerbelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
KerbelAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    KerbelAttributesObject *obj = (KerbelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

static PyObject *
KerbelAttributes_SetFilename(PyObject *self, PyObject *args)
{
    KerbelAttributesObject *obj = (KerbelAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the filename in the object.
    obj->data->SetFilename(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
KerbelAttributes_GetFilename(PyObject *self, PyObject *args)
{
    KerbelAttributesObject *obj = (KerbelAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetFilename().c_str());
    return retval;
}



static struct PyMethodDef KerbelAttributes_methods[] = {
    {"Notify", KerbelAttributes_Notify, METH_VARARGS},
    {"SetCenter", KerbelAttributes_SetCenter, METH_VARARGS},
    {"GetCenter", KerbelAttributes_GetCenter, METH_VARARGS},
    {"SetRadius", KerbelAttributes_SetRadius, METH_VARARGS},
    {"GetRadius", KerbelAttributes_GetRadius, METH_VARARGS},
    {"SetOpacity", KerbelAttributes_SetOpacity, METH_VARARGS},
    {"GetOpacity", KerbelAttributes_GetOpacity, METH_VARARGS},
    {"SetColorTableName", KerbelAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", KerbelAttributes_GetColorTableName, METH_VARARGS},
    {"SetLegendFlag", KerbelAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", KerbelAttributes_GetLegendFlag, METH_VARARGS},
    {"SetFilename", KerbelAttributes_SetFilename, METH_VARARGS},
    {"GetFilename", KerbelAttributes_GetFilename, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
KerbelAttributes_dealloc(PyObject *v)
{
   KerbelAttributesObject *obj = (KerbelAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
KerbelAttributes_compare(PyObject *v, PyObject *w)
{
    KerbelAttributes *a = ((KerbelAttributesObject *)v)->data;
    KerbelAttributes *b = ((KerbelAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
KerbelAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "Center") == 0)
        return KerbelAttributes_GetCenter(self, NULL);
    if(strcmp(name, "Radius") == 0)
        return KerbelAttributes_GetRadius(self, NULL);
    if(strcmp(name, "opacity") == 0)
        return KerbelAttributes_GetOpacity(self, NULL);
    if(strcmp(name, "colorTableName") == 0)
        return KerbelAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "legendFlag") == 0)
        return KerbelAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "filename") == 0)
        return KerbelAttributes_GetFilename(self, NULL);

    return Py_FindMethod(KerbelAttributes_methods, self, name);
}

static int
KerbelAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "Center") == 0)
        retval = (KerbelAttributes_SetCenter(self, tuple) != NULL);
    else if(strcmp(name, "Radius") == 0)
        retval = (KerbelAttributes_SetRadius(self, tuple) != NULL);
    else if(strcmp(name, "opacity") == 0)
        retval = (KerbelAttributes_SetOpacity(self, tuple) != NULL);
    else if(strcmp(name, "colorTableName") == 0)
        retval = (KerbelAttributes_SetColorTableName(self, tuple) != NULL);
    else if(strcmp(name, "legendFlag") == 0)
        retval = (KerbelAttributes_SetLegendFlag(self, tuple) != NULL);
    else if(strcmp(name, "filename") == 0)
        retval = (KerbelAttributes_SetFilename(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
KerbelAttributes_print(PyObject *v, FILE *fp, int flags)
{
    KerbelAttributesObject *obj = (KerbelAttributesObject *)v;

    {   const float *Center = obj->data->GetCenter();
        fprintf(fp, "Center = (");
        for(int i = 0; i < 3; ++i)
        {
            fprintf(fp, "%g", Center[i]);
            if(i < 2)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    fprintf(fp, "Radius = %g\n", obj->data->GetRadius());
    fprintf(fp, "opacity = %g\n", obj->data->GetOpacity());
    fprintf(fp, "colorTableName = %s\n", obj->data->GetColorTableName().c_str());
    if(obj->data->GetLegendFlag())
        fprintf(fp, "legendFlag = 1\n");
    else
        fprintf(fp, "legendFlag = 0\n");
    fprintf(fp, "filename = \"%s\"\n", obj->data->GetFilename().c_str());

    return 0;
}

//
// The doc string for the class.
//
static char *KerbelAttributes_Purpose = "This class contains the attributes for a Kerbel plot.";

//
// The type description structure
//
static PyTypeObject KerbelAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "KerbelAttributes",                    // tp_name
    sizeof(KerbelAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)KerbelAttributes_dealloc,  // tp_dealloc
    (printfunc)KerbelAttributes_print,     // tp_print
    (getattrfunc)KerbelAttributes_getattr, // tp_getattr
    (setattrfunc)KerbelAttributes_setattr, // tp_setattr
    (cmpfunc)KerbelAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    KerbelAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static KerbelAttributes *defaultAtts = 0;

static PyObject *
NewKerbelAttributes()
{
    KerbelAttributesObject *newObject;
    newObject = PyObject_NEW(KerbelAttributesObject, &KerbelAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new KerbelAttributes(*defaultAtts);
    else
        newObject->data = new KerbelAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapKerbelAttributes(const KerbelAttributes *attr)
{
    KerbelAttributesObject *newObject;
    newObject = PyObject_NEW(KerbelAttributesObject, &KerbelAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (KerbelAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
KerbelAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewKerbelAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef KerbelAttributesMethods[] = {
    {"KerbelAttributes", KerbelAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *KerbelAttributesObserver = 0;
static bool KerbelAttributesEnableLogging = true;

static void
PyKerbelAttributes_WriteLog(Subject *subj, void *data)
{
    KerbelAttributes *atts = (KerbelAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!KerbelAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# KerbelAttributes_WriteLog()\n");
}

void
PyKerbelAttributes_StartUp(KerbelAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyKerbelAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(KerbelAttributesObserver == 0)
    {
        KerbelAttributesObserver = new ObserverToCallback(subj,
            PyKerbelAttributes_WriteLog, (void *)logFile);
    }

    KerbelAttributesEnableLogging = true;
}

void
PyKerbelAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete KerbelAttributesObserver;
    KerbelAttributesObserver = 0;
}

PyMethodDef *
PyKerbelAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return KerbelAttributesMethods;
}

bool
PyKerbelAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &KerbelAttributesType);
}

KerbelAttributes *
PyKerbelAttributes_FromPyObject(PyObject *obj)
{
    KerbelAttributesObject *obj2 = (KerbelAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyKerbelAttributes_NewPyObject()
{
    return NewKerbelAttributes();
}

PyObject *
PyKerbelAttributes_WrapPyObject(const KerbelAttributes *attr)
{
    return WrapKerbelAttributes(attr);
}

void
PyKerbelAttributes_SetLogging(bool val)
{
    KerbelAttributesEnableLogging = val;
}

void
PyKerbelAttributes_SetDefaults(const KerbelAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new KerbelAttributes(*atts);
}

