// ************************************************************************* //
//  File: KerbelViewerPluginInfo.C
// ************************************************************************* //

#include <KerbelPluginInfo.h>
#include <avtKerbelPlot.h>

#if defined(__APPLE__)
#define GetViewerInfo Kerbel_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Kerbel plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:39 PST 2004
//
// ****************************************************************************
extern "C" ViewerPlotPluginInfo* GetViewerInfo()
{
    KerbelViewerPluginInfo::InitializeGlobalObjects();
    return new KerbelViewerPluginInfo;
}

//
// Storage for static data elements.
//
KerbelAttributes *KerbelViewerPluginInfo::clientAtts = NULL;
KerbelAttributes *KerbelViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  KerbelViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:39 PST 2004
//
// ****************************************************************************
void
KerbelViewerPluginInfo::InitializeGlobalObjects()
{
    KerbelViewerPluginInfo::clientAtts  = new KerbelAttributes;
    KerbelViewerPluginInfo::defaultAtts = new KerbelAttributes;
}

// ****************************************************************************
//  Method: KerbelViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:39 PST 2004
//
// ****************************************************************************

AttributeSubject *
KerbelViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: KerbelViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:39 PST 2004
//
// ****************************************************************************

AttributeSubject *
KerbelViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: KerbelViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:39 PST 2004
//
// ****************************************************************************

void
KerbelViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(KerbelAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: KerbelViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:39 PST 2004
//
// ****************************************************************************

void
KerbelViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(KerbelAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: KerbelViewerPluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:39 PST 2004
//
// ****************************************************************************

avtPlot *
KerbelViewerPluginInfo::AllocAvtPlot()
{
    return new avtKerbelPlot;
}

// ****************************************************************************
//  Method: KerbelViewerPluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:39 PST 2004
//
// ****************************************************************************

void
KerbelViewerPluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtDatabaseMetaData *, const char *)
{
    *(KerbelAttributes*)atts = *defaultAtts;
}

// ****************************************************************************
// Method: KerbelViewerPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:39 PST 2004
//
// Modifications:
//   
// ****************************************************************************

int
KerbelViewerPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_MESH;
}

