// ************************************************************************* //
//                        KerbelScriptingPluginInfo.C
// ************************************************************************* //
#include <KerbelPluginInfo.h>
#include <PyKerbelAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Makefile.in_GetScriptingInfo
#endif

#if defined(__APPLE__)
#define GetScriptingInfo Kerbel_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Kerbel plot.
//
//  Programmer: ahern -- generated by xml2info
//  Creation:   Fri Nov 15 10:46:12 PDT 2002
//
// ****************************************************************************
extern "C" ScriptingPlotPluginInfo* GetScriptingInfo()
{
    return new KerbelScriptingPluginInfo;
}

// ****************************************************************************
// Method: KerbelScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: ahern -- generated by xml2info
//  Creation:   Fri Nov 15 10:46:12 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

void
KerbelScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyKerbelAttributes_StartUp((KerbelAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: KerbelScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: ahern -- generated by xml2info
//  Creation:   Fri Nov 15 10:46:12 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

void *
KerbelScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyKerbelAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: KerbelScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Kerbel plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: ahern -- generated by xml2info
//  Creation:   Fri Nov 15 10:46:12 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

bool
KerbelScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyKerbelAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: KerbelScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: ahern -- generated by xml2info
//  Creation:   Fri Nov 15 10:46:12 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

void
KerbelScriptingPluginInfo::SetLogging(bool val)
{
    PyKerbelAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: KerbelScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: ahern -- generated by xml2info
//  Creation:   Fri Nov 15 10:46:12 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

void
KerbelScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyKerbelAttributes_SetDefaults((const KerbelAttributes *)atts);
}
