// ************************************************************************* //
//                               KerbelPluginInfo.h                          //
// ************************************************************************* //

#ifndef KERBEL_PLUGIN_INFO_H
#define KERBEL_PLUGIN_INFO_H
#include <PlotPluginInfo.h>
#include <plot_plugin_exports.h>

class KerbelAttributes;

// ****************************************************************************
//  Class: KerbelPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about a Kerbel
//    plot plugin.  The information is broken up into five classes since
//    portions of it are only relevant to particular components within
//    visit.  There is the general information which all the components
//    are interested in, the gui information which the gui is interested in,
//    the viewer information which the viewer is interested in, the
//    engine information which the engine is interested in, and finally a.
//    scripting portion that enables the Python VisIt extension to use the
//    plugin.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:39 PST 2004
//
// ****************************************************************************

class KerbelGeneralPluginInfo: public virtual GeneralPlotPluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
};

class KerbelCommonPluginInfo : public virtual CommonPlotPluginInfo, public virtual KerbelGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class KerbelGUIPluginInfo: public virtual GUIPlotPluginInfo, public virtual KerbelCommonPluginInfo
{
  public:
    virtual const char *GetMenuName() const;
    virtual int GetVariableTypes() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, QvisNotepadArea *notepad);
};

class KerbelViewerPluginInfo: public virtual ViewerPlotPluginInfo, public virtual KerbelCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual avtPlot *AllocAvtPlot();

    virtual void InitializePlotAtts(AttributeSubject *atts,
        const avtDatabaseMetaData *md,
        const char *variableName);
    virtual int GetVariableTypes() const;

    static void InitializeGlobalObjects();
  private:
    static KerbelAttributes *defaultAtts;
    static KerbelAttributes *clientAtts;
};

class KerbelEnginePluginInfo: public virtual EnginePlotPluginInfo, public virtual KerbelCommonPluginInfo
{
  public:
    virtual avtPlot *AllocAvtPlot();
};

class KerbelScriptingPluginInfo : public virtual ScriptingPlotPluginInfo, public virtual KerbelCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, FILE *log);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual void SetLogging(bool val);
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
