// ************************************************************************* //
//  File: KerbelGUIPluginInfo.C
// ************************************************************************* //

#include <KerbelPluginInfo.h>
#include <KerbelAttributes.h>
#include <QvisKerbelPlotWindowWithButtons.h>

#if defined(__APPLE__)
#define GetGUIInfo Makefile.in_GetGUIInfo
#endif

#if defined(__APPLE__)
#define GetGUIInfo Kerbel_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Kerbel plot.
//
//  Programmer: ahern -- generated by xml2info
//  Creation:   Fri Nov 15 10:46:12 PDT 2002
//
// ****************************************************************************
extern "C" GUIPlotPluginInfo* GetGUIInfo()
{
    return new KerbelGUIPluginInfo;
}

// ****************************************************************************
//  Method: KerbelGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: ahern -- generated by xml2info
//  Creation:   Fri Nov 15 10:46:12 PDT 2002
//
// ****************************************************************************

const char *
KerbelGUIPluginInfo::GetMenuName() const
{
    return "Kerbel";
}


// ****************************************************************************
// Method: KerbelGUIPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: ahern -- generated by xml2info
//  Creation:   Fri Nov 15 10:46:12 PDT 2002
//
// Modifications:
//   
// ****************************************************************************

int
KerbelGUIPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_MESH;
}

// ****************************************************************************
//  Method: KerbelGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: ahern -- generated by xml2info
//  Creation:   Fri Nov 15 10:46:12 PDT 2002
//
// ****************************************************************************

QvisPostableWindowObserver *
KerbelGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisKerbelPlotWindowWithButtons(type, (KerbelAttributes *)attr,
        "Kerbel plot attributes", "Kerbel plot", notepad);
}
