#ifndef KERBELATTRIBUTES_H
#define KERBELATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>

// ****************************************************************************
// Class: KerbelAttributes
//
// Purpose:
//    This class contains the attributes for a Kerbel plot.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:09 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

class KerbelAttributes : public AttributeSubject
{
public:
    KerbelAttributes();
    KerbelAttributes(const KerbelAttributes &obj);
    virtual ~KerbelAttributes();

    virtual void operator = (const KerbelAttributes &obj);
    virtual bool operator == (const KerbelAttributes &obj) const;
    virtual bool operator != (const KerbelAttributes &obj) const;

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectCenter();
    void SelectFilename();

    // Property setting methods
    void SetCenter(const float *Center_);
    void SetRadius(float Radius_);
    void SetFilename(const std::string &filename_);

    // Property getting methods
    const float       *GetCenter() const;
          float       *GetCenter();
    float             GetRadius() const;
    const std::string &GetFilename() const;
          std::string &GetFilename();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

private:
    float       Center[3];
    float       Radius;
    std::string filename;
};

#endif
