#include <PyHistogramAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyHistogramAttributes
//
// Purpose: 
//   Attributes for Histogram Plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Mon Aug 30 08:17:12 PDT 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a HistogramAttributes.
//
struct HistogramAttributesObject
{
    PyObject_HEAD
    HistogramAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewHistogramAttributes();

static PyObject *
HistogramAttributes_Notify(PyObject *self, PyObject *args)
{
    HistogramAttributesObject *obj = (HistogramAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HistogramAttributes_SetSpecifyRange(PyObject *self, PyObject *args)
{
    HistogramAttributesObject *obj = (HistogramAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the specifyRange in the object.
    obj->data->SetSpecifyRange(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HistogramAttributes_GetSpecifyRange(PyObject *self, PyObject *args)
{
    HistogramAttributesObject *obj = (HistogramAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSpecifyRange()?1L:0L);
    return retval;
}

static PyObject *
HistogramAttributes_SetMin(PyObject *self, PyObject *args)
{
    HistogramAttributesObject *obj = (HistogramAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the min in the object.
    obj->data->SetMin(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HistogramAttributes_GetMin(PyObject *self, PyObject *args)
{
    HistogramAttributesObject *obj = (HistogramAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMin());
    return retval;
}

static PyObject *
HistogramAttributes_SetMax(PyObject *self, PyObject *args)
{
    HistogramAttributesObject *obj = (HistogramAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the max in the object.
    obj->data->SetMax(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HistogramAttributes_GetMax(PyObject *self, PyObject *args)
{
    HistogramAttributesObject *obj = (HistogramAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMax());
    return retval;
}

static PyObject *
HistogramAttributes_SetOutputType(PyObject *self, PyObject *args)
{
    HistogramAttributesObject *obj = (HistogramAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the outputType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetOutputType(HistogramAttributes::OutputType(ival));
    else
    {
        fprintf(stderr, "An invalid outputType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Curve, Block.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HistogramAttributes_GetOutputType(PyObject *self, PyObject *args)
{
    HistogramAttributesObject *obj = (HistogramAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOutputType()));
    return retval;
}

static PyObject *
HistogramAttributes_SetNumBins(PyObject *self, PyObject *args)
{
    HistogramAttributesObject *obj = (HistogramAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numBins in the object.
    obj->data->SetNumBins(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HistogramAttributes_GetNumBins(PyObject *self, PyObject *args)
{
    HistogramAttributesObject *obj = (HistogramAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumBins()));
    return retval;
}

static PyObject *
HistogramAttributes_SetTwoDAmount(PyObject *self, PyObject *args)
{
    HistogramAttributesObject *obj = (HistogramAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the twoDAmount in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetTwoDAmount(HistogramAttributes::TwoDAmount(ival));
    else
    {
        fprintf(stderr, "An invalid twoDAmount value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Area, RevolvedVolume.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HistogramAttributes_GetTwoDAmount(PyObject *self, PyObject *args)
{
    HistogramAttributesObject *obj = (HistogramAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTwoDAmount()));
    return retval;
}

static PyObject *
HistogramAttributes_SetLineStyle(PyObject *self, PyObject *args)
{
    HistogramAttributesObject *obj = (HistogramAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineStyle in the object.
    obj->data->SetLineStyle(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HistogramAttributes_GetLineStyle(PyObject *self, PyObject *args)
{
    HistogramAttributesObject *obj = (HistogramAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineStyle()));
    return retval;
}

static PyObject *
HistogramAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    HistogramAttributesObject *obj = (HistogramAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HistogramAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    HistogramAttributesObject *obj = (HistogramAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

static PyObject *
HistogramAttributes_SetColor(PyObject *self, PyObject *args)
{
    HistogramAttributesObject *obj = (HistogramAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the color in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
HistogramAttributes_GetColor(PyObject *self, PyObject *args)
{
    HistogramAttributesObject *obj = (HistogramAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the color.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *color = obj->data->GetColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(color[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(color[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(color[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(color[3])));
    return retval;
}



static struct PyMethodDef HistogramAttributes_methods[] = {
    {"Notify", HistogramAttributes_Notify, METH_VARARGS},
    {"SetSpecifyRange", HistogramAttributes_SetSpecifyRange, METH_VARARGS},
    {"GetSpecifyRange", HistogramAttributes_GetSpecifyRange, METH_VARARGS},
    {"SetMin", HistogramAttributes_SetMin, METH_VARARGS},
    {"GetMin", HistogramAttributes_GetMin, METH_VARARGS},
    {"SetMax", HistogramAttributes_SetMax, METH_VARARGS},
    {"GetMax", HistogramAttributes_GetMax, METH_VARARGS},
    {"SetOutputType", HistogramAttributes_SetOutputType, METH_VARARGS},
    {"GetOutputType", HistogramAttributes_GetOutputType, METH_VARARGS},
    {"SetNumBins", HistogramAttributes_SetNumBins, METH_VARARGS},
    {"GetNumBins", HistogramAttributes_GetNumBins, METH_VARARGS},
    {"SetTwoDAmount", HistogramAttributes_SetTwoDAmount, METH_VARARGS},
    {"GetTwoDAmount", HistogramAttributes_GetTwoDAmount, METH_VARARGS},
    {"SetLineStyle", HistogramAttributes_SetLineStyle, METH_VARARGS},
    {"GetLineStyle", HistogramAttributes_GetLineStyle, METH_VARARGS},
    {"SetLineWidth", HistogramAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", HistogramAttributes_GetLineWidth, METH_VARARGS},
    {"SetColor", HistogramAttributes_SetColor, METH_VARARGS},
    {"GetColor", HistogramAttributes_GetColor, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
HistogramAttributes_dealloc(PyObject *v)
{
   HistogramAttributesObject *obj = (HistogramAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
HistogramAttributes_compare(PyObject *v, PyObject *w)
{
    HistogramAttributes *a = ((HistogramAttributesObject *)v)->data;
    HistogramAttributes *b = ((HistogramAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
HistogramAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "specifyRange") == 0)
        return HistogramAttributes_GetSpecifyRange(self, NULL);
    if(strcmp(name, "min") == 0)
        return HistogramAttributes_GetMin(self, NULL);
    if(strcmp(name, "max") == 0)
        return HistogramAttributes_GetMax(self, NULL);
    if(strcmp(name, "outputType") == 0)
        return HistogramAttributes_GetOutputType(self, NULL);
    if(strcmp(name, "Curve") == 0)
        return PyInt_FromLong(long(HistogramAttributes::Curve));
    else if(strcmp(name, "Block") == 0)
        return PyInt_FromLong(long(HistogramAttributes::Block));

    if(strcmp(name, "numBins") == 0)
        return HistogramAttributes_GetNumBins(self, NULL);
    if(strcmp(name, "twoDAmount") == 0)
        return HistogramAttributes_GetTwoDAmount(self, NULL);
    if(strcmp(name, "Area") == 0)
        return PyInt_FromLong(long(HistogramAttributes::Area));
    else if(strcmp(name, "RevolvedVolume") == 0)
        return PyInt_FromLong(long(HistogramAttributes::RevolvedVolume));

    if(strcmp(name, "lineStyle") == 0)
        return HistogramAttributes_GetLineStyle(self, NULL);
    if(strcmp(name, "lineWidth") == 0)
        return HistogramAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "color") == 0)
        return HistogramAttributes_GetColor(self, NULL);

    return Py_FindMethod(HistogramAttributes_methods, self, name);
}

static int
HistogramAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "specifyRange") == 0)
        retval = (HistogramAttributes_SetSpecifyRange(self, tuple) != NULL);
    else if(strcmp(name, "min") == 0)
        retval = (HistogramAttributes_SetMin(self, tuple) != NULL);
    else if(strcmp(name, "max") == 0)
        retval = (HistogramAttributes_SetMax(self, tuple) != NULL);
    else if(strcmp(name, "outputType") == 0)
        retval = (HistogramAttributes_SetOutputType(self, tuple) != NULL);
    else if(strcmp(name, "numBins") == 0)
        retval = (HistogramAttributes_SetNumBins(self, tuple) != NULL);
    else if(strcmp(name, "twoDAmount") == 0)
        retval = (HistogramAttributes_SetTwoDAmount(self, tuple) != NULL);
    else if(strcmp(name, "lineStyle") == 0)
        retval = (HistogramAttributes_SetLineStyle(self, tuple) != NULL);
    else if(strcmp(name, "lineWidth") == 0)
        retval = (HistogramAttributes_SetLineWidth(self, tuple) != NULL);
    else if(strcmp(name, "color") == 0)
        retval = (HistogramAttributes_SetColor(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
HistogramAttributes_print(PyObject *v, FILE *fp, int flags)
{
    HistogramAttributesObject *obj = (HistogramAttributesObject *)v;

    if(obj->data->GetSpecifyRange())
        fprintf(fp, "specifyRange = 1\n");
    else
        fprintf(fp, "specifyRange = 0\n");
    fprintf(fp, "min = %g\n", obj->data->GetMin());
    fprintf(fp, "max = %g\n", obj->data->GetMax());
    const char *outputType_names = "Curve, Block";
    if(obj->data->GetOutputType() == HistogramAttributes::Curve)
        fprintf(fp, "outputType = Curve  # %s\n", outputType_names);
    else
        fprintf(fp, "outputType = Block  # %s\n", outputType_names);

    fprintf(fp, "numBins = %d\n", obj->data->GetNumBins());
    const char *twoDAmount_names = "Area, RevolvedVolume";
    if(obj->data->GetTwoDAmount() == HistogramAttributes::Area)
        fprintf(fp, "twoDAmount = Area  # %s\n", twoDAmount_names);
    else
        fprintf(fp, "twoDAmount = RevolvedVolume  # %s\n", twoDAmount_names);

    fprintf(fp, "lineStyle = %d\n", obj->data->GetLineStyle());
    fprintf(fp, "lineWidth = %d\n", obj->data->GetLineWidth());
    const unsigned char *color = obj->data->GetColor().GetColor();
    fprintf(fp, "color = (%d, %d, %d, %d)\n", int(color[0]), int(color[1]), int(color[2]), int(color[3]));

    return 0;
}

#include <snprintf.h>
PyObject *
PyHistogramAttributes_StringRepresentation(const HistogramAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    if(atts->GetSpecifyRange())
        SNPRINTF(tmpStr, 1000, "specifyRange = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "specifyRange = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "min = %g\n", atts->GetMin());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "max = %g\n", atts->GetMax());
    str += tmpStr;
    const char *outputType_names = "Curve, Block";
    if(atts->GetOutputType() == HistogramAttributes::Curve)
        {
             SNPRINTF(tmpStr, 1000, "outputType = Curve  # %s\n", outputType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "outputType = Block  # %s\n", outputType_names);
             str += tmpStr;
        }

    SNPRINTF(tmpStr, 1000, "numBins = %d\n", atts->GetNumBins());
    str += tmpStr;
    const char *twoDAmount_names = "Area, RevolvedVolume";
    if(atts->GetTwoDAmount() == HistogramAttributes::Area)
        {
             SNPRINTF(tmpStr, 1000, "twoDAmount = Area  # %s\n", twoDAmount_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "twoDAmount = RevolvedVolume  # %s\n", twoDAmount_names);
             str += tmpStr;
        }

    SNPRINTF(tmpStr, 1000, "lineStyle = %d\n", atts->GetLineStyle());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "lineWidth = %d\n", atts->GetLineWidth());
    str += tmpStr;
    const unsigned char *color = atts->GetColor().GetColor();
    SNPRINTF(tmpStr, 1000, "color = (%d, %d, %d, %d)\n", int(color[0]), int(color[1]), int(color[2]), int(color[3]));
    str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
HistogramAttributes_str(PyObject *v)
{
    HistogramAttributesObject *obj = (HistogramAttributesObject *)v;
    return PyHistogramAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *HistogramAttributes_Purpose = "Attributes for Histogram Plot";

//
// The type description structure
//
static PyTypeObject HistogramAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "HistogramAttributes",                    // tp_name
    sizeof(HistogramAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)HistogramAttributes_dealloc,  // tp_dealloc
    (printfunc)HistogramAttributes_print,     // tp_print
    (getattrfunc)HistogramAttributes_getattr, // tp_getattr
    (setattrfunc)HistogramAttributes_setattr, // tp_setattr
    (cmpfunc)HistogramAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)HistogramAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    HistogramAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static HistogramAttributes *defaultAtts = 0;

static PyObject *
NewHistogramAttributes()
{
    HistogramAttributesObject *newObject;
    newObject = PyObject_NEW(HistogramAttributesObject, &HistogramAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new HistogramAttributes(*defaultAtts);
    else
        newObject->data = new HistogramAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapHistogramAttributes(const HistogramAttributes *attr)
{
    HistogramAttributesObject *newObject;
    newObject = PyObject_NEW(HistogramAttributesObject, &HistogramAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (HistogramAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
HistogramAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewHistogramAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef HistogramAttributesMethods[] = {
    {"HistogramAttributes", HistogramAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *HistogramAttributesObserver = 0;
static bool HistogramAttributesEnableLogging = true;

static void
PyHistogramAttributes_WriteLog(Subject *subj, void *data)
{
    HistogramAttributes *atts = (HistogramAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!HistogramAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# HistogramAttributes_WriteLog()\n");
}

void
PyHistogramAttributes_StartUp(HistogramAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyHistogramAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(HistogramAttributesObserver == 0)
    {
        HistogramAttributesObserver = new ObserverToCallback(subj,
            PyHistogramAttributes_WriteLog, (void *)logFile);
    }

    HistogramAttributesEnableLogging = true;
}

void
PyHistogramAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete HistogramAttributesObserver;
    HistogramAttributesObserver = 0;
}

PyMethodDef *
PyHistogramAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return HistogramAttributesMethods;
}

bool
PyHistogramAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &HistogramAttributesType);
}

HistogramAttributes *
PyHistogramAttributes_FromPyObject(PyObject *obj)
{
    HistogramAttributesObject *obj2 = (HistogramAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyHistogramAttributes_NewPyObject()
{
    return NewHistogramAttributes();
}

PyObject *
PyHistogramAttributes_WrapPyObject(const HistogramAttributes *attr)
{
    return WrapHistogramAttributes(attr);
}

void
PyHistogramAttributes_SetLogging(bool val)
{
    HistogramAttributesEnableLogging = val;
}

void
PyHistogramAttributes_SetDefaults(const HistogramAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new HistogramAttributes(*atts);
}

