// ************************************************************************* //
//  File: HistogramViewerPluginInfo.C
// ************************************************************************* //

#include <HistogramPluginInfo.h>
#include <avtHistogramPlot.h>

#if defined(__APPLE__)
#define GetViewerInfo Histogram_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Histogram plot.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Aug 30 08:17:12 PDT 2004
//
// ****************************************************************************
extern "C" ViewerPlotPluginInfo* GetViewerInfo()
{
    HistogramViewerPluginInfo::InitializeGlobalObjects();
    return new HistogramViewerPluginInfo;
}

//
// Storage for static data elements.
//
HistogramAttributes *HistogramViewerPluginInfo::clientAtts = NULL;
HistogramAttributes *HistogramViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  HistogramViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Aug 30 08:17:12 PDT 2004
//
// ****************************************************************************
void
HistogramViewerPluginInfo::InitializeGlobalObjects()
{
    HistogramViewerPluginInfo::clientAtts  = new HistogramAttributes;
    HistogramViewerPluginInfo::defaultAtts = new HistogramAttributes;
}

// ****************************************************************************
//  Method: HistogramViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Aug 30 08:17:12 PDT 2004
//
// ****************************************************************************

AttributeSubject *
HistogramViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: HistogramViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Aug 30 08:17:12 PDT 2004
//
// ****************************************************************************

AttributeSubject *
HistogramViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: HistogramViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Aug 30 08:17:12 PDT 2004
//
// ****************************************************************************

void
HistogramViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(HistogramAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: HistogramViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Aug 30 08:17:12 PDT 2004
//
// ****************************************************************************

void
HistogramViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(HistogramAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: HistogramViewerPluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Aug 30 08:17:12 PDT 2004
//
// ****************************************************************************

avtPlot *
HistogramViewerPluginInfo::AllocAvtPlot()
{
    return new avtHistogramPlot;
}

// ****************************************************************************
//  Method: HistogramViewerPluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Aug 30 08:17:12 PDT 2004
//
// ****************************************************************************

void
HistogramViewerPluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtDatabaseMetaData *, const char *)
{
    *(HistogramAttributes*)atts = *defaultAtts;
}

// ****************************************************************************
// Method: HistogramViewerPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Aug 30 08:17:12 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

int
HistogramViewerPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SCALAR;
}


// ****************************************************************************
//  Method: HistogramViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Aug 30 08:17:12 PDT 2004
//
// ****************************************************************************

#include <Histogram.xpm>
const char **
HistogramViewerPluginInfo::XPMIconData() const
{
    return Histogram_xpm;
}
