// ************************************************************************* //
//                        HistogramScriptingPluginInfo.C
// ************************************************************************* //
#include <HistogramPluginInfo.h>
#include <PyHistogramAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo Histogram_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the Histogram plot.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jun 26 10:33:56 PDT 2003
//
// ****************************************************************************
extern "C" ScriptingPlotPluginInfo* GetScriptingInfo()
{
    return new HistogramScriptingPluginInfo;
}

// ****************************************************************************
// Method: HistogramScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jun 26 10:33:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
HistogramScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyHistogramAttributes_StartUp((HistogramAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: HistogramScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jun 26 10:33:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void *
HistogramScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyHistogramAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: HistogramScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is Histogram plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jun 26 10:33:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
HistogramScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyHistogramAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: HistogramScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jun 26 10:33:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
HistogramScriptingPluginInfo::SetLogging(bool val)
{
    PyHistogramAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: HistogramScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Jun 26 10:33:56 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
HistogramScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyHistogramAttributes_SetDefaults((const HistogramAttributes *)atts);
}
