// ************************************************************************* //
//  File: HistogramGUIPluginInfo.C
// ************************************************************************* //

#include <HistogramPluginInfo.h>
#include <HistogramAttributes.h>
#include <QvisHistogramPlotWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo Histogram_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the Histogram plot.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Aug 30 08:17:12 PDT 2004
//
// ****************************************************************************
extern "C" GUIPlotPluginInfo* GetGUIInfo()
{
    return new HistogramGUIPluginInfo;
}

// ****************************************************************************
//  Method: HistogramGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Aug 30 08:17:12 PDT 2004
//
// ****************************************************************************

const char *
HistogramGUIPluginInfo::GetMenuName() const
{
    return "Histogram";
}


// ****************************************************************************
// Method: HistogramGUIPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Aug 30 08:17:12 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

int
HistogramGUIPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SCALAR;
}

// ****************************************************************************
//  Method: HistogramGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Aug 30 08:17:12 PDT 2004
//
// ****************************************************************************

QvisPostableWindowObserver *
HistogramGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisHistogramPlotWindow(type, (HistogramAttributes *)attr,
        "Histogram plot attributes", "Histogram plot", notepad);
}

// ****************************************************************************
//  Method: HistogramGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Mon Aug 30 08:17:12 PDT 2004
//
// ****************************************************************************

#include <Histogram.xpm>
const char **
HistogramGUIPluginInfo::XPMIconData() const
{
    return Histogram_xpm;
}
