package llnl.visit.plots;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;
import llnl.visit.ColorAttribute;

// ****************************************************************************
// Class: HistogramAttributes
//
// Purpose:
//    Attributes for Histogram Plot
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Thu Jul 31 16:07:56 PST 2003
//
// Modifications:
//   
// ****************************************************************************

public class HistogramAttributes extends AttributeSubject implements Plugin
{
    // Constants
    public final static int OUTPUTTYPE_CURVE = 0;
    public final static int OUTPUTTYPE_BLOCK = 1;

    public final static int TWODAMOUNT_AREA = 0;
    public final static int TWODAMOUNT_REVOLVEDVOLUME = 1;


    public HistogramAttributes()
    {
        super(9);

        specifyRange = false;
        min = 0;
        max = 1;
        outputType = OUTPUTTYPE_BLOCK;
        numBins = 32;
        twoDAmount = TWODAMOUNT_REVOLVEDVOLUME;
        lineStyle = 0;
        lineWidth = 0;
        color = new ColorAttribute();
    }

    public HistogramAttributes(HistogramAttributes obj)
    {
        super(9);

        specifyRange = obj.specifyRange;
        min = obj.min;
        max = obj.max;
        outputType = obj.outputType;
        numBins = obj.numBins;
        twoDAmount = obj.twoDAmount;
        lineStyle = obj.lineStyle;
        lineWidth = obj.lineWidth;
        color = new ColorAttribute(obj.color);

        SelectAll();
    }

    public boolean equals(HistogramAttributes obj)
    {
        // Create the return value
        return ((specifyRange == obj.specifyRange) &&
                (min == obj.min) &&
                (max == obj.max) &&
                (outputType == obj.outputType) &&
                (numBins == obj.numBins) &&
                (twoDAmount == obj.twoDAmount) &&
                (lineStyle == obj.lineStyle) &&
                (lineWidth == obj.lineWidth) &&
                (color == obj.color));
    }

    public String GetName() { return "Histogram"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetSpecifyRange(boolean specifyRange_)
    {
        specifyRange = specifyRange_;
        Select(0);
    }

    public void SetMin(double min_)
    {
        min = min_;
        Select(1);
    }

    public void SetMax(double max_)
    {
        max = max_;
        Select(2);
    }

    public void SetOutputType(int outputType_)
    {
        outputType = outputType_;
        Select(3);
    }

    public void SetNumBins(int numBins_)
    {
        numBins = numBins_;
        Select(4);
    }

    public void SetTwoDAmount(int twoDAmount_)
    {
        twoDAmount = twoDAmount_;
        Select(5);
    }

    public void SetLineStyle(int lineStyle_)
    {
        lineStyle = lineStyle_;
        Select(6);
    }

    public void SetLineWidth(int lineWidth_)
    {
        lineWidth = lineWidth_;
        Select(7);
    }

    public void SetColor(ColorAttribute color_)
    {
        color = color_;
        Select(8);
    }

    // Property getting methods
    public boolean        GetSpecifyRange() { return specifyRange; }
    public double         GetMin() { return min; }
    public double         GetMax() { return max; }
    public int            GetOutputType() { return outputType; }
    public int            GetNumBins() { return numBins; }
    public int            GetTwoDAmount() { return twoDAmount; }
    public int            GetLineStyle() { return lineStyle; }
    public int            GetLineWidth() { return lineWidth; }
    public ColorAttribute GetColor() { return color; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteBool(specifyRange);
        if(WriteSelect(1, buf))
            buf.WriteDouble(min);
        if(WriteSelect(2, buf))
            buf.WriteDouble(max);
        if(WriteSelect(3, buf))
            buf.WriteInt(outputType);
        if(WriteSelect(4, buf))
            buf.WriteInt(numBins);
        if(WriteSelect(5, buf))
            buf.WriteInt(twoDAmount);
        if(WriteSelect(6, buf))
            buf.WriteInt(lineStyle);
        if(WriteSelect(7, buf))
            buf.WriteInt(lineWidth);
        if(WriteSelect(8, buf))
            color.Write(buf);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetSpecifyRange(buf.ReadBool());
                break;
            case 1:
                SetMin(buf.ReadDouble());
                break;
            case 2:
                SetMax(buf.ReadDouble());
                break;
            case 3:
                SetOutputType(buf.ReadInt());
                break;
            case 4:
                SetNumBins(buf.ReadInt());
                break;
            case 5:
                SetTwoDAmount(buf.ReadInt());
                break;
            case 6:
                SetLineStyle(buf.ReadInt());
                break;
            case 7:
                SetLineWidth(buf.ReadInt());
                break;
            case 8:
                color.Read(buf);
                Select(8);
                break;
            }
        }
    }


    // Attributes
    private boolean        specifyRange;
    private double         min;
    private double         max;
    private int            outputType;
    private int            numBins;
    private int            twoDAmount;
    private int            lineStyle;
    private int            lineWidth;
    private ColorAttribute color;
}

