#include <HistogramAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for HistogramAttributes::OutputType
//

static const char *OutputType_strings[] = {
"Curve", "Block"};

std::string
HistogramAttributes::OutputType_ToString(HistogramAttributes::OutputType t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return OutputType_strings[index];
}

std::string
HistogramAttributes::OutputType_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return OutputType_strings[index];
}

bool
HistogramAttributes::OutputType_FromString(const std::string &s, HistogramAttributes::OutputType &val)
{
    val = HistogramAttributes::Curve;
    for(int i = 0; i < 2; ++i)
    {
        if(s == OutputType_strings[i])
        {
            val = (OutputType)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for HistogramAttributes::TwoDAmount
//

static const char *TwoDAmount_strings[] = {
"Area", "RevolvedVolume"};

std::string
HistogramAttributes::TwoDAmount_ToString(HistogramAttributes::TwoDAmount t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return TwoDAmount_strings[index];
}

std::string
HistogramAttributes::TwoDAmount_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return TwoDAmount_strings[index];
}

bool
HistogramAttributes::TwoDAmount_FromString(const std::string &s, HistogramAttributes::TwoDAmount &val)
{
    val = HistogramAttributes::Area;
    for(int i = 0; i < 2; ++i)
    {
        if(s == TwoDAmount_strings[i])
        {
            val = (TwoDAmount)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: HistogramAttributes::HistogramAttributes
//
// Purpose: 
//   Constructor for the HistogramAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

HistogramAttributes::HistogramAttributes() : AttributeSubject("bddiiiiia"),
    color(0, 0, 0)
{
    specifyRange = false;
    min = 0;
    max = 1;
    outputType = Block;
    numBins = 32;
    twoDAmount = RevolvedVolume;
    lineStyle = 0;
    lineWidth = 0;
}

// ****************************************************************************
// Method: HistogramAttributes::HistogramAttributes
//
// Purpose: 
//   Copy constructor for the HistogramAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

HistogramAttributes::HistogramAttributes(const HistogramAttributes &obj) : AttributeSubject("bddiiiiia")
{
    specifyRange = obj.specifyRange;
    min = obj.min;
    max = obj.max;
    outputType = obj.outputType;
    numBins = obj.numBins;
    twoDAmount = obj.twoDAmount;
    lineStyle = obj.lineStyle;
    lineWidth = obj.lineWidth;
    color = obj.color;

    SelectAll();
}

// ****************************************************************************
// Method: HistogramAttributes::~HistogramAttributes
//
// Purpose: 
//   Destructor for the HistogramAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

HistogramAttributes::~HistogramAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: HistogramAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the HistogramAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
HistogramAttributes::operator = (const HistogramAttributes &obj)
{
    specifyRange = obj.specifyRange;
    min = obj.min;
    max = obj.max;
    outputType = obj.outputType;
    numBins = obj.numBins;
    twoDAmount = obj.twoDAmount;
    lineStyle = obj.lineStyle;
    lineWidth = obj.lineWidth;
    color = obj.color;

    SelectAll();
}

// ****************************************************************************
// Method: HistogramAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the HistogramAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
HistogramAttributes::operator == (const HistogramAttributes &obj) const
{
    // Create the return value
    return ((specifyRange == obj.specifyRange) &&
            (min == obj.min) &&
            (max == obj.max) &&
            (outputType == obj.outputType) &&
            (numBins == obj.numBins) &&
            (twoDAmount == obj.twoDAmount) &&
            (lineStyle == obj.lineStyle) &&
            (lineWidth == obj.lineWidth) &&
            (color == obj.color));
}

// ****************************************************************************
// Method: HistogramAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the HistogramAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
HistogramAttributes::operator != (const HistogramAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: HistogramAttributes::TypeName
//
// Purpose: 
//   Type name method for the HistogramAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

const std::string
HistogramAttributes::TypeName() const
{
    return "HistogramAttributes";
}

// ****************************************************************************
// Method: HistogramAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the HistogramAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
HistogramAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const HistogramAttributes *tmp = (const HistogramAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: HistogramAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the HistogramAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
HistogramAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new HistogramAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: HistogramAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the HistogramAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
HistogramAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new HistogramAttributes(*this);
    else
        retval = new HistogramAttributes;

    return retval;
}

// ****************************************************************************
// Method: HistogramAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
HistogramAttributes::SelectAll()
{
    Select(0, (void *)&specifyRange);
    Select(1, (void *)&min);
    Select(2, (void *)&max);
    Select(3, (void *)&outputType);
    Select(4, (void *)&numBins);
    Select(5, (void *)&twoDAmount);
    Select(6, (void *)&lineStyle);
    Select(7, (void *)&lineWidth);
    Select(8, (void *)&color);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: HistogramAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
HistogramAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    HistogramAttributes defaultObject;
    bool addToParent = false;
    // Create a node for HistogramAttributes.
    DataNode *node = new DataNode("HistogramAttributes");

    if(completeSave || !FieldsEqual(0, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("specifyRange", specifyRange));
    }

    if(completeSave || !FieldsEqual(1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("min", min));
    }

    if(completeSave || !FieldsEqual(2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("max", max));
    }

    if(completeSave || !FieldsEqual(3, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("outputType", OutputType_ToString(outputType)));
    }

    if(completeSave || !FieldsEqual(4, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numBins", numBins));
    }

    if(completeSave || !FieldsEqual(5, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("twoDAmount", TwoDAmount_ToString(twoDAmount)));
    }

    if(completeSave || !FieldsEqual(6, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineStyle", lineStyle));
    }

    if(completeSave || !FieldsEqual(7, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineWidth", lineWidth));
    }

        DataNode *colorNode = new DataNode("color");
        if(color.CreateNode(colorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(colorNode);
        }
        else
            delete colorNode;

    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: HistogramAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
HistogramAttributes::SetFromNode(DataNode *parentNode)
{
    int i;
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("HistogramAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("specifyRange")) != 0)
        SetSpecifyRange(node->AsBool());
    if((node = searchNode->GetNode("min")) != 0)
        SetMin(node->AsDouble());
    if((node = searchNode->GetNode("max")) != 0)
        SetMax(node->AsDouble());
    if((node = searchNode->GetNode("outputType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetOutputType(OutputType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            OutputType value;
            if(OutputType_FromString(node->AsString(), value))
                SetOutputType(value);
        }
    }
    if((node = searchNode->GetNode("numBins")) != 0)
        SetNumBins(node->AsInt());
    if((node = searchNode->GetNode("twoDAmount")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetTwoDAmount(TwoDAmount(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            TwoDAmount value;
            if(TwoDAmount_FromString(node->AsString(), value))
                SetTwoDAmount(value);
        }
    }
    if((node = searchNode->GetNode("lineStyle")) != 0)
        SetLineStyle(node->AsInt());
    if((node = searchNode->GetNode("lineWidth")) != 0)
        SetLineWidth(node->AsInt());
    if((node = searchNode->GetNode("color")) != 0)
        color.SetFromNode(node);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
HistogramAttributes::SetSpecifyRange(bool specifyRange_)
{
    specifyRange = specifyRange_;
    Select(0, (void *)&specifyRange);
}

void
HistogramAttributes::SetMin(double min_)
{
    min = min_;
    Select(1, (void *)&min);
}

void
HistogramAttributes::SetMax(double max_)
{
    max = max_;
    Select(2, (void *)&max);
}

void
HistogramAttributes::SetOutputType(HistogramAttributes::OutputType outputType_)
{
    outputType = outputType_;
    Select(3, (void *)&outputType);
}

void
HistogramAttributes::SetNumBins(int numBins_)
{
    numBins = numBins_;
    Select(4, (void *)&numBins);
}

void
HistogramAttributes::SetTwoDAmount(HistogramAttributes::TwoDAmount twoDAmount_)
{
    twoDAmount = twoDAmount_;
    Select(5, (void *)&twoDAmount);
}

void
HistogramAttributes::SetLineStyle(int lineStyle_)
{
    lineStyle = lineStyle_;
    Select(6, (void *)&lineStyle);
}

void
HistogramAttributes::SetLineWidth(int lineWidth_)
{
    lineWidth = lineWidth_;
    Select(7, (void *)&lineWidth);
}

void
HistogramAttributes::SetColor(const ColorAttribute &color_)
{
    color = color_;
    Select(8, (void *)&color);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
HistogramAttributes::GetSpecifyRange() const
{
    return specifyRange;
}

double
HistogramAttributes::GetMin() const
{
    return min;
}

double
HistogramAttributes::GetMax() const
{
    return max;
}

HistogramAttributes::OutputType
HistogramAttributes::GetOutputType() const
{
    return OutputType(outputType);
}

int
HistogramAttributes::GetNumBins() const
{
    return numBins;
}

HistogramAttributes::TwoDAmount
HistogramAttributes::GetTwoDAmount() const
{
    return TwoDAmount(twoDAmount);
}

int
HistogramAttributes::GetLineStyle() const
{
    return lineStyle;
}

int
HistogramAttributes::GetLineWidth() const
{
    return lineWidth;
}

const ColorAttribute &
HistogramAttributes::GetColor() const
{
    return color;
}

ColorAttribute &
HistogramAttributes::GetColor()
{
    return color;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
HistogramAttributes::SelectColor()
{
    Select(8, (void *)&color);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: HistogramAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
HistogramAttributes::GetFieldName(int index) const
{
    switch (index)
    {
        case 0:  return "Specify Range?";
        case 1:  return "Minimum";
        case 2:  return "Maximum";
        case 3:  return "Type of Output";
        case 4:  return "Number of Bins";
        case 5:  return "Calculate 2D based on";
        case 6:  return "Line Style";
        case 7:  return "Line Width";
        case 8:  return "Color";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: HistogramAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
HistogramAttributes::GetFieldType(int index) const
{
    switch (index)
    {
        case 0:  return FieldType_bool;
        case 1:  return FieldType_double;
        case 2:  return FieldType_double;
        case 3:  return FieldType_enum;
        case 4:  return FieldType_int;
        case 5:  return FieldType_enum;
        case 6:  return FieldType_linestyle;
        case 7:  return FieldType_linewidth;
        case 8:  return FieldType_color;
        default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: HistogramAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

std::string
HistogramAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
        case 0:  return "bool";
        case 1:  return "double";
        case 2:  return "double";
        case 3:  return "enum";
        case 4:  return "int";
        case 5:  return "enum";
        case 6:  return "linestyle";
        case 7:  return "linewidth";
        case 8:  return "color";
        default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: HistogramAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Thu Dec 18 11:51:06 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
HistogramAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const HistogramAttributes &obj = *((const HistogramAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case 0:
        {  // new scope
        retval = (specifyRange == obj.specifyRange);
        }
        break;
    case 1:
        {  // new scope
        retval = (min == obj.min);
        }
        break;
    case 2:
        {  // new scope
        retval = (max == obj.max);
        }
        break;
    case 3:
        {  // new scope
        retval = (outputType == obj.outputType);
        }
        break;
    case 4:
        {  // new scope
        retval = (numBins == obj.numBins);
        }
        break;
    case 5:
        {  // new scope
        retval = (twoDAmount == obj.twoDAmount);
        }
        break;
    case 6:
        {  // new scope
        retval = (lineStyle == obj.lineStyle);
        }
        break;
    case 7:
        {  // new scope
        retval = (lineWidth == obj.lineWidth);
        }
        break;
    case 8:
        {  // new scope
        retval = (color == obj.color);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

bool
HistogramAttributes::ChangesRequireRecalculation(const HistogramAttributes &obj) const
{
    if (specifyRange != obj.GetSpecifyRange())
        return true;
    if (specifyRange && (min != obj.GetMin()))
        return true;
    if (specifyRange && (max != obj.GetMax()))
        return true;
    if (outputType != obj.GetOutputType())
        return true;
    if (numBins != obj.GetNumBins())
        return true;
    if (twoDAmount != obj.GetTwoDAmount())
        return true;
 
    return false;
}

