#include <PyFilledBoundaryAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyFilledBoundaryAttributes
//
// Purpose: 
//   This class contains the plot attributes for the filled boundary plot.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Fri Nov 12 10:40:19 PDT 2004
//
// ****************************************************************************

//
// This struct contains the Python type information and a FilledBoundaryAttributes.
//
struct FilledBoundaryAttributesObject
{
    PyObject_HEAD
    FilledBoundaryAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewFilledBoundaryAttributes();

static PyObject *
FilledBoundaryAttributes_Notify(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
FilledBoundaryAttributes_SetColorType(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the colorType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetColorType(FilledBoundaryAttributes::ColoringMethod(ival));
    else
    {
        fprintf(stderr, "An invalid colorType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "ColorBySingleColor, ColorByMultipleColors, ColorByColorTable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
FilledBoundaryAttributes_GetColorType(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColorType()));
    return retval;
}

static PyObject *
FilledBoundaryAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
FilledBoundaryAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

static PyObject *
FilledBoundaryAttributes_SetFilledFlag(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the filledFlag in the object.
    obj->data->SetFilledFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
FilledBoundaryAttributes_GetFilledFlag(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFilledFlag()?1L:0L);
    return retval;
}

static PyObject *
FilledBoundaryAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
FilledBoundaryAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

static PyObject *
FilledBoundaryAttributes_SetLineStyle(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineStyle in the object.
    obj->data->SetLineStyle(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
FilledBoundaryAttributes_GetLineStyle(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineStyle()));
    return retval;
}

static PyObject *
FilledBoundaryAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
FilledBoundaryAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

static PyObject *
FilledBoundaryAttributes_SetSingleColor(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the singleColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetSingleColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
FilledBoundaryAttributes_GetSingleColor(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the singleColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *singleColor = obj->data->GetSingleColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(singleColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(singleColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(singleColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(singleColor[3])));
    return retval;
}

static PyObject *
FilledBoundaryAttributes_SetMultiColor(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    // NOT IMPLEMENTED!!!
    // name=multiColor, type=att

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
FilledBoundaryAttributes_GetMultiColor(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    // NOT IMPLEMENTED!!!
    // name=multiColor, type=att
    PyObject *retval = NULL;
    return retval;
}

static PyObject *
FilledBoundaryAttributes_SetBoundaryNames(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    stringVector  &vec = obj->data->GetBoundaryNames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the boundaryNames in the object as modified.
    obj->data->SelectBoundaryNames();

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
FilledBoundaryAttributes_GetBoundaryNames(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the boundaryNames.
    const stringVector &boundaryNames = obj->data->GetBoundaryNames();
    PyObject *retval = PyTuple_New(boundaryNames.size());
    for(int i = 0; i < boundaryNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(boundaryNames[i].c_str()));
    return retval;
}

static PyObject *
FilledBoundaryAttributes_SetBoundaryType(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the boundaryType in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetBoundaryType(FilledBoundaryAttributes::Boundary_Type(ival));
    else
    {
        fprintf(stderr, "An invalid boundaryType value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "Domain, Group, Material, Unknown.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
FilledBoundaryAttributes_GetBoundaryType(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetBoundaryType()));
    return retval;
}

static PyObject *
FilledBoundaryAttributes_SetOpacity(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the opacity in the object.
    obj->data->SetOpacity(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
FilledBoundaryAttributes_GetOpacity(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOpacity());
    return retval;
}

static PyObject *
FilledBoundaryAttributes_SetWireframe(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the wireframe in the object.
    obj->data->SetWireframe(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
FilledBoundaryAttributes_GetWireframe(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetWireframe()?1L:0L);
    return retval;
}

static PyObject *
FilledBoundaryAttributes_SetDrawInternal(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the drawInternal in the object.
    obj->data->SetDrawInternal(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
FilledBoundaryAttributes_GetDrawInternal(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDrawInternal()?1L:0L);
    return retval;
}

static PyObject *
FilledBoundaryAttributes_SetSmoothingLevel(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the smoothingLevel in the object.
    obj->data->SetSmoothingLevel(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
FilledBoundaryAttributes_GetSmoothingLevel(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSmoothingLevel()));
    return retval;
}

static PyObject *
FilledBoundaryAttributes_SetCleanZonesOnly(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the cleanZonesOnly in the object.
    obj->data->SetCleanZonesOnly(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
FilledBoundaryAttributes_GetCleanZonesOnly(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCleanZonesOnly()?1L:0L);
    return retval;
}

static PyObject *
FilledBoundaryAttributes_SetMixedColor(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the mixedColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetMixedColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
FilledBoundaryAttributes_GetMixedColor(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the mixedColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *mixedColor = obj->data->GetMixedColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(mixedColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(mixedColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(mixedColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(mixedColor[3])));
    return retval;
}

static PyObject *
FilledBoundaryAttributes_SetPointSize(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pointSize in the object.
    obj->data->SetPointSize(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
FilledBoundaryAttributes_GetPointSize(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPointSize());
    return retval;
}

static PyObject *
FilledBoundaryAttributes_SetPointType(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointType in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetPointType(FilledBoundaryAttributes::PointType(ival));
    else
    {
        fprintf(stderr, "An invalid pointType value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "Box, Axis, Icosahedron, Point.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
FilledBoundaryAttributes_GetPointType(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointType()));
    return retval;
}

static PyObject *
FilledBoundaryAttributes_SetPointSizeVarEnabled(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointSizeVarEnabled in the object.
    obj->data->SetPointSizeVarEnabled(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
FilledBoundaryAttributes_GetPointSizeVarEnabled(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPointSizeVarEnabled()?1L:0L);
    return retval;
}

static PyObject *
FilledBoundaryAttributes_SetPointSizeVar(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the pointSizeVar in the object.
    obj->data->SetPointSizeVar(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
FilledBoundaryAttributes_GetPointSizeVar(PyObject *self, PyObject *args)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetPointSizeVar().c_str());
    return retval;
}



static struct PyMethodDef FilledBoundaryAttributes_methods[] = {
    {"Notify", FilledBoundaryAttributes_Notify, METH_VARARGS},
    {"SetColorType", FilledBoundaryAttributes_SetColorType, METH_VARARGS},
    {"GetColorType", FilledBoundaryAttributes_GetColorType, METH_VARARGS},
    {"SetColorTableName", FilledBoundaryAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", FilledBoundaryAttributes_GetColorTableName, METH_VARARGS},
    {"SetFilledFlag", FilledBoundaryAttributes_SetFilledFlag, METH_VARARGS},
    {"GetFilledFlag", FilledBoundaryAttributes_GetFilledFlag, METH_VARARGS},
    {"SetLegendFlag", FilledBoundaryAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", FilledBoundaryAttributes_GetLegendFlag, METH_VARARGS},
    {"SetLineStyle", FilledBoundaryAttributes_SetLineStyle, METH_VARARGS},
    {"GetLineStyle", FilledBoundaryAttributes_GetLineStyle, METH_VARARGS},
    {"SetLineWidth", FilledBoundaryAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", FilledBoundaryAttributes_GetLineWidth, METH_VARARGS},
    {"SetSingleColor", FilledBoundaryAttributes_SetSingleColor, METH_VARARGS},
    {"GetSingleColor", FilledBoundaryAttributes_GetSingleColor, METH_VARARGS},
    {"SetMultiColor", FilledBoundaryAttributes_SetMultiColor, METH_VARARGS},
    {"GetMultiColor", FilledBoundaryAttributes_GetMultiColor, METH_VARARGS},
    {"SetBoundaryNames", FilledBoundaryAttributes_SetBoundaryNames, METH_VARARGS},
    {"GetBoundaryNames", FilledBoundaryAttributes_GetBoundaryNames, METH_VARARGS},
    {"SetBoundaryType", FilledBoundaryAttributes_SetBoundaryType, METH_VARARGS},
    {"GetBoundaryType", FilledBoundaryAttributes_GetBoundaryType, METH_VARARGS},
    {"SetOpacity", FilledBoundaryAttributes_SetOpacity, METH_VARARGS},
    {"GetOpacity", FilledBoundaryAttributes_GetOpacity, METH_VARARGS},
    {"SetWireframe", FilledBoundaryAttributes_SetWireframe, METH_VARARGS},
    {"GetWireframe", FilledBoundaryAttributes_GetWireframe, METH_VARARGS},
    {"SetDrawInternal", FilledBoundaryAttributes_SetDrawInternal, METH_VARARGS},
    {"GetDrawInternal", FilledBoundaryAttributes_GetDrawInternal, METH_VARARGS},
    {"SetSmoothingLevel", FilledBoundaryAttributes_SetSmoothingLevel, METH_VARARGS},
    {"GetSmoothingLevel", FilledBoundaryAttributes_GetSmoothingLevel, METH_VARARGS},
    {"SetCleanZonesOnly", FilledBoundaryAttributes_SetCleanZonesOnly, METH_VARARGS},
    {"GetCleanZonesOnly", FilledBoundaryAttributes_GetCleanZonesOnly, METH_VARARGS},
    {"SetMixedColor", FilledBoundaryAttributes_SetMixedColor, METH_VARARGS},
    {"GetMixedColor", FilledBoundaryAttributes_GetMixedColor, METH_VARARGS},
    {"SetPointSize", FilledBoundaryAttributes_SetPointSize, METH_VARARGS},
    {"GetPointSize", FilledBoundaryAttributes_GetPointSize, METH_VARARGS},
    {"SetPointType", FilledBoundaryAttributes_SetPointType, METH_VARARGS},
    {"GetPointType", FilledBoundaryAttributes_GetPointType, METH_VARARGS},
    {"SetPointSizeVarEnabled", FilledBoundaryAttributes_SetPointSizeVarEnabled, METH_VARARGS},
    {"GetPointSizeVarEnabled", FilledBoundaryAttributes_GetPointSizeVarEnabled, METH_VARARGS},
    {"SetPointSizeVar", FilledBoundaryAttributes_SetPointSizeVar, METH_VARARGS},
    {"GetPointSizeVar", FilledBoundaryAttributes_GetPointSizeVar, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
FilledBoundaryAttributes_dealloc(PyObject *v)
{
   FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
FilledBoundaryAttributes_compare(PyObject *v, PyObject *w)
{
    FilledBoundaryAttributes *a = ((FilledBoundaryAttributesObject *)v)->data;
    FilledBoundaryAttributes *b = ((FilledBoundaryAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
FilledBoundaryAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "colorType") == 0)
        return FilledBoundaryAttributes_GetColorType(self, NULL);
    if(strcmp(name, "ColorBySingleColor") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::ColorBySingleColor));
    else if(strcmp(name, "ColorByMultipleColors") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::ColorByMultipleColors));
    else if(strcmp(name, "ColorByColorTable") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::ColorByColorTable));

    if(strcmp(name, "colorTableName") == 0)
        return FilledBoundaryAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "filledFlag") == 0)
        return FilledBoundaryAttributes_GetFilledFlag(self, NULL);
    if(strcmp(name, "legendFlag") == 0)
        return FilledBoundaryAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "lineStyle") == 0)
        return FilledBoundaryAttributes_GetLineStyle(self, NULL);
    if(strcmp(name, "lineWidth") == 0)
        return FilledBoundaryAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "singleColor") == 0)
        return FilledBoundaryAttributes_GetSingleColor(self, NULL);
    if(strcmp(name, "boundaryNames") == 0)
        return FilledBoundaryAttributes_GetBoundaryNames(self, NULL);
    if(strcmp(name, "boundaryType") == 0)
        return FilledBoundaryAttributes_GetBoundaryType(self, NULL);
    if(strcmp(name, "Domain") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::Domain));
    else if(strcmp(name, "Group") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::Group));
    else if(strcmp(name, "Material") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::Material));
    else if(strcmp(name, "Unknown") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::Unknown));

    if(strcmp(name, "opacity") == 0)
        return FilledBoundaryAttributes_GetOpacity(self, NULL);
    if(strcmp(name, "wireframe") == 0)
        return FilledBoundaryAttributes_GetWireframe(self, NULL);
    if(strcmp(name, "drawInternal") == 0)
        return FilledBoundaryAttributes_GetDrawInternal(self, NULL);
    if(strcmp(name, "smoothingLevel") == 0)
        return FilledBoundaryAttributes_GetSmoothingLevel(self, NULL);
    if(strcmp(name, "cleanZonesOnly") == 0)
        return FilledBoundaryAttributes_GetCleanZonesOnly(self, NULL);
    if(strcmp(name, "mixedColor") == 0)
        return FilledBoundaryAttributes_GetMixedColor(self, NULL);
    if(strcmp(name, "pointSize") == 0)
        return FilledBoundaryAttributes_GetPointSize(self, NULL);
    if(strcmp(name, "pointType") == 0)
        return FilledBoundaryAttributes_GetPointType(self, NULL);
    if(strcmp(name, "Box") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::Box));
    else if(strcmp(name, "Axis") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::Axis));
    else if(strcmp(name, "Icosahedron") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::Icosahedron));
    else if(strcmp(name, "Point") == 0)
        return PyInt_FromLong(long(FilledBoundaryAttributes::Point));

    if(strcmp(name, "pointSizeVarEnabled") == 0)
        return FilledBoundaryAttributes_GetPointSizeVarEnabled(self, NULL);
    if(strcmp(name, "pointSizeVar") == 0)
        return FilledBoundaryAttributes_GetPointSizeVar(self, NULL);

    return Py_FindMethod(FilledBoundaryAttributes_methods, self, name);
}

static int
FilledBoundaryAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "colorType") == 0)
        retval = (FilledBoundaryAttributes_SetColorType(self, tuple) != NULL);
    else if(strcmp(name, "colorTableName") == 0)
        retval = (FilledBoundaryAttributes_SetColorTableName(self, tuple) != NULL);
    else if(strcmp(name, "filledFlag") == 0)
        retval = (FilledBoundaryAttributes_SetFilledFlag(self, tuple) != NULL);
    else if(strcmp(name, "legendFlag") == 0)
        retval = (FilledBoundaryAttributes_SetLegendFlag(self, tuple) != NULL);
    else if(strcmp(name, "lineStyle") == 0)
        retval = (FilledBoundaryAttributes_SetLineStyle(self, tuple) != NULL);
    else if(strcmp(name, "lineWidth") == 0)
        retval = (FilledBoundaryAttributes_SetLineWidth(self, tuple) != NULL);
    else if(strcmp(name, "singleColor") == 0)
        retval = (FilledBoundaryAttributes_SetSingleColor(self, tuple) != NULL);
    else if(strcmp(name, "boundaryNames") == 0)
        retval = (FilledBoundaryAttributes_SetBoundaryNames(self, tuple) != NULL);
    else if(strcmp(name, "boundaryType") == 0)
        retval = (FilledBoundaryAttributes_SetBoundaryType(self, tuple) != NULL);
    else if(strcmp(name, "opacity") == 0)
        retval = (FilledBoundaryAttributes_SetOpacity(self, tuple) != NULL);
    else if(strcmp(name, "wireframe") == 0)
        retval = (FilledBoundaryAttributes_SetWireframe(self, tuple) != NULL);
    else if(strcmp(name, "drawInternal") == 0)
        retval = (FilledBoundaryAttributes_SetDrawInternal(self, tuple) != NULL);
    else if(strcmp(name, "smoothingLevel") == 0)
        retval = (FilledBoundaryAttributes_SetSmoothingLevel(self, tuple) != NULL);
    else if(strcmp(name, "cleanZonesOnly") == 0)
        retval = (FilledBoundaryAttributes_SetCleanZonesOnly(self, tuple) != NULL);
    else if(strcmp(name, "mixedColor") == 0)
        retval = (FilledBoundaryAttributes_SetMixedColor(self, tuple) != NULL);
    else if(strcmp(name, "pointSize") == 0)
        retval = (FilledBoundaryAttributes_SetPointSize(self, tuple) != NULL);
    else if(strcmp(name, "pointType") == 0)
        retval = (FilledBoundaryAttributes_SetPointType(self, tuple) != NULL);
    else if(strcmp(name, "pointSizeVarEnabled") == 0)
        retval = (FilledBoundaryAttributes_SetPointSizeVarEnabled(self, tuple) != NULL);
    else if(strcmp(name, "pointSizeVar") == 0)
        retval = (FilledBoundaryAttributes_SetPointSizeVar(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
FilledBoundaryAttributes_print(PyObject *v, FILE *fp, int flags)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)v;

    const char *colorType_names = "ColorBySingleColor, ColorByMultipleColors, ColorByColorTable";
    if(obj->data->GetColorType() == FilledBoundaryAttributes::ColorBySingleColor)
        fprintf(fp, "colorType = ColorBySingleColor  # %s\n", colorType_names);
    else if(obj->data->GetColorType() == FilledBoundaryAttributes::ColorByMultipleColors)
        fprintf(fp, "colorType = ColorByMultipleColors  # %s\n", colorType_names);
    else
        fprintf(fp, "colorType = ColorByColorTable  # %s\n", colorType_names);

    fprintf(fp, "colorTableName = %s\n", obj->data->GetColorTableName().c_str());
    if(obj->data->GetFilledFlag())
        fprintf(fp, "filledFlag = 1\n");
    else
        fprintf(fp, "filledFlag = 0\n");
    if(obj->data->GetLegendFlag())
        fprintf(fp, "legendFlag = 1\n");
    else
        fprintf(fp, "legendFlag = 0\n");
    fprintf(fp, "lineStyle = %d\n", obj->data->GetLineStyle());
    fprintf(fp, "lineWidth = %d\n", obj->data->GetLineWidth());
    const unsigned char *singleColor = obj->data->GetSingleColor().GetColor();
    fprintf(fp, "singleColor = (%d, %d, %d, %d)\n", int(singleColor[0]), int(singleColor[1]), int(singleColor[2]), int(singleColor[3]));
    //multiColor
    {   const stringVector &boundaryNames = obj->data->GetBoundaryNames();
        fprintf(fp, "boundaryNames = (");
        for(int i = 0; i < boundaryNames.size(); ++i)
        {
            fprintf(fp, "\"%s\"", boundaryNames[i].c_str());
            if(i < boundaryNames.size() - 1)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }
    const char *boundaryType_names = "Domain, Group, Material, Unknown";
    if(obj->data->GetBoundaryType() == FilledBoundaryAttributes::Domain)
        fprintf(fp, "boundaryType = Domain  # %s\n", boundaryType_names);
    else if(obj->data->GetBoundaryType() == FilledBoundaryAttributes::Group)
        fprintf(fp, "boundaryType = Group  # %s\n", boundaryType_names);
    else if(obj->data->GetBoundaryType() == FilledBoundaryAttributes::Material)
        fprintf(fp, "boundaryType = Material  # %s\n", boundaryType_names);
    else
        fprintf(fp, "boundaryType = Unknown  # %s\n", boundaryType_names);

    fprintf(fp, "opacity = %g\n", obj->data->GetOpacity());
    if(obj->data->GetWireframe())
        fprintf(fp, "wireframe = 1\n");
    else
        fprintf(fp, "wireframe = 0\n");
    if(obj->data->GetDrawInternal())
        fprintf(fp, "drawInternal = 1\n");
    else
        fprintf(fp, "drawInternal = 0\n");
    fprintf(fp, "smoothingLevel = %d\n", obj->data->GetSmoothingLevel());
    if(obj->data->GetCleanZonesOnly())
        fprintf(fp, "cleanZonesOnly = 1\n");
    else
        fprintf(fp, "cleanZonesOnly = 0\n");
    const unsigned char *mixedColor = obj->data->GetMixedColor().GetColor();
    fprintf(fp, "mixedColor = (%d, %d, %d, %d)\n", int(mixedColor[0]), int(mixedColor[1]), int(mixedColor[2]), int(mixedColor[3]));
    fprintf(fp, "pointSize = %g\n", obj->data->GetPointSize());
    const char *pointType_names = "Box, Axis, Icosahedron, Point";
    if(obj->data->GetPointType() == FilledBoundaryAttributes::Box)
        fprintf(fp, "pointType = Box  # %s\n", pointType_names);
    else if(obj->data->GetPointType() == FilledBoundaryAttributes::Axis)
        fprintf(fp, "pointType = Axis  # %s\n", pointType_names);
    else if(obj->data->GetPointType() == FilledBoundaryAttributes::Icosahedron)
        fprintf(fp, "pointType = Icosahedron  # %s\n", pointType_names);
    else
        fprintf(fp, "pointType = Point  # %s\n", pointType_names);

    if(obj->data->GetPointSizeVarEnabled())
        fprintf(fp, "pointSizeVarEnabled = 1\n");
    else
        fprintf(fp, "pointSizeVarEnabled = 0\n");
    fprintf(fp, "pointSizeVar = \"%s\"\n", obj->data->GetPointSizeVar().c_str());

    return 0;
}

#include <snprintf.h>
PyObject *
PyFilledBoundaryAttributes_StringRepresentation(const FilledBoundaryAttributes *atts)
{
   std::string str; 
   char tmpStr[1000]; 

    const char *colorType_names = "ColorBySingleColor, ColorByMultipleColors, ColorByColorTable";
    if(atts->GetColorType() == FilledBoundaryAttributes::ColorBySingleColor)
        {
             SNPRINTF(tmpStr, 1000, "colorType = ColorBySingleColor  # %s\n", colorType_names);
             str += tmpStr;
        }
    else if(atts->GetColorType() == FilledBoundaryAttributes::ColorByMultipleColors)
        {
             SNPRINTF(tmpStr, 1000, "colorType = ColorByMultipleColors  # %s\n", colorType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "colorType = ColorByColorTable  # %s\n", colorType_names);
             str += tmpStr;
        }

   SNPRINTF(tmpStr, 1000, "colorTableName = %s\n", atts->GetColorTableName().c_str());
   str += tmpStr;
    if(atts->GetFilledFlag())
        SNPRINTF(tmpStr, 1000, "filledFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "filledFlag = 0\n");
    str += tmpStr;
    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "legendFlag = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "legendFlag = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "lineStyle = %d\n", atts->GetLineStyle());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "lineWidth = %d\n", atts->GetLineWidth());
    str += tmpStr;
    const unsigned char *singleColor = atts->GetSingleColor().GetColor();
    SNPRINTF(tmpStr, 1000, "singleColor = (%d, %d, %d, %d)\n", int(singleColor[0]), int(singleColor[1]), int(singleColor[2]), int(singleColor[3]));
    str += tmpStr;
#if 0
    { // new scope
         PyObject *s = PyColorAttributeList_StringRepresentation(atts->GetMultiColor());
         str += "multiColor = {"
         if(obj != 0) str += PyString_AS_STRING(s);
         str += "}"
    }
#endif
    {   const stringVector &boundaryNames = atts->GetBoundaryNames();
        SNPRINTF(tmpStr, 1000, "boundaryNames = (");
        str += tmpStr;
        for(int i = 0; i < boundaryNames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", boundaryNames[i].c_str());
            str += tmpStr;
            if(i < boundaryNames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *boundaryType_names = "Domain, Group, Material, Unknown";
    if(atts->GetBoundaryType() == FilledBoundaryAttributes::Domain)
        {
             SNPRINTF(tmpStr, 1000, "boundaryType = Domain  # %s\n", boundaryType_names);
             str += tmpStr;
        }
    else if(atts->GetBoundaryType() == FilledBoundaryAttributes::Group)
        {
             SNPRINTF(tmpStr, 1000, "boundaryType = Group  # %s\n", boundaryType_names);
             str += tmpStr;
        }
    else if(atts->GetBoundaryType() == FilledBoundaryAttributes::Material)
        {
             SNPRINTF(tmpStr, 1000, "boundaryType = Material  # %s\n", boundaryType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "boundaryType = Unknown  # %s\n", boundaryType_names);
             str += tmpStr;
        }

    SNPRINTF(tmpStr, 1000, "opacity = %g\n", atts->GetOpacity());
    str += tmpStr;
    if(atts->GetWireframe())
        SNPRINTF(tmpStr, 1000, "wireframe = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "wireframe = 0\n");
    str += tmpStr;
    if(atts->GetDrawInternal())
        SNPRINTF(tmpStr, 1000, "drawInternal = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "drawInternal = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "smoothingLevel = %d\n", atts->GetSmoothingLevel());
    str += tmpStr;
    if(atts->GetCleanZonesOnly())
        SNPRINTF(tmpStr, 1000, "cleanZonesOnly = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "cleanZonesOnly = 0\n");
    str += tmpStr;
    const unsigned char *mixedColor = atts->GetMixedColor().GetColor();
    SNPRINTF(tmpStr, 1000, "mixedColor = (%d, %d, %d, %d)\n", int(mixedColor[0]), int(mixedColor[1]), int(mixedColor[2]), int(mixedColor[3]));
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "pointSize = %g\n", atts->GetPointSize());
    str += tmpStr;
    const char *pointType_names = "Box, Axis, Icosahedron, Point";
    if(atts->GetPointType() == FilledBoundaryAttributes::Box)
        {
             SNPRINTF(tmpStr, 1000, "pointType = Box  # %s\n", pointType_names);
             str += tmpStr;
        }
    else if(atts->GetPointType() == FilledBoundaryAttributes::Axis)
        {
             SNPRINTF(tmpStr, 1000, "pointType = Axis  # %s\n", pointType_names);
             str += tmpStr;
        }
    else if(atts->GetPointType() == FilledBoundaryAttributes::Icosahedron)
        {
             SNPRINTF(tmpStr, 1000, "pointType = Icosahedron  # %s\n", pointType_names);
             str += tmpStr;
        }
    else
        {
             SNPRINTF(tmpStr, 1000, "pointType = Point  # %s\n", pointType_names);
             str += tmpStr;
        }

    if(atts->GetPointSizeVarEnabled())
        SNPRINTF(tmpStr, 1000, "pointSizeVarEnabled = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "pointSizeVarEnabled = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "pointSizeVar = \"%s\"\n", atts->GetPointSizeVar().c_str());
    str += tmpStr;
    return PyString_FromString(str.c_str());
}

static PyObject *
FilledBoundaryAttributes_str(PyObject *v)
{
    FilledBoundaryAttributesObject *obj = (FilledBoundaryAttributesObject *)v;
    return PyFilledBoundaryAttributes_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
static char *FilledBoundaryAttributes_Purpose = "This class contains the plot attributes for the filled boundary plot.";

//
// The type description structure
//
static PyTypeObject FilledBoundaryAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "FilledBoundaryAttributes",                    // tp_name
    sizeof(FilledBoundaryAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)FilledBoundaryAttributes_dealloc,  // tp_dealloc
    (printfunc)FilledBoundaryAttributes_print,     // tp_print
    (getattrfunc)FilledBoundaryAttributes_getattr, // tp_getattr
    (setattrfunc)FilledBoundaryAttributes_setattr, // tp_setattr
    (cmpfunc)FilledBoundaryAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)FilledBoundaryAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    FilledBoundaryAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static FilledBoundaryAttributes *defaultAtts = 0;

static PyObject *
NewFilledBoundaryAttributes()
{
    FilledBoundaryAttributesObject *newObject;
    newObject = PyObject_NEW(FilledBoundaryAttributesObject, &FilledBoundaryAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new FilledBoundaryAttributes(*defaultAtts);
    else
        newObject->data = new FilledBoundaryAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapFilledBoundaryAttributes(const FilledBoundaryAttributes *attr)
{
    FilledBoundaryAttributesObject *newObject;
    newObject = PyObject_NEW(FilledBoundaryAttributesObject, &FilledBoundaryAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (FilledBoundaryAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
FilledBoundaryAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewFilledBoundaryAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef FilledBoundaryAttributesMethods[] = {
    {"FilledBoundaryAttributes", FilledBoundaryAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *FilledBoundaryAttributesObserver = 0;
static bool FilledBoundaryAttributesEnableLogging = true;

static void
PyFilledBoundaryAttributes_WriteLog(Subject *subj, void *data)
{
    FilledBoundaryAttributes *atts = (FilledBoundaryAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!FilledBoundaryAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# FilledBoundaryAttributes_WriteLog()\n");
}

void
PyFilledBoundaryAttributes_StartUp(FilledBoundaryAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyFilledBoundaryAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(FilledBoundaryAttributesObserver == 0)
    {
        FilledBoundaryAttributesObserver = new ObserverToCallback(subj,
            PyFilledBoundaryAttributes_WriteLog, (void *)logFile);
    }

    FilledBoundaryAttributesEnableLogging = true;
}

void
PyFilledBoundaryAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete FilledBoundaryAttributesObserver;
    FilledBoundaryAttributesObserver = 0;
}

PyMethodDef *
PyFilledBoundaryAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return FilledBoundaryAttributesMethods;
}

bool
PyFilledBoundaryAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &FilledBoundaryAttributesType);
}

FilledBoundaryAttributes *
PyFilledBoundaryAttributes_FromPyObject(PyObject *obj)
{
    FilledBoundaryAttributesObject *obj2 = (FilledBoundaryAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyFilledBoundaryAttributes_NewPyObject()
{
    return NewFilledBoundaryAttributes();
}

PyObject *
PyFilledBoundaryAttributes_WrapPyObject(const FilledBoundaryAttributes *attr)
{
    return WrapFilledBoundaryAttributes(attr);
}

void
PyFilledBoundaryAttributes_SetLogging(bool val)
{
    FilledBoundaryAttributesEnableLogging = val;
}

// ****************************************************************************
//  Modifications:
//    Kathleen Bonnell, Fri Jul 18 13:49:42 PDT 2003
//    Make defaultAtts point to the passed atts directly.
//
// ****************************************************************************
void
PyFilledBoundaryAttributes_SetDefaults(const FilledBoundaryAttributes *atts)
{
    defaultAtts = const_cast<FilledBoundaryAttributes*>(atts);
}
