// ************************************************************************* //
//                        FilledBoundaryScriptingPluginInfo.C
// ************************************************************************* //
#include <FilledBoundaryPluginInfo.h>
#include <PyFilledBoundaryAttributes.h>

#if defined(__APPLE__)
#define GetScriptingInfo FilledBoundary_GetScriptingInfo
#endif

// ****************************************************************************
//  Function:  GetScriptingInfo
//
//  Purpose:
//    Return a new ScriptingPluginInfo for the FilledBoundary plot.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri May 9 11:20:53 PDT 2003
//
// ****************************************************************************
extern "C" ScriptingPlotPluginInfo* GetScriptingInfo()
{
    return new FilledBoundaryScriptingPluginInfo;
}

// ****************************************************************************
// Method: FilledBoundaryScriptingPluginInfo::InitializePlugin
//
// Purpose: 
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   logFile : A pointer to the logFile to be used.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri May 9 11:20:53 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
FilledBoundaryScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    FILE *logFile)
{
    PyFilledBoundaryAttributes_StartUp((FilledBoundaryAttributes *)subj, logFile);
}

// ****************************************************************************
// Method: FilledBoundaryScriptingPluginInfo::GetMethodTable
//
// Purpose: 
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri May 9 11:20:53 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void *
FilledBoundaryScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyFilledBoundaryAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: FilledBoundaryScriptingPluginInfo::TypesMatch
//
// Purpose: 
//   Returns whether or not the input PyObject is FilledBoundary plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri May 9 11:20:53 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

bool
FilledBoundaryScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyFilledBoundaryAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: FilledBoundaryScriptingPluginInfo::SetLogging
//
// Purpose: 
//   Used to turn logging of commands on and off.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri May 9 11:20:53 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
FilledBoundaryScriptingPluginInfo::SetLogging(bool val)
{
    PyFilledBoundaryAttributes_SetLogging(val);
}

// ****************************************************************************
// Method: FilledBoundaryScriptingPluginInfo::SetDefaults
//
// Purpose: 
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Fri May 9 11:20:53 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

void
FilledBoundaryScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyFilledBoundaryAttributes_SetDefaults((const FilledBoundaryAttributes *)atts);
}
