// ************************************************************************* //
//  File: FilledBoundaryGUIPluginInfo.C
// ************************************************************************* //

#include <FilledBoundaryPluginInfo.h>
#include <FilledBoundaryAttributes.h>
#include <QvisFilledBoundaryPlotWindow.h>

#if defined(__APPLE__)
#define GetGUIInfo FilledBoundary_GetGUIInfo
#endif

// ****************************************************************************
//  Function:  GetGUIInfo
//
//  Purpose:
//    Return a new GUIPluginInfo for the FilledBoundary plot.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Mon Jun 21 15:18:19 PST 2004
//
// ****************************************************************************
extern "C" GUIPlotPluginInfo* GetGUIInfo()
{
    return new FilledBoundaryGUIPluginInfo;
}

// ****************************************************************************
//  Method: FilledBoundaryGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Mon Jun 21 15:18:19 PST 2004
//
// ****************************************************************************

const char *
FilledBoundaryGUIPluginInfo::GetMenuName() const
{
    return "Filled Boundary";
}


// ****************************************************************************
// Method: FilledBoundaryGUIPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Mon Jun 21 15:18:19 PST 2004
//
// Modifications:
//   
// ****************************************************************************

int
FilledBoundaryGUIPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_MATERIAL;
}

// ****************************************************************************
//  Method: FilledBoundaryGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Mon Jun 21 15:18:19 PST 2004
//
// ****************************************************************************

QvisPostableWindowObserver *
FilledBoundaryGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    QvisNotepadArea *notepad)
{
    return new QvisFilledBoundaryPlotWindow(type, (FilledBoundaryAttributes *)attr,
        "FilledBoundary plot attributes", "FilledBoundary plot", notepad);
}

// ****************************************************************************
//  Method: FilledBoundaryGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Mon Jun 21 15:18:19 PST 2004
//
// ****************************************************************************

#include <FilledBoundary.xpm>
const char **
FilledBoundaryGUIPluginInfo::XPMIconData() const
{
    return FilledBoundary_xpm;
}
