// ************************************************************************* //
//                                 avtCurvePlot.h                             //
// ************************************************************************* //

#ifndef AVT_CURVE_PLOT_H
#define AVT_CURVE_PLOT_H


#include <avtLegend.h>
#include <avtPlot.h>
#include <avtSurfaceAndWireframeRenderer.h>

#include <CurveAttributes.h>

class     avtCurveFilter;
class     avtUserDefinedMapper;
class     avtLabeledCurveMapper;
class     vtkProperty;


// ****************************************************************************
//  Class:  avtCurvePlot
//
//  Purpose:
//      A concrete type of avtPlot, this is the Curve plot.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Sat Apr 20 13:01:58 PST 2002
//
//  Modifications:
//    Kathleen Bonnell, Fri Jul 12 16:53:11 PDT 2002 
//    Added labeled curve mapper.
//
//    Kathleen Bonnell, Tue Oct 22 08:33:26 PDT 2002
//    Added ApplyRenderingTransformation. 
//    
// ****************************************************************************


class avtCurvePlot : public avtLineDataPlot
{
  public:
                                avtCurvePlot();
    virtual                    ~avtCurvePlot();

    virtual const char         *GetName(void) { return "CurvePlot"; };
    virtual void                ReleaseData(void);

    static avtPlot             *Create();

    virtual void                SetAtts(const AttributeGroup*);
    void                        SetLineWidth(int);
    void                        SetLineStyle(int);

  protected:
    CurveAttributes                atts;

    avtSurfaceAndWireframeRenderer_p renderer;
    avtUserDefinedMapper           *mapper;
    avtLabeledCurveMapper          *decoMapper;
    vtkProperty                    *property;

    avtCurveFilter                *CurveFilter;

    virtual avtMapper          *GetMapper(void);
    virtual avtDataObject_p     ApplyOperators(avtDataObject_p);
    virtual avtDataObject_p     ApplyRenderingTransformation(avtDataObject_p);
    virtual void                CustomizeBehavior(void);

    virtual avtLegend_p         GetLegend(void) { return NULL; };
    virtual avtDecorationsMapper *GetDecorationsMapper(void); 
};

#endif


