// ************************************************************************* //
//                             avtCurvePlot.C                                 //
// ************************************************************************* //

#include <avtCurvePlot.h>

#include <avtCurveFilter.h>
#include <avtCompactTreeFilter.h>
#include <avtSurfaceAndWireframeRenderer.h>                                                          
#include <LineAttributes.h>

#include <avtUserDefinedMapper.h>
#include <avtLabeledCurveMapper.h>
#include <vtkProperty.h>

// ****************************************************************************
//  Method: avtCurvePlot constructor
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Sat Apr 20 13:01:58 PST 2002
//
//  Modifications:
//
//    Hank Childs, Wed May 22 15:52:30 PDT 2002
//    Use a reference counted mapper to avoid problems when the plot has been
//    deleted but the actor is still part of a network.
//
//    Kathleen Bonnell, Fri Jul 12 16:53:11 PDT 2002  
//    Add a labeled curve mapper for decorations.  
//    
// ****************************************************************************

avtCurvePlot::avtCurvePlot()
{
    CurveFilter = new avtCurveFilter();
    renderer = avtSurfaceAndWireframeRenderer::New();
    avtCustomRenderer_p ren;
    CopyTo(ren, renderer);
    mapper = new avtUserDefinedMapper(ren);
 
    property = vtkProperty::New();
    property->SetAmbient(0.0);
    property->SetDiffuse(1.0);

    renderer->ScalarVisibilityOff();
    renderer->ResolveTopologyOff();

    renderer->SurfaceVertsOff();
    renderer->SurfaceLinesOn();
    renderer->SurfaceStripsOff();
    renderer->SurfacePolysOn();

    renderer->EdgeLinesOff();
    renderer->EdgeStripsOff();
    renderer->EdgePolysOff();

    decoMapper = new avtLabeledCurveMapper();
}


// ****************************************************************************
//  Method: avtCurvePlot destructor
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Sat Apr 20 13:01:58 PST 2002
//
//  Modifications:
//
//    Hank Childs, Wed May 22 15:52:30 PDT 2002
//    Do not delete the renderer since it is now reference counted.
//
//    Kathleen Bonnell, Fri Jul 12 16:53:11 PDT 2002  
//    Delete the decorations mapper. 
//    
// ****************************************************************************

avtCurvePlot::~avtCurvePlot()
{
    if (property != NULL)
    {
        property->Delete();
        property = NULL;
    }
    if (mapper != NULL)
    {
        delete mapper;
        mapper = NULL;
    }
    if (CurveFilter != NULL)
    {
        delete CurveFilter;
        CurveFilter = NULL;
    }
    if (decoMapper != NULL)
    {
        delete decoMapper;
        decoMapper = NULL;
    }
}


// ****************************************************************************
//  Method:  avtCurvePlot::Create
//
//  Purpose:
//    Call the constructor.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Sat Apr 20 13:01:58 PST 2002
//
// ****************************************************************************

avtPlot*
avtCurvePlot::Create()
{
    return new avtCurvePlot;
}


// ****************************************************************************
//  Method: avtCurvePlot::GetMapper
//
//  Purpose:
//      Gets a mapper for this plot, it is actually a variable mapper.
//
//  Returns:    The variable mapper typed as its base class mapper.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Sat Apr 20 13:01:58 PST 2002
//
// ****************************************************************************

avtMapper *
avtCurvePlot::GetMapper(void)
{
    return mapper;
}


// ****************************************************************************
//  Method: avtCurvePlot::GetDecorationsMapper
//
//  Purpose:
//      Gets a decorations mapper for this plot, in this case the
//      labeled curve mapper. 
//
//  Returns:    The labeled curve mapper typed as its base class mapper.
//
//  Programmer: Kathleen Bonnell 
//  Creation:   July 12, 2002 
//
// ****************************************************************************

avtDecorationsMapper *
avtCurvePlot::GetDecorationsMapper(void)
{
    return decoMapper;
}

// ****************************************************************************
//  Method: avtCurvePlot::ApplyOperators
//
//  Purpose:
//      Applies the operators associated with a Curve plot.  
//
//  Arguments:
//      input   The input data object.
//
//  Returns:    The data object after the Curve plot has been applied.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Sat Apr 20 13:01:58 PST 2002
//
//  Modifications:
//
//    Hank Childs, Fri Oct  3 11:27:49 PDT 2003
//    No longer set attributes with curve filter.
//
// ****************************************************************************

avtDataObject_p
avtCurvePlot::ApplyOperators(avtDataObject_p input)
{
    CurveFilter->SetInput(input);
    return CurveFilter->GetOutput();
}


// ****************************************************************************
//  Method: avtCurvePlot::ApplyRenderingTransformation
//
//  Purpose:
//      Applies the rendering transformation associated with a Curve plot.  
//      Nothing for now.
//
//  Arguments:
//      input   The input data object.
//
//  Returns:    The input data object. 
//
//  Programmer: Kathleen Bonnell 
//  Creation:   October 22, 2002 
//
// ****************************************************************************

avtDataObject_p
avtCurvePlot::ApplyRenderingTransformation(avtDataObject_p input)
{
    return input;
}



// ****************************************************************************
//  Method: avtCurvePlot::CustomizeBehavior
//
//  Purpose:
//      Customizes the behavior as appropriate for a Curve plot.  This includes
//      behavior like shifting towards or away from the screen.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Sat Apr 20 13:01:58 PST 2002
//
//  Modifications:
//    Eric Brugger, Wed Aug 20 10:23:51 PDT 2003
//    I added code to set the window mode to curve.
//
// ****************************************************************************

void
avtCurvePlot::CustomizeBehavior(void)
{
    behavior->GetInfo().GetAttributes().SetWindowMode(WINMODE_CURVE);

    renderer->SetProperty(property);            
}


// ****************************************************************************
//  Method: avtCurvePlot::SetAtts
//
//  Purpose:
//      Sets the atts for the Curve plot.
//
//  Arguments:
//      atts    The attributes for this Curve plot.
//
//  Programmer: kbonnell -- generated by xml2info
//  Creation:   Sat Apr 20 13:01:58 PST 2002
//
//  Modifications:
//    Kathleen Bonnell, Fri Jul 12 18:42:11 PDT 2002 
//    Set attributes for the decorations mapper.
//
//    Kathleen Bonnell, Tue Jul 23 14:12:47 PDT 2002       
//    LabelSize no longer an attribute. 
//
//    Kathleen Bonnell, Tue Dec 23 11:08:38 PST 2003 
//    Added ShowPoints and PointSize. 
//
// ****************************************************************************

void
avtCurvePlot::SetAtts(const AttributeGroup *a)
{
    needsRecalculation =
        atts.ChangesRequireRecalculation(*(const CurveAttributes*)a);
    atts = *(const CurveAttributes*)a;

    double rgba[4];
    atts.GetColor().GetRgba(rgba);
    property->SetColor((float)rgba[0], (float)rgba[1], (float)rgba[2]);

    SetLineWidth(atts.GetLineWidth());
    SetLineStyle(atts.GetLineStyle());

    decoMapper->SetLabel(atts.GetDesignator());
    decoMapper->SetLabelColor((float)rgba[0], (float)rgba[1], (float)rgba[2]);
    decoMapper->SetLabelVisibility(atts.GetShowLabels());

    if (atts.GetShowPoints())
        renderer->SurfaceVertsOn();
    else 
        renderer->SurfaceVertsOff();
    
    property->SetPointSize(atts.GetPointSize()); 
}

// ****************************************************************************
//  Method: avtCurvePlot::SetLineWidth
//
//  Purpose:
//      Sets the line width.
//
//  Programmer: Kathleen Bonnell
//  Creation:   April 24, 2002 
//
// ****************************************************************************
 
void
avtCurvePlot::SetLineWidth(int lw)
{
    property->SetLineWidth(LineWidth2Int(Int2LineWidth(lw)));
}
 
 
// ****************************************************************************
//  Method: avtCurvePlot::SetLineStyle
//
//  Purpose:
//      Sets the line style.
//
//  Programmer: Kathleen Bonnell
//  Creation:   April 24, 2002 
//
// ****************************************************************************
 
void
avtCurvePlot::SetLineStyle(int ls)
{
    property->SetLineStipplePattern(LineStyle2StipplePattern(Int2LineStyle(ls)));
}


// ****************************************************************************
//  Method: avtCurvePlot::ReleaseData
//
//  Purpose:
//      Release the problem sized data associated with this plot.
//
//  Programmer: Hank Childs
//  Creation:   September 12, 2002
//
// ****************************************************************************
 
void
avtCurvePlot::ReleaseData(void)
{
    avtLineDataPlot::ReleaseData();
 
    if (CurveFilter != NULL)
    {
        CurveFilter->ReleaseData();
    }
}


