#include <PyCurveAttributes.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyCurveAttributes
//
// Purpose: 
//   Attributes for the xy plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Tue Dec 23 13:35:53 PST 2003
//
// ****************************************************************************

//
// This struct contains the Python type information and a CurveAttributes.
//
struct CurveAttributesObject
{
    PyObject_HEAD
    CurveAttributes *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewCurveAttributes();

static PyObject *
CurveAttributes_Notify(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
CurveAttributes_SetLineStyle(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineStyle in the object.
    obj->data->SetLineStyle(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
CurveAttributes_GetLineStyle(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineStyle()));
    return retval;
}

static PyObject *
CurveAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
CurveAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

static PyObject *
CurveAttributes_SetColor(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the color in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
CurveAttributes_GetColor(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the color.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *color = obj->data->GetColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(color[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(color[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(color[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(color[3])));
    return retval;
}

static PyObject *
CurveAttributes_SetShowLabels(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showLabels in the object.
    obj->data->SetShowLabels(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
CurveAttributes_GetShowLabels(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowLabels()?1L:0L);
    return retval;
}

static PyObject *
CurveAttributes_SetShowPoints(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showPoints in the object.
    obj->data->SetShowPoints(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
CurveAttributes_GetShowPoints(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowPoints()?1L:0L);
    return retval;
}

static PyObject *
CurveAttributes_SetPointSize(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pointSize in the object.
    obj->data->SetPointSize(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
CurveAttributes_GetPointSize(PyObject *self, PyObject *args)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPointSize());
    return retval;
}



static struct PyMethodDef CurveAttributes_methods[] = {
    {"Notify", CurveAttributes_Notify, METH_VARARGS},
    {"SetLineStyle", CurveAttributes_SetLineStyle, METH_VARARGS},
    {"GetLineStyle", CurveAttributes_GetLineStyle, METH_VARARGS},
    {"SetLineWidth", CurveAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", CurveAttributes_GetLineWidth, METH_VARARGS},
    {"SetColor", CurveAttributes_SetColor, METH_VARARGS},
    {"GetColor", CurveAttributes_GetColor, METH_VARARGS},
    {"SetShowLabels", CurveAttributes_SetShowLabels, METH_VARARGS},
    {"GetShowLabels", CurveAttributes_GetShowLabels, METH_VARARGS},
    {"SetShowPoints", CurveAttributes_SetShowPoints, METH_VARARGS},
    {"GetShowPoints", CurveAttributes_GetShowPoints, METH_VARARGS},
    {"SetPointSize", CurveAttributes_SetPointSize, METH_VARARGS},
    {"GetPointSize", CurveAttributes_GetPointSize, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
CurveAttributes_dealloc(PyObject *v)
{
   CurveAttributesObject *obj = (CurveAttributesObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
CurveAttributes_compare(PyObject *v, PyObject *w)
{
    CurveAttributes *a = ((CurveAttributesObject *)v)->data;
    CurveAttributes *b = ((CurveAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
CurveAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "lineStyle") == 0)
        return CurveAttributes_GetLineStyle(self, NULL);
    if(strcmp(name, "lineWidth") == 0)
        return CurveAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "color") == 0)
        return CurveAttributes_GetColor(self, NULL);
    if(strcmp(name, "showLabels") == 0)
        return CurveAttributes_GetShowLabels(self, NULL);
    if(strcmp(name, "showPoints") == 0)
        return CurveAttributes_GetShowPoints(self, NULL);
    if(strcmp(name, "pointSize") == 0)
        return CurveAttributes_GetPointSize(self, NULL);

    return Py_FindMethod(CurveAttributes_methods, self, name);
}

static int
CurveAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "lineStyle") == 0)
        retval = (CurveAttributes_SetLineStyle(self, tuple) != NULL);
    else if(strcmp(name, "lineWidth") == 0)
        retval = (CurveAttributes_SetLineWidth(self, tuple) != NULL);
    else if(strcmp(name, "color") == 0)
        retval = (CurveAttributes_SetColor(self, tuple) != NULL);
    else if(strcmp(name, "showLabels") == 0)
        retval = (CurveAttributes_SetShowLabels(self, tuple) != NULL);
    else if(strcmp(name, "showPoints") == 0)
        retval = (CurveAttributes_SetShowPoints(self, tuple) != NULL);
    else if(strcmp(name, "pointSize") == 0)
        retval = (CurveAttributes_SetPointSize(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
CurveAttributes_print(PyObject *v, FILE *fp, int flags)
{
    CurveAttributesObject *obj = (CurveAttributesObject *)v;

    fprintf(fp, "lineStyle = %d\n", obj->data->GetLineStyle());
    fprintf(fp, "lineWidth = %d\n", obj->data->GetLineWidth());
    const unsigned char *color = obj->data->GetColor().GetColor();
    fprintf(fp, "color = (%d, %d, %d, %d)\n", int(color[0]), int(color[1]), int(color[2]), int(color[3]));
    if(obj->data->GetShowLabels())
        fprintf(fp, "showLabels = 1\n");
    else
        fprintf(fp, "showLabels = 0\n");
    if(obj->data->GetShowPoints())
        fprintf(fp, "showPoints = 1\n");
    else
        fprintf(fp, "showPoints = 0\n");
    fprintf(fp, "pointSize = %g\n", obj->data->GetPointSize());

    return 0;
}

//
// The doc string for the class.
//
static char *CurveAttributes_Purpose = "Attributes for the xy plot";

//
// The type description structure
//
static PyTypeObject CurveAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "CurveAttributes",                    // tp_name
    sizeof(CurveAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)CurveAttributes_dealloc,  // tp_dealloc
    (printfunc)CurveAttributes_print,     // tp_print
    (getattrfunc)CurveAttributes_getattr, // tp_getattr
    (setattrfunc)CurveAttributes_setattr, // tp_setattr
    (cmpfunc)CurveAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    0,                                   // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    CurveAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static CurveAttributes *defaultAtts = 0;

static PyObject *
NewCurveAttributes()
{
    CurveAttributesObject *newObject;
    newObject = PyObject_NEW(CurveAttributesObject, &CurveAttributesType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new CurveAttributes(*defaultAtts);
    else
        newObject->data = new CurveAttributes;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapCurveAttributes(const CurveAttributes *attr)
{
    CurveAttributesObject *newObject;
    newObject = PyObject_NEW(CurveAttributesObject, &CurveAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (CurveAttributes *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
CurveAttributes_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewCurveAttributes();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef CurveAttributesMethods[] = {
    {"CurveAttributes", CurveAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *CurveAttributesObserver = 0;
static bool CurveAttributesEnableLogging = true;

static void
PyCurveAttributes_WriteLog(Subject *subj, void *data)
{
    CurveAttributes *atts = (CurveAttributes *)subj;
    FILE *logFile = (FILE *)data;

    if(!CurveAttributesEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# CurveAttributes_WriteLog()\n");
}

void
PyCurveAttributes_StartUp(CurveAttributes *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyCurveAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(CurveAttributesObserver == 0)
    {
        CurveAttributesObserver = new ObserverToCallback(subj,
            PyCurveAttributes_WriteLog, (void *)logFile);
    }

    CurveAttributesEnableLogging = true;
}

void
PyCurveAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete CurveAttributesObserver;
    CurveAttributesObserver = 0;
}

PyMethodDef *
PyCurveAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return CurveAttributesMethods;
}

bool
PyCurveAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &CurveAttributesType);
}

CurveAttributes *
PyCurveAttributes_FromPyObject(PyObject *obj)
{
    CurveAttributesObject *obj2 = (CurveAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyCurveAttributes_NewPyObject()
{
    return NewCurveAttributes();
}

PyObject *
PyCurveAttributes_WrapPyObject(const CurveAttributes *attr)
{
    return WrapCurveAttributes(attr);
}

void
PyCurveAttributes_SetLogging(bool val)
{
    CurveAttributesEnableLogging = val;
}

void
PyCurveAttributes_SetDefaults(const CurveAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new CurveAttributes(*atts);
}

