// ************************************************************************* //
//  File: CurveViewerPluginInfo.C
// ************************************************************************* //

#include <CurvePluginInfo.h>
#include <avtCurvePlot.h>

#if defined(__APPLE__)
#define GetViewerInfo Curve_GetViewerInfo
#endif

// ****************************************************************************
//  Function:  GetViewerInfo
//
//  Purpose:
//    Return a new ViewerPluginInfo for the Curve plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:32 PST 2004
//
// ****************************************************************************
extern "C" ViewerPlotPluginInfo* GetViewerInfo()
{
    CurveViewerPluginInfo::InitializeGlobalObjects();
    return new CurveViewerPluginInfo;
}

//
// Storage for static data elements.
//
CurveAttributes *CurveViewerPluginInfo::clientAtts = NULL;
CurveAttributes *CurveViewerPluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  CurveViewerPluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:32 PST 2004
//
// ****************************************************************************
void
CurveViewerPluginInfo::InitializeGlobalObjects()
{
    CurveViewerPluginInfo::clientAtts  = new CurveAttributes;
    CurveViewerPluginInfo::defaultAtts = new CurveAttributes;
}

// ****************************************************************************
//  Method: CurveViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:32 PST 2004
//
// ****************************************************************************

AttributeSubject *
CurveViewerPluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: CurveViewerPluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:32 PST 2004
//
// ****************************************************************************

AttributeSubject *
CurveViewerPluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: CurveViewerPluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:32 PST 2004
//
// ****************************************************************************

void
CurveViewerPluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(CurveAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: CurveViewerPluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:32 PST 2004
//
// ****************************************************************************

void
CurveViewerPluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(CurveAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: CurveViewerPluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:32 PST 2004
//
// ****************************************************************************

avtPlot *
CurveViewerPluginInfo::AllocAvtPlot()
{
    return new avtCurvePlot;
}

// ****************************************************************************
//  Method: CurveViewerPluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:32 PST 2004
//
// ****************************************************************************

void
CurveViewerPluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtDatabaseMetaData *, const char *)
{
    *(CurveAttributes*)atts = *defaultAtts;
}

// ****************************************************************************
// Method: CurveViewerPluginInfo::GetVariableTypes
//
// Purpose: 
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:32 PST 2004
//
// Modifications:
//   
// ****************************************************************************

int
CurveViewerPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_CURVE;
}


// ****************************************************************************
//  Method: CurveViewerPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:32 PST 2004
//
// ****************************************************************************

#include <Curve.xpm>
const char **
CurveViewerPluginInfo::XPMIconData() const
{
    return Curve_xpm;
}
